/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import java.io.DataInput;
import java.io.IOException;
import java.util.Arrays;
import org.joml.Vector3d;
import org.joml.Vector3dc;

public interface EnergyCalculator {
    public String id();

    public Type type();

    public int ffi();

    default public void readSettings(DataInput in) throws IOException {
    }

    public double calcEnergy(double var1, double var3, double[] var5);

    default public double calcEnergyStatic(AssignedCoords coords) {
        int ffi = this.ffi();
        double energy = coords.getStaticEnergy(ffi);
        Vector3d pos1 = new Vector3d();
        Vector3d pos2 = new Vector3d();
        ConfSpace.IndicesStatic indices = coords.getIndices(ffi);
        for (int i = 0; i < indices.size(); ++i) {
            int atomi1 = indices.getStaticAtom1Index(i);
            int atomi2 = indices.getStaticAtom2Index(i);
            int paramsi = indices.getParamsIndex(i);
            coords.coords.get(coords.getStaticIndex(atomi1), pos1);
            coords.coords.get(coords.getStaticIndex(atomi2), pos2);
            double r2 = pos1.distanceSquared((Vector3dc)pos2);
            double r = Math.sqrt(r2);
            energy += this.calcEnergy(r, r2, coords.getParams(ffi, paramsi));
        }
        return energy;
    }

    default public double calcEnergySingle(AssignedCoords coords, int posi) {
        int ffi = this.ffi();
        double energy = coords.getInternalEnergy(ffi, posi);
        Vector3d pos1 = new Vector3d();
        Vector3d pos2 = new Vector3d();
        ConfSpace.IndicesSingle indices = coords.getIndices(ffi, posi);
        for (int i = 0; i < indices.sizeInternals(); ++i) {
            int confAtom1i = indices.getInternalConfAtom1Index(i);
            int confAtom2i = indices.getInternalConfAtom2Index(i);
            int paramsi = indices.getInternalParamsIndex(i);
            coords.coords.get(coords.getConfIndex(posi, confAtom1i), pos1);
            coords.coords.get(coords.getConfIndex(posi, confAtom2i), pos2);
            double r2 = pos1.distanceSquared((Vector3dc)pos2);
            double r = Math.sqrt(r2);
            energy += this.calcEnergy(r, r2, coords.getParams(ffi, paramsi));
        }
        return energy;
    }

    default public double calcEnergyStatic(AssignedCoords coords, int posi) {
        double energy = 0.0;
        Vector3d pos1 = new Vector3d();
        Vector3d pos2 = new Vector3d();
        int ffi = this.ffi();
        ConfSpace.IndicesSingle indices = coords.getIndices(ffi, posi);
        for (int i = 0; i < indices.sizeStatics(); ++i) {
            int confAtomi = indices.getStaticConfAtomIndex(i);
            int staticAtomi = indices.getStaticStaticAtomIndex(i);
            int paramsi = indices.getStaticParamsIndex(i);
            coords.coords.get(coords.getConfIndex(posi, confAtomi), pos1);
            coords.coords.get(coords.getStaticIndex(staticAtomi), pos2);
            double r2 = pos1.distanceSquared((Vector3dc)pos2);
            double r = Math.sqrt(r2);
            energy += this.calcEnergy(r, r2, coords.getParams(ffi, paramsi));
        }
        return energy;
    }

    default public double calcEnergyPair(AssignedCoords coords, int posi1, int posi2) {
        double energy = 0.0;
        Vector3d pos1 = new Vector3d();
        Vector3d pos2 = new Vector3d();
        int ffi = this.ffi();
        ConfSpace.IndicesPair indices = coords.getIndices(ffi, posi1, posi2);
        for (int i = 0; i < indices.size(); ++i) {
            int confAtomi1 = indices.getConfAtom1Index(i);
            int confAtomi2 = indices.getConfAtom2Index(i);
            int paramsi = indices.getParamsIndex(i);
            coords.coords.get(coords.getConfIndex(posi1, confAtomi1), pos1);
            coords.coords.get(coords.getConfIndex(posi2, confAtomi2), pos2);
            double r2 = pos1.distanceSquared((Vector3dc)pos2);
            double r = Math.sqrt(r2);
            energy += this.calcEnergy(r, r2, coords.getParams(ffi, paramsi));
        }
        return energy;
    }

    default public double calcEnergy(AssignedCoords coords) {
        double energy = this.calcEnergyStatic(coords);
        int numPos = coords.confSpace.positions.length;
        for (int posi = 0; posi < numPos; ++posi) {
            energy += this.calcEnergySingle(coords, posi);
            energy += this.calcEnergyStatic(coords, posi);
        }
        for (int posi1 = 0; posi1 < numPos; ++posi1) {
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                energy += this.calcEnergyPair(coords, posi1, posi2);
            }
        }
        return energy;
    }

    default public double calcEnergy(AssignedCoords coords, PosInter inter) {
        double energy = inter.posi1 == inter.posi2 ? (inter.posi1 == -1 ? this.calcEnergyStatic(coords) : this.calcEnergySingle(coords, inter.posi1)) : (inter.posi1 == -1 ? this.calcEnergyStatic(coords, inter.posi2) : (inter.posi2 == -1 ? this.calcEnergyStatic(coords, inter.posi1) : this.calcEnergyPair(coords, inter.posi1, inter.posi2)));
        return inter.weight * energy;
    }

    public static enum Type {
        Amber("amber"),
        EEF1("eef1");

        public final String id;

        private Type(String id) {
            this.id = id;
        }

        public static Type get(String id) {
            return Arrays.stream(Type.values()).filter(type -> type.id.equals(id)).findAny().orElseThrow(() -> new UnsupportedOperationException("forcefield type '" + id + "' is not supported"));
        }
    }
}

