/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.compiled;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import com.sun.jna.Native;
import edu.duke.cs.osprey.confspace.compiled.AssignedCoords;
import edu.duke.cs.osprey.confspace.compiled.ConfSpace;
import edu.duke.cs.osprey.confspace.compiled.ContinuousMotion;
import edu.duke.cs.osprey.confspace.compiled.PosInter;
import edu.duke.cs.osprey.confspace.compiled.motions.DihedralAngle;
import edu.duke.cs.osprey.confspace.compiled.motions.TranslationRotation;
import edu.duke.cs.osprey.energy.compiled.AmberEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EEF1EnergyCalculator;
import edu.duke.cs.osprey.energy.compiled.EnergyCalculator;
import edu.duke.cs.osprey.gpu.MemoryBuffer;
import edu.duke.cs.osprey.gpu.Precision;
import edu.duke.cs.osprey.gpu.Structs;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class NativeConfEnergyCalculator
implements ConfEnergyCalculator {
    public final ConfSpace confSpace;
    public final Precision precision;
    public final ForcefieldsImpl forcefieldsImpl;
    private final MemoryBuffer buf;
    private final SConfSpace confSpaceStruct = new SConfSpace();
    private final SPos posStruct = new SPos();
    private final SConf confStruct = new SConf();
    private final SArray arrayStruct = new SArray();
    private final SReal3 real3Struct = new SReal3();
    private final SPosInter posInterStruct = new SPosInter();
    private final SDihedral dihedralStruct = new SDihedral();
    private static final int dihedralId = 0;
    private final STranslationRotation transRotStruct = new STranslationRotation();
    private static final int transRotId = 1;

    public NativeConfEnergyCalculator(ConfSpace confSpace, Precision precision) {
        MemoryBuffer fragOffsetsAddr;
        int posi1;
        int fragi1;
        int posi12;
        this.confSpace = confSpace;
        this.precision = precision;
        EnergyCalculator.Type[] ecalcTypes = (EnergyCalculator.Type[])Arrays.stream(confSpace.ecalcs).map(EnergyCalculator::type).toArray(EnergyCalculator.Type[]::new);
        if (ecalcTypes.length != 2 || ecalcTypes[0] != AmberEnergyCalculator.type || ecalcTypes[1] != EEF1EnergyCalculator.type) {
            throw new IllegalArgumentException("No native implementation for forcefields: " + Arrays.toString((Object[])ecalcTypes));
        }
        this.forcefieldsImpl = new AmberEef1();
        this.confSpaceStruct.init();
        this.posStruct.init();
        this.confStruct.init();
        this.arrayStruct.init();
        this.real3Struct.init();
        this.posInterStruct.init();
        this.dihedralStruct.init();
        this.transRotStruct.init();
        Structs.Int64.Array posOffsets = Structs.int64array();
        Structs.Int64.Array confOffsets = Structs.int64array();
        Structs.Int64.Array posPairOffsets = Structs.int64array();
        Structs.Int64.Array fragOffsets = Structs.int64array();
        Structs.Int64.Array molMotionOffsets = Structs.int64array();
        Structs.Int64.Array confMotionOffsets = Structs.int64array();
        long motionIdBytes = 8L;
        long bufSize = this.confSpaceStruct.bytes() + posOffsets.bytes(confSpace.positions.length) + Structs.sum(confSpace.positions, pos -> this.posStruct.bytes() + confOffsets.bytes(pos.confs.length) + Structs.sum(pos.confs, conf -> this.confStruct.bytes() + this.arrayStruct.bytes() + this.real3Struct.bytes() * (long)conf.coords.size + this.arrayStruct.bytes() + MemoryBuffer.padToAlignment(4L * (long)conf.coords.size, 8L) + confMotionOffsets.bytes(conf.motions.length) + motionIdBytes * (long)conf.motions.length + Structs.sum(conf.motions, motion -> {
            if (motion instanceof DihedralAngle.Description) {
                DihedralAngle.Description dihedral = (DihedralAngle.Description)motion;
                return this.dihedralStruct.bytes(dihedral.rotated.length);
            }
            throw new UnsupportedOperationException(motion.getClass().getName());
        }))) + this.arrayStruct.bytes() + this.real3Struct.bytes() * (long)confSpace.staticCoords.size + this.arrayStruct.bytes() + MemoryBuffer.padToAlignment(4L * (long)confSpace.staticCoords.size, 8L) + this.forcefieldsImpl.paramsBytes();
        int numPosPairs = 1 + confSpace.numPos() + confSpace.numPos() + confSpace.numPos() * (confSpace.numPos() - 1) / 2;
        bufSize += posPairOffsets.bytes(numPosPairs);
        bufSize += this.forcefieldsImpl.staticStaticBytes();
        for (posi12 = 0; posi12 < confSpace.positions.length; ++posi12) {
            bufSize += fragOffsets.itemBytes * (long)confSpace.numFrag(posi12);
            for (fragi1 = 0; fragi1 < confSpace.numFrag(posi12); ++fragi1) {
                bufSize += this.forcefieldsImpl.staticPosBytes(posi12, fragi1);
            }
        }
        for (posi12 = 0; posi12 < confSpace.positions.length; ++posi12) {
            bufSize += fragOffsets.itemBytes * (long)confSpace.numFrag(posi12);
            for (fragi1 = 0; fragi1 < confSpace.numFrag(posi12); ++fragi1) {
                bufSize += this.forcefieldsImpl.posBytes(posi12, fragi1);
            }
        }
        for (posi12 = 0; posi12 < confSpace.positions.length; ++posi12) {
            for (int posi2 = 0; posi2 < posi12; ++posi2) {
                bufSize += fragOffsets.itemBytes * (long)confSpace.numFrag(posi12) * (long)confSpace.numFrag(posi2);
                for (int fragi12 = 0; fragi12 < confSpace.numFrag(posi12); ++fragi12) {
                    for (int fragi2 = 0; fragi2 < confSpace.numFrag(posi2); ++fragi2) {
                        bufSize += this.forcefieldsImpl.posPosBytes(posi12, fragi12, posi2, fragi2);
                    }
                }
            }
        }
        int numMolMotions = 0;
        for (int moli = 0; moli < confSpace.molInfos.length; ++moli) {
            ConfSpace.MolInfo molInfo = confSpace.molInfos[moli];
            for (ContinuousMotion.MolDescription motion : molInfo.motions) {
                ++numMolMotions;
                if (motion instanceof DihedralAngle.Description) {
                    DihedralAngle.Description dihedral = (DihedralAngle.Description)motion;
                    bufSize += this.dihedralStruct.bytes(dihedral.rotated.length);
                    continue;
                }
                if (motion instanceof TranslationRotation.Description) {
                    bufSize += this.transRotStruct.bytes();
                    continue;
                }
                throw new UnsupportedOperationException(motion.getClass().getName());
            }
        }
        this.buf = new MemoryBuffer(bufSize += molMotionOffsets.bytes(numMolMotions) + motionIdBytes * (long)numMolMotions);
        MemoryBuffer confSpaceAddr = this.buf.place(this.confSpaceStruct);
        this.confSpaceStruct.num_pos.set(confSpaceAddr, confSpace.positions.length);
        this.confSpaceStruct.max_num_conf_atoms.set(confSpaceAddr, confSpace.maxNumConfAtoms);
        this.confSpaceStruct.max_num_dofs.set(confSpaceAddr, confSpace.maxNumDofs);
        this.confSpaceStruct.num_molecule_motions.set(confSpaceAddr, numMolMotions);
        this.confSpaceStruct.static_energy.set(confSpaceAddr, Arrays.stream(confSpace.staticEnergies).sum());
        this.confSpaceStruct.positions_offset.set(confSpaceAddr, this.buf.getPos());
        MemoryBuffer posOffsetsAddr = this.buf.place(posOffsets, confSpace.positions.length);
        for (ConfSpace.Pos pos2 : confSpace.positions) {
            posOffsets.set(posOffsetsAddr, pos2.index, this.buf.getPos());
            MemoryBuffer posAddr = this.buf.place(this.posStruct);
            this.posStruct.num_confs.set(posAddr, pos2.confs.length);
            this.posStruct.max_num_atoms.set(posAddr, pos2.maxNumAtoms);
            this.posStruct.num_frags.set(posAddr, pos2.numFrags);
            MemoryBuffer confOffsetsAddr = this.buf.place(confOffsets, pos2.confs.length);
            for (ConfSpace.Conf conf : pos2.confs) {
                confOffsets.set(confOffsetsAddr, conf.index, this.buf.getPos());
                MemoryBuffer confAddr = this.buf.place(this.confStruct);
                this.confStruct.frag_index.set(confAddr, conf.fragIndex);
                this.confStruct.internal_energy.set(confAddr, Arrays.stream(conf.energies).sum());
                this.confStruct.num_motions.set(confAddr, conf.motions.length);
                this.confStruct.atom_coords_offset.set(confAddr, this.buf.getPos());
                MemoryBuffer atomCoordsAddr = this.buf.place(this.arrayStruct);
                this.arrayStruct.size.set(atomCoordsAddr, conf.coords.size);
                this.arrayStruct.things_ptr.set(atomCoordsAddr, 0L);
                for (int i = 0; i < conf.coords.size; ++i) {
                    MemoryBuffer addr = this.buf.place(this.real3Struct);
                    this.real3Struct.x.set(addr, conf.coords.x(i));
                    this.real3Struct.y.set(addr, conf.coords.y(i));
                    this.real3Struct.z.set(addr, conf.coords.z(i));
                }
                this.confStruct.atom_molis_offset.set(confAddr, this.buf.getPos());
                MemoryBuffer atomMolisAddr = this.buf.place(this.arrayStruct);
                this.arrayStruct.size.set(atomMolisAddr, conf.coords.size);
                this.arrayStruct.things_ptr.set(atomMolisAddr, 0L);
                for (int i = 0; i < conf.numAtoms; ++i) {
                    this.buf.int32(conf.atomMolInfoIndices[i]);
                }
                this.buf.skipToAlignment(8L);
                this.confStruct.motions_offset.set(confAddr, this.buf.getPos());
                MemoryBuffer confMotionAddr = this.buf.place(confMotionOffsets, conf.motions.length);
                for (int i = 0; i < conf.motions.length; ++i) {
                    ContinuousMotion.ConfDescription motion = conf.motions[i];
                    confMotionOffsets.set(confMotionAddr, i, this.buf.getPos());
                    if (!(motion instanceof DihedralAngle.Description)) {
                        throw new UnsupportedOperationException(motion.getClass().getName());
                    }
                    this.writeDihedral((DihedralAngle.Description)motion, pos2.index, this.buf);
                }
            }
        }
        this.confSpaceStruct.static_atom_coords_offset.set(confSpaceAddr, this.buf.getPos());
        MemoryBuffer atomCoordsAddr = this.buf.place(this.arrayStruct);
        this.arrayStruct.size.set(atomCoordsAddr, confSpace.staticCoords.size);
        this.arrayStruct.things_ptr.set(atomCoordsAddr, 0L);
        for (int i = 0; i < confSpace.staticCoords.size; ++i) {
            MemoryBuffer addr = this.buf.place(this.real3Struct);
            this.real3Struct.x.set(addr, confSpace.staticCoords.x(i));
            this.real3Struct.y.set(addr, confSpace.staticCoords.y(i));
            this.real3Struct.z.set(addr, confSpace.staticCoords.z(i));
        }
        this.confSpaceStruct.static_atom_molis_offset.set(confSpaceAddr, this.buf.getPos());
        MemoryBuffer atomMolisAddr = this.buf.place(this.arrayStruct);
        this.arrayStruct.size.set(atomMolisAddr, confSpace.staticCoords.size);
        this.arrayStruct.things_ptr.set(atomMolisAddr, 0L);
        for (int i = 0; i < confSpace.staticCoords.size; ++i) {
            this.buf.int32(confSpace.staticMolInfoIndices[i]);
        }
        this.buf.skipToAlignment(8L);
        this.confSpaceStruct.params_offset.set(confSpaceAddr, this.buf.getPos());
        this.forcefieldsImpl.writeParams(this.buf);
        this.confSpaceStruct.pos_pairs_offset.set(confSpaceAddr, this.buf.getPos());
        MemoryBuffer posPairOffsetsAddr = this.buf.place(posPairOffsets, numPosPairs);
        posPairOffsets.set(posPairOffsetsAddr, 0L, this.buf.getPos());
        this.forcefieldsImpl.writeStaticStatic(this.buf);
        for (posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            posPairOffsets.set(posPairOffsetsAddr, 1 + posi1, this.buf.getPos());
            fragOffsetsAddr = this.buf.place(fragOffsets, confSpace.numFrag(posi1));
            for (int fragi13 = 0; fragi13 < confSpace.numFrag(posi1); ++fragi13) {
                fragOffsets.set(fragOffsetsAddr, fragi13, this.buf.getPos());
                this.forcefieldsImpl.writeStaticPos(posi1, fragi13, this.buf);
            }
        }
        for (posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            posPairOffsets.set(posPairOffsetsAddr, 1 + confSpace.positions.length + posi1, this.buf.getPos());
            fragOffsetsAddr = this.buf.place(fragOffsets, confSpace.numFrag(posi1));
            for (int fragi14 = 0; fragi14 < confSpace.numFrag(posi1); ++fragi14) {
                fragOffsets.set(fragOffsetsAddr, fragi14, this.buf.getPos());
                this.forcefieldsImpl.writePos(posi1, fragi14, this.buf);
            }
        }
        for (posi1 = 0; posi1 < confSpace.positions.length; ++posi1) {
            for (int posi2 = 0; posi2 < posi1; ++posi2) {
                posPairOffsets.set(posPairOffsetsAddr, 1 + 2 * confSpace.positions.length + posi1 * (posi1 - 1) / 2 + posi2, this.buf.getPos());
                MemoryBuffer fragOffsetsAddr2 = this.buf.place(fragOffsets, confSpace.numFrag(posi1) * confSpace.numFrag(posi2));
                for (int fragi15 = 0; fragi15 < confSpace.numFrag(posi1); ++fragi15) {
                    for (int fragi2 = 0; fragi2 < confSpace.numFrag(posi2); ++fragi2) {
                        fragOffsets.set(fragOffsetsAddr2, fragi15 * confSpace.numFrag(posi2) + fragi2, this.buf.getPos());
                        this.forcefieldsImpl.writePosPos(posi1, fragi15, posi2, fragi2, this.buf);
                    }
                }
            }
        }
        this.confSpaceStruct.molecule_motions_offset.set(confSpaceAddr, this.buf.getPos());
        MemoryBuffer molMotionOffsetsAddr = this.buf.place(molMotionOffsets, numMolMotions);
        int molMotionIndex = 0;
        for (int moli = 0; moli < confSpace.molInfos.length; ++moli) {
            ConfSpace.MolInfo molInfo = confSpace.molInfos[moli];
            for (ContinuousMotion.MolDescription motion : molInfo.motions) {
                molMotionOffsets.set(molMotionOffsetsAddr, molMotionIndex++, this.buf.getPos());
                if (motion instanceof DihedralAngle.Description) {
                    this.writeDihedral((DihedralAngle.Description)motion, -1, this.buf);
                    continue;
                }
                if (motion instanceof TranslationRotation.Description) {
                    this.writeTranslationRotation((TranslationRotation.Description)motion, moli, this.buf);
                    continue;
                }
                throw new UnsupportedOperationException(motion.getClass().getName());
            }
        }
        assert (this.buf.getPos() == bufSize) : String.format("%d bytes leftover", bufSize - this.buf.getPos());
    }

    private void writeDihedral(DihedralAngle.Description desc, int posi, MemoryBuffer buf) {
        buf.int64(0L);
        MemoryBuffer dihedralAddr = buf.place(this.dihedralStruct);
        this.dihedralStruct.min_radians.set(dihedralAddr, Math.toRadians(desc.minDegrees));
        this.dihedralStruct.max_radians.set(dihedralAddr, Math.toRadians(desc.maxDegrees));
        this.dihedralStruct.a_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.a));
        this.dihedralStruct.b_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.b));
        this.dihedralStruct.c_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.c));
        this.dihedralStruct.d_index.set(dihedralAddr, desc.getAtomIndex(this.confSpace, posi, desc.d));
        this.dihedralStruct.num_rotated.set(dihedralAddr, desc.rotated.length);
        this.dihedralStruct.modified_posi.set(dihedralAddr, posi);
        Structs.Int32.Array rotatedIndices = Structs.int32array();
        MemoryBuffer indicesAddr = buf.place(rotatedIndices, desc.rotated.length);
        for (int i = 0; i < desc.rotated.length; ++i) {
            rotatedIndices.set(indicesAddr, i, desc.getAtomIndex(this.confSpace, posi, desc.rotated[i]));
        }
        buf.skipToAlignment(8L);
    }

    private void writeTranslationRotation(TranslationRotation.Description desc, int moli, MemoryBuffer buf) {
        buf.int64(1L);
        MemoryBuffer transrotAddr = buf.place(this.transRotStruct);
        this.transRotStruct.max_distance.set(transrotAddr, desc.maxDistance);
        this.transRotStruct.max_radians.set(transrotAddr, desc.maxRotationRadians);
        MemoryBuffer centroidAddr = this.transRotStruct.centroid.offsetOf(transrotAddr);
        this.real3Struct.x.set(centroidAddr, desc.centroid.x);
        this.real3Struct.y.set(centroidAddr, desc.centroid.y);
        this.real3Struct.z.set(centroidAddr, desc.centroid.z);
        this.transRotStruct.moli.set(transrotAddr, moli);
    }

    @Override
    public Precision precision() {
        return this.precision;
    }

    public String version() {
        return String.format("%d.%d", NativeLib.version_major(), NativeLib.version_minor());
    }

    public AssignedCoords assign(int[] conf) {
        try (MemoryBuffer coordsMem = this.makeArray(this.confSpace.maxNumConfAtoms, this.real3Struct.bytes());){
            MemoryBuffer confSpaceMem = this.buf;
            switch (this.precision) {
                case Float32: {
                    NativeLib.assign_f32(confSpaceMem.asByteBuffer(), conf, coordsMem.asByteBuffer());
                    break;
                }
                case Float64: {
                    NativeLib.assign_f64(confSpaceMem.asByteBuffer(), conf, coordsMem.asByteBuffer());
                }
            }
            AssignedCoords assignedCoords = this.makeCoords(coordsMem, conf);
            return assignedCoords;
        }
    }

    private AssignedCoords makeCoords(MemoryBuffer mem, int[] assignments) {
        AssignedCoords coords = new AssignedCoords(this.confSpace, assignments);
        MemoryBuffer arrayAddr = this.getArrayAddress(mem);
        for (int i = 0; i < this.confSpace.maxNumConfAtoms; ++i) {
            MemoryBuffer addr = arrayAddr.sliceFrom((long)i * this.real3Struct.bytes());
            coords.coords.set(i, this.real3Struct.x.get(addr), this.real3Struct.y.get(addr), this.real3Struct.z.get(addr));
        }
        return coords;
    }

    @Override
    public void close() {
        this.buf.close();
    }

    @Override
    public ConfSpace confSpace() {
        return this.confSpace;
    }

    @Override
    public ConfEnergyCalculator.EnergiedCoords calc(int[] conf, List<PosInter> inters) {
        try (MemoryBuffer intersMem = this.makeIntersMem(inters);){
            ConfEnergyCalculator.EnergiedCoords energiedCoords;
            block12: {
                MemoryBuffer coordsMem = this.makeArray(this.confSpace.maxNumConfAtoms, this.real3Struct.bytes());
                try {
                    MemoryBuffer confSpaceMem = this.buf;
                    double energy = this.forcefieldsImpl.calc(confSpaceMem.asByteBuffer(), conf, intersMem.asByteBuffer(), coordsMem.asByteBuffer());
                    energiedCoords = new ConfEnergyCalculator.EnergiedCoords(this.makeCoords(coordsMem, conf), energy);
                    if (coordsMem == null) break block12;
                }
                catch (Throwable throwable) {
                    if (coordsMem != null) {
                        try {
                            coordsMem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                coordsMem.close();
            }
            return energiedCoords;
        }
    }

    @Override
    public double calcEnergy(int[] conf, List<PosInter> inters) {
        try (MemoryBuffer intersMem = this.makeIntersMem(inters);){
            MemoryBuffer confSpaceMem = this.buf;
            double d = this.forcefieldsImpl.calc(confSpaceMem.asByteBuffer(), conf, intersMem.asByteBuffer(), null);
            return d;
        }
    }

    private DoubleMatrix1D makeDofs(MemoryBuffer mem) {
        int size = (int)this.getArraySize(mem);
        DoubleMatrix1D vals = DoubleFactory1D.dense.make(size);
        Structs.Real.Array floats = Structs.realarray(this.precision);
        MemoryBuffer addr = this.getArrayAddress(mem);
        for (int i = 0; i < size; ++i) {
            vals.set(i, floats.get(addr, i));
        }
        return vals;
    }

    /*
     * Exception decompiling
     */
    @Override
    public ConfEnergyCalculator.EnergiedCoords minimize(int[] conf, List<PosInter> inters) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public double minimizeEnergy(int[] conf, List<PosInter> inters) {
        try (MemoryBuffer intersMem = this.makeIntersMem(inters);){
            MemoryBuffer confSpaceMem = this.buf;
            double d = this.forcefieldsImpl.minimize(confSpaceMem.asByteBuffer(), conf, intersMem.asByteBuffer(), null, null);
            return d;
        }
    }

    private MemoryBuffer makeIntersMem(List<PosInter> inters) {
        MemoryBuffer buf = this.makeArray(inters.size(), this.posInterStruct.bytes());
        MemoryBuffer arrayBuf = this.getArrayAddress(buf);
        for (PosInter inter : inters) {
            MemoryBuffer addr = arrayBuf.place(this.posInterStruct);
            this.posInterStruct.posi1.set(addr, inter.posi1);
            this.posInterStruct.posi2.set(addr, inter.posi2);
            this.posInterStruct.weight.set(addr, inter.weight);
            this.posInterStruct.offset.set(addr, inter.offset);
        }
        return buf;
    }

    private MemoryBuffer makeArray(long size, long itemBytes) {
        MemoryBuffer buf = new MemoryBuffer(16L + size * itemBytes);
        buf.int64(size);
        buf.int64(0L);
        return buf.sliceFrom(0L);
    }

    private long getArraySize(MemoryBuffer mem) {
        return mem.getLong(0L);
    }

    private MemoryBuffer getArrayAddress(MemoryBuffer mem) {
        return mem.sliceFrom(16L);
    }

    class SConfSpace
    extends Structs.Struct {
        Structs.Int32 num_pos = Structs.int32();
        Structs.Int32 max_num_conf_atoms = Structs.int32();
        Structs.Int32 max_num_dofs = Structs.int32();
        Structs.Int32 num_molecule_motions = Structs.int32();
        Structs.Int64 positions_offset = Structs.int64();
        Structs.Int64 static_atom_coords_offset = Structs.int64();
        Structs.Int64 static_atom_molis_offset = Structs.int64();
        Structs.Int64 params_offset = Structs.int64();
        Structs.Int64 pos_pairs_offset = Structs.int64();
        Structs.Int64 molecule_motions_offset = Structs.int64();
        Structs.Real static_energy;
        Structs.Pad pad;

        SConfSpace() {
        }

        void init() {
            this.static_energy = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.pad = Structs.pad(NativeConfEnergyCalculator.this.precision.map(4, 0).intValue());
            this.init(NativeConfEnergyCalculator.this.precision.map(72, 72), "num_pos", "max_num_conf_atoms", "max_num_dofs", "num_molecule_motions", "positions_offset", "static_atom_coords_offset", "static_atom_molis_offset", "params_offset", "pos_pairs_offset", "molecule_motions_offset", "static_energy", "pad");
        }
    }

    static class SPos
    extends Structs.Struct {
        Structs.Int32 num_confs = Structs.int32();
        Structs.Int32 max_num_atoms = Structs.int32();
        Structs.Int32 num_frags = Structs.int32();
        Structs.Pad pad;

        SPos() {
        }

        void init() {
            this.pad = Structs.pad(4L);
            this.init(16, "num_confs", "max_num_atoms", "num_frags", "pad");
        }
    }

    class SConf
    extends Structs.Struct {
        Structs.Int64 atom_coords_offset = Structs.int64();
        Structs.Int64 atom_molis_offset = Structs.int64();
        Structs.Int32 frag_index = Structs.int32();
        Structs.Pad pad;
        Structs.Real internal_energy;
        Structs.Int64 num_motions = Structs.int64();
        Structs.Int64 motions_offset = Structs.int64();

        SConf() {
        }

        void init() {
            this.pad = Structs.pad(NativeConfEnergyCalculator.this.precision.map(0, 4).intValue());
            this.internal_energy = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.init(NativeConfEnergyCalculator.this.precision.map(40, 48), "atom_coords_offset", "atom_molis_offset", "frag_index", "pad", "internal_energy", "num_motions", "motions_offset");
        }
    }

    static class SArray
    extends Structs.Struct {
        Structs.Int64 size = Structs.int64();
        Structs.Int64 things_ptr = Structs.int64();

        SArray() {
        }

        void init() {
            this.init(16, "size", "things_ptr");
        }
    }

    class SReal3
    extends Structs.Struct {
        Structs.Real x;
        Structs.Real y;
        Structs.Real z;
        Structs.Pad pad;

        SReal3() {
        }

        void init() {
            this.x = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.y = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.z = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.pad = Structs.pad(NativeConfEnergyCalculator.this.precision.map(4, 0).intValue());
            this.init(NativeConfEnergyCalculator.this.precision.map(16, 24), "x", "y", "z", "pad");
        }
    }

    class SPosInter
    extends Structs.Struct {
        Structs.Int32 posi1 = Structs.int32();
        Structs.Int32 posi2 = Structs.int32();
        Structs.Real weight;
        Structs.Real offset;

        SPosInter() {
        }

        void init() {
            this.weight = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.offset = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.init(NativeConfEnergyCalculator.this.precision.map(16, 24), "posi1", "posi2", "weight", "offset");
        }
    }

    class SDihedral
    extends Structs.Struct {
        Structs.Real min_radians;
        Structs.Real max_radians;
        Structs.Int32 a_index = Structs.int32();
        Structs.Int32 b_index = Structs.int32();
        Structs.Int32 c_index = Structs.int32();
        Structs.Int32 d_index = Structs.int32();
        Structs.Int32 num_rotated = Structs.int32();
        Structs.Int32 modified_posi = Structs.int32();

        SDihedral() {
        }

        void init() {
            this.min_radians = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.max_radians = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.init(NativeConfEnergyCalculator.this.precision.map(32, 40), "min_radians", "max_radians", "a_index", "b_index", "c_index", "d_index", "num_rotated", "modified_posi");
        }

        long bytes(int numRotated) {
            return this.bytes() + MemoryBuffer.padToAlignment(4L * (long)numRotated, 8L);
        }
    }

    class STranslationRotation
    extends Structs.Struct {
        Structs.Real max_distance;
        Structs.Real max_radians;
        Structs.StructField<SReal3> centroid;
        Structs.Int32 moli = Structs.int32();
        Structs.Pad pad = Structs.pad(4L);

        STranslationRotation() {
        }

        void init() {
            this.max_distance = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.max_radians = Structs.real(NativeConfEnergyCalculator.this.precision);
            this.centroid = Structs.struct(NativeConfEnergyCalculator.this.real3Struct);
            this.init(NativeConfEnergyCalculator.this.precision.map(32, 48), "max_distance", "max_radians", "centroid", "moli", "pad");
        }
    }

    private class AmberEef1
    implements ForcefieldsImpl {
        final SParamsAmberEef1 paramsStruct = new SParamsAmberEef1(this);
        final SAtomPairs atomPairsStruct = new SAtomPairs(this);
        final SAtomPairAmber amberStruct = new SAtomPairAmber();
        final SAtomPairEef1 eef1Struct = new SAtomPairEef1();

        AmberEef1() {
            this.paramsStruct.init();
            this.atomPairsStruct.init();
            this.amberStruct.init();
            this.eef1Struct.init();
        }

        @Override
        public double calc(ByteBuffer confSpaceBuf, int[] conf, ByteBuffer intersBuf, ByteBuffer coords) {
            return switch (NativeConfEnergyCalculator.this.precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> NativeLib.calc_amber_eef1_f32(confSpaceBuf, conf, intersBuf, coords);
                case Precision.Float64 -> NativeLib.calc_amber_eef1_f64(confSpaceBuf, conf, intersBuf, coords);
            };
        }

        @Override
        public double minimize(ByteBuffer confSpaceBuf, int[] conf, ByteBuffer intersBuf, ByteBuffer coords, ByteBuffer dofs) {
            return switch (NativeConfEnergyCalculator.this.precision) {
                default -> throw new IncompatibleClassChangeError();
                case Precision.Float32 -> NativeLib.minimize_amber_eef1_f32(confSpaceBuf, conf, intersBuf, coords, dofs);
                case Precision.Float64 -> NativeLib.minimize_amber_eef1_f64(confSpaceBuf, conf, intersBuf, coords, dofs);
            };
        }

        @Override
        public long paramsBytes() {
            return this.paramsStruct.bytes();
        }

        @Override
        public void writeParams(MemoryBuffer buf) {
            MemoryBuffer addr = buf.place(this.paramsStruct);
            AmberEnergyCalculator.Settings amberSettings = ((AmberEnergyCalculator)NativeConfEnergyCalculator.this.confSpace.ecalcs[0]).settings;
            this.paramsStruct.distance_dependent_dielectric.set(addr, amberSettings.distanceDependentDielectric);
        }

        private long atomPairsBytes(int numAmber, int numEef1) {
            return this.atomPairsStruct.bytes() + (long)numAmber * this.amberStruct.bytes() + (long)numEef1 * this.eef1Struct.bytes();
        }

        @Override
        public long staticStaticBytes() {
            return this.atomPairsBytes(NativeConfEnergyCalculator.this.confSpace.indicesStatic(0).size(), NativeConfEnergyCalculator.this.confSpace.indicesStatic(1).size());
        }

        @Override
        public long staticPosBytes(int posi1, int fragi1) {
            return this.atomPairsBytes(NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1).sizeStatics(), NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1).sizeStatics());
        }

        @Override
        public long posBytes(int posi1, int fragi1) {
            return this.atomPairsBytes(NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1).sizeInternals(), NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1).sizeInternals());
        }

        @Override
        public long posPosBytes(int posi1, int fragi1, int posi2, int fragi2) {
            return this.atomPairsBytes(NativeConfEnergyCalculator.this.confSpace.indicesPairsByFrags(0, posi1, fragi1, posi2, fragi2).size(), NativeConfEnergyCalculator.this.confSpace.indicesPairsByFrags(1, posi1, fragi1, posi2, fragi2).size());
        }

        private void writeAtomPairs(AtomPairWriter amber, AtomPairWriter eef1, MemoryBuffer buf) {
            int atomi2;
            int atomi1;
            MemoryBuffer addr;
            int i;
            long firstPos = buf.getPos();
            MemoryBuffer atomPairsAddr = buf.place(this.atomPairsStruct);
            this.atomPairsStruct.num_amber.set(atomPairsAddr, amber.size());
            this.atomPairsStruct.num_eef1.set(atomPairsAddr, eef1.size());
            for (i = 0; i < amber.size(); ++i) {
                addr = buf.place(this.amberStruct);
                atomi1 = amber.atomi1(i);
                atomi2 = amber.atomi2(i);
                assert (atomi1 != atomi2);
                this.amberStruct.atomi1.set(addr, atomi1);
                this.amberStruct.atomi2.set(addr, atomi2);
                this.amberStruct.setParams(addr, amber.params(i));
            }
            for (i = 0; i < eef1.size(); ++i) {
                addr = buf.place(this.eef1Struct);
                atomi1 = eef1.atomi1(i);
                atomi2 = eef1.atomi2(i);
                assert (atomi1 != atomi2);
                this.eef1Struct.atomi1.set(addr, atomi1);
                this.eef1Struct.atomi2.set(addr, atomi2);
                this.eef1Struct.setParams(addr, eef1.params(i));
            }
            assert (buf.getPos() - firstPos == this.atomPairsBytes(amber.size(), eef1.size())) : String.format("overshot by %d bytes", buf.getPos() - firstPos - this.atomPairsBytes(amber.size(), eef1.size()));
        }

        @Override
        public void writeStaticStatic(MemoryBuffer buf) {
            final ConfSpace.IndicesStatic amberIndices = NativeConfEnergyCalculator.this.confSpace.indicesStatic(0);
            final ConfSpace.IndicesStatic eef1Indices = NativeConfEnergyCalculator.this.confSpace.indicesStatic(1);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.size();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getStaticAtomIndex(amberIndices.getStaticAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getStaticAtomIndex(amberIndices.getStaticAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.size();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getStaticAtomIndex(eef1Indices.getStaticAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getStaticAtomIndex(eef1Indices.getStaticAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getParamsIndex(i));
                }
            }, buf);
        }

        @Override
        public void writeStaticPos(final int posi1, int fragi1, MemoryBuffer buf) {
            final ConfSpace.IndicesSingle amberIndices = NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1);
            final ConfSpace.IndicesSingle eef1Indices = NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.sizeStatics();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getStaticAtomIndex(amberIndices.getStaticStaticAtomIndex(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getStaticConfAtomIndex(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getStaticParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.sizeStatics();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getStaticAtomIndex(eef1Indices.getStaticStaticAtomIndex(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getStaticConfAtomIndex(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getStaticParamsIndex(i));
                }
            }, buf);
        }

        @Override
        public void writePos(final int posi1, int fragi1, MemoryBuffer buf) {
            final ConfSpace.IndicesSingle amberIndices = NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(0, posi1, fragi1);
            final ConfSpace.IndicesSingle eef1Indices = NativeConfEnergyCalculator.this.confSpace.indicesSinglesByFrag(1, posi1, fragi1);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.sizeInternals();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getInternalConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getInternalConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getInternalParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.sizeInternals();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getInternalConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getInternalConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getInternalParamsIndex(i));
                }
            }, buf);
        }

        @Override
        public void writePosPos(final int posi1, int fragi1, final int posi2, int fragi2, MemoryBuffer buf) {
            final ConfSpace.IndicesPair amberIndices = NativeConfEnergyCalculator.this.confSpace.indicesPairsByFrags(0, posi1, fragi1, posi2, fragi2);
            final ConfSpace.IndicesPair eef1Indices = NativeConfEnergyCalculator.this.confSpace.indicesPairsByFrags(1, posi1, fragi1, posi2, fragi2);
            this.writeAtomPairs(new AtomPairWriter(){

                @Override
                public int size() {
                    return amberIndices.size();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, amberIndices.getConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi2, amberIndices.getConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(0, amberIndices.getParamsIndex(i));
                }
            }, new AtomPairWriter(){

                @Override
                public int size() {
                    return eef1Indices.size();
                }

                @Override
                public int atomi1(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi1, eef1Indices.getConfAtom1Index(i));
                }

                @Override
                public int atomi2(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.getConfAtomIndex(posi2, eef1Indices.getConfAtom2Index(i));
                }

                @Override
                public double[] params(int i) {
                    return NativeConfEnergyCalculator.this.confSpace.ffparams(1, eef1Indices.getParamsIndex(i));
                }
            }, buf);
        }

        class SParamsAmberEef1
        extends Structs.Struct {
            Structs.Bool distance_dependent_dielectric = Structs.bool();
            Structs.Pad pad = Structs.pad(7L);

            SParamsAmberEef1(AmberEef1 this$1) {
            }

            void init() {
                this.init(8, "distance_dependent_dielectric", "pad");
            }
        }

        class SAtomPairs
        extends Structs.Struct {
            final Structs.Int32 num_amber = Structs.int32();
            final Structs.Int32 num_eef1 = Structs.int32();

            SAtomPairs(AmberEef1 this$1) {
            }

            void init() {
                this.init(8, "num_amber", "num_eef1");
            }
        }

        class SAtomPairAmber
        extends Structs.Struct {
            final Structs.Int32 atomi1 = Structs.int32();
            final Structs.Int32 atomi2 = Structs.int32();
            final Structs.Real esQ;
            final Structs.Real vdwA;
            final Structs.Real vdwB;
            final Structs.Pad pad;

            SAtomPairAmber() {
                this.esQ = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.vdwA = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.vdwB = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.pad = Structs.pad(NativeConfEnergyCalculator.this.precision.map(4, 0).intValue());
            }

            void init() {
                this.init(NativeConfEnergyCalculator.this.precision.map(24, 32), "atomi1", "atomi2", "esQ", "vdwA", "vdwB", "pad");
            }

            void setParams(MemoryBuffer buf, double[] params) {
                this.esQ.set(buf, params[0]);
                this.vdwA.set(buf, params[1]);
                this.vdwB.set(buf, params[2]);
            }
        }

        class SAtomPairEef1
        extends Structs.Struct {
            final Structs.Int32 atomi1 = Structs.int32();
            final Structs.Int32 atomi2 = Structs.int32();
            final Structs.Real vdwRadius1;
            final Structs.Real lambda1;
            final Structs.Real vdwRadius2;
            final Structs.Real lambda2;
            final Structs.Real alpha1;
            final Structs.Real alpha2;

            SAtomPairEef1() {
                this.vdwRadius1 = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.lambda1 = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.vdwRadius2 = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.lambda2 = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.alpha1 = Structs.real(NativeConfEnergyCalculator.this.precision);
                this.alpha2 = Structs.real(NativeConfEnergyCalculator.this.precision);
            }

            void init() {
                this.init(NativeConfEnergyCalculator.this.precision.map(32, 56), "atomi1", "atomi2", "vdwRadius1", "lambda1", "vdwRadius2", "lambda2", "alpha1", "alpha2");
            }

            void setParams(MemoryBuffer buf, double[] params) {
                this.vdwRadius1.set(buf, params[0]);
                this.lambda1.set(buf, params[1]);
                this.vdwRadius2.set(buf, params[2]);
                this.lambda2.set(buf, params[3]);
                this.alpha1.set(buf, params[4]);
                this.alpha2.set(buf, params[5]);
            }
        }
    }

    private static interface ForcefieldsImpl {
        public double calc(ByteBuffer var1, int[] var2, ByteBuffer var3, ByteBuffer var4);

        public double minimize(ByteBuffer var1, int[] var2, ByteBuffer var3, ByteBuffer var4, ByteBuffer var5);

        public long paramsBytes();

        public void writeParams(MemoryBuffer var1);

        public long staticStaticBytes();

        public long staticPosBytes(int var1, int var2);

        public long posBytes(int var1, int var2);

        public long posPosBytes(int var1, int var2, int var3, int var4);

        public void writeStaticStatic(MemoryBuffer var1);

        public void writeStaticPos(int var1, int var2, MemoryBuffer var3);

        public void writePos(int var1, int var2, MemoryBuffer var3);

        public void writePosPos(int var1, int var2, int var3, int var4, MemoryBuffer var5);
    }

    private static class NativeLib {
        private NativeLib() {
        }

        public static native int version_major();

        public static native int version_minor();

        public static native void assign_f32(ByteBuffer var0, int[] var1, ByteBuffer var2);

        public static native void assign_f64(ByteBuffer var0, int[] var1, ByteBuffer var2);

        public static native float calc_amber_eef1_f32(ByteBuffer var0, int[] var1, ByteBuffer var2, ByteBuffer var3);

        public static native double calc_amber_eef1_f64(ByteBuffer var0, int[] var1, ByteBuffer var2, ByteBuffer var3);

        public static native float minimize_amber_eef1_f32(ByteBuffer var0, int[] var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4);

        public static native double minimize_amber_eef1_f64(ByteBuffer var0, int[] var1, ByteBuffer var2, ByteBuffer var3, ByteBuffer var4);

        static {
            Native.register((String)"ConfEcalc");
        }
    }

    private static interface AtomPairWriter {
        public int size();

        public int atomi1(int var1);

        public int atomi2(int var1);

        public double[] params(int var1);
    }
}

