/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomConnectivity;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.structure.Residues;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Map;

public class ResPairCache {
    public final ForcefieldParams ffparams;
    public final AtomConnectivity connectivity;
    private Map<AtomConnectivity.AtomPairs, AtomPairInfo> infos;

    public ResPairCache(ForcefieldParams ffparams, AtomConnectivity connectivity) {
        this.ffparams = ffparams;
        this.connectivity = connectivity;
        this.infos = new IdentityHashMap<AtomConnectivity.AtomPairs, AtomPairInfo>();
    }

    public ResPair get(Residues residues, ResidueInteractions.Pair pair, ForcefieldParams.SolvationForcefield.ResiduesInfo solvInfo) {
        Residue res2;
        int indxe1 = residues.findIndex(pair.resNum1);
        int index2 = residues.findIndex(pair.resNum2);
        Residue res1 = (Residue)residues.get(indxe1);
        AtomConnectivity.AtomPairs atomPairs = this.connectivity.getAtomPairs(res1, res2 = (Residue)residues.get(index2));
        if (atomPairs == null) {
            throw new RuntimeException("Atom connectivity was not correctly calculated. Can't find atom pairs for residues: " + res1.fullName + ", " + res2.fullName);
        }
        AtomPairInfo info2 = this.infos.get(atomPairs);
        if (info2 == null) {
            info2 = new AtomPairInfo(res1, res2, this.ffparams, atomPairs, solvInfo);
            this.infos.put(atomPairs, info2);
        }
        return new ResPair(indxe1, index2, res1, res2, pair.weight, pair.offset, info2, solvInfo, this.ffparams.solvScale);
    }

    public static class AtomPairInfo {
        public final int numAtomPairs;
        public final long[] flags;
        public final double[] precomputed;
        public final int numPrecomputedPerAtomPair;

        public AtomPairInfo(Residue res1, Residue res2, ForcefieldParams ffparams, AtomConnectivity.AtomPairs atomPairs, ForcefieldParams.SolvationForcefield.ResiduesInfo solvInfo) {
            int numPrecomputedPerAtomPair = 3;
            if (solvInfo != null) {
                numPrecomputedPerAtomPair += solvInfo.getNumPrecomputedPerAtomPair();
            }
            this.numPrecomputedPerAtomPair = numPrecomputedPerAtomPair;
            this.numAtomPairs = atomPairs.getNumPairs(AtomNeighbors.Type.BONDED14) + atomPairs.getNumPairs(AtomNeighbors.Type.NONBONDED);
            this.flags = new long[this.numAtomPairs];
            this.precomputed = new double[this.numAtomPairs * numPrecomputedPerAtomPair];
            int flagsIndex = 0;
            int precomputedIndex = 0;
            for (AtomNeighbors.Type type : Arrays.asList(AtomNeighbors.Type.BONDED14, AtomNeighbors.Type.NONBONDED)) {
                for (int[] atomPair : atomPairs.getPairs(type)) {
                    Atom atom1 = res1.atoms.get(atomPair[0]);
                    Atom atom2 = res2.atoms.get(atomPair[1]);
                    boolean isHeavyPair = !atom1.isHydrogen() && !atom2.isHydrogen();
                    boolean is14Bonded = type == AtomNeighbors.Type.BONDED14;
                    int atomOffset1 = atomPair[0] * 3;
                    int atomOffset2 = atomPair[1] * 3;
                    long flags = is14Bonded ? 1L : 0L;
                    flags <<= 1;
                    flags |= isHeavyPair ? 1L : 0L;
                    flags <<= 46;
                    flags |= (long)atomOffset1 & 0xFFFFL;
                    flags <<= 16;
                    this.flags[flagsIndex++] = flags |= (long)atomOffset2 & 0xFFFFL;
                    this.precomputed[precomputedIndex++] = atom1.charge * atom2.charge;
                    ForcefieldParams.VdwParams vdwparams = ffparams.getVdwParams(atom1, atom2, type);
                    this.precomputed[precomputedIndex++] = vdwparams.Aij;
                    this.precomputed[precomputedIndex++] = vdwparams.Bij;
                    if (solvInfo == null) continue;
                    solvInfo.putPrecomputed(this.precomputed, precomputedIndex, res1, atomPair[0], res2, atomPair[1], ffparams.solvScale);
                    precomputedIndex += solvInfo.getNumPrecomputedPerAtomPair();
                }
            }
        }
    }

    public static class ResPair {
        public final int resIndex1;
        public final int resIndex2;
        public final Residue res1;
        public final Residue res2;
        public final AtomPairInfo info;
        public final double solvEnergy;
        public final double weight;
        public final double offset;

        public ResPair(int resIndex1, int resIndex2, Residue res1, Residue res2, double weight, double offset, AtomPairInfo info2, ForcefieldParams.SolvationForcefield.ResiduesInfo solvInfo, double solvScale) {
            this.resIndex1 = resIndex1;
            this.resIndex2 = resIndex2;
            this.res1 = res1;
            this.res2 = res2;
            this.info = info2;
            this.solvEnergy = solvInfo != null ? solvInfo.getResPairEnergy(res1, res2) * solvScale : 0.0;
            this.weight = weight;
            this.offset = offset;
        }

        public String toString() {
            return String.format("%s:%s", this.res1.fullName, this.res2.fullName);
        }
    }
}

