/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.energy.forcefield;

import edu.duke.cs.osprey.energy.forcefield.AtomPairEnergyContribution;
import edu.duke.cs.osprey.energy.forcefield.ResPairCache;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ResPairEnergyContribution {
    public static final ResPairEnergyContribution BrokenConformation = new ResPairEnergyContribution(null, null);
    private final ResPairCache.ResPair resPair;
    private final List<AtomPairEnergyContribution> atomPairs;

    public ResPairEnergyContribution(ResPairCache.ResPair resPair, List<AtomPairEnergyContribution> atomPairs) {
        this.atomPairs = atomPairs;
        this.resPair = resPair;
    }

    public double getEnergy() {
        Double energy = this.atomPairs.stream().map(AtomPairEnergyContribution::getEnergy).reduce(Double::sum).orElseThrow();
        return (energy + this.resPair.offset + this.resPair.solvEnergy) * this.resPair.weight;
    }

    public ResPairCache.ResPair getResPair() {
        return this.resPair;
    }

    public List<AtomPairEnergyContribution> getTopEnergyContributions(int n) {
        return this.atomPairs.stream().sorted(Comparator.comparingDouble(AtomPairEnergyContribution::getEnergy).reversed()).limit(n).collect(Collectors.toList());
    }

    public List<AtomPairEnergyContribution> getAtomPairEnergyContributions() {
        return this.atomPairs;
    }
}

