/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.ewakstar;

import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.ewakstar.EWAKStarPartitionFunction;
import edu.duke.cs.osprey.ewakstar.EWAKStarScore;
import edu.duke.cs.osprey.ewakstar.EWAKStarScoreWriter;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class EWAKStar {
    public final ConfSpaceInfo protein;
    public final ConfSpaceInfo ligand;
    public final ConfSpaceInfo complex;
    public final Settings settings;

    public EWAKStar(SimpleConfSpace protein, SimpleConfSpace ligand, SimpleConfSpace complex, Settings settings) {
        this.settings = settings;
        this.protein = new ConfSpaceInfo(this, protein, ConfSpaceType.Protein);
        this.ligand = new ConfSpaceInfo(this, ligand, ConfSpaceType.Ligand);
        this.complex = new ConfSpaceInfo(this, complex, ConfSpaceType.Complex);
    }

    public Iterable<ConfSpaceInfo> confSpaceInfos() {
        return Arrays.asList(this.protein, this.ligand, this.complex);
    }

    public ConfSpaceInfo getConfSpaceInfo(SimpleConfSpace confSpace) {
        if (confSpace == this.protein.confSpace) {
            return this.protein;
        }
        if (confSpace == this.ligand.confSpace) {
            return this.ligand;
        }
        if (confSpace == this.complex.confSpace) {
            return this.complex;
        }
        throw new IllegalArgumentException("conf space does not match any known by this K* instance");
    }

    public static class Settings {
        public boolean printPDBs;
        public final int numTopOverallSeqs;
        public final boolean useExternalMemory;
        public final int numMutations;
        public final boolean useExact;
        public final boolean wtBenchmark;
        public final int maxPFConfs;
        public final double epsilon;
        public final double eW;
        public final EWAKStarScoreWriter.Writers scoreWriters;
        public final boolean showPfuncProgress;

        public Settings(boolean printPDBs, boolean useExternalMemory, boolean useExact, int numMutations, double epsilon, double eW, int maxPFConfs, int numTopOverallSeqs, EWAKStarScoreWriter.Writers scoreWriters, boolean dumpPfuncConfs, boolean wtBenchmark) {
            this.printPDBs = printPDBs;
            this.numTopOverallSeqs = numTopOverallSeqs;
            this.useExternalMemory = useExternalMemory;
            this.useExact = useExact;
            this.numMutations = numMutations;
            this.wtBenchmark = wtBenchmark;
            this.maxPFConfs = maxPFConfs;
            this.epsilon = epsilon;
            this.eW = eW;
            this.scoreWriters = scoreWriters;
            this.showPfuncProgress = dumpPfuncConfs;
        }

        public static class Builder {
            private double epsilon = 0.683;
            private int numMutations = Integer.MAX_VALUE;
            private boolean useExact = false;
            private double eW = 2.0;
            private int maxPFConfs = Integer.MAX_VALUE;
            private EWAKStarScoreWriter.Writers scoreWriters = new EWAKStarScoreWriter.Writers();
            private boolean showPfuncProgress = false;
            private boolean wtBenchmark = true;
            private boolean useExternalMemory = false;
            private int numTopOverallSeqs = Integer.MAX_VALUE;
            private boolean printPDBs = false;

            public Builder setPrintPDBs(boolean val) {
                this.printPDBs = val;
                return this;
            }

            public Builder setNumTopOverallSeqs(int val) {
                this.numTopOverallSeqs = val;
                return this;
            }

            public Builder setMaxNumConfs(int val) {
                this.maxPFConfs = val;
                return this;
            }

            public Builder setWTBenchmark(boolean ans) {
                this.wtBenchmark = ans;
                return this;
            }

            public Builder setEpsilon(double val) {
                this.epsilon = val;
                return this;
            }

            public Builder setEw(double val) {
                this.eW = val;
                return this;
            }

            public Builder setUseExact(boolean val) {
                this.useExact = val;
                return this;
            }

            public Builder setUseExternalMemory(boolean val) {
                this.useExternalMemory = val;
                return this;
            }

            public Builder setNumMutations(int val) {
                this.numMutations = val;
                return this;
            }

            public Builder addScoreWriter(EWAKStarScoreWriter val) {
                this.scoreWriters.add(val);
                return this;
            }

            public Builder addScoreConsoleWriter(EWAKStarScoreWriter.Formatter val) {
                return this.addScoreWriter(new EWAKStarScoreWriter.ToConsole(val));
            }

            public Builder addScoreConsoleWriter() {
                return this.addScoreConsoleWriter(new EWAKStarScoreWriter.Formatter.SequenceKStarPfuncs());
            }

            public Builder addScoreFileWriter(File file, EWAKStarScoreWriter.Formatter val) {
                return this.addScoreWriter(new EWAKStarScoreWriter.ToFile(file, val));
            }

            public Builder addScoreFileWriter(File file) {
                return this.addScoreFileWriter(file, new EWAKStarScoreWriter.Formatter.Log());
            }

            public Builder setShowPfuncProgress(boolean val) {
                this.showPfuncProgress = val;
                return this;
            }

            public Settings build() {
                return new Settings(this.printPDBs, this.useExternalMemory, this.useExact, this.numMutations, this.epsilon, this.eW, this.maxPFConfs, this.numTopOverallSeqs, this.scoreWriters, this.showPfuncProgress, this.wtBenchmark);
            }
        }
    }

    public class ConfSpaceInfo {
        public final SimpleConfSpace confSpace;
        public final ConfSpaceType type;
        public final String id;
        public final Map<Sequence, EWAKStarPartitionFunction.Result> pfuncResults = new HashMap<Sequence, EWAKStarPartitionFunction.Result>();
        public ConfEnergyCalculator confEcalc = null;
        public File confDBFile = null;

        public ConfSpaceInfo(EWAKStar this$0, SimpleConfSpace confSpace, ConfSpaceType type) {
            this.confSpace = confSpace;
            this.type = type;
            this.id = type.name().toLowerCase();
        }

        private void check() {
            if (this.confEcalc == null) {
                throw new InitException(this.type, "confEcalc");
            }
        }

        public void clear() {
            this.pfuncResults.clear();
        }

        public void setConfDBFile(String path2) {
            this.confDBFile = new File(path2);
        }
    }

    public static enum ConfSpaceType {
        Protein,
        Ligand,
        Complex;

    }

    private static interface Scorer {
        public KStarScore score(int var1, PartitionFunction.Result var2, PartitionFunction.Result var3, PartitionFunction.Result var4);
    }

    public static class InitException
    extends RuntimeException {
        public InitException(ConfSpaceType type, String name) {
            super(String.format("set %s for the %s conf space info before running", name, type.name()));
        }
    }

    public static class ScoredSequence {
        public final Sequence sequence;
        public final EWAKStarScore score;

        public ScoredSequence(Sequence sequence, EWAKStarScore score) {
            this.sequence = sequence;
            this.score = score;
        }

        public String toString() {
            return "sequence: " + String.valueOf(this.sequence) + "   K*(log10): " + String.valueOf(this.score);
        }

        public String toString(Sequence wildtype) {
            return "sequence: " + this.sequence.toString(Sequence.Renderer.AssignmentMutations) + "   K*(log10): " + String.valueOf(this.score);
        }
    }
}

