/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.cuda;

import com.jogamp.common.nio.Buffers;
import edu.duke.cs.osprey.gpu.cuda.GpuStream;
import java.nio.Buffer;
import jcuda.CudaException;
import jcuda.NativePointerObject;
import jcuda.Pointer;
import jcuda.driver.CUdeviceptr;

public class CUBuffer<T extends Buffer> {
    private GpuStream stream;
    private T buf;
    private long numBytes;
    private Pointer phBuf;
    private CUdeviceptr pdBuf;

    public CUBuffer(GpuStream stream, T buf) {
        this.stream = stream;
        this.buf = buf;
        this.numBytes = ((Buffer)buf).capacity() * Buffers.sizeOfBufferElem(buf);
        this.phBuf = Pointer.to(buf);
        try {
            stream.getContext().pinBuffer(this.phBuf, this.numBytes);
        }
        catch (CudaException ex) {
            if (ex.getMessage().equals("CUDA_ERROR_HOST_MEMORY_ALREADY_REGISTERED")) {
                throw new Error("can't create new buffer... usually caused by failure to cleanup old buffers");
            }
            throw ex;
        }
        this.pdBuf = stream.getContext().malloc(this.numBytes);
    }

    public T getHostBuffer() {
        return this.buf;
    }

    public Pointer getDevicePointer() {
        return Pointer.to((NativePointerObject[])new NativePointerObject[]{this.pdBuf});
    }

    public int size() {
        return ((Buffer)this.buf).capacity();
    }

    public long getNumBytes() {
        return this.numBytes;
    }

    public void uploadAsync() {
        ((Buffer)this.buf).rewind();
        this.stream.getContext().uploadAsync(this.pdBuf, this.phBuf, this.numBytes, this.stream);
    }

    public void downloadAsync() {
        ((Buffer)this.buf).rewind();
        this.stream.getContext().downloadAsync(this.phBuf, this.pdBuf, this.numBytes, this.stream);
    }

    public T downloadSync() {
        this.downloadAsync();
        this.stream.waitForGpu();
        return this.buf;
    }

    public void expand(T buf) {
        int newNumBytes = ((Buffer)buf).capacity() * Buffers.sizeOfBufferElem(buf);
        if ((long)newNumBytes <= this.numBytes) {
            return;
        }
        this.stream.getContext().unpinBuffer(this.phBuf);
        this.buf = buf;
        this.phBuf = Pointer.to(this.buf);
        this.stream.getContext().pinBuffer(this.phBuf, newNumBytes);
        this.stream.getContext().free(this.pdBuf);
        this.pdBuf = this.stream.getContext().malloc(newNumBytes);
        this.numBytes = newNumBytes;
    }

    public void cleanup() {
        try {
            this.stream.getContext().attachCurrentThread();
            this.stream.getContext().unpinBuffer(this.phBuf);
            this.stream.getContext().free(this.pdBuf);
            this.phBuf = null;
            this.pdBuf = null;
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.phBuf != null || this.pdBuf != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }
}

