/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gpu.opencl;

import com.jogamp.opencl.CLBuffer;
import com.jogamp.opencl.CLException;
import com.jogamp.opencl.CLKernel;
import com.jogamp.opencl.CLPlatform;
import com.jogamp.opencl.llb.CL;
import com.jogamp.opencl.util.CLUtil;
import edu.duke.cs.osprey.gpu.opencl.GpuQueue;
import edu.duke.cs.osprey.gpu.opencl.ProfilingEvents;
import java.io.IOException;

public abstract class Kernel {
    private GpuQueue queue;
    private CLKernel kernel;
    private ProfilingEvents events;

    public Kernel(GpuQueue queue, String fileName, String kernelName) throws IOException {
        if (queue.getCLQueue().isOutOfOrderModeEnabled()) {
            throw new Error("GPU command queue should be strictly ordered... this is a bug");
        }
        this.queue = queue;
        this.kernel = queue.getGpu().getProgram(fileName).createCLKernel(kernelName);
        this.events = null;
    }

    public GpuQueue getQueue() {
        return this.queue;
    }

    protected CLKernel getCLKernel() {
        return this.kernel;
    }

    public void waitForGpu() {
        this.queue.getCLQueue().finish();
    }

    public void cleanup() {
        this.kernel.release();
        this.kernel = null;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.kernel != null) {
                System.err.println("WARNING: " + this.getClass().getName() + " was garbage collected, but not cleaned up. Attempting cleanup now");
                this.cleanup();
            }
        }
        finally {
            super.finalize();
        }
    }

    protected int getMaxGroupSize() {
        return this.queue.getCLQueue().getDevice().getMaxWorkGroupSize();
    }

    protected int roundUpWorkSize(int workSize, int groupSize) {
        return (workSize + groupSize - 1) / groupSize * groupSize;
    }

    protected void uploadBufferAsync(CLBuffer<?> buf) {
        this.queue.getCLQueue().putWriteBuffer(buf, false, this.events != null ? this.events.getCLEvents() : null);
    }

    protected void uploadPartialBufferAsync(CLBuffer<?> buf) {
        buf.getBuffer().rewind();
        int size = buf.getElementSize() * buf.getBuffer().limit();
        CL cl = CLPlatform.getLowLevelCLInterface();
        int ret = cl.clEnqueueWriteBuffer(this.queue.getCLQueue().getID(), buf.getID(), CLUtil.clBoolean((boolean)false), 0L, (long)size, buf.getBuffer(), 0, null, this.events != null ? this.events.getCLIds() : null);
        if (ret != 0) {
            throw CLException.newException((int)ret, (String)("can not enqueue write-buffer: " + String.valueOf(buf)));
        }
    }

    protected void runAsync(int workSize, int groupSize) {
        this.queue.getCLQueue().put1DRangeKernel(this.kernel, 0L, (long)workSize, (long)groupSize, this.events != null ? this.events.getCLEvents() : null);
    }

    protected void downloadBufferSync(CLBuffer<?> buf) {
        this.queue.getCLQueue().putReadBuffer(buf, true, this.events != null ? this.events.getCLEvents() : null);
    }

    protected void downloadBufferAsync(CLBuffer<?> buf) {
        this.queue.getCLQueue().putReadBuffer(buf, false, this.events != null ? this.events.getCLEvents() : null);
    }

    public ProfilingEvents getProfilingEvents() {
        return this.events;
    }

    public void setProfilingEvents(ProfilingEvents val) {
        if (val == this.events) {
            return;
        }
        if (!this.queue.isProfilingEnabled()) {
            throw new IllegalStateException("profiling not enabled for the gpu queue");
        }
        this.events = val;
    }
}

