/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.features.components;

import cuchaz.kludge.imgui.Commands;
import cuchaz.kludge.tools.Ref;
import edu.duke.cs.osprey.gui.features.components.DihedralAngleViewer;
import edu.duke.cs.osprey.gui.features.components.DihedralAngleViewerKt;
import edu.duke.cs.osprey.gui.features.components.MotionViewer;
import edu.duke.cs.osprey.gui.motions.DihedralAngle;
import edu.duke.cs.osprey.gui.prep.Assignments;
import edu.duke.cs.osprey.gui.tools.LangKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeMaps;
import edu.duke.cs.osprey.molscope.render.MoleculeRenderEffects;
import edu.duke.cs.osprey.molscope.view.MoleculeRenderView;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 -2\u00020\u0001:\u0001-B/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020#2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020*H\u0016J\b\u0010,\u001a\u00020#H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0015R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0015R\u0012\u0010\u001d\u001a\u00060\u001eR\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006."}, d2={"Ledu/duke/cs/osprey/gui/features/components/DihedralAngleViewer;", "Ledu/duke/cs/osprey/gui/features/components/MotionViewer;", "dihedral", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle;", "minDegrees", "", "maxDegrees", "view", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "mapsToCopy", "Ledu/duke/cs/osprey/molscope/molecule/MoleculeMaps;", "(Ledu/duke/cs/osprey/gui/motions/DihedralAngle;FFLedu/duke/cs/osprey/molscope/view/MoleculeRenderView;Ledu/duke/cs/osprey/molscope/molecule/MoleculeMaps;)V", "getDihedral", "()Ledu/duke/cs/osprey/gui/motions/DihedralAngle;", "label", "", "getLabel", "()Ljava/lang/String;", "getMapsToCopy", "()Ledu/duke/cs/osprey/molscope/molecule/MoleculeMaps;", "getMaxDegrees", "()F", "getMinDegrees", "pValue", "Lcuchaz/kludge/tools/Ref;", "getPValue", "()Lcuchaz/kludge/tools/Ref;", "radius", "getRadius", "renderEffects", "Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects$Writer;", "Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects;", "getView", "()Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "gui", "", "imgui", "Lcuchaz/kludge/imgui/Commands;", "jiggle", "rand", "Lkotlin/random/Random;", "mapAtomToOriginalMol", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "atom", "reset", "Companion", "osprey3"})
public final class DihedralAngleViewer
implements MotionViewer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DihedralAngle dihedral;
    private final float minDegrees;
    private final float maxDegrees;
    @NotNull
    private final MoleculeRenderView view;
    @NotNull
    private final MoleculeMaps mapsToCopy;
    private final float radius;
    @NotNull
    private final Ref<Float> pValue;
    @NotNull
    private final String label;
    @NotNull
    private MoleculeRenderEffects.Writer renderEffects;

    /*
     * WARNING - void declaration
     */
    private DihedralAngleViewer(DihedralAngle dihedral, float minDegrees, float maxDegrees, MoleculeRenderView view, MoleculeMaps mapsToCopy) {
        void $this$renderEffects_u24lambda_u240;
        this.dihedral = dihedral;
        this.minDegrees = minDegrees;
        this.maxDegrees = maxDegrees;
        this.view = view;
        this.mapsToCopy = mapsToCopy;
        this.radius = (this.maxDegrees - this.minDegrees) / 2.0f;
        this.pValue = Ref.Companion.of((Object)Float.valueOf((this.minDegrees + this.maxDegrees) / 2.0f));
        Object object = new Atom[]{this.dihedral.getA(), this.dihedral.getB(), this.dihedral.getC(), this.dihedral.getD()};
        this.label = "Dihedral Angle: " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.listOf((Object[])object), (CharSequence)", ", null, null, (int)0, null, (Function1)label.1.INSTANCE, (int)30, null);
        Object object2 = object = this.view.getRenderEffects().writer();
        DihedralAngleViewer dihedralAngleViewer = this;
        boolean bl = false;
        for (Atom atom : this.dihedral.getRotatedAtoms()) {
            $this$renderEffects_u24lambda_u240.set(atom, DihedralAngleViewerKt.access$getRotatableEffect$p());
        }
        $this$renderEffects_u24lambda_u240.set(this.dihedral.getA(), DihedralAngleViewerKt.access$getSelectedEffect$p());
        $this$renderEffects_u24lambda_u240.set(this.dihedral.getB(), DihedralAngleViewerKt.access$getSelectedEffect$p());
        $this$renderEffects_u24lambda_u240.set(this.dihedral.getC(), DihedralAngleViewerKt.access$getSelectedEffect$p());
        $this$renderEffects_u24lambda_u240.set(this.dihedral.getD(), DihedralAngleViewerKt.access$getSelectedEffect$p());
        dihedralAngleViewer.renderEffects = object;
    }

    @NotNull
    public final DihedralAngle getDihedral() {
        return this.dihedral;
    }

    public final float getMinDegrees() {
        return this.minDegrees;
    }

    public final float getMaxDegrees() {
        return this.maxDegrees;
    }

    @NotNull
    public final MoleculeRenderView getView() {
        return this.view;
    }

    @NotNull
    public final MoleculeMaps getMapsToCopy() {
        return this.mapsToCopy;
    }

    public final float getRadius() {
        return this.radius;
    }

    @NotNull
    public final Ref<Float> getPValue() {
        return this.pValue;
    }

    @Override
    @NotNull
    public String getLabel() {
        return this.label;
    }

    @Override
    public void gui(@NotNull Commands imgui) {
        Intrinsics.checkNotNullParameter((Object)imgui, (String)"imgui");
        Commands $this$gui_u24lambda_u241 = imgui;
        boolean bl = false;
        String string = "Radius: %.1f degrees";
        Object[] objectArray = new Object[]{Float.valueOf(this.radius)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(this, *args)");
        $this$gui_u24lambda_u241.text(string2);
        string = "Range: %.1f to %.1f degrees";
        objectArray = new Object[]{Float.valueOf(this.minDegrees), Float.valueOf(this.maxDegrees)};
        String string3 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(this, *args)");
        $this$gui_u24lambda_u241.text(string3);
        float f = this.minDegrees;
        if (!Float.isInfinite(f) && !Float.isNaN(f) && !Float.isInfinite(f = this.maxDegrees) && !Float.isNaN(f) && !Float.isInfinite(f = ((Number)this.pValue.getValue()).floatValue()) && !Float.isNaN(f)) {
            if (Commands.sliderFloat$default((Commands)$this$gui_u24lambda_u241, (String)"Angle", this.pValue, (float)this.minDegrees, (float)this.maxDegrees, (String)"%.1f", (float)0.0f, (int)32, null)) {
                this.dihedral.setDegrees(((Number)this.pValue.getValue()).floatValue());
                this.view.moleculeChanged();
            }
        } else {
            $this$gui_u24lambda_u241.text("(invalid angle)");
        }
    }

    @Override
    public void jiggle(@NotNull Random rand) {
        Intrinsics.checkNotNullParameter((Object)rand, (String)"rand");
        this.pValue.setValue((Object)Float.valueOf(LangKt.nextFloatIn(rand, this.minDegrees, this.maxDegrees)));
        this.dihedral.setDegrees(((Number)this.pValue.getValue()).floatValue());
        this.view.moleculeChanged();
    }

    @Override
    public void reset() {
        this.renderEffects.close();
    }

    @Override
    @NotNull
    public Atom mapAtomToOriginalMol(@NotNull Atom atom) {
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        return this.mapsToCopy.getAtoms().getAOrThrow(atom);
    }

    public /* synthetic */ DihedralAngleViewer(DihedralAngle dihedral, float minDegrees, float maxDegrees, MoleculeRenderView view, MoleculeMaps mapsToCopy, DefaultConstructorMarker $constructor_marker) {
        this(dihedral, minDegrees, maxDegrees, view, mapsToCopy);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ&\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u0010"}, d2={"Ledu/duke/cs/osprey/gui/features/components/DihedralAngleViewer$Companion;", "", "()V", "make", "Ledu/duke/cs/osprey/gui/features/components/DihedralAngleViewer;", "desc", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle$ConfDescription;", "assignmentInfo", "Ledu/duke/cs/osprey/gui/prep/Assignments$AssignmentInfo;", "view", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "Ledu/duke/cs/osprey/gui/motions/DihedralAngle$MolDescription;", "molCopy", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "molMaps", "Ledu/duke/cs/osprey/molscope/molecule/MoleculeMaps;", "osprey3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DihedralAngleViewer make(@NotNull DihedralAngle.ConfDescription desc, @NotNull Assignments.AssignmentInfo assignmentInfo, @NotNull MoleculeRenderView view) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Intrinsics.checkNotNullParameter((Object)assignmentInfo, (String)"assignmentInfo");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return new DihedralAngleViewer(desc.make(assignmentInfo.getMolInfo().getAssignedMol(), assignmentInfo.getConfSwitcher().getAtomResolverOrThrow()), (float)desc.getMinDegrees(), (float)desc.getMaxDegrees(), view, assignmentInfo.getConfSwitcher().getMolInfo().getMaps(), null);
        }

        @NotNull
        public final DihedralAngleViewer make(@NotNull DihedralAngle.MolDescription desc, @NotNull Molecule molCopy, @NotNull MoleculeMaps molMaps, @NotNull MoleculeRenderView view) {
            Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
            Intrinsics.checkNotNullParameter((Object)molCopy, (String)"molCopy");
            Intrinsics.checkNotNullParameter((Object)molMaps, (String)"molMaps");
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            return new DihedralAngleViewer(desc.copyTo(molCopy, molMaps.getAtoms()).make(), (float)desc.getMinDegrees(), (float)desc.getMaxDegrees(), view, molMaps, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

