/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.features.slide;

import cuchaz.kludge.imgui.Commands;
import cuchaz.kludge.tools.IntFlags;
import cuchaz.kludge.tools.LangKt;
import cuchaz.kludge.tools.Ref;
import edu.duke.cs.osprey.dof.DihedralRotation;
import edu.duke.cs.osprey.gui.features.slide.ProtonationEditorKt;
import edu.duke.cs.osprey.gui.forcefield.amber.ProtonateKt;
import edu.duke.cs.osprey.gui.forcefield.amber.ProtonatedAtom;
import edu.duke.cs.osprey.gui.forcefield.amber.Protonation;
import edu.duke.cs.osprey.gui.prep.MoleculePrep;
import edu.duke.cs.osprey.molscope.Slide;
import edu.duke.cs.osprey.molscope.gui.ClickTracker;
import edu.duke.cs.osprey.molscope.gui.ContextMenu;
import edu.duke.cs.osprey.molscope.gui.InfoTipKt;
import edu.duke.cs.osprey.molscope.gui.SlideCommands;
import edu.duke.cs.osprey.molscope.gui.SlideFeature;
import edu.duke.cs.osprey.molscope.gui.ViewIndexed;
import edu.duke.cs.osprey.molscope.gui.features.FeatureId;
import edu.duke.cs.osprey.molscope.gui.features.WindowState;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.render.HoverEffects;
import edu.duke.cs.osprey.molscope.render.MoleculeRenderEffects;
import edu.duke.cs.osprey.molscope.view.MoleculeRenderView;
import edu.duke.cs.osprey.molscope.view.RenderView;
import edu.duke.cs.osprey.tools.Protractor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001)B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J\u0016\u0010\u001d\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00120\u001cH\u0002J$\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\"R\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J$\u0010&\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 2\n\u0010!\u001a\u00060\"R\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\u001b\u0010'\u001a\r\u0012\t\u0012\u00070\u0012\u00a2\u0006\u0002\b(0\u001c*\u00060\"R\u00020#H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0012\u0012\b\u0012\u00060\u0013R\u00020\u00140\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\b\u0018\u00010\u0016R\u00020\u0000X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor;", "Ledu/duke/cs/osprey/molscope/gui/SlideFeature;", "prep", "Ledu/duke/cs/osprey/gui/prep/MoleculePrep;", "(Ledu/duke/cs/osprey/gui/prep/MoleculePrep;)V", "clickTracker", "Ledu/duke/cs/osprey/molscope/gui/ClickTracker;", "hoverEffects", "Ledu/duke/cs/osprey/molscope/render/HoverEffects$Writer;", "Ledu/duke/cs/osprey/molscope/render/HoverEffects;", "id", "Ledu/duke/cs/osprey/molscope/gui/features/FeatureId;", "getId", "()Ledu/duke/cs/osprey/molscope/gui/features/FeatureId;", "getPrep", "()Ledu/duke/cs/osprey/gui/prep/MoleculePrep;", "renderEffects", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects$Writer;", "Ledu/duke/cs/osprey/molscope/render/MoleculeRenderEffects;", "selection", "Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection;", "winState", "Ledu/duke/cs/osprey/molscope/gui/features/WindowState;", "autoProtonate", "", "views", "", "clearAll", "gui", "imgui", "Lcuchaz/kludge/imgui/Commands;", "slide", "Ledu/duke/cs/osprey/molscope/Slide$Locked;", "Ledu/duke/cs/osprey/molscope/Slide;", "slidewin", "Ledu/duke/cs/osprey/molscope/gui/SlideCommands;", "menu", "molViews", "Lkotlin/internal/NoInfer;", "Selection", "osprey3"})
@SourceDebugExtension(value={"SMAP\nProtonationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtonationEditor.kt\nedu/duke/cs/osprey/gui/features/slide/ProtonationEditor\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,398:1\n800#2,11:399\n1855#2,2:410\n1855#2,2:412\n*S KotlinDebug\n*F\n+ 1 ProtonationEditor.kt\nedu/duke/cs/osprey/gui/features/slide/ProtonationEditor\n*L\n35#1:399,11\n206#1:410,2\n210#1:412,2\n*E\n"})
public final class ProtonationEditor
implements SlideFeature {
    @NotNull
    private final MoleculePrep prep;
    @NotNull
    private final FeatureId id;
    @NotNull
    private final WindowState winState;
    @NotNull
    private final ClickTracker clickTracker;
    @Nullable
    private Selection selection;
    @Nullable
    private HoverEffects.Writer hoverEffects;
    @NotNull
    private final IdentityHashMap<MoleculeRenderView, MoleculeRenderEffects.Writer> renderEffects;

    public ProtonationEditor(@NotNull MoleculePrep prep) {
        Intrinsics.checkNotNullParameter((Object)prep, (String)"prep");
        this.prep = prep;
        this.id = new FeatureId("edit.protonation");
        this.winState = new WindowState();
        this.clickTracker = new ClickTracker(0, 1, null);
        this.hoverEffects = null;
        this.renderEffects = new IdentityHashMap();
    }

    @NotNull
    public final MoleculePrep getPrep() {
        return this.prep;
    }

    @Override
    @NotNull
    public FeatureId getId() {
        return this.id;
    }

    /*
     * WARNING - void declaration
     */
    private final List<MoleculeRenderView> molViews(Slide.Locked $this$molViews) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = $this$molViews.getViews();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MoleculeRenderView)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Override
    public void menu(@NotNull Commands imgui, @NotNull Slide.Locked slide2, @NotNull SlideCommands slidewin) {
        Intrinsics.checkNotNullParameter((Object)imgui, (String)"imgui");
        Intrinsics.checkNotNullParameter((Object)slide2, (String)"slide");
        Intrinsics.checkNotNullParameter((Object)slidewin, (String)"slidewin");
        Commands $this$menu_u24lambda_u240 = imgui;
        boolean bl = false;
        if (Commands.menuItem$default((Commands)$this$menu_u24lambda_u240, (String)"Protonation", null, (int)2, null)) {
            this.winState.setOpen(true);
        }
    }

    @Override
    public void gui(@NotNull Commands imgui, @NotNull Slide.Locked slide2, @NotNull SlideCommands slidewin) {
        Intrinsics.checkNotNullParameter((Object)imgui, (String)"imgui");
        Intrinsics.checkNotNullParameter((Object)slide2, (String)"slide");
        Intrinsics.checkNotNullParameter((Object)slidewin, (String)"slidewin");
        Commands $this$gui_u24lambda_u241 = imgui;
        boolean bl = false;
        List<MoleculeRenderView> views = this.molViews(slide2);
        this.winState.render((Function0<Unit>)((Function0)new Function0<Unit>(this, slidewin, views){
            final /* synthetic */ ProtonationEditor this$0;
            final /* synthetic */ SlideCommands $slidewin;
            final /* synthetic */ List<MoleculeRenderView> $views;
            {
                this.this$0 = $receiver;
                this.$slidewin = $slidewin;
                this.$views = $views;
                super(0);
            }

            /*
             * WARNING - void declaration
             */
            public final void invoke() {
                void $this$invoke_u24lambda_u240;
                HoverEffects.Writer writer = this.$slidewin.getHoverEffects().writer();
                HoverEffects.Writer writer2 = writer;
                ProtonationEditor protonationEditor = this.this$0;
                boolean bl = false;
                $this$invoke_u24lambda_u240.setEffect(ProtonationEditorKt.access$getHoverEffect$p());
                ProtonationEditor.access$setHoverEffects$p(protonationEditor, writer);
                for (MoleculeRenderView view : this.$views) {
                    ((Map)ProtonationEditor.access$getRenderEffects$p(this.this$0)).put(view, view.getRenderEffects().writer());
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this, slidewin, $this$gui_u24lambda_u241, slide2, views){
            final /* synthetic */ ProtonationEditor this$0;
            final /* synthetic */ SlideCommands $slidewin;
            final /* synthetic */ Commands $this_run;
            final /* synthetic */ Slide.Locked $slide;
            final /* synthetic */ List<MoleculeRenderView> $views;
            {
                this.this$0 = $receiver;
                this.$slidewin = $slidewin;
                this.$this_run = $receiver2;
                this.$slide = $slide;
                this.$views = $views;
                super(0);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public final void invoke() {
                void flags$iv;
                void open$iv;
                void name$iv;
                void this_$iv;
                Object target22;
                Object object;
                Object $this$forEach$iv;
                if (ProtonationEditor.access$getClickTracker$p(this.this$0).clicked(this.$slidewin)) {
                    Collection<V> collection = ProtonationEditor.access$getRenderEffects$p(this.this$0).values();
                    Intrinsics.checkNotNullExpressionValue(collection, (String)"renderEffects.values");
                    $this$forEach$iv = collection;
                    boolean $i$f$forEach2 = false;
                    object = $this$forEach$iv.iterator();
                    while (object.hasNext()) {
                        E element$iv = object.next();
                        MoleculeRenderEffects.Writer it = (MoleculeRenderEffects.Writer)element$iv;
                        boolean bl = false;
                        it.clear();
                    }
                    ProtonationEditor.access$setSelection$p(this.this$0, null);
                    ViewIndexed viewIndexed = this.$slidewin.getMouseTarget();
                    if (viewIndexed != null) {
                        ViewIndexed $i$f$forEach2 = viewIndexed;
                        object = this.this$0;
                        target22 = $i$f$forEach2;
                        boolean bl = false;
                        RenderView renderView = ((ViewIndexed)target22).getView();
                        MoleculeRenderView moleculeRenderView = renderView instanceof MoleculeRenderView ? (MoleculeRenderView)renderView : null;
                        if (moleculeRenderView != null) {
                            MoleculeRenderView view = moleculeRenderView;
                            boolean bl2 = false;
                            Object object2 = ((ViewIndexed)target22).getTarget();
                            Atom atom = object2 instanceof Atom ? (Atom)object2 : null;
                            if (atom != null) {
                                Atom atom2 = atom;
                                boolean bl3 = false;
                                if (atom2.getElement() != Element.Hydrogen) {
                                    ProtonationEditor.access$setSelection$p((ProtonationEditor)object, new Selection((ProtonationEditor)object, view, atom2));
                                }
                            }
                        }
                    }
                }
                $this$forEach$iv = this.$this_run;
                String $i$f$forEach2 = "Protonation Editor##" + this.$slide.getName();
                object = ProtonationEditor.access$getWinState$p(this.this$0).getPOpen();
                target22 = new Commands.BeginFlags[]{Commands.BeginFlags.AlwaysAutoResize};
                int target22 = IntFlags.Companion.of-V5G__BY((IntFlags.Bit[])target22);
                Commands commands2 = this.$this_run;
                ProtonationEditor protonationEditor = this.this$0;
                List<MoleculeRenderView> list = this.$views;
                SlideCommands slideCommands = this.$slidewin;
                boolean bl = false;
                this_$iv.begin-aPAI5eo((String)name$iv, (Ref)open$iv, (int)flags$iv);
                try {
                    boolean bl4 = false;
                    commands2.text("Tools:");
                    commands2.indent(10.0f);
                    if (Commands.button$default((Commands)commands2, (String)"Clear all Hydrogens", (float)0.0f, (float)0.0f, (int)6, null)) {
                        ProtonationEditor.access$clearAll(protonationEditor, list);
                    }
                    if (Commands.button$default((Commands)commands2, (String)"Add Hydrogens automatically", (float)0.0f, (float)0.0f, (int)6, null)) {
                        slideCommands.showExceptions((Function0<Unit>)((Function0)new Function0<Unit>(protonationEditor, list){
                            final /* synthetic */ ProtonationEditor this$0;
                            final /* synthetic */ List<MoleculeRenderView> $views;
                            {
                                this.this$0 = $receiver;
                                this.$views = $views;
                                super(0);
                            }

                            public final void invoke() {
                                ProtonationEditor.access$autoProtonate(this.this$0, this.$views);
                            }
                        }));
                    }
                    Commands.sameLine$default((Commands)commands2, (float)0.0f, (float)0.0f, (int)3, null);
                    InfoTipKt.infoTip$default(commands2, "This tool adds Hydrogen atoms to heavy atoms based on inferred\nforcefield atom types and bond types. Atom and bond type inference\non unprotonated molecules is very error-prone, so feel free to use\nthe fine-grained editing tools to add any missing Hydrogen atoms,\nremove any extraneous Hydrogen atoms, or change hybridizations and geometry.", 0.0f, 2, null);
                    commands2.unindent(10.0f);
                    Selection selection = ProtonationEditor.access$getSelection$p(protonationEditor);
                    commands2.text("Selected:");
                    Commands.child-MUbzFbY$default((Commands)commands2, (String)"selected", (float)300.0f, (float)30.0f, (boolean)true, (int)0, (Function0)((Function0)new Function0<Unit>(selection, commands2){
                        final /* synthetic */ Selection $selection;
                        final /* synthetic */ Commands $this_run;
                        {
                            this.$selection = $selection;
                            this.$this_run = $receiver;
                            super(0);
                        }

                        public final void invoke() {
                            if (this.$selection != null) {
                                this.$this_run.text(this.$selection.getAtom().getName());
                            } else {
                                this.$this_run.text("(Click a heavy atom to show protonation options.)");
                            }
                        }
                    }), (int)16, null);
                    if (selection != null) {
                        void $this$listBox_u24default$iv;
                        commands2.text("Protonation states:");
                        int numItems = selection.getProtonations().size() + 1;
                        Commands commands3 = commands2;
                        String label$iv = "";
                        int heightInItems$iv = numItems;
                        boolean $i$f$listBox = false;
                        if ($this$listBox_u24default$iv.listBoxHeader(label$iv, numItems, heightInItems$iv)) {
                            try {
                                boolean bl5 = false;
                                if (Commands.selectable-_H7b3LM$default((Commands)commands2, (String)"0 H", (selection.getCurrent() == null ? 1 : 0) != 0, (int)0, null, (int)12, null)) {
                                    selection.set(null);
                                }
                                for (Protonation protonation2 : selection.getProtonations()) {
                                    if (!Commands.selectable-_H7b3LM$default((Commands)commands2, (String)(protonation2.getNumH() + " H, " + protonation2.getHybridization()), (boolean)Intrinsics.areEqual((Object)selection.getCurrent(), (Object)protonation2), (int)0, null, (int)12, null)) continue;
                                    slideCommands.showExceptions((Function0<Unit>)((Function0)new Function0<Unit>(selection, protonation2){
                                        final /* synthetic */ Selection $selection;
                                        final /* synthetic */ Protonation $protonation;
                                        {
                                            this.$selection = $selection;
                                            this.$protonation = $protonation;
                                            super(0);
                                        }

                                        public final void invoke() {
                                            this.$selection.set(this.$protonation);
                                        }
                                    }));
                                }
                            }
                            finally {
                                $this$listBox_u24default$iv.listBoxFooter();
                            }
                        }
                        Selection.Rotator rotator = selection.getRotator();
                        if ((rotator != null ? rotator.getRotationH() : null) != null) {
                            Selection.Rotator rotator2 = selection.getRotator();
                            commands2.spacing();
                            commands2.text("Rotation");
                            if (Commands.sliderFloat$default((Commands)commands2, (String)"Dihedral angle", rotator2.getPDihedral(), (float)-180.0f, (float)180.0f, (String)"%.1f", (float)0.0f, (int)32, null)) {
                                rotator2.set();
                            }
                            Commands.sameLine$default((Commands)commands2, (float)0.0f, (float)0.0f, (int)3, null);
                            InfoTipKt.infoTip$default(commands2, "Ctrl-click to type angle exactly", 0.0f, 2, null);
                            if (rotator2.getRotationHeavies().size() > 1 && Commands.listBoxHeader$default((Commands)commands2, (String)"Anchor Heavy Atom", (int)rotator2.getRotationHeavies().size(), (int)0, (int)4, null)) {
                                for (Atom atom : rotator2.getRotationHeavies()) {
                                    if (!Commands.selectable-_H7b3LM$default((Commands)commands2, (String)atom.getName(), (boolean)Intrinsics.areEqual((Object)rotator2.getRotationHeavy(), (Object)atom), (int)0, null, (int)12, null)) continue;
                                    rotator2.setRotationHeavy(atom);
                                }
                                commands2.listBoxFooter();
                            }
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    this_$iv.end();
                }
            }
        }), (Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ ProtonationEditor this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                HoverEffects.Writer writer = ProtonationEditor.access$getHoverEffects$p(this.this$0);
                if (writer != null) {
                    writer.close();
                }
                ProtonationEditor.access$setHoverEffects$p(this.this$0, null);
                Collection<V> collection = ProtonationEditor.access$getRenderEffects$p(this.this$0).values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"renderEffects.values");
                Iterable $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    MoleculeRenderEffects.Writer it = (MoleculeRenderEffects.Writer)element$iv;
                    boolean bl = false;
                    it.close();
                }
                ProtonationEditor.access$getRenderEffects$p(this.this$0).clear();
                ProtonationEditor.access$setSelection$p(this.this$0, null);
            }
        }));
    }

    private final void clearAll(List<? extends MoleculeRenderView> views) {
        for (MoleculeRenderView moleculeRenderView : views) {
            Molecule mol = moleculeRenderView.getMolStack().getOriginalMol();
            ProtonateKt.deprotonate(mol);
            moleculeRenderView.moleculeChanged();
        }
    }

    private final void autoProtonate(List<? extends MoleculeRenderView> views) {
        for (MoleculeRenderView moleculeRenderView : views) {
            boolean bl;
            boolean $i$f$forEach;
            Iterable $this$forEach$iv;
            Molecule mol = moleculeRenderView.getMolStack().getOriginalMol();
            boolean needsInversion = this.prep.isInverted(mol);
            if (needsInversion) {
                mol.invertedInPlace();
            }
            List<ProtonatedAtom> protons = ProtonateKt.inferProtonationBlocking(mol);
            if (needsInversion) {
                mol.invertedInPlace();
                $this$forEach$iv = protons;
                $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ProtonatedAtom protonatedAtom = (ProtonatedAtom)element$iv;
                    bl = false;
                    protonatedAtom.getLight().invertInPlace();
                }
            }
            $this$forEach$iv = protons;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ProtonatedAtom it = (ProtonatedAtom)element$iv;
                bl = false;
                it.add();
            }
            moleculeRenderView.moleculeChanged();
        }
    }

    @Override
    public void contextMenu(@NotNull ContextMenu contextMenu2, @NotNull Slide.Locked slide2, @NotNull SlideCommands slidewin, @NotNull ViewIndexed target) {
        SlideFeature.DefaultImpls.contextMenu(this, contextMenu2, slide2, slidewin, target);
    }

    public static final /* synthetic */ void access$setHoverEffects$p(ProtonationEditor $this, HoverEffects.Writer writer) {
        $this.hoverEffects = writer;
    }

    public static final /* synthetic */ ClickTracker access$getClickTracker$p(ProtonationEditor $this) {
        return $this.clickTracker;
    }

    public static final /* synthetic */ void access$setSelection$p(ProtonationEditor $this, Selection selection) {
        $this.selection = selection;
    }

    public static final /* synthetic */ WindowState access$getWinState$p(ProtonationEditor $this) {
        return $this.winState;
    }

    public static final /* synthetic */ void access$clearAll(ProtonationEditor $this, List views) {
        $this.clearAll(views);
    }

    public static final /* synthetic */ void access$autoProtonate(ProtonationEditor $this, List views) {
        $this.autoProtonate(views);
    }

    public static final /* synthetic */ Selection access$getSelection$p(ProtonationEditor $this) {
        return $this.selection;
    }

    public static final /* synthetic */ HoverEffects.Writer access$getHoverEffects$p(ProtonationEditor $this) {
        return $this.hoverEffects;
    }

    /*
     * Exception performing whole class analysis.
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001:\u0001\"B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010\nJ\b\u0010!\u001a\u00020\u001fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0017\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\f\u0018\u00010\u0018R\u00060\u0000R\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006#"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection;", "", "view", "Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "(Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor;Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getAtom", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "current", "Ledu/duke/cs/osprey/gui/forcefield/amber/Protonation;", "getCurrent", "()Ledu/duke/cs/osprey/gui/forcefield/amber/Protonation;", "setCurrent", "(Ledu/duke/cs/osprey/gui/forcefield/amber/Protonation;)V", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "getMol", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "protonations", "", "getProtonations", "()Ljava/util/List;", "rotator", "Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection$Rotator;", "Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor;", "getRotator", "()Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection$Rotator;", "getView", "()Ledu/duke/cs/osprey/molscope/view/MoleculeRenderView;", "set", "", "protonation", "updateSelectionEffects", "Rotator", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nProtonationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtonationEditor.kt\nedu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n1774#2,4:399\n1774#2,4:403\n766#2:407\n857#2,2:408\n766#2:411\n857#2,2:412\n766#2:414\n857#2,2:415\n1#3:410\n*S KotlinDebug\n*F\n+ 1 ProtonationEditor.kt\nedu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection\n*L\n225#1:399,4\n226#1:403,4\n228#1:407\n228#1:408,2\n324#1:411\n324#1:412,2\n329#1:414\n329#1:415,2\n*E\n"})
    private final class Selection {
        @NotNull
        private final MoleculeRenderView view;
        @NotNull
        private final Atom atom;
        @NotNull
        private final Molecule mol;
        @NotNull
        private final List<Protonation> protonations;
        @Nullable
        private Protonation current;
        @Nullable
        private final Rotator rotator;
        final /* synthetic */ ProtonationEditor this$0;

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        public Selection(@NotNull ProtonationEditor this$0, @NotNull MoleculeRenderView view, Atom atom) {
            Intrinsics.checkNotNullParameter((Object)view, (String)"view");
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.this$0 = this$0;
            super();
            this.view = view;
            this.atom = atom;
            this.mol = this.view.getMolStack().getOriginalMol();
            this.protonations = ProtonateKt.protonations(this.mol, this.atom);
            var4_4 = this;
            var19_5 = this;
            $i$a$-run-ProtonationEditor$Selection$current$1 = false;
            bondedAtoms /* !! */  = $this$current_u24lambda_u244.mol.getBonds().bondedAtoms($this$current_u24lambda_u244.atom);
            $this$count$iv = bondedAtoms /* !! */ ;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v0 = 0;
            } else {
                count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (Atom)element$iv;
                    $i$a$-count-ProtonationEditor$Selection$current$1$numHeavy$1 = false;
                    if (!(it.getElement() != Element.Hydrogen) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v0 = count$iv;
            }
            numHeavy = v0;
            $this$count$iv = bondedAtoms /* !! */ ;
            $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                v1 = 0;
            } else {
                count$iv = 0;
                for (E element$iv : $this$count$iv) {
                    it = (Atom)element$iv;
                    $i$a$-count-ProtonationEditor$Selection$current$1$numH$1 = false;
                    if (!(it.getElement() == Element.Hydrogen) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                v1 = count$iv;
            }
            numH = v1;
            $i$f$count = $this$current_u24lambda_u244.protonations;
            $i$f$filter = false;
            element$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Protonation)element$iv$iv;
                $i$a$-filter-ProtonationEditor$Selection$current$1$1 = false;
                if (!(it.getNumHeavy() == numHeavy && it.getNumH() == numH)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            it = $this$filter$iv = (List<E>)destination$iv$iv;
            $i$a$-takeIf-ProtonationEditor$Selection$current$1$2 = false;
            v2 /* !! */  = $this$count$iv = it.size() == 1 != false ? $this$filter$iv : null;
            var19_5.current = $this$count$iv != null ? (Protonation)CollectionsKt.first((List)$this$count$iv) : null;
            $this$current_u24lambda_u244 = this;
            var19_5 = this;
            $i$a$-run-ProtonationEditor$Selection$rotator$1 = false;
            bondedAtoms /* !! */  = $this$rotator_u24lambda_u247.mol.getBonds().bondedAtoms($this$rotator_u24lambda_u247.atom);
            $i$f$filter = false;
            $this$count$iv = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Atom)element$iv$iv;
                $i$a$-filter-ProtonationEditor$Selection$rotator$1$bondedHeavies$1 = false;
                if (!(it.getElement() != Element.Hydrogen)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            bondedHeavies = (List)destination$iv$iv;
            if (bondedHeavies.size() != 1) ** GOTO lbl-1000
            bondedHeavy = (Atom)CollectionsKt.first((List)bondedHeavies);
            $this$filterTo$iv$iv = $this$rotator_u24lambda_u247.mol.getBonds().bondedAtoms(bondedHeavy);
            $i$f$filter = false;
            $i$f$filterTo = $this$filter$iv;
            destination$iv$iv = new ArrayList<E>();
            $i$f$filterTo = false;
            for (T element$iv$iv : $this$filterTo$iv$iv) {
                it = (Atom)element$iv$iv;
                $i$a$-filter-ProtonationEditor$Selection$rotator$1$rotationHeavies$1 = false;
                if (!(it.getElement() != Element.Hydrogen && Intrinsics.areEqual((Object)it, (Object)$this$rotator_u24lambda_u247.atom) == false)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            rotationHeavies = (List)destination$iv$iv;
            if (((Collection)rotationHeavies).isEmpty() == false) {
                v3 = (Selection)$this$rotator_u24lambda_u247.new Rotator(bondedHeavy, rotationHeavies);
            } else lbl-1000:
            // 2 sources

            {
                v3 = null;
            }
            var19_5.rotator = v3;
            this.updateSelectionEffects();
        }

        @NotNull
        public final MoleculeRenderView getView() {
            return this.view;
        }

        @NotNull
        public final Atom getAtom() {
            return this.atom;
        }

        @NotNull
        public final Molecule getMol() {
            return this.mol;
        }

        @NotNull
        public final List<Protonation> getProtonations() {
            return this.protonations;
        }

        @Nullable
        public final Protonation getCurrent() {
            return this.current;
        }

        public final void setCurrent(@Nullable Protonation protonation2) {
            this.current = protonation2;
        }

        @Nullable
        public final Rotator getRotator() {
            return this.rotator;
        }

        public final void set(@Nullable Protonation protonation2) {
            if (Intrinsics.areEqual((Object)this.current, (Object)protonation2)) {
                return;
            }
            this.current = protonation2;
            if (protonation2 != null) {
                ProtonateKt.protonateBlocking(this.mol, this.atom, protonation2);
            } else {
                ProtonateKt.deprotonate(this.mol, this.atom);
            }
            this.view.moleculeChanged();
            Rotator rotator = this.rotator;
            if (rotator != null) {
                rotator.update();
            }
            this.updateSelectionEffects();
        }

        private final void updateSelectionEffects() {
            block1: {
                MoleculeRenderEffects.Writer writer = (MoleculeRenderEffects.Writer)this.this$0.renderEffects.get(this.view);
                if (writer == null) {
                    return;
                }
                MoleculeRenderEffects.Writer effects = writer;
                effects.clear();
                effects.set(this.atom, ProtonationEditorKt.access$getSelectedEffect$p());
                Object object = this.rotator;
                if (object == null || (object = ((Rotator)object).getRotationH()) == null) break block1;
                Object rotationH = object;
                boolean bl = false;
                Object[] objectArray = new Atom[]{this.rotator.getRotationHeavy(), this.rotator.getBondedHeavy(), this.atom, rotationH};
                effects.set(CollectionsKt.listOf((Object[])objectArray), ProtonationEditorKt.access$getRotationEffect$p());
            }
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0018\u001a\u00020\u000bH\u0002J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00032\u0006\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003J\n\u0010\u001e\u001a\u0004\u0018\u00010\u0003H\u0002J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020 J\u001a\u0010\"\u001a\n $*\u0004\u0018\u00010#0#*\u00020#2\u0006\u0010%\u001a\u00020&J\n\u0010'\u001a\u00020&*\u00020#J\n\u0010(\u001a\u00020)*\u00020\u0003R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\b\"\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\b\"\u0004\b\u0017\u0010\u0011\u00a8\u0006*"}, d2={"Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection$Rotator;", "", "bondedHeavy", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "rotationHeavies", "", "(Ledu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ljava/util/List;)V", "getBondedHeavy", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "pDihedral", "Lcuchaz/kludge/tools/Ref;", "", "getPDihedral", "()Lcuchaz/kludge/tools/Ref;", "rotationH", "getRotationH", "setRotationH", "(Ledu/duke/cs/osprey/molscope/molecule/Atom;)V", "getRotationHeavies", "()Ljava/util/List;", "value", "rotationHeavy", "getRotationHeavy", "setRotationHeavy", "measureDihedral", "", "a", "b", "c", "d", "pickHydrogen", "set", "", "update", "fromArray", "Lorg/joml/Vector3d;", "kotlin.jvm.PlatformType", "array", "", "toArray", "toInt", "", "osprey3"})
        @SourceDebugExtension(value={"SMAP\nProtonationEditor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtonationEditor.kt\nedu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection$Rotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,398:1\n766#2:399\n857#2,2:400\n2333#2,14:402\n766#2:423\n857#2,2:424\n1855#2,2:426\n429#3:416\n502#3,5:417\n1#4:422\n*S KotlinDebug\n*F\n+ 1 ProtonationEditor.kt\nedu/duke/cs/osprey/gui/features/slide/ProtonationEditor$Selection$Rotator\n*L\n249#1:399\n249#1:400,2\n250#1:402,14\n307#1:423\n307#1:424,2\n308#1:426,2\n264#1:416\n264#1:417,5\n*E\n"})
        public final class Rotator {
            @NotNull
            private final Atom bondedHeavy;
            @NotNull
            private final List<Atom> rotationHeavies;
            @NotNull
            private Atom rotationHeavy;
            @Nullable
            private Atom rotationH;
            @NotNull
            private final Ref<Float> pDihedral;

            public Rotator(@NotNull Atom bondedHeavy, List<Atom> rotationHeavies) {
                Intrinsics.checkNotNullParameter((Object)bondedHeavy, (String)"bondedHeavy");
                Intrinsics.checkNotNullParameter(rotationHeavies, (String)"rotationHeavies");
                this.bondedHeavy = bondedHeavy;
                this.rotationHeavies = rotationHeavies;
                this.rotationHeavy = (Atom)CollectionsKt.first(this.rotationHeavies);
                this.rotationH = this.pickHydrogen();
                this.pDihedral = Ref.Companion.of((Object)Float.valueOf(this.measureDihedral()));
            }

            @NotNull
            public final Atom getBondedHeavy() {
                return this.bondedHeavy;
            }

            @NotNull
            public final List<Atom> getRotationHeavies() {
                return this.rotationHeavies;
            }

            @NotNull
            public final Atom getRotationHeavy() {
                return this.rotationHeavy;
            }

            public final void setRotationHeavy(@NotNull Atom value2) {
                Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
                this.rotationHeavy = value2;
                this.update();
                Selection.this.updateSelectionEffects();
            }

            @Nullable
            public final Atom getRotationH() {
                return this.rotationH;
            }

            public final void setRotationH(@Nullable Atom atom) {
                this.rotationH = atom;
            }

            /*
             * WARNING - void declaration
             */
            private final Atom pickHydrogen() {
                Object v0;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = Selection.this.getMol().getBonds().bondedAtoms(Selection.this.getAtom());
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Atom it = (Atom)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getElement() == Element.Hydrogen)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$minByOrNull$iv = (List)destination$iv$iv;
                boolean $i$f$minByOrNull = false;
                Iterator iterator$iv = $this$minByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object minElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = minElem$iv;
                    } else {
                        Atom it = (Atom)minElem$iv;
                        boolean bl = false;
                        int minValue$iv = this.toInt(it);
                        do {
                            Object e$iv = iterator$iv.next();
                            Atom it2 = (Atom)e$iv;
                            $i$a$-minByOrNull-ProtonationEditor$Selection$Rotator$pickHydrogen$2 = false;
                            int v$iv = this.toInt(it2);
                            if (minValue$iv <= v$iv) continue;
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = minElem$iv;
                    }
                }
                return v0;
            }

            @NotNull
            public final Ref<Float> getPDihedral() {
                return this.pDihedral;
            }

            private final float measureDihedral() {
                Atom atom = this.rotationH;
                if (atom == null) {
                    return 0.0f;
                }
                Atom rotationH = atom;
                return (float)this.measureDihedral(this.rotationHeavy, this.bondedHeavy, Selection.this.getAtom(), rotationH);
            }

            /*
             * WARNING - void declaration
             */
            public final int toInt(@NotNull Atom $this$toInt) {
                void $this$filterTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)$this$toInt, (String)"<this>");
                String $this$filter$iv = $this$toInt.getName();
                boolean $i$f$filter = false;
                CharSequence charSequence = $this$filter$iv;
                Appendable destination$iv$iv = new StringBuilder();
                boolean $i$f$filterTo = false;
                int n = $this$filterTo$iv$iv.length();
                for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
                    char element$iv$iv;
                    char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                    boolean bl = false;
                    if (!Character.isDigit(it)) continue;
                    destination$iv$iv.append(element$iv$iv);
                }
                String string = ((StringBuilder)destination$iv$iv).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
                Integer n2 = StringsKt.toIntOrNull((String)string);
                return n2 != null ? n2 : 1;
            }

            @NotNull
            public final double[] toArray(@NotNull Vector3d $this$toArray) {
                Intrinsics.checkNotNullParameter((Object)$this$toArray, (String)"<this>");
                double[] dArray = new double[]{$this$toArray.x, $this$toArray.y, $this$toArray.z};
                return dArray;
            }

            public final Vector3d fromArray(@NotNull Vector3d $this$fromArray, @NotNull double[] array) {
                Intrinsics.checkNotNullParameter((Object)$this$fromArray, (String)"<this>");
                Intrinsics.checkNotNullParameter((Object)array, (String)"array");
                return $this$fromArray.set(array[0], array[1], array[2]);
            }

            public final double measureDihedral(@NotNull Atom a, @NotNull Atom b, @NotNull Atom c, @NotNull Atom d) {
                Intrinsics.checkNotNullParameter((Object)a, (String)"a");
                Intrinsics.checkNotNullParameter((Object)b, (String)"b");
                Intrinsics.checkNotNullParameter((Object)c, (String)"c");
                Intrinsics.checkNotNullParameter((Object)d, (String)"d");
                double[][] dArrayArray = new double[][]{this.toArray(a.getPos()), this.toArray(b.getPos()), this.toArray(c.getPos()), this.toArray(d.getPos())};
                return Protractor.measureDihedral(dArrayArray);
            }

            public final void update() {
                this.rotationH = this.pickHydrogen();
                this.pDihedral.setValue((Object)Float.valueOf(this.measureDihedral()));
            }

            /*
             * WARNING - void declaration
             */
            public final void set() {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                double it = LangKt.toRadians((double)((Number)this.pDihedral.getValue()).floatValue());
                boolean bl = false;
                Pair pair = TuplesKt.to((Object)Math.sin(it), (Object)Math.cos(it));
                double targetSin = ((Number)pair.component1()).doubleValue();
                double targetCos = ((Number)pair.component2()).doubleValue();
                double it2 = LangKt.toRadians((double)this.measureDihedral());
                boolean bl2 = false;
                Pair pair2 = TuplesKt.to((Object)Math.sin(it2), (Object)Math.cos(it2));
                double currentSin = ((Number)pair2.component1()).doubleValue();
                double currentCos = ((Number)pair2.component2()).doubleValue();
                double dsin = targetSin * currentCos - targetCos * currentSin;
                double dcos = targetCos * currentCos + targetSin * currentSin;
                DihedralRotation rotation = new DihedralRotation(this.toArray(this.bondedHeavy.getPos()), this.toArray(Selection.this.getAtom().getPos()), dsin, dcos);
                Iterable iterable = Selection.this.getMol().getBonds().bondedAtoms(Selection.this.getAtom());
                boolean $i$f$filter = false;
                Iterator iterator2 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    Atom it3 = (Atom)element$iv$iv;
                    boolean bl3 = false;
                    if (!(it3.getElement() == Element.Hydrogen)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Atom h = (Atom)element$iv;
                    boolean bl4 = false;
                    double[] coords = this.toArray(h.getPos());
                    rotation.transform(coords, 0);
                    this.fromArray(h.getPos(), coords);
                }
                Selection.this.getView().moleculeChanged();
            }
        }
    }
}

