/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.amber;

import edu.duke.cs.osprey.gui.forcefield.amber.Hybridization;
import edu.duke.cs.osprey.gui.forcefield.amber.MolPartitioningKt;
import edu.duke.cs.osprey.gui.forcefield.amber.MoleculeMapper;
import edu.duke.cs.osprey.gui.forcefield.amber.MoleculeMapperKt;
import edu.duke.cs.osprey.gui.forcefield.amber.MoleculeType;
import edu.duke.cs.osprey.gui.forcefield.amber.ProtonateKt;
import edu.duke.cs.osprey.gui.forcefield.amber.ProtonatedAtom;
import edu.duke.cs.osprey.gui.forcefield.amber.Protonation;
import edu.duke.cs.osprey.gui.forcefield.amber.ProtonationTypes;
import edu.duke.cs.osprey.gui.io.MOL2Kt;
import edu.duke.cs.osprey.gui.io.OspreyService;
import edu.duke.cs.osprey.gui.io.PDBKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import edu.duke.cs.osprey.service.services.ProtonateRequest;
import edu.duke.cs.osprey.service.services.ProtonateResponse;
import edu.duke.cs.osprey.service.services.ProtonationRequest;
import edu.duke.cs.osprey.service.services.ProtonationResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000B\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0004\u001a\u00020\u0005*\u00020\u0006\u001a\u0012\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a$\u0010\t\u001a\u0004\u0018\u00010\u0002*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r\u001a\u001b\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0006H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011\u001a\u0010\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f*\u00020\u0006\u001a%\u0010\u0013\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0002H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015\u001a\u001a\u0010\u0016\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\u0002\u001a\u0018\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a&\u0010\u0017\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00180\u000f*\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u0006H\u0002\"\u001a\u0010\u0000\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u001a"}, d2={"protonations", "", "Ledu/duke/cs/osprey/gui/forcefield/amber/Protonation;", "Ledu/duke/cs/osprey/gui/forcefield/amber/ProtonationTypes;", "deprotonate", "", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "findProtonation", "numH", "", "hybridization", "Ledu/duke/cs/osprey/gui/forcefield/amber/Hybridization;", "inferProtonation", "", "Ledu/duke/cs/osprey/gui/forcefield/amber/ProtonatedAtom;", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "inferProtonationBlocking", "protonate", "protonation", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/molscope/molecule/Atom;Ledu/duke/cs/osprey/gui/forcefield/amber/Protonation;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "protonateBlocking", "translateHydrogens", "Lkotlin/Pair;", "dst", "osprey3"})
@SourceDebugExtension(value={"SMAP\nprotonate.kt\nKotlin\n*S Kotlin\n*F\n+ 1 protonate.kt\nedu/duke/cs/osprey/gui/forcefield/amber/ProtonateKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,431:1\n766#2:432\n857#2,2:433\n766#2:435\n857#2,2:436\n766#2:438\n857#2,2:439\n1855#2,2:441\n766#2:443\n857#2,2:444\n1855#2,2:446\n766#2:449\n857#2,2:450\n1855#2,2:452\n766#2:454\n857#2,2:455\n1855#2:457\n1856#2:464\n766#2:465\n857#2,2:466\n1549#2:468\n1620#2,3:469\n766#2:472\n857#2,2:473\n1855#2,2:475\n766#2:477\n857#2,2:478\n1603#2,9:480\n1855#2:489\n288#2,2:490\n1856#2:493\n1612#2:494\n1963#2,14:501\n1#3:448\n1#3:492\n429#4:458\n502#4,5:459\n429#4:495\n502#4,5:496\n*S KotlinDebug\n*F\n+ 1 protonate.kt\nedu/duke/cs/osprey/gui/forcefield/amber/ProtonateKt\n*L\n23#1:432\n23#1:433,2\n28#1:435\n28#1:436,2\n38#1:438\n38#1:439,2\n39#1:441,2\n52#1:443\n52#1:444,2\n53#1:446,2\n85#1:449\n85#1:450,2\n86#1:452,2\n100#1:454\n100#1:455,2\n101#1:457\n101#1:464\n137#1:465\n137#1:466,2\n155#1:468\n155#1:469,3\n176#1:472\n176#1:473,2\n177#1:475,2\n299#1:477\n299#1:478,2\n300#1:480,9\n300#1:489\n305#1:490,2\n300#1:493\n300#1:494\n115#1:501,14\n300#1:492\n103#1:458\n103#1:459,5\n112#1:495\n112#1:496,5\n*E\n"})
public final class ProtonateKt {
    @NotNull
    private static final Map<Protonation, ProtonationTypes> protonations;

    @NotNull
    public static final List<Protonation> protonations(@NotNull Molecule $this$protonations, @NotNull Atom atom) {
        Object it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$protonations, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Iterable $this$filter$iv = $this$protonations.getBonds().bondedAtoms(atom);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Atom)element$iv$iv;
            boolean bl = false;
            if (!(((Atom)it).getElement() != Element.Hydrogen)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        int numHeavy = ((List)destination$iv$iv).size();
        $this$filter$iv = protonations.keySet();
        $i$f$filter = false;
        $this$filterTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (Protonation)element$iv$iv;
            boolean bl = false;
            if (!(((Protonation)it).getElement() == atom.getElement() && ((Protonation)it).getNumHeavy() == numHeavy)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    public static final void deprotonate(@NotNull Molecule $this$deprotonate, @NotNull Atom atom) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$deprotonate, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Iterable $this$filter$iv = $this$deprotonate.getBonds().bondedAtoms(atom);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Atom it = (Atom)element$iv$iv;
            boolean bl = false;
            if (!(it.getElement() == Element.Hydrogen)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Atom it = (Atom)element$iv;
            boolean bl = false;
            $this$deprotonate.getAtoms().remove(it);
            if (!($this$deprotonate instanceof Polymer)) continue;
            Object object = ((Polymer)$this$deprotonate).findResidue(it);
            if (object == null || (object = ((Polymer.Residue)object).getAtoms()) == null) continue;
            object.remove(it);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final void deprotonate(@NotNull Molecule $this$deprotonate) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$this$deprotonate, (String)"<this>");
        Iterable $this$filter$iv = $this$deprotonate.getAtoms();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Atom it = (Atom)element$iv$iv;
            boolean bl = false;
            if (!(it.getElement() == Element.Hydrogen)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Atom it = (Atom)element$iv;
            boolean bl = false;
            $this$deprotonate.getAtoms().remove(it);
            if (!($this$deprotonate instanceof Polymer)) continue;
            Object object = ((Polymer)$this$deprotonate).findResidue(it);
            if (object == null || (object = ((Polymer.Residue)object).getAtoms()) == null) continue;
            object.remove(it);
        }
    }

    @Nullable
    public static final Protonation findProtonation(@NotNull Molecule $this$findProtonation, @NotNull Atom atom, int numH, @NotNull Hybridization hybridization) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)$this$findProtonation, (String)"<this>");
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            Intrinsics.checkNotNullParameter((Object)((Object)hybridization), (String)"hybridization");
            Iterable iterable = ProtonateKt.protonations($this$findProtonation, atom);
            for (Object t : iterable) {
                Protonation it = (Protonation)t;
                boolean bl = false;
                if (!(it.getNumH() == numH && it.getHybridization() == hybridization)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public static final void protonateBlocking(@NotNull Molecule $this$protonateBlocking, @NotNull Atom atom, @NotNull Protonation protonation2) {
        Intrinsics.checkNotNullParameter((Object)$this$protonateBlocking, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
        Intrinsics.checkNotNullParameter((Object)protonation2, (String)"protonation");
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>($this$protonateBlocking, atom, protonation2, null){
            int label;
            final /* synthetic */ Molecule $this_protonateBlocking;
            final /* synthetic */ Atom $atom;
            final /* synthetic */ Protonation $protonation;
            {
                this.$this_protonateBlocking = $receiver;
                this.$atom = $atom;
                this.$protonation = $protonation;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ProtonateKt.protonate(this.$this_protonateBlocking, this.$atom, this.$protonation, (Continuation<? super Unit>)((Continuation)this));
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Nullable
    public static final Object protonate(@NotNull Molecule var0, @NotNull Atom var1_1, @NotNull Protonation var2_2, @NotNull Continuation<? super Unit> var3_3) {
        if (!(var3_3 instanceof protonate.1)) ** GOTO lbl-1000
        var37_4 = var3_3;
        if ((var37_4.label & -2147483648) != 0) {
            var37_4.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var3_3){
                Object L$0;
                Object L$1;
                Object L$2;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProtonateKt.protonate(null, null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var43_6 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                mol = $this$protonate;
                v0 = ProtonateKt.protonations.get(protonation);
                if (v0 == null) {
                    throw new IllegalArgumentException("protonation not supported for atom " + atom.getName() + ": " + (Protonation)protonation);
                }
                amberTypes = v0;
                var7_9 = new Molecule(mol.getName(), null, null, 6, null);
                $this$protonate_u24lambda_u249 = var7_9;
                $i$a$-apply-ProtonateKt$protonate$smol$1 = false;
                $this$protonate_u24lambda_u249.getAtoms().add(atom);
                $this$filter$iv = mol.getBonds().bondedAtoms(atom);
                $i$f$filter = false;
                var12_20 = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                var15_32 = $this$filterTo$iv$iv.iterator();
                while (var15_32.hasNext()) {
                    element$iv$iv = var15_32.next();
                    it = (Atom)element$iv$iv;
                    $i$a$-filter-ProtonateKt$protonate$smol$1$1 = false;
                    if (!(it.getElement() != Element.Hydrogen)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Atom)element$iv /* !! */ ;
                    $i$a$-forEach-ProtonateKt$protonate$smol$1$2 = false;
                    $this$protonate_u24lambda_u249.getAtoms().add(it);
                    $this$protonate_u24lambda_u249.getBonds().add(atom, it);
                }
                smol = MOL2Kt.toMol2$default(var7_9, null, 1, null);
                $this$protonate_u24lambda_u2414 = $this$protonate_u24lambda_u249 = new HashMap<K, V>();
                $i$a$-apply-ProtonateKt$protonate$domainHydrogens$1 = false;
                $this$filter$iv = mol instanceof Polymer != false ? ((Polymer)mol).findResidueOrThrow(atom).getAtoms() : (List<Atom>)mol.getAtoms();
                $i$f$filter = false;
                element$iv /* !! */  = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                element$iv$iv = $this$filterTo$iv$iv.iterator();
                while (element$iv$iv.hasNext()) {
                    element$iv$iv = element$iv$iv.next();
                    it = (Atom)element$iv$iv;
                    $i$a$-filter-ProtonateKt$protonate$domainHydrogens$1$1 = false;
                    if (!(it.getElement() == Element.Hydrogen)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    atom = (Atom)element$iv;
                    $i$a$-forEach-ProtonateKt$protonate$domainHydrogens$1$2 = false;
                    element$iv$iv = (Map)$this$protonate_u24lambda_u2414;
                    it = atom.getName();
                    $this$filter$iv = atom.getName();
                    $i$f$filter = false;
                    var21_66 = $this$filter$iv;
                    destination$iv$iv = new StringBuilder();
                    $i$f$filterTo = false;
                    var25_70 = $this$filterTo$iv$iv.length();
                    for (index$iv$iv = 0; index$iv$iv < var25_70; ++index$iv$iv) {
                        element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
                        it = element$iv$iv;
                        $i$a$-filter-ProtonateKt$protonate$domainHydrogens$1$2$1 = false;
                        if (!Character.isDigit(it)) continue;
                        destination$iv$iv.append(element$iv$iv);
                    }
                    v1 = ((StringBuilder)destination$iv$iv).toString();
                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"filterTo(StringBuilder(), predicate).toString()");
                    it = $this$filter$iv = v1;
                    $i$a$-takeIf-ProtonateKt$protonate$domainHydrogens$1$2$2 = false;
                    v2 = var29_74 = !StringsKt.isBlank((CharSequence)it) != false ? $this$filter$iv : null;
                    var29_74 = var29_74 != null ? Boxing.boxInt((int)Integer.parseInt(var29_74)) : null;
                    element$iv$iv.put((String)it, (String)var29_74);
                }
                domainHydrogens = $this$protonate_u24lambda_u249;
                v3 = smol;
                v4 = atom.getName();
                v5 = amberTypes.getHeavy();
                if (protonation.getNumHeavy() == 1 && amberTypes.getBondedHeavy() != null && amberTypes.getHeavyBond() != null) {
                    $this$filter$iv = mol.getBonds().bondedAtoms(atom);
                    var33_75 = v5;
                    var32_76 = v4;
                    var31_77 = v3;
                    $i$f$filter = false;
                    $this$filterTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList<E>();
                    $i$f$filterTo = false;
                    $i$a$-forEach-ProtonateKt$protonate$domainHydrogens$1$2 = $this$filterTo$iv$iv.iterator();
                    while ($i$a$-forEach-ProtonateKt$protonate$domainHydrogens$1$2.hasNext()) {
                        element$iv$iv = $i$a$-forEach-ProtonateKt$protonate$domainHydrogens$1$2.next();
                        it = (Atom)element$iv$iv;
                        $i$a$-filter-ProtonateKt$protonate$request$heavyAtom$1 = false;
                        if (!(it.getElement() != Element.Hydrogen)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    var34_78 = (List)destination$iv$iv;
                    $this$filter$iv = var34_78;
                    it = $this$filter$iv;
                    $i$a$-takeIf-ProtonateKt$protonate$request$heavyAtom$2 = false;
                    var34_79 = it.size() == 1;
                    v3 = var31_77;
                    v4 = var32_76;
                    v5 = var33_75;
                    v6 = $i$a$-apply-ProtonateKt$protonate$domainHydrogens$1 = var34_79 != false ? $this$filter$iv : null;
                    if ($i$a$-apply-ProtonateKt$protonate$domainHydrogens$1 == null || ($this$filter$iv = (Atom)CollectionsKt.first((List)$i$a$-apply-ProtonateKt$protonate$domainHydrogens$1)) == null) {
                        throw new IllegalArgumentException("couldn't find unique heavy bonded atom");
                    }
                    heavyAtom = $this$filter$iv;
                    v7 = amberTypes.getBondedHeavy().get((Object)heavyAtom.getElement());
                    if (v7 == null) {
                        throw new Error("protonation is Sp hybridized, but has no bonded heavy atom type for " + heavyAtom.getElement());
                    }
                    heavyAtomType = v7;
                    v8 = CollectionsKt.listOf((Object)new ProtonateRequest.Bond(heavyAtom.getName(), heavyAtomType, amberTypes.getHeavyBond()));
                } else {
                    v8 = CollectionsKt.emptyList();
                }
                $this$map$iv = (Iterable)RangesKt.until((int)0, (int)protonation.getNumH());
                var34_80 = v8;
                var33_75 = v5;
                var32_76 = v4;
                var31_77 = v3;
                $i$f$map = false;
                $this$filter$iv = $this$map$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                $i$f$mapTo = false;
                destination$iv$iv = $this$mapTo$iv$iv.iterator();
                while (destination$iv$iv.hasNext()) {
                    $i$a$-forEach-ProtonateKt$protonate$domainHydrogens$1$2 = item$iv$iv = ((IntIterator)destination$iv$iv).nextInt();
                    var35_81 = destination$iv$iv;
                    $i$a$-map-ProtonateKt$protonate$request$1 = false;
                    var35_81.add(new ProtonateRequest.Hydrogen(ProtonateKt.protonate$pickHydrogenName(atom, (HashMap<String, Integer>)domainHydrogens, (int)i), amberTypes.getHydrogen()));
                }
                var38_82 = var35_81 = (List)destination$iv$iv;
                var39_83 = var34_80;
                var40_84 = var33_75;
                var41_85 = var32_76;
                var42_86 = var31_77;
                request = new ProtonateRequest(var42_86, var41_85, var40_84, var39_83, (List<ProtonateRequest.Hydrogen>)var38_82);
                var30_87 = Molecule.Companion;
                $continuation.L$0 = atom;
                $continuation.L$1 = mol;
                $continuation.L$2 = var30_87;
                $continuation.label = 1;
                v9 = OspreyService.INSTANCE.protonate(request, (Continuation<? super ProtonateResponse>)$continuation);
                if (v9 == var43_6) {
                    return var43_6;
                }
                ** GOTO lbl175
            }
            case 1: {
                var30_87 = (Molecule.Companion)$continuation.L$2;
                mol = (Molecule)$continuation.L$1;
                atom = (Atom)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v9 = $result;
lbl175:
                // 2 sources

                hmol = MOL2Kt.fromMol2(var30_87, ((ProtonateResponse)v9).getMol2(), Boxing.boxBoolean((boolean)(mol instanceof Polymer)));
                $i$f$mapTo = hmol.getAtoms();
                for (T item$iv$iv : $i$f$mapTo) {
                    it = (Atom)item$iv$iv;
                    $i$a$-find-ProtonateKt$protonate$centerAtom$1 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)atom.getName())) continue;
                    v10 = item$iv$iv;
                    ** GOTO lbl184
                }
                v10 = null;
lbl184:
                // 2 sources

                v11 = v10;
                if (v11 == null) {
                    throw new Error("can't find central atom in LEaP output molecule");
                }
                centerAtom = v11;
                ProtonateKt.deprotonate(mol, atom);
                v12 = mol instanceof Polymer != false ? (Polymer)mol : null;
                res = v12 != null ? v12.findResidue(atom) : null;
                $this$filter$iv = hmol.getBonds().bondedAtoms(centerAtom);
                $i$f$filter = false;
                destination$iv$iv = $this$filter$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    it = (Atom)element$iv$iv;
                    $i$a$-filter-ProtonateKt$protonate$2 = false;
                    if (!(it.getElement() == Element.Hydrogen)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$forEach$iv = (List)destination$iv$iv;
                $i$f$forEach = false;
                for (T element$iv : $this$forEach$iv) {
                    it = (Atom)element$iv;
                    $i$a$-forEach-ProtonateKt$protonate$3 = false;
                    mol.getAtoms().add(it);
                    mol.getBonds().add(atom, it);
                    v13 = res;
                    if (v13 == null || (v13 = v13.getAtoms()) == null) continue;
                    Boxing.boxBoolean((boolean)v13.add(it));
                }
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final List<ProtonatedAtom> inferProtonationBlocking(@NotNull Molecule $this$inferProtonationBlocking) {
        Intrinsics.checkNotNullParameter((Object)$this$inferProtonationBlocking, (String)"<this>");
        return (List)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super List<? extends ProtonatedAtom>>, Object>($this$inferProtonationBlocking, null){
            int label;
            final /* synthetic */ Molecule $this_inferProtonationBlocking;
            {
                this.$this_inferProtonationBlocking = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        this.label = 1;
                        Object object3 = ProtonateKt.inferProtonation(this.$this_inferProtonationBlocking, (Continuation<? super List<ProtonatedAtom>>)((Continuation)this));
                        if (object3 != object2) return object3;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return object3;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value2, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super List<ProtonatedAtom>> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object inferProtonation(@NotNull Molecule var0, @NotNull Continuation<? super List<ProtonatedAtom>> var1_1) {
        if (!(var1_1 instanceof inferProtonation.1)) ** GOTO lbl-1000
        var22_2 = var1_1;
        if ((var22_2.label & -2147483648) != 0) {
            var22_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(var1_1){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return ProtonateKt.inferProtonation(null, (Continuation<? super List<ProtonatedAtom>>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var23_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                dst = $this$inferProtonation;
                dstAtoms = new ArrayList();
                var4_7 = MolPartitioningKt.partitionAndAtomMap(dst, true);
                partition = (List)var4_7.component1();
                atomMap = (AtomMap)var4_7.component2();
                var7_10 = partition.iterator();
lbl18:
                // 4 sources

                block10: while (var7_10.hasNext()) {
                    var8_11 = (Pair)var7_10.next();
                    type = (MoleculeType)var8_11.component1();
                    src = (Molecule)var8_11.component2();
                    switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            v0 = new ProtonationRequest(PDBKt.toPDB$default(src, false, false, null, null, false, false, false, 127, null), type.getDefaultForcefieldNameOrThrow().getName(), null);
                            break;
                        }
                        case 5: {
                            ffname = type.getDefaultForcefieldNameOrThrow();
                            v0 = new ProtonationRequest(PDBKt.toPDB$default(src, false, false, null, null, false, false, false, 127, null), ffname.getName(), ffname.getAtomTypesOrThrow().getId());
                            break;
                        }
                        case 6: {
                            continue block10;
                        }
                        case 7: {
                            continue block10;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    request = v0;
                    var20_23 = Molecule.Companion;
                    $continuation.L$0 = dst;
                    $continuation.L$1 = dstAtoms;
                    $continuation.L$2 = atomMap;
                    $continuation.L$3 = var7_10;
                    $continuation.L$4 = src;
                    $continuation.L$5 = var20_23;
                    $continuation.label = 1;
                    v1 = OspreyService.INSTANCE.protonation(request, (Continuation<? super ProtonationResponse>)$continuation);
                    if (v1 == var23_4) {
                        return var23_4;
                    }
                    ** GOTO lbl59
                }
                break;
            }
            case 1: {
                var20_23 = (Molecule.Companion)$continuation.L$5;
                src = (Molecule)$continuation.L$4;
                var7_10 = (Iterator<E>)$continuation.L$3;
                atomMap = (AtomMap)$continuation.L$2;
                dstAtoms = (ArrayList)$continuation.L$1;
                dst = (Molecule)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl59:
                // 2 sources

                protonatedMol = MOL2Kt.fromMol2(var20_23, ((ProtonationResponse)v1).getMol2(), Boxing.boxBoolean((boolean)(src instanceof Polymer)));
                srcAtoms = ProtonateKt.translateHydrogens(protonatedMol, src);
                for (Pair<Atom, Atom> var15_18 : srcAtoms) {
                    srcHeavy = (Atom)var15_18.component1();
                    h = (Atom)var15_18.component2();
                    dstHeavy = atomMap.getAOrThrow(srcHeavy);
                    v2 = dst instanceof Polymer != false ? (Polymer)dst : null;
                    v3 = chainRes = v2 != null ? v2.findChainAndResidue(dstHeavy) : null;
                    v4 = chainRes;
                    dstAtoms.add(new ProtonatedAtom(dst, v3 != null ? (Polymer.Chain)v3.getFirst() : null, v4 != null ? (Polymer.Residue)v4.getSecond() : null, dstHeavy, h));
                }
                ** GOTO lbl18
            }
        }
        return dstAtoms;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - void declaration
     */
    private static final List<Pair<Atom, Atom>> translateHydrogens(Molecule $this$translateHydrogens, Molecule dst) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Molecule src = $this$translateHydrogens;
        MoleculeMapper mapper = MoleculeMapperKt.mapTo(src, dst);
        Iterable iterable = src.getAtoms();
        boolean $i$f$filter = false;
        void var6_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Atom it = (Atom)element$iv$iv;
            boolean bl = false;
            if (!(it.getElement() == Element.Hydrogen)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Pair it$iv$iv;
            Atom dstHeavy;
            Atom srcHeavy;
            Object v0;
            Atom srcH;
            block3: {
                void $this$firstOrNull$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                srcH = (Atom)element$iv$iv;
                boolean bl2 = false;
                Iterable iterable2 = src.getBonds().bondedAtoms(srcH);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Atom it = (Atom)element$iv;
                    boolean bl3 = false;
                    if (!(it.getElement() != Element.Hydrogen)) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if (((Atom)v0 == null ? null : (mapper.mapAtom(srcHeavy) == null ? null : TuplesKt.to((Object)dstHeavy, (Object)srcH))) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final String protonate$pickHydrogenName(Atom $atom, HashMap<String, Integer> domainHydrogens, int i) {
        void $this$filterTo$iv$iv;
        String $this$filter$iv = $atom.getName();
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        String string = ((StringBuilder)destination$iv$iv).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"filterTo(StringBuilder(), predicate).toString()");
        String atomNumber = string;
        int hNumber = Integer.parseInt(atomNumber + (i + 1));
        if (domainHydrogens.values().contains(hNumber)) {
            Integer n2;
            Object v2;
            Collection<Integer> collection = domainHydrogens.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"domainHydrogens.values");
            Iterable $this$maxByOrNull$iv = collection;
            boolean $i$f$maxByOrNull = false;
            Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
            if (!iterator$iv.hasNext()) {
                v2 = null;
            } else {
                Object maxElem$iv = iterator$iv.next();
                if (!iterator$iv.hasNext()) {
                    v2 = maxElem$iv;
                } else {
                    Integer it = (Integer)maxElem$iv;
                    boolean bl = false;
                    Integer n3 = it;
                    if (n3 == null) {
                        n3 = 0;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)n3, (String)"it ?: 0");
                    int maxValue$iv = ((Number)n3).intValue();
                    do {
                        Object e$iv = iterator$iv.next();
                        Integer it2 = (Integer)e$iv;
                        $i$a$-maxByOrNull-ProtonateKt$protonate$pickHydrogenName$1 = false;
                        Integer n4 = it2;
                        if (n4 == null) {
                            n4 = 0;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"it ?: 0");
                        int v$iv = ((Number)n4).intValue();
                        if (maxValue$iv >= v$iv) continue;
                        maxElem$iv = e$iv;
                        maxValue$iv = v$iv;
                    } while (iterator$iv.hasNext());
                    v2 = maxElem$iv;
                }
            }
            if ((n2 = (Integer)v2) == null) {
                n2 = 0;
            }
            hNumber = n2 + 1;
        }
        String hName = "H" + hNumber;
        Integer n5 = hNumber;
        ((Map)domainHydrogens).put(hName, n5);
        return hName;
    }

    static {
        Pair[] pairArray = new Pair[40];
        pairArray[0] = TuplesKt.to((Object)new Protonation(Element.Carbon, 0, 2, Hybridization.Sp2), (Object)new ProtonationTypes("c1", "hc", null, null, 12, null));
        pairArray[1] = TuplesKt.to((Object)new Protonation(Element.Carbon, 0, 3, Hybridization.Sp2), (Object)new ProtonationTypes("c2", "hc", null, null, 12, null));
        pairArray[2] = TuplesKt.to((Object)new Protonation(Element.Carbon, 0, 4, Hybridization.Sp3), (Object)new ProtonationTypes("c3", "hc", null, null, 12, null));
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)Element.Carbon), (Object)"c1"), TuplesKt.to((Object)((Object)Element.Nitrogen), (Object)"n1"), TuplesKt.to((Object)((Object)Element.Phosphorus), (Object)"p2")};
        pairArray[3] = TuplesKt.to((Object)new Protonation(Element.Carbon, 1, 1, Hybridization.Sp), (Object)new ProtonationTypes("c1", "hc", "T", MapsKt.mapOf((Pair[])pairArray2)));
        pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)Element.Carbon), (Object)"c2"), TuplesKt.to((Object)((Object)Element.Nitrogen), (Object)"n2"), TuplesKt.to((Object)((Object)Element.Phosphorus), (Object)"p3"), TuplesKt.to((Object)((Object)Element.Oxygen), (Object)"o")};
        pairArray[4] = TuplesKt.to((Object)new Protonation(Element.Carbon, 1, 2, Hybridization.Sp2), (Object)new ProtonationTypes("c2", "hc", "D", MapsKt.mapOf((Pair[])pairArray2)));
        pairArray[5] = TuplesKt.to((Object)new Protonation(Element.Carbon, 1, 3, Hybridization.Sp3), (Object)new ProtonationTypes("c3", "hc", null, null, 12, null));
        pairArray[6] = TuplesKt.to((Object)new Protonation(Element.Carbon, 2, 1, Hybridization.Sp2), (Object)new ProtonationTypes("c2", "hc", null, null, 12, null));
        pairArray[7] = TuplesKt.to((Object)new Protonation(Element.Carbon, 2, 2, Hybridization.Sp3), (Object)new ProtonationTypes("c3", "hc", null, null, 12, null));
        pairArray[8] = TuplesKt.to((Object)new Protonation(Element.Carbon, 3, 1, Hybridization.Sp3), (Object)new ProtonationTypes("c3", "hc", null, null, 12, null));
        pairArray[9] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 0, 2, Hybridization.Sp2), (Object)new ProtonationTypes("n2", "hn", null, null, 12, null));
        pairArray[10] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 0, 3, Hybridization.Sp3), (Object)new ProtonationTypes("n3", "hn", null, null, 12, null));
        pairArray[11] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 0, 4, Hybridization.Sp3), (Object)new ProtonationTypes("n4", "hn", null, null, 12, null));
        pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)Element.Carbon), (Object)"c1"), TuplesKt.to((Object)((Object)Element.Nitrogen), (Object)"n1"), TuplesKt.to((Object)((Object)Element.Phosphorus), (Object)"p2")};
        pairArray[12] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 1, 1, Hybridization.Sp), (Object)new ProtonationTypes("n1", "hn", "T", MapsKt.mapOf((Pair[])pairArray2)));
        pairArray[13] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 1, 1, Hybridization.Sp2), (Object)new ProtonationTypes("n2", "hn", null, null, 12, null));
        pairArray[14] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 1, 2, Hybridization.Sp2), (Object)new ProtonationTypes("na", "hn", null, null, 12, null));
        pairArray[15] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 1, 2, Hybridization.Sp3), (Object)new ProtonationTypes("n3", "hn", null, null, 12, null));
        pairArray[16] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 1, 3, Hybridization.Sp3), (Object)new ProtonationTypes("n4", "hn", null, null, 12, null));
        pairArray[17] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 2, 1, Hybridization.Sp2), (Object)new ProtonationTypes("na", "hn", null, null, 12, null));
        pairArray[18] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 2, 1, Hybridization.Sp3), (Object)new ProtonationTypes("n3", "hn", null, null, 12, null));
        pairArray[19] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 2, 2, Hybridization.Sp3), (Object)new ProtonationTypes("n4", "hn", null, null, 12, null));
        pairArray[20] = TuplesKt.to((Object)new Protonation(Element.Nitrogen, 3, 1, Hybridization.Sp3), (Object)new ProtonationTypes("n4", "hn", null, null, 12, null));
        pairArray[21] = TuplesKt.to((Object)new Protonation(Element.Oxygen, 0, 1, Hybridization.Sp2), (Object)new ProtonationTypes("o", "hw", null, null, 12, null));
        pairArray[22] = TuplesKt.to((Object)new Protonation(Element.Oxygen, 0, 2, Hybridization.Sp3), (Object)new ProtonationTypes("ow", "hw", null, null, 12, null));
        pairArray[23] = TuplesKt.to((Object)new Protonation(Element.Oxygen, 0, 3, Hybridization.Sp3), (Object)new ProtonationTypes("ow", "hw", null, null, 12, null));
        pairArray[24] = TuplesKt.to((Object)new Protonation(Element.Oxygen, 1, 1, Hybridization.Sp3), (Object)new ProtonationTypes("oh", "ho", null, null, 12, null));
        pairArray[25] = TuplesKt.to((Object)new Protonation(Element.Oxygen, 1, 2, Hybridization.Sp3), (Object)new ProtonationTypes("oh", "ho", null, null, 12, null));
        pairArray[26] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 0, 2, Hybridization.Sp2), (Object)new ProtonationTypes("p2", "hp", null, null, 12, null));
        pairArray[27] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 0, 3, Hybridization.Sp3), (Object)new ProtonationTypes("p3", "hp", null, null, 12, null));
        pairArray[28] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 0, 4, Hybridization.Sp3), (Object)new ProtonationTypes("p5", "hp", null, null, 12, null));
        pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)Element.Carbon), (Object)"c2"), TuplesKt.to((Object)((Object)Element.Nitrogen), (Object)"n2"), TuplesKt.to((Object)((Object)Element.Phosphorus), (Object)"p3"), TuplesKt.to((Object)((Object)Element.Oxygen), (Object)"o")};
        pairArray[29] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 1, 1, Hybridization.Sp2), (Object)new ProtonationTypes("p2", "hp", "D", MapsKt.mapOf((Pair[])pairArray2)));
        pairArray[30] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 1, 2, Hybridization.Sp3), (Object)new ProtonationTypes("p3", "hp", null, null, 12, null));
        pairArray[31] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 1, 3, Hybridization.Sp3), (Object)new ProtonationTypes("p5", "hp", null, null, 12, null));
        pairArray[32] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 2, 1, Hybridization.Sp3), (Object)new ProtonationTypes("p3", "hp", null, null, 12, null));
        pairArray[33] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 2, 2, Hybridization.Sp3), (Object)new ProtonationTypes("p5", "hp", null, null, 12, null));
        pairArray[34] = TuplesKt.to((Object)new Protonation(Element.Phosphorus, 3, 1, Hybridization.Sp3), (Object)new ProtonationTypes("p5", "hp", null, null, 12, null));
        pairArray[35] = TuplesKt.to((Object)new Protonation(Element.Sulfur, 0, 1, Hybridization.Sp2), (Object)new ProtonationTypes("s", "hs", null, null, 12, null));
        pairArray[36] = TuplesKt.to((Object)new Protonation(Element.Sulfur, 0, 2, Hybridization.Sp3), (Object)new ProtonationTypes("sh", "hs", null, null, 12, null));
        pairArray[37] = TuplesKt.to((Object)new Protonation(Element.Sulfur, 0, 3, Hybridization.Sp3), (Object)new ProtonationTypes("sh", "hs", null, null, 12, null));
        pairArray[38] = TuplesKt.to((Object)new Protonation(Element.Sulfur, 1, 1, Hybridization.Sp3), (Object)new ProtonationTypes("sh", "hs", null, null, 12, null));
        pairArray[39] = TuplesKt.to((Object)new Protonation(Element.Sulfur, 1, 2, Hybridization.Sp3), (Object)new ProtonationTypes("sh", "hs", null, null, 12, null));
        protonations = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 8, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[MoleculeType.values().length];
            try {
                nArray[MoleculeType.Protein.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoleculeType.DNA.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoleculeType.RNA.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoleculeType.Solvent.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoleculeType.SmallMolecule.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoleculeType.AtomicIon.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MoleculeType.Synthetic.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

