/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.forcefield.eef1;

import edu.duke.cs.osprey.gui.forcefield.AtomIndex;
import edu.duke.cs.osprey.gui.forcefield.Forcefield;
import edu.duke.cs.osprey.gui.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.gui.forcefield.eef1.EEF1;
import edu.duke.cs.osprey.gui.forcefield.eef1.Eef1Kt;
import edu.duke.cs.osprey.gui.tools.ArrayMap;
import edu.duke.cs.osprey.gui.tools.CombineCollisionException;
import edu.duke.cs.osprey.gui.tools.LangKt;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 (2\u00020\u0001:\u0005$%&'(B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J#\u0010\u0016\u001a\u00060\u0017R\u00020\u00002\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u001bJ+\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010\u000eH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010#R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000eX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006)"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams;", "()V", "forcefield", "Ledu/duke/cs/osprey/gui/forcefield/Forcefield$EEF1;", "getForcefield", "()Ledu/duke/cs/osprey/gui/forcefield/Forcefield$EEF1;", "scale", "", "getScale", "()D", "setScale", "(D)V", "unconnectedDistance", "", "getUnconnectedDistance", "()I", "combineAtomsParams", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomsParams;", "info1", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomsInfo;", "info2", "parameterizeAtomPairs", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomPairsParams;", "infos", "", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$MolInfo;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "parameterizeAtoms", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomsParams;", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "atomIndex", "Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;", "netCharge", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ledu/duke/cs/osprey/gui/forcefield/AtomIndex;Ljava/lang/Integer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "AtomPairParams", "AtomPairsParams", "AtomParams", "AtomsParams", "Companion", "osprey3"})
public final class EEF1ForcefieldParams
implements ForcefieldParams {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Forcefield.EEF1 forcefield = Forcefield.EEF1.INSTANCE;
    private final int unconnectedDistance;
    private double scale = 0.5;
    private static final double trigConst = 2.0 / (Math.PI * 4 * cuchaz.kludge.tools.LangKt.sqrt((double)Math.PI));
    public static final double cutoff = 9.0;

    public EEF1ForcefieldParams() {
        this.unconnectedDistance = 4;
    }

    @Override
    @NotNull
    public Forcefield.EEF1 getForcefield() {
        return this.forcefield;
    }

    @Override
    public int getUnconnectedDistance() {
        return this.unconnectedDistance;
    }

    public final double getScale() {
        return this.scale;
    }

    public final void setScale(double d) {
        this.scale = d;
    }

    @Nullable
    public Object parameterizeAtoms(@NotNull Molecule mol, @NotNull AtomIndex atomIndex, @Nullable Integer netCharge, @NotNull Continuation<? super AtomsParams> $completion) {
        AtomsParams atomsParams;
        AtomsParams $this$parameterizeAtoms_u24lambda_u240 = atomsParams = new AtomsParams();
        boolean bl = false;
        for (Atom atom : mol.getAtoms()) {
            EEF1.AtomType type;
            if (Eef1Kt.atomTypeEEF1(atom, mol) == null) continue;
            int atomi = atomIndex.getOrThrow(atom);
            Integer n = Boxing.boxInt((int)atomi);
            ((Map)$this$parameterizeAtoms_u24lambda_u240.getAtomsParams()).put(n, new AtomParams(type));
        }
        return atomsParams;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Object parameterizeAtomPairs(@NotNull List<ForcefieldParams.MolInfo> infos2, @NotNull Continuation<? super AtomPairsParams> $completion) {
        ArrayMap arrayMap;
        ArrayMap arrayMap2 = arrayMap = new ArrayMap();
        EEF1ForcefieldParams eEF1ForcefieldParams = this;
        boolean bl = false;
        for (ForcefieldParams.MolInfo info2 : infos2) {
            void $this$parameterizeAtomPairs_u24lambda_u241;
            Map map = (Map)$this$parameterizeAtomPairs_u24lambda_u241;
            Integer n = Boxing.boxInt((int)info2.getMoli());
            ForcefieldParams.AtomsParams atomsParams = info2.getAtomsParams();
            Intrinsics.checkNotNull((Object)atomsParams, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.forcefield.eef1.EEF1ForcefieldParams.AtomsParams");
            AtomsParams atomsParams2 = (AtomsParams)atomsParams;
            map.put(n, atomsParams2);
        }
        Map map = arrayMap;
        EEF1ForcefieldParams eEF1ForcefieldParams2 = eEF1ForcefieldParams;
        return eEF1ForcefieldParams2.new AtomPairsParams(map);
    }

    @Override
    @NotNull
    public ForcefieldParams.AtomsParams combineAtomsParams(@NotNull ForcefieldParams.AtomsInfo info1, @NotNull ForcefieldParams.AtomsInfo info2) {
        Intrinsics.checkNotNullParameter((Object)info1, (String)"info1");
        Intrinsics.checkNotNullParameter((Object)info2, (String)"info2");
        ForcefieldParams.AtomsParams atomsParams = info1.getAtomsParams();
        Intrinsics.checkNotNull((Object)atomsParams, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.forcefield.eef1.EEF1ForcefieldParams.AtomsParams");
        AtomsParams cfr_ignored_0 = (AtomsParams)atomsParams;
        ForcefieldParams.AtomsParams atomsParams2 = info2.getAtomsParams();
        Intrinsics.checkNotNull((Object)atomsParams2, (String)"null cannot be cast to non-null type edu.duke.cs.osprey.gui.forcefield.eef1.EEF1ForcefieldParams.AtomsParams");
        AtomsParams cfr_ignored_1 = (AtomsParams)atomsParams2;
        AtomsParams combined = new AtomsParams();
        try {
            LangKt.combineMaps((Map)((AtomsParams)info1.getAtomsParams()).getAtomsParams(), info1.getPreferredAtomIndices(), info1.getIgnoredAtomIndices(), (Map)((AtomsParams)info2.getAtomsParams()).getAtomsParams(), info2.getPreferredAtomIndices(), info2.getIgnoredAtomIndices(), (Map)combined.getAtomsParams());
        }
        catch (CombineCollisionException ex) {
            throw new IllegalArgumentException(StringsKt.trimMargin$default((String)("\n\t\t\t\t|two EEF1 atoms params disagree on atom params for atom " + ex.getKey() + ":\n\t\t\t\t|\t" + ex.getVal1() + "\n\t\t\t\t|\t" + ex.getVal2() + "\n\t\t\t"), null, (int)1, null));
        }
        return combined;
    }

    @Override
    @NotNull
    public Map<String, Object> settings() {
        return ForcefieldParams.DefaultImpls.settings(this);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B5\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u0012\u0006\u0010\n\u001a\u00020\u0007\u0012\u0006\u0010\u000b\u001a\u00020\u0007\u0012\u0006\u0010\f\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\rJ\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u0007H\u0016R\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000fR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000fR\u0011\u0010\t\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u000f\u00a8\u0006\u001b"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomPairParams;", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomPairParams;", "a", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1$AtomType;", "b", "(Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1$AtomType;Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1$AtomType;)V", "vdwRadiusa", "", "lambdaa", "vdwRadiusb", "lambdab", "alpha1", "alpha2", "(Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;DDDDDD)V", "getAlpha1", "()D", "getAlpha2", "getLambdaa", "getLambdab", "list", "", "getList", "()Ljava/util/List;", "getVdwRadiusa", "getVdwRadiusb", "calcEnergy", "r", "osprey3"})
    public final class AtomPairParams
    implements ForcefieldParams.AtomPairParams {
        private final double vdwRadiusa;
        private final double lambdaa;
        private final double vdwRadiusb;
        private final double lambdab;
        private final double alpha1;
        private final double alpha2;
        @NotNull
        private final List<Double> list;
        final /* synthetic */ EEF1ForcefieldParams this$0;

        public AtomPairParams(EEF1ForcefieldParams this$0, double vdwRadiusa, double lambdaa, double vdwRadiusb, double lambdab, double alpha1, double alpha2) {
            this.this$0 = this$0;
            this.vdwRadiusa = vdwRadiusa;
            this.lambdaa = lambdaa;
            this.vdwRadiusb = vdwRadiusb;
            this.lambdab = lambdab;
            this.alpha1 = alpha1;
            this.alpha2 = alpha2;
            Object[] objectArray = new Double[]{this.vdwRadiusa, this.lambdaa, this.vdwRadiusb, this.lambdab, this.alpha1, this.alpha2};
            this.list = CollectionsKt.listOf((Object[])objectArray);
        }

        public final double getVdwRadiusa() {
            return this.vdwRadiusa;
        }

        public final double getLambdaa() {
            return this.lambdaa;
        }

        public final double getVdwRadiusb() {
            return this.vdwRadiusb;
        }

        public final double getLambdab() {
            return this.lambdab;
        }

        public final double getAlpha1() {
            return this.alpha1;
        }

        public final double getAlpha2() {
            return this.alpha2;
        }

        public AtomPairParams(@NotNull EEF1ForcefieldParams this$0, @NotNull EEF1.AtomType a, EEF1.AtomType b) {
            Intrinsics.checkNotNullParameter((Object)((Object)a), (String)"a");
            Intrinsics.checkNotNullParameter((Object)((Object)b), (String)"b");
            this(this$0, a.getVdwRadius(), a.getLambda(), b.getVdwRadius(), b.getLambda(), this$0.getScale() * Companion.getTrigConst() * a.getDGfree() * b.getVolume() / a.getLambda(), this$0.getScale() * Companion.getTrigConst() * b.getDGfree() * a.getVolume() / b.getLambda());
        }

        @Override
        @NotNull
        public List<Double> getList() {
            return this.list;
        }

        @Override
        public double calcEnergy(double r) {
            double d;
            if (r <= 9.0) {
                double Xij = (r - this.vdwRadiusa) / this.lambdaa;
                double Xji = (r - this.vdwRadiusb) / this.lambdab;
                double r2 = r * r;
                d = -(this.alpha1 * Math.exp(-Xij * Xij) + this.alpha2 * Math.exp(-Xji * Xji)) / r2;
            } else {
                d = 0.0;
            }
            return d;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J>\u0010\t\u001a\b\u0018\u00010\nR\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\u0011R\u001d\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0012"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomPairsParams;", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomPairsParams;", "molsParams", "", "", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomsParams;", "(Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;Ljava/util/Map;)V", "getMolsParams", "()Ljava/util/Map;", "get", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomPairParams;", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;", "moli1", "atomi1", "moli2", "atomi2", "dist", "(IIIILjava/lang/Integer;)Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomPairParams;", "osprey3"})
    public final class AtomPairsParams
    implements ForcefieldParams.AtomPairsParams {
        @NotNull
        private final Map<Integer, AtomsParams> molsParams;

        public AtomPairsParams(Map<Integer, AtomsParams> molsParams) {
            Intrinsics.checkNotNullParameter(molsParams, (String)"molsParams");
            this.molsParams = molsParams;
        }

        @NotNull
        public final Map<Integer, AtomsParams> getMolsParams() {
            return this.molsParams;
        }

        @Override
        @Nullable
        public AtomPairParams get(int moli1, int atomi1, int moli2, int atomi2, @Nullable Integer dist) {
            if (dist != null && dist < 3) {
                return null;
            }
            Object object = this.molsParams.get(moli1);
            if (object == null || (object = ((AtomsParams)object).get(atomi1)) == null) {
                return null;
            }
            Object params1 = object;
            Object object2 = this.molsParams.get(moli2);
            if (object2 == null || (object2 = ((AtomsParams)object2).get(atomi2)) == null) {
                return null;
            }
            Object params2 = object2;
            return new AtomPairParams(EEF1ForcefieldParams.this, ((AtomParams)params1).getType(), ((AtomParams)params2).getType());
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\u000f\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0012"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomParams;", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomParams;", "type", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1$AtomType;", "(Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1$AtomType;)V", "getType", "()Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1$AtomType;", "equals", "", "other", "", "hashCode", "", "internalEnergy", "", "()Ljava/lang/Double;", "toString", "", "osprey3"})
    public final class AtomParams
    implements ForcefieldParams.AtomParams {
        @NotNull
        private final EEF1.AtomType type;

        public AtomParams(EEF1.AtomType type) {
            Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
            this.type = type;
        }

        @NotNull
        public final EEF1.AtomType getType() {
            return this.type;
        }

        @Override
        @Nullable
        public Double internalEnergy() {
            return EEF1ForcefieldParams.this.getScale() * this.type.getDGref();
        }

        @NotNull
        public String toString() {
            return String.valueOf((Object)this.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }

        @Override
        public boolean equals(@Nullable Object other) {
            return other instanceof AtomParams && this.type == ((AtomParams)other).type;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\b\u0018\u00010\u0005R\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bH\u0096\u0002R\u001b\u0010\u0003\u001a\f\u0012\b\u0012\u00060\u0005R\u00020\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomsParams;", "Ledu/duke/cs/osprey/gui/forcefield/ForcefieldParams$AtomsParams;", "()V", "atomsParams", "Ledu/duke/cs/osprey/gui/tools/ArrayMap;", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$AtomParams;", "Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams;", "getAtomsParams", "()Ledu/duke/cs/osprey/gui/tools/ArrayMap;", "get", "atomi", "", "osprey3"})
    public static final class AtomsParams
    implements ForcefieldParams.AtomsParams {
        @NotNull
        private final ArrayMap<AtomParams> atomsParams = new ArrayMap();

        @NotNull
        public final ArrayMap<AtomParams> getAtomsParams() {
            return this.atomsParams;
        }

        @Override
        @Nullable
        public AtomParams get(int atomi) {
            return this.atomsParams.get((Object)atomi);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ledu/duke/cs/osprey/gui/forcefield/eef1/EEF1ForcefieldParams$Companion;", "", "()V", "cutoff", "", "trigConst", "getTrigConst", "()D", "osprey3"})
    public static final class Companion {
        private Companion() {
        }

        public final double getTrigConst() {
            return trigConst;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

