/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.io;

import edu.duke.cs.osprey.gui.io.FilesKt;
import edu.duke.cs.osprey.gui.io.TomlKt;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tomlj.Toml;
import org.tomlj.TomlArray;
import org.tomlj.TomlParseResult;
import org.tomlj.TomlTable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0018\u001a\u00020\u0019H\u0002J\u0006\u0010\u001a\u001a\u00020\u0019J\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001cH\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R4\u0010\t\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00042\u000e\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u000e@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001e"}, d2={"Ledu/duke/cs/osprey/gui/io/UserSettings;", "", "()V", "file", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "isLoading", "", "value", "openSaveDir", "getOpenSaveDir", "()Ljava/nio/file/Path;", "setOpenSaveDir", "(Ljava/nio/file/Path;)V", "Ledu/duke/cs/osprey/gui/io/UserSettings$ServiceProvider;", "serviceProvider", "getServiceProvider", "()Ledu/duke/cs/osprey/gui/io/UserSettings$ServiceProvider;", "setServiceProvider", "(Ledu/duke/cs/osprey/gui/io/UserSettings$ServiceProvider;)V", "serviceProviders", "", "getServiceProviders", "()Ljava/util/List;", "load", "", "save", "quote", "", "ServiceProvider", "osprey3"})
@SourceDebugExtension(value={"SMAP\nUserSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UserSettings.kt\nedu/duke/cs/osprey/gui/io/UserSettings\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,148:1\n1#2:149\n350#3,7:150\n*S KotlinDebug\n*F\n+ 1 UserSettings.kt\nedu/duke/cs/osprey/gui/io/UserSettings\n*L\n130#1:150,7\n*E\n"})
public final class UserSettings {
    @NotNull
    public static final UserSettings INSTANCE = new UserSettings();
    private static final Path file = Paths.get(System.getProperty("user.home"), new String[0]).resolve(".osprey").resolve("settings.toml");
    private static boolean isLoading = true;
    @NotNull
    private static final List<ServiceProvider> serviceProviders;
    @NotNull
    private static ServiceProvider serviceProvider;
    private static Path openSaveDir;

    private UserSettings() {
    }

    @NotNull
    public final List<ServiceProvider> getServiceProviders() {
        return serviceProviders;
    }

    @NotNull
    public final ServiceProvider getServiceProvider() {
        return serviceProvider;
    }

    public final void setServiceProvider(@NotNull ServiceProvider value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        if (!serviceProviders.contains(value2)) {
            serviceProviders.add(value2);
        }
        serviceProvider = value2;
        if (!isLoading) {
            this.save();
        }
    }

    public final Path getOpenSaveDir() {
        return openSaveDir;
    }

    public final void setOpenSaveDir(Path value2) {
        openSaveDir = value2;
        if (!isLoading) {
            this.save();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void load() {
        try {
            isLoading = true;
            Path path2 = file;
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
            TomlParseResult doc = Toml.parse((String)edu.duke.cs.osprey.service.FilesKt.read(path2));
            serviceProviders.clear();
            TomlArray serviceProvidersArray = doc.getArray("serviceProviders");
            if (serviceProvidersArray != null) {
                int n = serviceProvidersArray.size();
                for (int i = 0; i < n; ++i) {
                    int n2;
                    String string;
                    TomlTable providerTable = serviceProvidersArray.getTable(i);
                    if (providerTable == null || providerTable.getString("host") == null) continue;
                    Integer n3 = TomlKt.getInt(providerTable, "port");
                    if (n3 == null) {
                        continue;
                    }
                    Boolean bl = providerTable.getBoolean("https");
                    if (bl == null) {
                        n3.intValue();
                        continue;
                    }
                    boolean bl2 = bl;
                    serviceProviders.add(new ServiceProvider(string, n2, bl2));
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)doc, (String)"doc");
            Integer n = TomlKt.getInt((TomlTable)doc, "serviceProvider");
            if (n != null) {
                int index = ((Number)n).intValue();
                boolean bl = false;
                ServiceProvider serviceProvider = (ServiceProvider)CollectionsKt.getOrNull(serviceProviders, (int)index);
                if (serviceProvider != null) {
                    ServiceProvider it = serviceProvider;
                    boolean bl3 = false;
                    INSTANCE.setServiceProvider(it);
                }
            }
            String string = doc.getString("openSaveDir");
            if (string != null) {
                String pathname = string;
                boolean bl = false;
                Path path3 = Paths.get(pathname, new String[0]);
                if (Files.isDirectory(path3, new LinkOption[0])) {
                    INSTANCE.setOpenSaveDir(path3);
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace(System.err);
        }
        finally {
            isLoading = false;
        }
    }

    public final void save() {
        int n;
        Object[] objectArray;
        Object[] objectArray2;
        StringBuilder buf;
        block5: {
            buf = new StringBuilder();
            if (!((Collection)serviceProviders).isEmpty()) {
                UserSettings.save$write(buf, "serviceProviders = [\n", new Object[0]);
                objectArray2 = serviceProviders.iterator();
                int n2 = 0;
                while (objectArray2.hasNext()) {
                    int index = n2++;
                    ServiceProvider endpoint = objectArray2.next();
                    objectArray = new Object[]{this.quote(endpoint.getHostname()), endpoint.getPort(), endpoint.getHttps(), index};
                    UserSettings.save$write(buf, "\t{ host = %s, port = %d, https = %b }, # %d\n", objectArray);
                }
                UserSettings.save$write(buf, "]\n", new Object[0]);
            }
            List<ServiceProvider> $this$indexOfFirst$iv = serviceProviders;
            boolean $i$f$indexOfFirst = false;
            int index$iv = 0;
            objectArray = $this$indexOfFirst$iv.iterator();
            while (objectArray.hasNext()) {
                ServiceProvider item$iv;
                ServiceProvider it = item$iv = objectArray.next();
                boolean bl = false;
                if (it == serviceProvider) {
                    n = index$iv;
                    break block5;
                }
                ++index$iv;
            }
            n = -1;
        }
        Object[] objectArray3 = Integer.valueOf(n);
        int it = ((Number)objectArray3).intValue();
        boolean bl = false;
        Object[] objectArray4 = objectArray2 = it >= 0 ? objectArray3 : null;
        if (objectArray2 != null) {
            it = ((Number)objectArray2).intValue();
            boolean bl2 = false;
            objectArray = new Object[]{it};
            UserSettings.save$write(buf, "serviceProvider = %d\n", objectArray);
        }
        objectArray2 = new Object[]{this.quote(((Object)openSaveDir.toAbsolutePath()).toString())};
        UserSettings.save$write(buf, "openSaveDir = %s\n", objectArray2);
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buf.toString()");
        Path path2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
        FilesKt.write(string, path2);
    }

    private final String quote(String $this$quote) {
        String str = StringsKt.replace$default((String)StringsKt.replace$default((String)$this$quote, (String)"\\", (String)"\\\\", (boolean)false, (int)4, null), (String)"\"", (String)"\\\"", (boolean)false, (int)4, null);
        boolean bl = false;
        return "\"" + str + "\"";
    }

    private static final StringBuilder save$write(StringBuilder buf, String str, Object ... args) {
        Object[] objectArray = Arrays.copyOf(args, args.length);
        String string = String.format(str, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(format, *args)");
        return buf.append(string);
    }

    static {
        Object[] objectArray = new ServiceProvider[]{new ServiceProvider("grisman-36.cs.duke.edu", 0, true, 2, null)};
        serviceProviders = CollectionsKt.mutableListOf((Object[])objectArray);
        serviceProvider = (ServiceProvider)CollectionsKt.first(serviceProviders);
        openSaveDir = Paths.get(System.getProperty("user.home"), new String[0]);
        Path path2 = file;
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"file");
        if (FilesKt.getExists(path2)) {
            INSTANCE.load();
        } else {
            INSTANCE.save();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0010\b\u0086\b\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00072\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Ledu/duke/cs/osprey/gui/io/UserSettings$ServiceProvider;", "", "hostname", "", "port", "", "https", "", "(Ljava/lang/String;IZ)V", "getHostname", "()Ljava/lang/String;", "getHttps", "()Z", "getPort", "()I", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "osprey3"})
    public static final class ServiceProvider {
        @NotNull
        private final String hostname;
        private final int port;
        private final boolean https;

        public ServiceProvider(@NotNull String hostname, int port, boolean https) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            this.hostname = hostname;
            this.port = port;
            this.https = https;
        }

        public /* synthetic */ ServiceProvider(String string, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 2) != 0) {
                n = 44342;
            }
            if ((n2 & 4) != 0) {
                bl = true;
            }
            this(string, n, bl);
        }

        @NotNull
        public final String getHostname() {
            return this.hostname;
        }

        public final int getPort() {
            return this.port;
        }

        public final boolean getHttps() {
            return this.https;
        }

        @NotNull
        public String toString() {
            return (this.https ? "https" : "https") + "://" + this.hostname + ":" + this.port;
        }

        @NotNull
        public final String component1() {
            return this.hostname;
        }

        public final int component2() {
            return this.port;
        }

        public final boolean component3() {
            return this.https;
        }

        @NotNull
        public final ServiceProvider copy(@NotNull String hostname, int port, boolean https) {
            Intrinsics.checkNotNullParameter((Object)hostname, (String)"hostname");
            return new ServiceProvider(hostname, port, https);
        }

        public static /* synthetic */ ServiceProvider copy$default(ServiceProvider serviceProvider, String string, int n, boolean bl, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = serviceProvider.hostname;
            }
            if ((n2 & 2) != 0) {
                n = serviceProvider.port;
            }
            if ((n2 & 4) != 0) {
                bl = serviceProvider.https;
            }
            return serviceProvider.copy(string, n, bl);
        }

        public int hashCode() {
            int result = this.hostname.hashCode();
            result = result * 31 + Integer.hashCode(this.port);
            int n = this.https ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ServiceProvider)) {
                return false;
            }
            ServiceProvider serviceProvider = (ServiceProvider)other;
            if (!Intrinsics.areEqual((Object)this.hostname, (Object)serviceProvider.hostname)) {
                return false;
            }
            if (this.port != serviceProvider.port) {
                return false;
            }
            return this.https == serviceProvider.https;
        }
    }
}

