/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.gui.prep;

import edu.duke.cs.osprey.gui.forcefield.amber.MolPartitioningKt;
import edu.duke.cs.osprey.gui.forcefield.amber.MoleculeType;
import edu.duke.cs.osprey.gui.io.ConfLib;
import edu.duke.cs.osprey.gui.io.TomlKt;
import edu.duke.cs.osprey.gui.motions.ConfMotion;
import edu.duke.cs.osprey.gui.motions.MolMotion;
import edu.duke.cs.osprey.gui.prep.Anchor;
import edu.duke.cs.osprey.gui.prep.DesignPosition;
import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import edu.duke.cs.osprey.molscope.tools.LangKt;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0096\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\n\u0018\u0000 K2\u00020\u0001:\u0006KLMNOPB\u001f\u0012\u0018\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00062\u0006\u0010(\u001a\u00020\u000fJ\u0016\u0010)\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001cJ\u000e\u0010,\u001a\u00020&2\u0006\u0010-\u001a\u00020\u0016J'\u0010.\u001a\u00020&2\u0006\u0010*\u001a\u00020\u00112\u0012\u0010/\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u001c00\"\u00020\u001c\u00a2\u0006\u0002\u00101J\u000e\u00102\u001a\u00020\u00112\u0006\u0010*\u001a\u00020\u0011J\u000e\u00103\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0011J\u000e\u00104\u001a\u00020&2\u0006\u0010*\u001a\u00020\u0011J\u000e\u00105\u001a\u0002062\u0006\u0010*\u001a\u00020\u0011J\u001f\u00107\u001a\u00020\u00002\u0012\u0010\u0002\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u000600\"\u00020\u0006\u00a2\u0006\u0002\u00108J\u0016\u00107\u001a\u00020\u00002\u000e\b\u0002\u00109\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003J\u0006\u0010:\u001a\u00020;J\u0006\u0010<\u001a\u00020;J\u0010\u0010=\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001b\u001a\u00020\u001cJ\u0014\u0010>\u001a\b\u0012\u0004\u0012\u00020?0\u00032\u0006\u0010'\u001a\u00020\u0006J\u0014\u0010@\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0006\u0010'\u001a\u00020\u0006J\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u00032\u0006\u0010*\u001a\u00020\u00112\u0006\u0010C\u001a\u00020DJ\u001c\u0010A\u001a\b\u0012\u0004\u0012\u00020B0\u00032\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001cJ\u0014\u0010E\u001a\b\u0012\u0004\u0012\u00020D0\u00032\u0006\u0010*\u001a\u00020\u0011J\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020D0\u00032\u0006\u0010*\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001cJ\u0014\u0010F\u001a\b\u0012\u0004\u0012\u00020\u001c0G2\u0006\u0010*\u001a\u00020\u0011J\f\u0010H\u001a\b\u0012\u0004\u0012\u00020D0\u0003J\f\u0010I\u001a\b\u0012\u0004\u0012\u00020\u00110\u0003J\f\u0010J\u001a\b\u0012\u0004\u0012\u00020D0\u0003R\u0015\u0010\b\u001a\u00060\tR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR \u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R#\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00110\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R#\u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160\u000e0\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R#\u0010\u0002\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001a\u0010\u001b\u001a\u00020\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u0015\u0010!\u001a\u00060\"R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$\u00a8\u0006Q"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace;", "", "mols", "", "Lkotlin/Pair;", "Ledu/duke/cs/osprey/gui/forcefield/amber/MoleculeType;", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "(Ljava/util/List;)V", "conflibs", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfLibs;", "getConflibs", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfLibs;", "conflibsByMol", "", "", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "designPositionsByMol", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "getDesignPositionsByMol", "()Ljava/util/Map;", "molMotions", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/gui/motions/MolMotion$Description;", "getMolMotions", "()Ljava/util/IdentityHashMap;", "getMols", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "positionConfSpaces", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpaces;", "getPositionConfSpaces", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpaces;", "addConflibByMol", "", "mol", "conflib", "addConformationsFromLibraries", "pos", "type", "addMotion", "desc", "addMutations", "mutations", "", "(Ledu/duke/cs/osprey/gui/prep/DesignPosition;[Ljava/lang/String;)V", "addPosition", "addWildTypeConformation", "checkPosition", "containsPosition", "", "copy", "([Ledu/duke/cs/osprey/molscope/molecule/Molecule;)Ledu/duke/cs/osprey/gui/prep/ConfSpace;", "selMols", "countConformations", "Ljava/math/BigInteger;", "countSequences", "findMol", "fixedAtoms", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getConflibsByMol", "getConformations", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getFragments", "getMutations", "", "libraryFragments", "positions", "wildTypeFragments", "Companion", "ConfConfSpace", "ConfLibs", "DuplicateConfLibException", "PositionConfSpace", "PositionConfSpaces", "osprey3"})
@SourceDebugExtension(value={"SMAP\nConfSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,503:1\n1549#2:504\n1620#2,3:505\n1045#2:523\n1360#2:524\n1446#2,5:525\n1603#2,9:530\n1855#2:539\n1856#2:541\n1612#2:542\n1360#2:543\n1446#2,2:544\n766#2:546\n857#2,2:547\n1448#2,3:549\n1045#2:552\n1603#2,9:553\n1855#2:562\n1856#2:564\n1612#2:565\n1045#2:566\n1549#2:567\n1620#2,3:568\n2661#2,7:571\n1549#2:578\n1620#2,3:579\n766#2:582\n857#2,2:583\n766#2:585\n857#2,2:586\n1549#2:588\n1620#2,3:589\n2661#2,7:592\n1360#2:606\n1446#2,5:607\n766#2:612\n857#2,2:613\n1549#2:615\n1620#2,3:616\n1549#2:619\n1620#2,3:620\n1549#2:623\n1620#2,3:624\n1549#2:627\n1620#2,3:628\n1549#2:631\n1620#2,2:632\n1549#2:634\n1620#2,3:635\n1622#2:638\n1549#2:639\n1620#2,3:640\n1549#2:643\n1620#2,3:644\n1549#2:647\n1620#2,3:648\n1#3:508\n1#3:540\n1#3:563\n361#4,7:509\n361#4,7:516\n361#4,7:599\n*S KotlinDebug\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace\n*L\n29#1:504\n29#1:505,3\n78#1:523\n79#1:524\n79#1:525,5\n153#1:530,9\n153#1:539\n153#1:541\n153#1:542\n154#1:543\n154#1:544,2\n156#1:546\n156#1:547,2\n154#1:549,3\n159#1:552\n168#1:553,9\n168#1:562\n168#1:564\n168#1:565\n169#1:566\n305#1:567\n305#1:568,3\n306#1:571,7\n319#1:578\n319#1:579,3\n351#1:582\n351#1:583,2\n356#1:585\n356#1:586,2\n365#1:588\n365#1:589,3\n366#1:592,7\n378#1:606\n378#1:607,5\n382#1:612\n382#1:613,2\n397#1:615\n397#1:616,3\n402#1:619\n402#1:620,3\n405#1:623\n405#1:624,3\n408#1:627\n408#1:628,3\n436#1:631\n436#1:632,2\n438#1:634\n438#1:635,3\n436#1:638\n445#1:639\n445#1:640,3\n495#1:643\n495#1:644,3\n392#1:647\n392#1:648,3\n153#1:540\n168#1:563\n40#1:509,7\n56#1:516,7\n370#1:599,7\n*E\n"})
public final class ConfSpace {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Pair<MoleculeType, Molecule>> mols;
    @NotNull
    private String name;
    @NotNull
    private final Map<Molecule, List<ConfLib>> conflibsByMol;
    @NotNull
    private final Map<Molecule, List<DesignPosition>> designPositionsByMol;
    @NotNull
    private final ConfLibs conflibs;
    @NotNull
    private final PositionConfSpaces positionConfSpaces;
    @NotNull
    private final IdentityHashMap<Molecule, List<MolMotion.Description>> molMotions;

    public ConfSpace(@NotNull List<? extends Pair<? extends MoleculeType, ? extends Molecule>> mols) {
        Intrinsics.checkNotNullParameter(mols, (String)"mols");
        this.mols = mols;
        this.name = "Conformation Space";
        this.conflibsByMol = new IdentityHashMap();
        this.designPositionsByMol = new IdentityHashMap();
        this.conflibs = new ConfLibs();
        this.positionConfSpaces = new PositionConfSpaces();
        this.molMotions = new IdentityHashMap();
    }

    @NotNull
    public final List<Pair<MoleculeType, Molecule>> getMols() {
        return this.mols;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Molecule findMol(@NotNull String name) {
        Object v0;
        block2: {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Iterable $this$map$iv = this.mols;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Molecule mol = (Molecule)pair.component2();
                collection.add(mol);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            for (Object e : iterable2) {
                Molecule it = (Molecule)e;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                v0 = e;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    public final void addConflibByMol(@NotNull Molecule mol, @NotNull ConfLib conflib) {
        List list;
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
        Map<Molecule, List<ConfLib>> $this$getOrPut$iv = this.conflibsByMol;
        boolean $i$f$getOrPut = false;
        List value$iv = $this$getOrPut$iv.get(mol);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(mol, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        list.add((ConfLib)conflib);
        if (!this.conflibs.contains(conflib)) {
            this.conflibs.add(conflib);
        }
    }

    @NotNull
    public final List<ConfLib> getConflibsByMol(@NotNull Molecule mol) {
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        return this.conflibsByMol.getOrDefault(mol, new ArrayList());
    }

    @NotNull
    public final Map<Molecule, List<DesignPosition>> getDesignPositionsByMol() {
        return this.designPositionsByMol;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final DesignPosition addPosition(@NotNull DesignPosition pos) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Map<Molecule, List<DesignPosition>> map = this.designPositionsByMol;
        Molecule key$iv = pos.getMol();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(pos);
        return pos;
    }

    public final boolean containsPosition(@NotNull DesignPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        List<DesignPosition> list = this.designPositionsByMol.get(pos.getMol());
        if (list == null) {
            return false;
        }
        List<DesignPosition> positions = list;
        return positions.contains(pos);
    }

    public final void checkPosition(@NotNull DesignPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        if (!this.containsPosition(pos)) {
            throw new NoSuchElementException("conf space has no position " + pos.getName());
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DesignPosition> positions() {
        void $this$flatMapTo$iv$iv;
        Iterable $this$sortedBy$iv = MapsKt.toList(this.designPositionsByMol);
        boolean $i$f$sortedBy = false;
        Iterable $this$flatMap$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Pair pair = (Pair)a;
                boolean bl = false;
                Molecule mol = (Molecule)pair.component1();
                pair = (Pair)b;
                Comparable comparable = (Comparable)((Object)mol.getName());
                bl = false;
                mol = (Molecule)pair.component1();
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)((Comparable)((Object)mol.getName())));
            }
        });
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            Pair pair = (Pair)element$iv$iv;
            boolean bl = false;
            List positions = (List)pair.component2();
            Iterable list$iv$iv = positions;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ConfLibs getConflibs() {
        return this.conflibs;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConfLib.Fragment> libraryFragments() {
        void $this$flatMapTo$iv$iv;
        DesignPosition it;
        Object element$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)this.designPositionsByMol.values());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            PositionConfSpace it$iv$iv;
            Object element$iv$iv$iv;
            element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            it = (DesignPosition)element$iv$iv;
            boolean bl2 = false;
            if (this.positionConfSpaces.get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$flatMap = false;
        $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv2 : $this$flatMapTo$iv$iv) {
            void $this$filterTo$iv$iv;
            void $this$filter$iv;
            PositionConfSpace posConfSpace = (PositionConfSpace)element$iv$iv2;
            boolean bl = false;
            element$iv$iv = posConfSpace.getConfs().fragments();
            boolean $i$f$filter = false;
            it = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                ConfLib.Fragment it2 = (ConfLib.Fragment)element$iv$iv3;
                boolean bl4 = false;
                if (!(it2 != posConfSpace.getWildTypeFragment())) continue;
                destination$iv$iv2.add(element$iv$iv3);
            }
            Iterable list$iv$iv = (List)destination$iv$iv2;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$sortedBy$iv = CollectionsKt.toCollection((Iterable)((List)destination$iv$iv), (Collection)LangKt.identityHashSet());
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConfLib.Fragment it = (ConfLib.Fragment)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (ConfLib.Fragment)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConfLib.Fragment> wildTypeFragments() {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = CollectionsKt.flatten((Iterable)this.designPositionsByMol.values());
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            ConfLib.Fragment it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            DesignPosition it = (DesignPosition)element$iv$iv;
            boolean bl2 = false;
            PositionConfSpace positionConfSpace = this.positionConfSpaces.get(it);
            if ((positionConfSpace != null ? positionConfSpace.getWildTypeFragment() : null) == null) continue;
            it$iv$iv = it$iv$iv;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                ConfLib.Fragment it = (ConfLib.Fragment)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.getId());
                it = (ConfLib.Fragment)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getId())));
            }
        });
    }

    @NotNull
    public final PositionConfSpaces getPositionConfSpaces() {
        return this.positionConfSpaces;
    }

    @NotNull
    public final IdentityHashMap<Molecule, List<MolMotion.Description>> getMolMotions() {
        return this.molMotions;
    }

    public final void addMutations(@NotNull DesignPosition pos, String ... mutations) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)mutations, (String)"mutations");
        CollectionsKt.addAll((Collection)this.positionConfSpaces.getOrMake(pos).getMutations(), (Object[])mutations);
    }

    @NotNull
    public final Set<String> getMutations(@NotNull DesignPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.positionConfSpaces.getOrMake(pos).getMutations();
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final BigInteger countSequences() {
        BigInteger bigInteger;
        List<DesignPosition> list;
        List<DesignPosition> list2;
        List<DesignPosition> it = list2 = this.positions();
        boolean bl = false;
        List<DesignPosition> list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list != null) {
            void var7_11;
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                DesignPosition designPosition = (DesignPosition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                BigInteger bigInteger2 = BigInteger.valueOf(this.getMutations((DesignPosition)it2).size());
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(this.toLong())");
                collection.add(bigInteger2);
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object t = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                BigInteger bigInteger3 = (BigInteger)iterator$iv.next();
                BigInteger a = (BigInteger)var7_11;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.multiply((BigInteger)b), (String)"this.multiply(other)");
            }
            BigInteger bigInteger4 = (BigInteger)var7_11;
            if (bigInteger4 != null) {
                bigInteger = bigInteger4;
                return bigInteger;
            }
        }
        BigInteger bigInteger5 = BigInteger.ZERO;
        bigInteger = bigInteger5;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ZERO");
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    public final void addConformationsFromLibraries(@NotNull DesignPosition pos, @NotNull String type) {
        PositionConfSpace positionConfSpace;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        if (this.conflibs.isEmpty()) {
            throw new IllegalArgumentException("no conformation libaries have been attached to this conformation space");
        }
        List<ConfLib.Fragment> typeFrags = this.conflibs.findMatchingFragments(pos.getMol(), type);
        if (typeFrags.isEmpty()) {
            throw new IllegalArgumentException("no fragments match the given type: " + type);
        }
        List<ConfLib.Fragment> compatibleFrags = this.conflibs.findMatchingFragments(pos, typeFrags);
        if (compatibleFrags.isEmpty()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = typeFrags;
            String string = type;
            boolean $i$f$map = false;
            void var7_10 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ConfLib.Fragment fragment = (ConfLib.Fragment)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(it.getId());
            }
            String string2 = "none of the " + string + " fragments " + (List)destination$iv$iv + " are compatible with design position " + pos.getName();
            throw new IllegalArgumentException(string2);
        }
        PositionConfSpace $this$addConformationsFromLibraries_u24lambda_u2416 = positionConfSpace = this.positionConfSpaces.getOrMake(pos);
        boolean bl = false;
        for (ConfLib.Fragment frag : compatibleFrags) {
            $this$addConformationsFromLibraries_u24lambda_u2416.getConfs().addAll(frag);
        }
    }

    public final void addWildTypeConformation(@NotNull DesignPosition pos) {
        List<ConfLib.ContinuousMotion> list;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Object object = (ConfLib.Fragment)CollectionsKt.firstOrNull((List)ConfLibs.findMatchingFragments$default(this.conflibs, pos, null, 2, null));
        ConfLib.Fragment wtFrag = pos.makeFragment("wt-" + TomlKt.toTomlKey(pos.getMol().getName()) + "-" + TomlKt.toTomlKey(pos.getName()), "WildType @ " + pos.getMol().getName() + " " + pos.getName(), "conf1", "conf1", (List<? extends ConfLib.ContinuousMotion>)(object != null && (list = ((ConfLib.Fragment)object).getMotions()) != null ? list : CollectionsKt.emptyList()));
        Object $this$addWildTypeConformation_u24lambda_u2417 = object = this.positionConfSpaces.getOrMake(pos);
        boolean bl = false;
        ((PositionConfSpace)$this$addWildTypeConformation_u24lambda_u2417).setWildTypeFragment(wtFrag);
        ((PositionConfSpace)$this$addWildTypeConformation_u24lambda_u2417).getConfs().addAll(wtFrag);
    }

    @NotNull
    public final List<ConfLib.Fragment> getFragments(@NotNull DesignPosition pos) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return this.positionConfSpaces.getOrMake(pos).getConfs().fragments();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConfLib.Fragment> getFragments(@NotNull DesignPosition pos, @NotNull String type) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable $this$filter$iv = this.getFragments(pos);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfLib.Fragment it = (ConfLib.Fragment)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getType(), (Object)type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ConfConfSpace> getConformations(@NotNull DesignPosition pos, @NotNull String type) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Iterable $this$filter$iv = CollectionsKt.toList((Iterable)this.positionConfSpaces.getOrMake(pos).getConfs());
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConfConfSpace it = (ConfConfSpace)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getFrag().getType(), (Object)type)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<ConfConfSpace> getConformations(@NotNull DesignPosition pos, @NotNull ConfLib.Fragment frag) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
        return this.positionConfSpaces.getOrMake(pos).getConfs().getByFragment(frag);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    public final BigInteger countConformations() {
        BigInteger bigInteger;
        List<DesignPosition> list;
        List<DesignPosition> list2;
        List<DesignPosition> it = list2 = this.positions();
        boolean bl = false;
        List<DesignPosition> list3 = list = !((Collection)it).isEmpty() ? list2 : null;
        if (list != null) {
            void var7_11;
            void $this$reduce$iv;
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = list;
            boolean $i$f$map22 = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean bl2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                DesignPosition designPosition = (DesignPosition)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl3 = false;
                BigInteger bigInteger2 = BigInteger.valueOf(this.positionConfSpaces.getOrMake((DesignPosition)it2).getConfs().getSize());
                Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(this.toLong())");
                collection.add(bigInteger2);
            }
            Iterable $i$f$map22 = (List)destination$iv$iv;
            boolean $i$f$reduce = false;
            Iterator iterator$iv = $this$reduce$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new UnsupportedOperationException("Empty collection can't be reduced.");
            }
            Object t = iterator$iv.next();
            while (iterator$iv.hasNext()) {
                void b;
                BigInteger bigInteger3 = (BigInteger)iterator$iv.next();
                BigInteger a = (BigInteger)var7_11;
                boolean bl4 = false;
                Intrinsics.checkNotNullExpressionValue((Object)a.multiply((BigInteger)b), (String)"this.multiply(other)");
            }
            BigInteger bigInteger4 = (BigInteger)var7_11;
            if (bigInteger4 != null) {
                bigInteger = bigInteger4;
                return bigInteger;
            }
        }
        BigInteger bigInteger5 = BigInteger.ZERO;
        bigInteger = bigInteger5;
        Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ZERO");
        return bigInteger;
    }

    /*
     * WARNING - void declaration
     */
    public final void addMotion(@NotNull MolMotion.Description desc) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)desc, (String)"desc");
        Map map = this.molMotions;
        Molecule key$iv = desc.getMol();
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            List answer$iv = new ArrayList();
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        ((List)object).add(desc);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Atom> fixedAtoms(@NotNull Molecule mol) {
        void $this$filterTo$iv$iv;
        List list;
        Iterable $this$flatMap$iv;
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        List<DesignPosition> list2 = this.designPositionsByMol.get(mol);
        if (list2 != null) {
            void $this$flatMapTo$iv$iv;
            Iterable iterable = list2;
            boolean $i$f$flatMap = false;
            void var7_6 = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DesignPosition it = (DesignPosition)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = it.getSourceAtoms();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        Set<Atom> posAtoms = MoleculeKt.toIdentitySet(list);
        Iterable $this$filter$iv = mol.getAtoms();
        boolean $i$f$filter = false;
        $this$flatMap$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Atom it = (Atom)element$iv$iv;
            boolean bl = false;
            if (!(!posAtoms.contains(it))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final ConfSpace copy(Molecule ... mols) {
        Intrinsics.checkNotNullParameter((Object)mols, (String)"mols");
        return this.copy(ArraysKt.toList((Object[])mols));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ConfSpace copy(@NotNull List<? extends Molecule> selMols) {
        void $this$mapTo$iv$iv;
        Molecule mol;
        void $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Collection collection;
        void $this$mapTo$iv$iv4;
        Intrinsics.checkNotNullParameter(selMols, (String)"selMols");
        ConfSpace old = this;
        Iterable $this$map$iv = selMols;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv4) {
            Object v0;
            void selMol;
            block18: {
                Molecule molecule = (Molecule)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Iterable iterable2 = old.mols;
                for (Object t : iterable2) {
                    Pair pair = (Pair)t;
                    boolean bl2 = false;
                    Molecule mol2 = (Molecule)pair.component2();
                    if (!(mol2 == selMol)) continue;
                    v0 = t;
                    break block18;
                }
                v0 = null;
            }
            Pair pair = v0;
            if (pair == null) {
                throw new NoSuchElementException("this conformation space didn't contain the selected molecule: " + (Molecule)selMol);
            }
            collection.add(pair);
        }
        List oldTypedMols = (List)destination$iv$iv;
        Iterable $this$map$iv2 = oldTypedMols;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Iterable destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Molecule mol3 = (Molecule)bl.component2();
            collection.add(mol3);
        }
        List oldMols = (List)destination$iv$iv2;
        Iterable $this$map$iv3 = oldTypedMols;
        boolean $i$f$map3 = false;
        destination$iv$iv2 = $this$map$iv3;
        Iterable destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            Pair bl3 = (Pair)item$iv$iv;
            Collection collection2 = destination$iv$iv3;
            boolean bl = false;
            MoleculeType type = (MoleculeType)((Object)bl3.component1());
            mol = (Molecule)bl3.component2();
            collection2.add(TuplesKt.to((Object)((Object)type), (Object)mol.copy()));
        }
        List list = (List)destination$iv$iv3;
        ConfSpace confSpace = new ConfSpace(list);
        Iterable $this$map$iv4 = confSpace.mols;
        boolean $i$f$map4 = false;
        destination$iv$iv3 = $this$map$iv4;
        Collection destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Pair bl = (Pair)item$iv$iv;
            collection = destination$iv$iv4;
            boolean bl4 = false;
            mol = (Molecule)bl.component2();
            collection.add(mol);
        }
        List newMols = (List)destination$iv$iv4;
        confSpace.name = old.name;
        confSpace.conflibs.addAll(old.conflibs);
        for (Pair pair : CollectionsKt.zip((Iterable)oldMols, (Iterable)newMols)) {
            void $this$mapTo$iv$iv5;
            void $this$map$iv5;
            List<MolMotion.Description> oldMotions;
            Set<Atom> set;
            Iterable<DesignPosition> oldPositions;
            ArrayList<DesignPosition> newPositions;
            Molecule oldMol = (Molecule)pair.component1();
            Molecule newMol = (Molecule)pair.component2();
            AtomMap oldToNew = oldMol.mapAtomsByValueTo(newMol);
            if (old.designPositionsByMol.get(oldMol) != null) {
                boolean bl = false;
                newPositions = new ArrayList<DesignPosition>();
                confSpace.designPositionsByMol.put(newMol, newPositions);
                for (DesignPosition oldPos : oldPositions) {
                    PositionConfSpace oldPosConfSpace;
                    Atom oldAnchors;
                    Collection collection3;
                    Iterable $this$mapTo$iv$iv6;
                    Iterable $this$map$iv6;
                    DesignPosition newPos = new DesignPosition(oldPos.getName(), oldPos.getType(), newMol);
                    Iterable iterable3 = oldPos.getAnchorGroups();
                    set = newPos.getAnchorGroups();
                    boolean $i$f$map5 = false;
                    Iterator<ConfConfSpace> iterator2 = $this$map$iv6;
                    Collection destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                    boolean $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                        void $this$mapTo$iv$iv7;
                        void $this$map$iv7;
                        List list2 = (List)item$iv$iv;
                        collection3 = destination$iv$iv5;
                        boolean bl5 = false;
                        Iterable iterable4 = (Iterable)((Object)oldAnchors);
                        boolean $i$f$map6 = false;
                        void var33_71 = $this$map$iv7;
                        Collection destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
                        boolean $i$f$mapTo6 = false;
                        for (Object item$iv$iv2 : $this$mapTo$iv$iv7) {
                            void oldAnchor;
                            Anchor anchor = (Anchor)item$iv$iv2;
                            Collection collection4 = destination$iv$iv6;
                            boolean bl6 = false;
                            collection4.add(oldAnchor.copyToMol(newMol, oldToNew));
                        }
                        collection3.add(CollectionsKt.toMutableList((Collection)((List)destination$iv$iv6)));
                    }
                    set.addAll((List)destination$iv$iv5);
                    $this$map$iv6 = oldPos.getSourceAtoms();
                    set = newPos.getSourceAtoms();
                    $i$f$map5 = false;
                    $this$mapTo$iv$iv6 = $this$map$iv6;
                    destination$iv$iv5 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv6, (int)10));
                    $i$f$mapTo5 = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv6) {
                        void atom;
                        oldAnchors = (Atom)item$iv$iv;
                        collection3 = destination$iv$iv5;
                        boolean bl7 = false;
                        collection3.add((Atom)oldToNew.getBOrThrow(atom));
                    }
                    set.addAll((List)destination$iv$iv5);
                    newPositions.add(newPos);
                    if (old.positionConfSpaces.get(oldPos) == null) continue;
                    PositionConfSpace newPosConfSpace = confSpace.positionConfSpaces.getOrMake(newPos);
                    if (oldPosConfSpace.getWildTypeFragment() != null) {
                        ConfLib.Fragment oldWTFrag;
                        boolean bl8 = false;
                        ConfLib.Conf oldWTConf = (ConfLib.Conf)CollectionsKt.first((Iterable)oldWTFrag.getConfs().values());
                        newPosConfSpace.setWildTypeFragment(newPos.makeFragment(oldWTFrag.getId(), oldWTFrag.getName(), oldWTConf.getId(), oldWTConf.getName(), oldWTFrag.getMotions()));
                    }
                    newPosConfSpace.getMutations().addAll((Collection<String>)oldPosConfSpace.getMutations());
                    for (ConfConfSpace oldSpace : oldPosConfSpace.getConfs()) {
                        ConfConfSpace confConfSpace;
                        boolean isWildtype;
                        boolean bl9 = isWildtype = oldSpace.getFrag() == oldPosConfSpace.getWildTypeFragment();
                        if (isWildtype) {
                            ConfLib.Fragment newWTFrag;
                            Intrinsics.checkNotNull((Object)newPosConfSpace.getWildTypeFragment());
                            confConfSpace = newPosConfSpace.getConfs().add(newWTFrag, (ConfLib.Conf)CollectionsKt.first((Iterable)newWTFrag.getConfs().values()));
                        } else {
                            confConfSpace = newPosConfSpace.getConfs().add(oldSpace.getFrag(), oldSpace.getConf());
                        }
                        ConfConfSpace newSpace = confConfSpace;
                        for (ConfMotion.Description oldMotion : oldSpace.getMotions()) {
                            newSpace.getMotions().add(oldMotion.copyTo(newSpace, newPos));
                        }
                    }
                }
            }
            if ((oldMotions = old.molMotions.get(oldMol)) == null) continue;
            Map map = confSpace.molMotions;
            oldPositions = oldMotions;
            boolean $i$f$map7 = false;
            newPositions = $this$map$iv5;
            Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
            boolean $i$f$mapTo7 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv5) {
                void it;
                set = (MolMotion.Description)item$iv$iv;
                collection = destination$iv$iv7;
                boolean bl = false;
                collection.add(MolMotion.Description.DefaultImpls.copyTo$default((MolMotion.Description)it, newMol, null, 2, null));
            }
            List list3 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv7));
            map.put(newMol, list3);
        }
        return confSpace;
    }

    /*
     * WARNING - void declaration
     */
    public static /* synthetic */ ConfSpace copy$default(ConfSpace confSpace, List list, int n, Object object) {
        if ((n & 1) != 0) {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = confSpace.mols;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Molecule mol = (Molecule)pair.component2();
                collection.add(mol);
            }
            list = (List)destination$iv$iv;
        }
        return confSpace.copy(list);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$Companion;", "", "()V", "fromMols", "Ledu/duke/cs/osprey/gui/prep/ConfSpace;", "mols", "", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1549#2:504\n1620#2,3:505\n*S KotlinDebug\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$Companion\n*L\n23#1:504\n23#1:505,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ConfSpace fromMols(@NotNull List<? extends Molecule> mols) {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(mols, (String)"mols");
            Iterable $this$map$iv = mols;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Molecule molecule = (Molecule)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(TuplesKt.to((Object)((Object)MolPartitioningKt.findTypeOrThrow((Molecule)it)), (Object)it));
            }
            List list = (List)destination$iv$iv;
            return new ConfSpace(list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;", "", "frag", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "conf", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "(Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;)V", "getConf", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "getFrag", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "motions", "", "Ledu/duke/cs/osprey/gui/motions/ConfMotion$Description;", "getMotions", "()Ljava/util/List;", "osprey3"})
    public static final class ConfConfSpace {
        @NotNull
        private final ConfLib.Fragment frag;
        @NotNull
        private final ConfLib.Conf conf;
        @NotNull
        private final List<ConfMotion.Description> motions;

        public ConfConfSpace(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
            Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
            Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
            this.frag = frag;
            this.conf = conf;
            this.motions = new ArrayList();
        }

        @NotNull
        public final ConfLib.Fragment getFrag() {
            return this.frag;
        }

        @NotNull
        public final ConfLib.Conf getConf() {
            return this.conf;
        }

        @NotNull
        public final List<ConfMotion.Description> getMotions() {
            return this.motions;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010(\n\u0000\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002J\u0014\u0010\n\u001a\u00020\b2\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u0002J\u000e\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u0006J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u0006J\"\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010J\u001c\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0014\u001a\u00020\u0006J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0019\u001a\u00020\u0006J\u000e\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0006J\u0006\u0010\u001b\u001a\u00020\fJ\u000f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00020\u001dH\u0096\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfLibs;", "", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "(Ledu/duke/cs/osprey/gui/prep/ConfSpace;)V", "conflibs", "Ljava/util/HashMap;", "", "add", "", "conflib", "addAll", "contains", "", "coversMutation", "mutation", "findMatchingFragments", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "pos", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "type", "frags", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "get", "id", "getOrThrow", "isEmpty", "iterator", "", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$ConfLibs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,503:1\n1045#2:504\n1747#2,2:505\n1747#2,3:507\n1749#2:510\n1360#2:511\n1446#2,5:512\n1360#2:521\n1446#2,5:522\n766#2:527\n857#2,2:528\n766#2:530\n857#2,2:531\n125#3:517\n152#3,3:518\n*S KotlinDebug\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$ConfLibs\n*L\n91#1:504\n120#1:505,2\n121#1:507,3\n120#1:510\n129#1:511\n129#1:512,5\n130#1:521\n130#1:522,5\n139#1:527\n139#1:528,2\n125#1:530\n125#1:531,2\n130#1:517\n130#1:518,3\n*E\n"})
    public final class ConfLibs
    implements Iterable<ConfLib>,
    KMappedMarker {
        @NotNull
        private final HashMap<String, ConfLib> conflibs = new HashMap();

        public final boolean isEmpty() {
            return this.conflibs.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<ConfLib> iterator() {
            Collection<ConfLib> collection = this.conflibs.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"conflibs.values");
            Iterable $this$sortedBy$iv = collection;
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ConfLib it = (ConfLib)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (ConfLib)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            }).iterator();
        }

        public final boolean contains(@NotNull ConfLib conflib) {
            Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
            return this.conflibs.containsKey(conflib.getId());
        }

        @Nullable
        public final ConfLib get(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            return this.conflibs.get(id);
        }

        @NotNull
        public final ConfLib getOrThrow(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            ConfLib confLib = this.get(id);
            if (confLib == null) {
                throw new NoSuchElementException("no conformation library with id " + id);
            }
            return confLib;
        }

        public final void add(@NotNull ConfLib conflib) {
            Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
            if (this.contains(conflib)) {
                throw new DuplicateConfLibException(conflib);
            }
            ((Map)this.conflibs).put(conflib.getId(), conflib);
        }

        public final void addAll(@NotNull Iterable<ConfLib> conflibs) {
            Intrinsics.checkNotNullParameter(conflibs, (String)"conflibs");
            for (ConfLib conflib : conflibs) {
                this.add(conflib);
            }
        }

        public final boolean coversMutation(@NotNull String mutation) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullParameter((Object)mutation, (String)"mutation");
                Collection<ConfLib> collection = this.conflibs.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"conflibs.values");
                Iterable $this$any$iv = collection;
                boolean $i$f$any = false;
                if (((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        boolean bl2;
                        block6: {
                            ConfLib conflib = (ConfLib)element$iv;
                            boolean bl3 = false;
                            Iterable $this$any$iv2 = conflib.getFragments().values();
                            boolean $i$f$any2 = false;
                            if ($this$any$iv2 instanceof Collection && ((Collection)$this$any$iv2).isEmpty()) {
                                bl2 = false;
                            } else {
                                for (Object element$iv2 : $this$any$iv2) {
                                    ConfLib.Fragment it = (ConfLib.Fragment)element$iv2;
                                    boolean bl4 = false;
                                    if (!Intrinsics.areEqual((Object)it.getType(), (Object)mutation)) continue;
                                    bl2 = true;
                                    break block6;
                                }
                                bl2 = false;
                            }
                        }
                        if (!bl2) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ConfLib.Fragment> findMatchingFragments(@NotNull Molecule mol, @NotNull String type) {
            List list;
            Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            List list2 = (List)ConfSpace.this.conflibsByMol.get(mol);
            if (list2 != null) {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = list2;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    ConfLib it = (ConfLib)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = ConfLibs.findMatchingFragments$fragByType(it, type);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                ConfLib it;
                Object list$iv$iv;
                Iterable $this$mapTo$iv$iv;
                Map $this$map$iv = this.conflibs;
                boolean $i$f$map = false;
                Map $this$flatMapTo$iv$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                for (Map.Entry item$iv$iv : $this$mapTo$iv$iv.entrySet()) {
                    list$iv$iv = item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((ConfLib)it.getValue());
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$mapTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                Iterator iterator2 = $this$flatMapTo$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Map.Entry element$iv$iv = iterator2.next();
                    it = (ConfLib)((Object)element$iv$iv);
                    boolean bl = false;
                    list$iv$iv = ConfLibs.findMatchingFragments$fragByType(it, type);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = (List)destination$iv$iv;
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<ConfLib.Fragment> findMatchingFragments(@NotNull DesignPosition pos, @NotNull List<ConfLib.Fragment> frags) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter(frags, (String)"frags");
            Iterable $this$filter$iv = frags;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ConfLib.Fragment frag = (ConfLib.Fragment)element$iv$iv;
                boolean bl = false;
                if (!pos.isFragmentCompatible(frag)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        @NotNull
        public final List<ConfLib.Fragment> findMatchingFragments(@NotNull DesignPosition pos, @NotNull String type) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Intrinsics.checkNotNullParameter((Object)type, (String)"type");
            return this.findMatchingFragments(pos, this.findMatchingFragments(pos.getMol(), type));
        }

        public static /* synthetic */ List findMatchingFragments$default(ConfLibs confLibs, DesignPosition designPosition, String string, int n, Object object) {
            if ((n & 2) != 0) {
                string = designPosition.getType();
            }
            return confLibs.findMatchingFragments(designPosition, string);
        }

        /*
         * WARNING - void declaration
         */
        private static final List<ConfLib.Fragment> findMatchingFragments$fragByType(ConfLib $this$findMatchingFragments_u24fragByType, String type) {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = $this$findMatchingFragments_u24fragByType.getFragments().values();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                ConfLib.Fragment frag = (ConfLib.Fragment)element$iv$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)frag.getType(), (Object)type)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$DuplicateConfLibException;", "Ljava/lang/RuntimeException;", "Lkotlin/RuntimeException;", "conflib", "Ledu/duke/cs/osprey/gui/io/ConfLib;", "(Ledu/duke/cs/osprey/gui/io/ConfLib;)V", "getConflib", "()Ledu/duke/cs/osprey/gui/io/ConfLib;", "osprey3"})
    public static final class DuplicateConfLibException
    extends RuntimeException {
        @NotNull
        private final ConfLib conflib;

        public DuplicateConfLibException(@NotNull ConfLib conflib) {
            Intrinsics.checkNotNullParameter((Object)conflib, (String)"conflib");
            super("Conformation library already loaded: " + conflib.getName());
            this.conflib = conflib;
        }

        @NotNull
        public final ConfLib getConflib() {
            return this.conflib;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u0015\u0010\u0003\u001a\u00060\u0004R\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001c\u0010\f\u001a\u0004\u0018\u00010\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0015"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;", "", "()V", "confs", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace$Confs;", "getConfs", "()Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace$Confs;", "mutations", "", "", "getMutations", "()Ljava/util/Set;", "wildTypeFragment", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "getWildTypeFragment", "()Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "setWildTypeFragment", "(Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;)V", "isMutable", "", "Confs", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n1747#2,3:504\n*S KotlinDebug\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace\n*L\n185#1:504,3\n*E\n"})
    public static final class PositionConfSpace {
        @Nullable
        private ConfLib.Fragment wildTypeFragment;
        @NotNull
        private final Set<String> mutations = new HashSet();
        @NotNull
        private final Confs confs = new Confs();

        @Nullable
        public final ConfLib.Fragment getWildTypeFragment() {
            return this.wildTypeFragment;
        }

        public final void setWildTypeFragment(@Nullable ConfLib.Fragment fragment) {
            this.wildTypeFragment = fragment;
        }

        @NotNull
        public final Set<String> getMutations() {
            return this.mutations;
        }

        public final boolean isMutable() {
            boolean bl;
            block3: {
                Iterable $this$any$iv = this.mutations;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        String it = (String)element$iv;
                        boolean bl2 = false;
                        ConfLib.Fragment fragment = this.wildTypeFragment;
                        if (!(!Intrinsics.areEqual((Object)it, (Object)(fragment != null ? fragment.getType() : null)))) continue;
                        bl = true;
                        break block3;
                    }
                    bl = false;
                }
            }
            return bl;
        }

        @NotNull
        public final Confs getConfs() {
            return this.confs;
        }

        @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u0006J'\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00062\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014\u00a2\u0006\u0002\u0010\u0015J\u001c\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00062\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\b0\u0001J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u0014\u0010\u0019\u001a\u0010\u0012\f\u0012\n \u001b*\u0004\u0018\u00010\u00060\u00060\u001aJ\u0018\u0010\u001c\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00020\u001a2\u0006\u0010\u000e\u001a\u00020\u0006J\u0016\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00020 H\u0096\u0002J\u0016\u0010!\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\bJ\u000e\u0010\"\u001a\u00020\u00112\u0006\u0010#\u001a\u00020\u0014R&\u0010\u0004\u001a\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006$"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace$Confs;", "", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$ConfConfSpace;", "(Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;)V", "byFragConf", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;", "", "Ledu/duke/cs/osprey/gui/io/ConfLib$Conf;", "size", "", "getSize", "()I", "add", "frag", "conf", "addAll", "", "confIds", "", "", "(Ledu/duke/cs/osprey/gui/io/ConfLib$Fragment;[Ljava/lang/String;)V", "confs", "contains", "", "fragments", "", "kotlin.jvm.PlatformType", "get", "getByFragment", "getOrAdd", "iterator", "", "remove", "removeByFragmentType", "type", "osprey3"})
        @SourceDebugExtension(value={"SMAP\nConfSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace$Confs\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,503:1\n1045#2:504\n1603#2,9:505\n1855#2:514\n1856#2:516\n1612#2:517\n1360#2:518\n1446#2,2:519\n1045#2:521\n1448#2,3:522\n1855#2,2:533\n1#3:515\n1#3:525\n361#4,7:526\n515#4:535\n500#4,6:536\n215#5,2:542\n*S KotlinDebug\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace$Confs\n*L\n194#1:504\n198#1:505,9\n198#1:514\n198#1:516\n198#1:517\n199#1:518\n199#1:519,2\n199#1:521\n199#1:522,3\n256#1:533,2\n198#1:515\n230#1:526,7\n260#1:535\n260#1:536,6\n261#1:542,2\n*E\n"})
        public final class Confs
        implements Iterable<ConfConfSpace>,
        KMappedMarker {
            @NotNull
            private final IdentityHashMap<ConfLib.Fragment, Map<ConfLib.Conf, ConfConfSpace>> byFragConf = new IdentityHashMap();

            @NotNull
            public final List<ConfLib.Fragment> fragments() {
                Set<ConfLib.Fragment> set = this.byFragConf.keySet();
                Intrinsics.checkNotNullExpressionValue(set, (String)"byFragConf\n                    .keys");
                Iterable $this$sortedBy$iv = set;
                boolean $i$f$sortedBy = false;
                return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        ConfLib.Fragment frag = (ConfLib.Fragment)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)frag.getId());
                        frag = (ConfLib.Fragment)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)frag.getId())));
                    }
                });
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @NotNull
            public Iterator<ConfConfSpace> iterator() {
                void $this$flatMapTo$iv$iv;
                Iterable $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = this.fragments();
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    Map<ConfLib.Conf, ConfConfSpace> it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    ConfLib.Fragment frag = (ConfLib.Fragment)element$iv$iv;
                    boolean bl2 = false;
                    if (this.byFragConf.get(frag) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                Iterable $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$flatMap = false;
                $this$mapNotNullTo$iv$iv = $this$flatMap$iv;
                destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    Map spaces = (Map)element$iv$iv;
                    boolean bl = false;
                    Iterable $this$sortedBy$iv = spaces.values();
                    boolean $i$f$sortedBy = false;
                    Iterable list$iv$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                        public final int compare(T a, T b) {
                            ConfConfSpace it = (ConfConfSpace)a;
                            boolean bl = false;
                            Comparable comparable = (Comparable)((Object)it.getConf().getId());
                            it = (ConfConfSpace)b;
                            Comparable comparable2 = comparable;
                            bl = false;
                            return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getConf().getId())));
                        }
                    });
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                return ((List)destination$iv$iv).iterator();
            }

            /*
             * WARNING - void declaration
             */
            public final int getSize() {
                Collection<Map<ConfLib.Conf, ConfConfSpace>> collection = this.byFragConf.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"byFragConf\n                        .values");
                Iterable iterable = collection;
                int n = 0;
                for (Object t : iterable) {
                    void it;
                    Map map = (Map)t;
                    int n2 = n;
                    boolean bl = false;
                    int n3 = it.size();
                    n = n2 + n3;
                }
                return n;
            }

            @Nullable
            public final ConfConfSpace get(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                Map<ConfLib.Conf, ConfConfSpace> map = this.byFragConf.get(frag);
                return map != null ? map.get(conf) : null;
            }

            @NotNull
            public final List<ConfConfSpace> getByFragment(@NotNull ConfLib.Fragment frag) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Map<ConfLib.Conf, ConfConfSpace> map = this.byFragConf.get(frag);
                if (map == null || (map = map.values()) == null || (map = CollectionsKt.toList((Iterable)((Iterable)((Object)map)))) == null) {
                    map = CollectionsKt.emptyList();
                }
                return map;
            }

            public final boolean contains(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                return this.get(frag, conf) != null;
            }

            @NotNull
            public final ConfConfSpace getOrAdd(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                ConfConfSpace confConfSpace = this.get(frag, conf);
                if (confConfSpace == null) {
                    confConfSpace = this.add(frag, conf);
                }
                return confConfSpace;
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final ConfConfSpace add(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
                Object object;
                void $this$getOrPut$iv;
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                if (this.get(frag, conf) != null) {
                    throw new IllegalStateException("position already has conformation " + frag.getId() + ", " + conf.getId());
                }
                ConfConfSpace confConfSpace = new ConfConfSpace(frag, conf);
                Map map = this.byFragConf;
                boolean $i$f$getOrPut = false;
                Object value$iv = $this$getOrPut$iv.get(frag);
                if (value$iv == null) {
                    boolean bl = false;
                    Map answer$iv = new IdentityHashMap();
                    $this$getOrPut$iv.put(frag, answer$iv);
                    object = answer$iv;
                } else {
                    object = value$iv;
                }
                ((Map)object).put(conf, confConfSpace);
                return confConfSpace;
            }

            public final void addAll(@NotNull ConfLib.Fragment frag, @NotNull Iterable<ConfLib.Conf> confs) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter(confs, (String)"confs");
                for (ConfLib.Conf conf : confs) {
                    this.add(frag, conf);
                }
            }

            public final void addAll(@NotNull ConfLib.Fragment frag, String ... confIds) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)confIds, (String)"confIds");
                this.addAll(frag, (Iterable<ConfLib.Conf>)frag.getConfs(Arrays.copyOf(confIds, confIds.length)));
            }

            public final void addAll(@NotNull ConfLib.Fragment frag) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                this.addAll(frag, (Iterable<ConfLib.Conf>)frag.getConfs().values());
            }

            public final void remove(@NotNull ConfLib.Fragment frag, @NotNull ConfLib.Conf conf) {
                Intrinsics.checkNotNullParameter((Object)frag, (String)"frag");
                Intrinsics.checkNotNullParameter((Object)conf, (String)"conf");
                Map<ConfLib.Conf, ConfConfSpace> map = this.byFragConf.get(frag);
                if (map != null) {
                    map.remove(conf);
                }
                Map<ConfLib.Conf, ConfConfSpace> map2 = this.byFragConf.get(frag);
                boolean bl = map2 != null ? map2.isEmpty() : false;
                if (bl) {
                    this.byFragConf.remove(frag);
                }
            }

            /*
             * WARNING - void declaration
             */
            public final void removeByFragmentType(@NotNull String type) {
                void $this$filterTo$iv$iv;
                Object element$iv;
                Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                Collection<Map<ConfLib.Conf, ConfConfSpace>> collection = this.byFragConf.values();
                Intrinsics.checkNotNullExpressionValue(collection, (String)"byFragConf.values");
                Object $this$forEach$iv = collection;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.iterator();
                while (iterator2.hasNext()) {
                    element$iv = iterator2.next();
                    Map spaces = (Map)element$iv;
                    boolean bl = false;
                    spaces.values().removeIf(arg_0 -> Confs.removeByFragmentType$lambda$7$lambda$6((Function1)new Function1<ConfConfSpace, Boolean>(type){
                        final /* synthetic */ String $type;
                        {
                            this.$type = $type;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(@NotNull ConfConfSpace space) {
                            Intrinsics.checkNotNullParameter((Object)space, (String)"space");
                            return Intrinsics.areEqual((Object)space.getFrag().getType(), (Object)this.$type);
                        }
                    }, arg_0));
                }
                Map $this$filter$iv = this.byFragConf;
                boolean $i$f$filter = false;
                iterator2 = $this$filter$iv;
                Map destination$iv$iv = new LinkedHashMap();
                boolean $i$f$filterTo = false;
                Iterator bl = $this$filterTo$iv$iv.entrySet().iterator();
                while (bl.hasNext()) {
                    Map.Entry element$iv$iv;
                    Map.Entry it = element$iv$iv = bl.next();
                    boolean bl2 = false;
                    if (!((Map)it.getValue()).isEmpty()) continue;
                    destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
                }
                $this$forEach$iv = destination$iv$iv;
                $i$f$forEach = false;
                iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Object remove = element$iv = iterator2.next();
                    boolean bl3 = false;
                    this.byFragConf.remove(remove.getKey());
                }
            }

            private static final boolean removeByFragmentType$lambda$7$lambda$6(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (Boolean)$tmp0.invoke(p0);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0007\u001a\u00020\bJ\u0013\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005H\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u0005J\u0006\u0010\r\u001a\u00020\bR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpaces;", "", "(Ledu/duke/cs/osprey/gui/prep/ConfSpace;)V", "confSpaces", "", "Ledu/duke/cs/osprey/gui/prep/DesignPosition;", "Ledu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpace;", "confSpaceSize", "Ljava/math/BigInteger;", "get", "pos", "getOrMake", "remove", "sequenceSpaceSize", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nConfSpace.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpaces\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,503:1\n361#2,7:504\n1#3:511\n1549#4:512\n1620#4,3:513\n2661#4,7:516\n1549#4:523\n1620#4,3:524\n2661#4,7:527\n*S KotlinDebug\n*F\n+ 1 ConfSpace.kt\nedu/duke/cs/osprey/gui/prep/ConfSpace$PositionConfSpaces\n*L\n271#1:504,7\n280#1:512\n280#1:513,3\n281#1:516,7\n287#1:523\n287#1:524,3\n288#1:527,7\n*E\n"})
    public final class PositionConfSpaces {
        @NotNull
        private final Map<DesignPosition, PositionConfSpace> confSpaces = new IdentityHashMap();

        @Nullable
        public final PositionConfSpace get(@NotNull DesignPosition pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return this.confSpaces.get(pos);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final PositionConfSpace getOrMake(@NotNull DesignPosition pos) {
            Object object;
            void $this$getOrPut$iv;
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            Map<DesignPosition, PositionConfSpace> map = this.confSpaces;
            ConfSpace confSpace = ConfSpace.this;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(pos);
            if (value$iv == null) {
                boolean bl = false;
                confSpace.checkPosition(pos);
                PositionConfSpace answer$iv = new PositionConfSpace();
                $this$getOrPut$iv.put(pos, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (PositionConfSpace)object;
        }

        @Nullable
        public final PositionConfSpace remove(@NotNull DesignPosition pos) {
            Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
            return this.confSpaces.remove(pos);
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public final BigInteger sequenceSpaceSize() {
            BigInteger bigInteger;
            Collection<PositionConfSpace> collection;
            Collection<PositionConfSpace> collection2;
            Collection<PositionConfSpace> it = collection2 = this.confSpaces.values();
            boolean bl = false;
            Collection<PositionConfSpace> collection3 = collection = !it.isEmpty() ? collection2 : null;
            if (collection != null) {
                void var7_11;
                void $this$reduce$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = collection;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean bl2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    PositionConfSpace positionConfSpace = (PositionConfSpace)item$iv$iv;
                    Collection collection4 = destination$iv$iv;
                    boolean bl3 = false;
                    BigInteger bigInteger2 = BigInteger.valueOf(it2.getMutations().size());
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(this.toLong())");
                    collection4.add(bigInteger2);
                }
                Iterable $i$f$map22 = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object t = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    BigInteger bigInteger3 = (BigInteger)iterator$iv.next();
                    BigInteger a = (BigInteger)var7_11;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)a.multiply((BigInteger)b), (String)"a.multiply(b)");
                }
                BigInteger bigInteger4 = (BigInteger)var7_11;
                if (bigInteger4 != null) {
                    bigInteger = bigInteger4;
                    return bigInteger;
                }
            }
            BigInteger bigInteger5 = BigInteger.ZERO;
            bigInteger = bigInteger5;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ZERO");
            return bigInteger;
        }

        /*
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public final BigInteger confSpaceSize() {
            BigInteger bigInteger;
            Collection<PositionConfSpace> collection;
            Collection<PositionConfSpace> collection2;
            Collection<PositionConfSpace> it = collection2 = this.confSpaces.values();
            boolean bl = false;
            Collection<PositionConfSpace> collection3 = collection = !it.isEmpty() ? collection2 : null;
            if (collection != null) {
                void var7_11;
                void $this$reduce$iv;
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = collection;
                boolean $i$f$map22 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean bl2 = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it2;
                    PositionConfSpace positionConfSpace = (PositionConfSpace)item$iv$iv;
                    Collection collection4 = destination$iv$iv;
                    boolean bl3 = false;
                    BigInteger bigInteger2 = BigInteger.valueOf(it2.getConfs().getSize());
                    Intrinsics.checkNotNullExpressionValue((Object)bigInteger2, (String)"valueOf(this.toLong())");
                    collection4.add(bigInteger2);
                }
                Iterable $i$f$map22 = (List)destination$iv$iv;
                boolean $i$f$reduce = false;
                Iterator iterator$iv = $this$reduce$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    throw new UnsupportedOperationException("Empty collection can't be reduced.");
                }
                Object t = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void b;
                    BigInteger bigInteger3 = (BigInteger)iterator$iv.next();
                    BigInteger a = (BigInteger)var7_11;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)a.multiply((BigInteger)b), (String)"a.multiply(b)");
                }
                BigInteger bigInteger4 = (BigInteger)var7_11;
                if (bigInteger4 != null) {
                    bigInteger = bigInteger4;
                    return bigInteger;
                }
            }
            BigInteger bigInteger5 = BigInteger.ZERO;
            bigInteger = bigInteger5;
            Intrinsics.checkNotNullExpressionValue((Object)bigInteger5, (String)"ZERO");
            return bigInteger;
        }
    }
}

