/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.energy.compiled.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.ConfSpaceType;
import edu.duke.cs.osprey.kstar.InitException;
import edu.duke.cs.osprey.kstar.KStarSettings;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.AutoCloseableNoEx;
import java.io.File;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

public class ConfSpaceInfo {
    private final KStarSettings settings;
    public final ConfSpaceIteration confSpace;
    public final ConfSpaceType type;
    public ConfEnergyCalculator confEcalc = null;
    public final String id;
    public final Map<Sequence, PartitionFunction.Result> pfuncResults = new HashMap<Sequence, PartitionFunction.Result>();
    public File confDBFile = null;
    public PfuncFactory pfuncFactory = null;
    private ConfDB confDB = null;

    public ConfSpaceInfo(KStarSettings settings, ConfSpaceIteration confSpace, ConfSpaceType type) {
        this.settings = settings;
        this.confSpace = confSpace;
        this.type = type;
        this.id = type.name().toLowerCase();
        this.confDBFile = new File(String.format(settings.confDBPattern, this.id));
    }

    public void check() {
        if (this.confEcalc == null) {
            throw new InitException(this.type, "confEcalc");
        }
        if (this.pfuncFactory == null) {
            throw new InitException(this.type, "pfuncFactory");
        }
    }

    public AutoCloseableNoEx openConfDB() {
        if (this.confDBFile != null) {
            this.confDB = new ConfDB(this.confSpace, this.confDBFile);
        }
        return () -> {
            if (this.confDB != null) {
                this.confDB.close();
                this.confDB = null;
            }
        };
    }

    public void clear() {
        this.pfuncResults.clear();
    }

    public PartitionFunction.Result calcPfunc(TaskExecutor.ContextGroup ctxGroup, Sequence globalSequence, BigDecimal stabilityThreshold) {
        Sequence sequence = globalSequence.filter(this.confSpace.seqSpace());
        PartitionFunction.Result result = this.pfuncResults.get(sequence);
        if (result != null) {
            return result;
        }
        PartitionFunction pfunc = this.makePfunc(ctxGroup, sequence);
        pfunc.setStabilityThreshold(stabilityThreshold);
        if (this.settings.pfuncTimeout != null) {
            pfunc.compute(this.settings.pfuncTimeout);
        } else {
            pfunc.compute(this.settings.maxNumConfs);
        }
        result = pfunc.makeResult();
        this.pfuncResults.put(sequence, result);
        Runtime.getRuntime().gc();
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
        return result;
    }

    public PartitionFunction makePfunc(TaskExecutor.ContextGroup ctxGroup, Sequence seq) {
        RCs rcs = seq.makeRCs(this.confSpace);
        PartitionFunction pfunc = this.pfuncFactory.make(rcs);
        pfunc.setReportProgress(this.settings.showPfuncProgress);
        if (this.settings.useExternalMemory) {
            PartitionFunction.WithExternalMemory.setOrThrow(pfunc, true, rcs);
        }
        if (this.confDB != null) {
            PartitionFunction.WithConfDB.cast(pfunc).setConfDB(this.confDB, seq);
        }
        pfunc.setInstanceId(this.type.ordinal());
        pfunc.putTaskContexts(ctxGroup);
        pfunc.init(this.settings.epsilon);
        return pfunc;
    }

    public static interface PfuncFactory {
        public PartitionFunction make(RCs var1);
    }
}

