/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.confspace.Strand;
import edu.duke.cs.osprey.control.ConfigFileParser;
import edu.duke.cs.osprey.control.EnvironmentVars;
import edu.duke.cs.osprey.dof.deeper.DEEPerSettings;
import edu.duke.cs.osprey.ematrix.epic.EPICSettings;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.multistatekstar.ResidueTermini;
import edu.duke.cs.osprey.structure.Molecule;
import edu.duke.cs.osprey.structure.PDBIO;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.ObjectIO;
import edu.duke.cs.osprey.tools.StringParsing;
import edu.duke.cs.osprey.tupexp.LUTESettings;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;

public class KSConfigFileParser
extends ConfigFileParser
implements Serializable {
    private static final long serialVersionUID = 3653519769830569960L;

    public KSConfigFileParser(ConfigFileParser cfp) {
        super(cfp);
    }

    public KSConfigFileParser() {
    }

    public ArrayList<ArrayList<String>> getHighOrderTuplesByStrand(int strand) {
        ArrayList<ArrayList<String>> ans = this.getHighOrderTuplesByPDBResNum();
        switch (strand) {
            case 2: {
                return ans;
            }
            case 1: {
                return this.filterHOTListByStrand(this.getStrandLimits(1), ans);
            }
            case 0: {
                return this.filterHOTListByStrand(this.getStrandLimits(0), ans);
            }
        }
        throw new RuntimeException("ERROR: invalid strand");
    }

    public ArrayList<ArrayList<String>> getHighOrderTuplesByPDBResNum() {
        ArrayList<ArrayList<String>> ans = new ArrayList<ArrayList<String>>();
        HashSet<String> flexRes = new HashSet<String>(this.getFlexRes());
        HashSet<String> resInHot = new HashSet<String>();
        ArrayList<String> hotRecords = this.params.searchParams("kStarPFuncHot_");
        for (String hotRecord : hotRecords) {
            ArrayList<String> hotRes = new ArrayList<String>();
            String val = this.params.getValue(hotRecord);
            StringTokenizer tokenizer = new StringTokenizer(val);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!flexRes.contains(token)) {
                    throw new RuntimeException("ERROR: residue " + token + " in line " + hotRecord + " must be flexible.");
                }
                if (resInHot.contains(token)) {
                    throw new RuntimeException("ERROR: residue " + token + " cannot appear in more than one HOT.");
                }
                hotRes.add(token);
                resInHot.add(token);
            }
            if (hotRes.size() < 3) {
                throw new RuntimeException("ERROR: in line " + hotRecord + " the number of residues is < 3.");
            }
            hotRes.trimToSize();
            ans.add(hotRes);
        }
        ans.trimToSize();
        return ans;
    }

    protected ArrayList<ArrayList<String>> filterHOTListByStrand(ResidueTermini strand, ArrayList<ArrayList<String>> list) {
        ArrayList ans = (ArrayList)ObjectIO.deepCopy(list);
        Iterator iterator2 = ans.iterator();
        while (iterator2.hasNext()) {
            ArrayList hot = (ArrayList)iterator2.next();
            Iterator iterator22 = hot.iterator();
            while (iterator22.hasNext()) {
                String pdbResNum = (String)iterator22.next();
                if (strand.contains(pdbResNum)) continue;
                iterator22.remove();
            }
            if (hot.size() >= 3) continue;
            iterator2.remove();
        }
        return ans;
    }

    protected DEEPerSettings setupDEEPer(int strand) {
        ArrayList<String> flexRes = strand == 2 ? this.getFlexRes() : this.getFlexResByStrand(strand);
        DEEPerSettings dset = new DEEPerSettings(this.params.getBool("doPerturbations"), "STR" + strand + "." + this.params.getRunSpecificFileName("perturbationFile", ".pert"), this.params.getBool("selectPerturbations"), this.params.getValue("startingPerturbationFile"), this.params.getBool("onlyStartingPerturbations"), this.params.getDouble("maxShearParam"), this.params.getDouble("maxBackrubParam"), this.params.getBool("selectLCAs"), flexRes, this.params.getValue("PDBNAME"), this.params.getBool("DORAMACHECK"), EnvironmentVars.resTemplates);
        ResidueTermini limits = this.getStrandLimits(strand);
        dset.loadPertFile(limits);
        return dset;
    }

    private ArrayList<String[]> freeBBZoneTermini(ResidueTermini limits) {
        ArrayList<String[]> ans = new ArrayList<String[]>();
        for (String rt : this.params.searchParams("BBFREEBLOCK")) {
            String strandLimitsString = this.params.getValue(rt);
            String[] termini = new String[]{StringParsing.getToken(strandLimitsString, 1), StringParsing.getToken(strandLimitsString, 2)};
            if (limits != null && (!limits.contains(termini[0]) || !limits.contains(termini[1]))) continue;
            ans.add(termini);
        }
        return ans;
    }

    private ArrayList<String[]> moveableStrandTermini(ResidueTermini limits) {
        ArrayList<String[]> ans = new ArrayList<String[]>();
        for (String rt : this.params.searchParams("STRANDROTTRANS")) {
            if (!this.params.getBool(rt)) continue;
            String strandNum = rt.substring(14);
            String strandLimitsString = this.params.getValue("STRAND" + strandNum);
            String[] termini = new String[]{StringParsing.getToken(strandLimitsString, 1), StringParsing.getToken(strandLimitsString, 2)};
            if (limits != null && (!limits.contains(termini[0]) || !limits.contains(termini[1]))) continue;
            ans.add(termini);
        }
        return ans;
    }

    protected ResidueTermini getStrandLimits(int strand) {
        if (strand == 2) {
            return null;
        }
        String strandLimits = this.params.getValue("STRAND" + strand);
        StringTokenizer tokenizer = new StringTokenizer(this.params.getValue("STRANDMUTNUMS"));
        for (int it = 0; it < strand; ++it) {
            tokenizer.nextToken();
        }
        tokenizer = new StringTokenizer(strandLimits);
        ArrayList<String> strLimits = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            strLimits.add(tokenizer.nextToken());
        }
        return new ResidueTermini(strand, (String)strLimits.get(0), (String)strLimits.get(1));
    }

    public ArrayList<String> getWTSequence() {
        int pos;
        Molecule m = new Strand.Builder((Molecule)PDBIO.readFile((File)this.params.getFile((String)"PDBNAME"))).build().mol;
        ArrayList<String> flexibleRes = this.getFlexRes();
        int numPos = flexibleRes.size();
        ArrayList<String> wt = new ArrayList<String>();
        for (pos = 0; pos < numPos; ++pos) {
            wt.add(null);
        }
        for (pos = 0; pos < numPos; ++pos) {
            Residue res = m.getResByPDBResNumber(flexibleRes.get(pos));
            String wtName = res.template.name;
            wt.set(pos, wtName);
        }
        wt.trimToSize();
        return wt;
    }

    public SearchProblem getSearchProblem(int strand, KSAllowedSeqs strandSeqs) {
        String tmp = this.params.getValue("kStarOutputDir");
        if (tmp.equalsIgnoreCase("runName")) {
            tmp = this.params.getValue("RUNNAME");
        }
        String ematDir = tmp + File.separator + this.params.getValue("kStarEmatDir");
        ObjectIO.makeDir(ematDir, this.params.getBool("kStarDeleteEmatDir", false));
        String name = ematDir + File.separator + this.params.getValue("RUNNAME");
        String suffix = "Strand" + strand;
        ArrayList<String[]> moveableStrands = strandSeqs.getMoveableStrandTermini();
        ArrayList<String[]> freeBBZones = strandSeqs.getFreeBBZoneTermini();
        DEEPerSettings dset = strandSeqs.getDEEPerSettings();
        System.out.println("CREATING SEARCH PROBLEM.  NAME: " + name);
        return new SearchProblem(name + "." + suffix, this.params.getValue("PDBNAME"), strandSeqs.getFlexRes(), strandSeqs.getAllowedAAs(), this.params.getBool("AddWT"), this.params.getBool("doMinimize", false), this.params.getBool("useEpic"), new EPICSettings(this.params), this.params.getBool("UseTupExp", false), new LUTESettings(this.params), dset, moveableStrands, freeBBZones, this.params.getBool("useEllipses", false), this.params.getBool("useERef", false), this.params.getBool("AddResEntropy", false), this.params.getBool("addWTRots", false), this.getStrandLimits(strand), this.params.getBool("useVoxelG", false), new ArrayList<String>());
    }

    ArrayList<String> getFlexResByStrand(int strand) {
        if (strand != 2 && strand != 0 && strand != 1) {
            throw new RuntimeException("ERROR: specified strand " + strand + " is invalid");
        }
        ArrayList<String> flexResList = new ArrayList<String>();
        String resListString = this.params.getValue("strandMut" + strand);
        StringTokenizer tokenizer = new StringTokenizer(resListString);
        while (tokenizer.hasMoreTokens()) {
            flexResList.add(tokenizer.nextToken());
        }
        return flexResList;
    }

    public void verifyStrandsMutuallyExclusive() {
        ResidueTermini s0 = this.getStrandLimits(0);
        ResidueTermini s1 = this.getStrandLimits(1);
        if (s0.lBound.compareTo(s1.uBound) <= 0 && s1.lBound.compareTo(s0.uBound) <= 0) {
            throw new RuntimeException("ERROR: strand0 overlaps with strand1. Please fix strand termini.");
        }
    }

    public KSAllowedSeqs getAllowedSequences(int strand, KSAllowedSeqs complexSeqs) {
        ArrayList allowedAAs;
        ArrayList flexRes;
        ResidueTermini limits = this.getStrandLimits(strand);
        if (complexSeqs == null) {
            flexRes = this.getFlexRes();
            allowedAAs = this.getAllowedAAs();
            if (flexRes.size() != allowedAAs.size()) {
                throw new RuntimeException("ERROR: Number of flexible positions different in flexible residue and allowed AA type parameters!");
            }
            int numMutations = this.params.getInt("NUMMUTATIONS", 1);
            boolean allowLessMut = this.params.getBool("ALLOWLESSMUTATIONS", false);
            complexSeqs = new KSAllowedSeqs(strand, limits, this.setupDEEPer(strand), this.freeBBZoneTermini(limits), this.moveableStrandTermini(limits), flexRes, allowedAAs, this.getWTSequence(), this.params.getBool("addWT"), numMutations, allowLessMut);
            if (!complexSeqs.containsWTSeq()) {
                System.out.println("WARNING: allowed sequences does not contain the wild-type sequence: " + KSAbstract.list1D2String(complexSeqs.getWTSeq(), " ") + "\n");
            }
            if (numMutations > 0 && complexSeqs.getNumSeqs() == 1 && complexSeqs.containsWTSeq()) {
                throw new RuntimeException("ERROR: cannot generate any sequences for NUMMUTATIONS=" + numMutations + " mutation(s). Change the value of NUMMUTATIONS parameter.");
            }
        }
        if (strand == 2) {
            return complexSeqs;
        }
        flexRes = (ArrayList)ObjectIO.deepCopy(complexSeqs.getFlexRes());
        allowedAAs = (ArrayList)ObjectIO.deepCopy(complexSeqs.getAllowedAAs());
        int lb = -1;
        int ub = -1;
        ResidueTermini compressedLimits = this.getCompressedStrandLimits(strand, complexSeqs.getFlexRes());
        lb = flexRes.indexOf(String.valueOf(compressedLimits.lBound));
        ub = flexRes.indexOf(String.valueOf(compressedLimits.uBound)) + 1;
        this.filterResiduesByStrand(strand, flexRes, allowedAAs);
        KSAllowedSeqs strandSeqs = new KSAllowedSeqs(strand, this.getStrandLimits(strand), this.setupDEEPer(strand), this.freeBBZoneTermini(limits), this.moveableStrandTermini(limits), flexRes, complexSeqs, allowedAAs, lb, ub);
        return strandSeqs;
    }

    ResidueTermini getCompressedStrandLimits(int strand, ArrayList<String> flexRes) {
        ResidueTermini strandLimits = this.getStrandLimits(strand);
        ArrayList<String> strandResNums = this.getFlexResByStrand(strand);
        ArrayList flexRes2 = (ArrayList)ObjectIO.deepCopy(flexRes);
        int it = 0;
        while (it < flexRes2.size()) {
            if (!strandLimits.contains((String)flexRes2.get(it))) {
                String removed = (String)flexRes2.remove(it);
                if (!strandResNums.contains(removed)) continue;
                throw new RuntimeException("ERROR: in strand" + strand + ", flexible residue " + removed + " exceeds strand limits");
            }
            ++it;
        }
        ArrayList<String> limits = new ArrayList<String>();
        limits.add((String)flexRes2.get(0));
        limits.add((String)flexRes2.get(flexRes2.size() - 1));
        ResidueTermini ans = new ResidueTermini(strand, (String)limits.get(0), (String)limits.get(1));
        return ans;
    }

    void filterResiduesByStrand(int strand, ArrayList<String> flexRes, ArrayList<ArrayList<String>> allowedAAs) {
        ResidueTermini strandLimits = this.getStrandLimits(strand);
        ArrayList<String> strandResNums = this.getFlexResByStrand(strand);
        int it = 0;
        while (it < flexRes.size()) {
            if (!strandLimits.contains(flexRes.get(it))) {
                String removed = flexRes.remove(it);
                if (strandResNums.contains(removed)) {
                    throw new RuntimeException("ERROR: in strand" + strand + ", flexible residue " + removed + " exceeds strand limits");
                }
                allowedAAs.remove(it);
                continue;
            }
            ++it;
        }
        if (flexRes.size() != allowedAAs.size()) {
            throw new RuntimeException("ERROR: Number of flexible positions different in flexible residue and allowed AA type parameters!");
        }
    }
}

