/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;

public class KSPStarCalculator
extends Thread
implements Serializable {
    protected PFAbstract pf;
    private BigInteger pruned = BigInteger.ZERO;
    protected BigDecimal lastBoltzmannWeight = BigDecimal.ZERO;
    protected double lastEnergyBound = Double.NEGATIVE_INFINITY;
    protected BigInteger enumerated = BigInteger.ZERO;
    protected ConfSearch confSearch = null;
    protected boolean confsExhausted = false;
    protected BigDecimal totalPF = BigDecimal.ZERO;
    protected final String lock = new String("LOCK");

    public KSPStarCalculator(PFAbstract pf) {
        this.pf = pf;
        this.pruned = pf.getNumPruned();
        this.confSearch = this.getConfSearch();
    }

    private ConfSearch getConfSearch() {
        return this.pf.getConfTree(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getPStar() {
        BigDecimal ans = BigDecimal.ZERO;
        String string = this.lock;
        synchronized (string) {
            ans = this.totalPF;
            BigDecimal uniformBound = new BigDecimal(this.pruned.subtract(this.enumerated)).multiply(this.lastBoltzmannWeight);
            ans = ans.add(uniformBound);
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getTotalPF() {
        BigDecimal ans;
        String string = this.lock;
        synchronized (string) {
            ans = this.totalPF;
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigInteger getNumEnumerated() {
        BigInteger ans;
        String string = this.lock;
        synchronized (string) {
            ans = this.enumerated;
        }
        return ans;
    }

    protected void nullify() {
        if (!this.confsExhausted) {
            BigInteger remaining = this.pruned.subtract(this.enumerated);
            BigDecimal uniformBound = new BigDecimal(remaining).multiply(this.lastBoltzmannWeight);
            BigDecimal denom = uniformBound.add(this.totalPF);
            BigDecimal percentPStar = denom.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : this.totalPF.divide(denom, 4);
            System.out.print("p* confTree complete. # enumerated: " + String.valueOf(this.enumerated) + ". # remaining: " + String.valueOf(remaining) + ". ");
            System.out.println("% p*: " + String.valueOf(percentPStar));
        }
        this.confsExhausted = true;
        this.lastBoltzmannWeight = BigDecimal.ZERO;
        this.pf = null;
        this.confSearch = null;
    }

    public void cleanUp(boolean nullify) throws InterruptedException {
        this.join();
        if (nullify) {
            this.nullify();
        }
    }

    public boolean isExhausted() {
        return this.confsExhausted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.confsExhausted) {
            this.nullify();
            return;
        }
        while (true) {
            ConfSearch.ScoredConf conf = this.confSearch.nextConf();
            String string = this.lock;
            synchronized (string) {
                if (conf == null) {
                    this.nullify();
                    return;
                }
                this.lastEnergyBound = this.pf.getConfBound(this.confSearch, conf.getAssignments());
                if (this.lastEnergyBound == Double.POSITIVE_INFINITY) {
                    this.lastBoltzmannWeight = BigDecimal.ZERO;
                    this.totalPF = this.totalPF.add(BigDecimal.ZERO);
                    this.enumerated = this.enumerated.add(BigInteger.ONE);
                    this.nullify();
                    return;
                }
                this.lastBoltzmannWeight = this.pf.getBoltzmannWeight(this.lastEnergyBound);
                if (this.lastBoltzmannWeight.compareTo(BigDecimal.ZERO) == 0) {
                    this.totalPF = this.totalPF.add(BigDecimal.ZERO);
                    this.enumerated = this.enumerated.add(BigInteger.ONE);
                    this.nullify();
                    return;
                }
                this.totalPF = this.totalPF.add(this.lastBoltzmannWeight);
                this.enumerated = this.enumerated.add(BigInteger.ONE);
                if (this.pf.getEpsilonStatus() != PFAbstract.EApproxReached.FALSE) {
                    this.nullify();
                    return;
                }
            }
        }
    }
}

