/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.kstar.KSPStarCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import java.math.BigDecimal;
import java.math.BigInteger;

public class KSQPrimeCalculator
extends KSPStarCalculator {
    private BigInteger unPruned = BigInteger.ZERO;

    public KSQPrimeCalculator(PFAbstract pf) {
        super(pf);
        this.unPruned = pf.getNumUnPruned();
        this.confSearch = this.getConfSearch();
    }

    private ConfSearch getConfSearch() {
        return this.pf.getConfTree(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BigDecimal getQPrime(BigDecimal partialQLB) {
        BigDecimal ans = BigDecimal.ZERO;
        String string = this.lock;
        synchronized (string) {
            ans = this.totalPF.subtract(partialQLB);
            BigDecimal uniformBound = new BigDecimal(this.unPruned.subtract(this.enumerated)).multiply(this.lastBoltzmannWeight);
            ans = ans.add(uniformBound);
        }
        return ans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getPercentQPrime() {
        BigDecimal ans = BigDecimal.ZERO;
        String string = this.lock;
        synchronized (string) {
            BigInteger remaining = this.unPruned.subtract(this.enumerated);
            BigDecimal uniformBound = new BigDecimal(remaining).multiply(this.lastBoltzmannWeight);
            BigDecimal denom = uniformBound.add(this.totalPF);
            ans = denom.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : this.totalPF.divide(denom, 4);
        }
        return ans.doubleValue();
    }

    @Override
    protected void nullify() {
        if (!this.confsExhausted) {
            BigInteger remaining = this.unPruned.subtract(this.enumerated);
            BigDecimal uniformBound = new BigDecimal(remaining).multiply(this.lastBoltzmannWeight);
            BigDecimal denom = uniformBound.add(this.totalPF);
            BigDecimal percentQPrime = denom.compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ONE : this.totalPF.divide(denom, 4);
            System.out.print("q' confTree complete. # enumerated: " + String.valueOf(this.enumerated) + ". # remaining: " + String.valueOf(remaining) + ". ");
            System.out.println("% q': " + String.valueOf(percentQPrime));
        }
        this.confsExhausted = true;
        this.lastBoltzmannWeight = BigDecimal.ZERO;
        this.pf = null;
        this.confSearch = null;
    }
}

