/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSpaceIteration;
import edu.duke.cs.osprey.confspace.Sequence;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.ConfSpaceType;
import edu.duke.cs.osprey.kstar.InitException;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.kstar.KStarScoreWriter;
import edu.duke.cs.osprey.kstar.KStarSettings;
import edu.duke.cs.osprey.kstar.ScoredSequence;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import edu.duke.cs.osprey.tools.AutoCloseableNoEx;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class KStar {
    public final ConfSpaceInfo protein;
    public final ConfSpaceInfo ligand;
    public final ConfSpaceInfo complex;
    public final KStarSettings settings;
    private final List<Sequence> sequences;

    public KStar(ConfSpaceIteration protein, ConfSpaceIteration ligand, ConfSpaceIteration complex, KStarSettings settings) {
        this.settings = settings;
        this.protein = new ConfSpaceInfo(protein, ConfSpaceType.Protein);
        this.ligand = new ConfSpaceInfo(ligand, ConfSpaceType.Ligand);
        this.complex = new ConfSpaceInfo(complex, ConfSpaceType.Complex);
        this.sequences = new ArrayList<Sequence>();
    }

    public Iterable<ConfSpaceInfo> confSpaceInfos() {
        return Arrays.asList(this.protein, this.ligand, this.complex);
    }

    public ConfSpaceInfo getConfSpaceInfo(ConfSpaceIteration confSpace) {
        if (confSpace == this.protein.confSpace) {
            return this.protein;
        }
        if (confSpace == this.ligand.confSpace) {
            return this.ligand;
        }
        if (confSpace == this.complex.confSpace) {
            return this.complex;
        }
        throw new IllegalArgumentException("conf space does not match any known by this K* instance");
    }

    /*
     * Exception decompiling
     */
    public ScoredSequence score(Sequence seq, TaskExecutor tasks) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public List<ScoredSequence> run() {
        return this.run(new TaskExecutor());
    }

    public List<ScoredSequence> run(TaskExecutor tasks) {
        try (TaskExecutor.ContextGroup ctxGroup = tasks.contextGroup();){
            PartitionFunction.Result complexResult2;
            PartitionFunction.Result ligandResult2;
            PartitionFunction.Result proteinResult2;
            this.protein.check();
            this.ligand.check();
            this.complex.check();
            this.sequences.clear();
            this.protein.clear();
            this.ligand.clear();
            this.complex.clear();
            ArrayList<ScoredSequence> scores = new ArrayList<ScoredSequence>();
            if (this.complex.confSpace.seqSpace().containsWildTypeSequence()) {
                this.sequences.add(this.complex.confSpace.seqSpace().makeWildTypeSequence());
            }
            this.sequences.addAll(this.complex.confSpace.seqSpace().getMutants(this.settings.maxSimultaneousMutations, true));
            int n = this.sequences.size();
            Scorer scorer = (sequenceNumber, proteinResult, ligandResult, complexResult) -> {
                KStarScore kstarScore = new KStarScore(proteinResult, ligandResult, complexResult);
                Sequence sequence = this.sequences.get(sequenceNumber);
                scores.add(new ScoredSequence(sequence, kstarScore));
                this.settings.scoreWriters.writeScore(new KStarScoreWriter.ScoreInfo(sequenceNumber, n, sequence, kstarScore));
                return kstarScore;
            };
            System.out.println("computing K* scores for " + this.sequences.size() + " sequences to epsilon = " + this.settings.epsilon + " ...");
            this.settings.scoreWriters.writeHeader();
            BigDecimal proteinStabilityThreshold = null;
            BigDecimal ligandStabilityThreshold = null;
            try (AutoCloseableNoEx proteinCloser = this.protein.openConfDB();
                 AutoCloseableNoEx ligandCloser = this.ligand.openConfDB();
                 AutoCloseableNoEx complexCloser = this.complex.openConfDB();){
                proteinResult2 = this.protein.calcPfunc(ctxGroup, this.sequences.get(0), BigDecimal.ZERO);
                ligandResult2 = this.ligand.calcPfunc(ctxGroup, this.sequences.get(0), BigDecimal.ZERO);
                complexResult2 = this.complex.calcPfunc(ctxGroup, this.sequences.get(0), BigDecimal.ZERO);
            }
            KStarScore wildTypeScore = scorer.score(0, proteinResult2, ligandResult2, complexResult2);
            if (this.settings.stabilityThreshold != null) {
                BigDecimal stabilityThresholdFactor = new BoltzmannCalculator(PartitionFunction.decimalPrecision).calc(this.settings.stabilityThreshold);
                proteinStabilityThreshold = wildTypeScore.protein.values.calcLowerBound().multiply(stabilityThresholdFactor);
                ligandStabilityThreshold = wildTypeScore.ligand.values.calcLowerBound().multiply(stabilityThresholdFactor);
            }
            for (int i = 1; i < n; ++i) {
                try (AutoCloseableNoEx proteinCloser = this.protein.openConfDB();
                     AutoCloseableNoEx ligandCloser = this.ligand.openConfDB();
                     AutoCloseableNoEx complexCloser = this.complex.openConfDB();){
                    Sequence seq = this.sequences.get(i);
                    proteinResult2 = this.protein.calcPfunc(ctxGroup, seq, proteinStabilityThreshold);
                    if (!KStarScore.isLigandComplexUseful(proteinResult2)) {
                        ligandResult2 = PartitionFunction.Result.makeAborted();
                        complexResult2 = PartitionFunction.Result.makeAborted();
                    } else {
                        ligandResult2 = this.ligand.calcPfunc(ctxGroup, seq, ligandStabilityThreshold);
                        complexResult2 = !KStarScore.isComplexUseful(proteinResult2, ligandResult2) ? PartitionFunction.Result.makeAborted() : this.complex.calcPfunc(ctxGroup, seq, BigDecimal.ZERO);
                    }
                }
                scorer.score(i, proteinResult2, ligandResult2, complexResult2);
            }
            ArrayList<ScoredSequence> arrayList = scores;
            return arrayList;
        }
    }

    public class ConfSpaceInfo {
        public final ConfSpaceIteration confSpace;
        public final ConfSpaceType type;
        public final String id;
        public final Map<Sequence, PartitionFunction.Result> pfuncResults = new HashMap<Sequence, PartitionFunction.Result>();
        public File confDBFile = null;
        public ConfEnergyCalculator confEcalc = null;
        public PfuncFactory pfuncFactory = null;
        private ConfDB confDB = null;

        public ConfSpaceInfo(ConfSpaceIteration confSpace, ConfSpaceType type) {
            this.confSpace = confSpace;
            this.type = type;
            this.id = type.name().toLowerCase();
            this.confDBFile = new File(String.format(KStar.this.settings.confDBPattern, this.id));
        }

        private void check() {
            if (this.confEcalc == null) {
                throw new InitException(this.type, "confEcalc");
            }
            if (this.pfuncFactory == null) {
                throw new InitException(this.type, "pfuncFactory");
            }
        }

        private AutoCloseableNoEx openConfDB() {
            if (this.confDBFile != null) {
                this.confDB = new ConfDB(this.confSpace, this.confDBFile);
            }
            return () -> {
                if (this.confDB != null) {
                    this.confDB.close();
                    this.confDB = null;
                }
            };
        }

        private PartitionFunction makePfunc(TaskExecutor.ContextGroup ctxGroup, Sequence seq) {
            RCs rcs = seq.makeRCs(this.confSpace);
            PartitionFunction pfunc = this.pfuncFactory.make(rcs);
            pfunc.setReportProgress(KStar.this.settings.showPfuncProgress);
            if (KStar.this.settings.useExternalMemory) {
                PartitionFunction.WithExternalMemory.setOrThrow(pfunc, true, rcs);
            }
            if (this.confDB != null) {
                PartitionFunction.WithConfDB.cast(pfunc).setConfDB(this.confDB, seq);
            }
            pfunc.setInstanceId(this.type.ordinal());
            pfunc.init(KStar.this.settings.epsilon);
            pfunc.putTaskContexts(ctxGroup);
            return pfunc;
        }

        public void clear() {
            this.pfuncResults.clear();
        }

        public PartitionFunction.Result calcPfunc(TaskExecutor.ContextGroup ctxGroup, Sequence globalSequence, BigDecimal stabilityThreshold) {
            Sequence sequence = globalSequence.filter(this.confSpace.seqSpace());
            PartitionFunction.Result result = this.pfuncResults.get(sequence);
            if (result != null) {
                return result;
            }
            PartitionFunction pfunc = this.makePfunc(ctxGroup, sequence);
            pfunc.setStabilityThreshold(stabilityThreshold);
            if (KStar.this.settings.pfuncTimeout != null) {
                pfunc.compute(KStar.this.settings.pfuncTimeout);
            } else {
                pfunc.compute(KStar.this.settings.maxNumConfs);
            }
            result = pfunc.makeResult();
            this.pfuncResults.put(sequence, result);
            Runtime.getRuntime().gc();
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException(ex);
            }
            return result;
        }
    }

    private static interface Scorer {
        public KStarScore score(int var1, PartitionFunction.Result var2, PartitionFunction.Result var3, PartitionFunction.Result var4);
    }

    public static interface PfuncFactory {
        public PartitionFunction make(RCs var1);
    }
}

