/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar;

import edu.duke.cs.osprey.kstar.KStarScoreWriter;
import java.io.File;
import java.time.Duration;

public class KStarSettings {
    public final int maxNumConfs;
    public final double epsilon;
    public final Double stabilityThreshold;
    public final int maxSimultaneousMutations;
    public final KStarScoreWriter.Writers scoreWriters;
    public final boolean showPfuncProgress;
    public final boolean useExternalMemory;
    public final String confDBPattern;
    public final boolean resume;
    public final Duration pfuncTimeout;

    public KStarSettings(double epsilon, Double stabilityThreshold, int maxSimultaneousMutations, KStarScoreWriter.Writers scoreWriters, boolean dumpPfuncConfs, boolean useExternalMemory, String confDBPattern, boolean resume, int maxNumberConfs, Duration pfuncTimeout) {
        this.epsilon = epsilon;
        this.stabilityThreshold = stabilityThreshold;
        this.maxSimultaneousMutations = maxSimultaneousMutations;
        this.scoreWriters = scoreWriters;
        this.showPfuncProgress = dumpPfuncConfs;
        this.useExternalMemory = useExternalMemory;
        this.confDBPattern = confDBPattern;
        this.resume = resume;
        this.maxNumConfs = maxNumberConfs;
        this.pfuncTimeout = pfuncTimeout;
    }

    public static class Builder {
        private double epsilon = 0.683;
        private Double stabilityThreshold = 5.0;
        private int maxSimultaneousMutations = 1;
        private KStarScoreWriter.Writers scoreWriters = new KStarScoreWriter.Writers();
        private boolean showPfuncProgress = false;
        private boolean useExternalMemory = false;
        private String confDBPattern = "%s.confdb";
        private boolean resume = false;
        private int maxNumberConfs = Integer.MAX_VALUE;
        private Duration pfuncTimeout = null;

        public Builder setEpsilon(double val) {
            this.epsilon = val;
            return this;
        }

        public Builder setStabilityThreshold(Double val) {
            if (val != null && val.isInfinite()) {
                throw new IllegalArgumentException("only finite values allowed. To turn off the filter, pass null");
            }
            this.stabilityThreshold = val;
            return this;
        }

        public Builder setMaxSimultaneousMutations(int val) {
            this.maxSimultaneousMutations = val;
            return this;
        }

        public Builder addScoreWriter(KStarScoreWriter val) {
            this.scoreWriters.add(val);
            return this;
        }

        public Builder addScoreConsoleWriter(KStarScoreWriter.Formatter val) {
            return this.addScoreWriter(new KStarScoreWriter.ToConsole(val));
        }

        public Builder addScoreConsoleWriter() {
            return this.addScoreConsoleWriter(new KStarScoreWriter.Formatter.SequenceKStarPfuncs());
        }

        public Builder addScoreFileWriter(File file, KStarScoreWriter.Formatter val) {
            return this.addScoreWriter(new KStarScoreWriter.ToFile(file, val));
        }

        public Builder addScoreFileWriter(File file) {
            return this.addScoreFileWriter(file, new KStarScoreWriter.Formatter.Log());
        }

        public Builder setShowPfuncProgress(boolean val) {
            this.showPfuncProgress = val;
            return this;
        }

        public Builder setExternalMemory(boolean val) {
            this.useExternalMemory = val;
            return this;
        }

        public Builder setConfDBPattern(String val) {
            this.confDBPattern = val;
            return this;
        }

        public Builder setMaxNumConf(int val) {
            this.maxNumberConfs = val;
            return this;
        }

        public Builder resume(boolean val) {
            this.resume = val;
            return this;
        }

        public Builder setPfuncTimeout(Duration val) {
            this.pfuncTimeout = val;
            return this;
        }

        public KStarSettings build() {
            return new KStarSettings(this.epsilon, this.stabilityThreshold, this.maxSimultaneousMutations, this.scoreWriters, this.showPfuncProgress, this.useExternalMemory, this.confDBPattern, this.resume, this.maxNumberConfs, this.pfuncTimeout);
        }
    }
}

