/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.impl;

import edu.duke.cs.osprey.kstar.KAStarNode;
import edu.duke.cs.osprey.kstar.KAStarTree;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSAllowedSeqs;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class KSImplKAStar
extends KSAbstract {
    public static boolean useTightBounds = true;
    public static String nodeExpansionMethod = "parallel1";

    public KSImplKAStar(KSConfigFileParser cfp) {
        super(cfp);
        if (this.useVoxelG) {
            throw new RuntimeException("ERROR: Rigid-rotamer upper bound used by KSImplKAStar not compatible with continuous entropy (useVoxelG");
        }
    }

    @Override
    public void init(HashMap<Integer, KSAllowedSeqs> strand2AllowedSeqs) {
        this.strand2AllowedSeqs = strand2AllowedSeqs;
        this.checkAPPP();
        this.printSequences();
        this.createOutputDir();
        this.createEmatDir();
        ArrayList<Boolean> contSCFlexVals = new ArrayList<Boolean>(Arrays.asList(true, false));
        this.createEmats(contSCFlexVals);
    }

    @Override
    public String getKSMethod() {
        return "kastar";
    }

    @Override
    protected BigInteger countProcessedConfs() {
        BigInteger ans = BigInteger.ZERO;
        for (PFAbstract pf : this.name2PF.values()) {
            if (!pf.isFullyDefined() || !pf.getImpl().equalsIgnoreCase(PFAbstract.getCFGImpl())) continue;
            ans = ans.add(pf.getNumProcessed());
        }
        return ans;
    }

    @Override
    public void run() {
        this.setStartTime(System.currentTimeMillis());
        int numOutput = 0;
        numOutput = useTightBounds ? this.runTB() : this.runLB();
        System.out.println("\nseqsCompleted: " + KAStarNode.getNumLeavesCompleted() + " seqsCreated: " + KAStarNode.getNumLeavesCreated() + " seqsPossible: " + ((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getNumSeqs() + " seqsInOutput: " + numOutput);
        System.out.println("K* leaf conformations processed: " + String.valueOf(this.countProcessedConfs()));
        System.out.println("K* running time: " + (System.currentTimeMillis() - this.getStartTime()) / 1000L + " seconds\n");
        this.abortPFs();
    }

    private int runTB() {
        int completed = 0;
        this.wtKSCalc = this.computeWTCalc();
        if (((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getNumSeqs() <= 1) {
            return completed;
        }
        KAStarTree tree = new KAStarTree(this, this.strand2AllowedSeqs, this.wtKSCalc);
        tree.add(new KAStarNode(null, null, true));
        int target = this.cfp.params.getInt("KStarNumSeqs", 5);
        KAStarNode best = tree.poll();
        while (best != null && completed < target) {
            if (best.isFullyProcessed()) {
                best.checkConsistency(best);
                best.lb.printSummary(this.getOputputFilePath(), this.getStartTime(), this.getNumSeqsCreated(0), this.getNumSeqsCompleted(0));
                ++completed;
            } else {
                ArrayList<KAStarNode> children = best.expand();
                tree.add(children);
            }
            best = tree.poll();
        }
        return completed + 1;
    }

    private int runLB() {
        int completed = 0;
        this.wtKSCalc = this.computeWTCalc();
        if (((KSAllowedSeqs)this.strand2AllowedSeqs.get(2)).getNumSeqs() <= 1) {
            return completed;
        }
        KAStarTree tree = new KAStarTree(this, this.strand2AllowedSeqs, this.wtKSCalc);
        tree.add(new KAStarNode(null, null, true));
        double gUB = Double.NEGATIVE_INFINITY;
        KAStarNode best = tree.poll();
        while (best != null) {
            if (best.isFullyProcessed()) {
                double uB = best.getUBScore();
                if (completed++ == 0) {
                    gUB = uB;
                }
                if (best.getLBScore() > gUB && gUB > Double.NEGATIVE_INFINITY) break;
                best.lb.printSummary(this.getOputputFilePath(), this.getStartTime(), this.getNumSeqsCreated(0), this.getNumSeqsCompleted(0));
                if (uB > gUB) {
                    gUB = uB;
                }
            } else {
                ArrayList<KAStarNode> children = best.expand();
                tree.add(children);
            }
            best = tree.poll();
        }
        return completed + 1;
    }
}

