/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import ch.obermuhlner.math.big.BigDecimalMath;
import edu.duke.cs.osprey.tools.BigExp;
import edu.duke.cs.osprey.tools.ExpFunction;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.MathContext;

public class BoltzmannCalculator {
    public static final double RClassic = 0.0019891;
    public static final double RPrecise = 0.00198720425864083;
    public static final double TAlmostFrozen = 275.0;
    public static final double TRoom = 298.15;
    public static final double TBody = 310.0;
    public static final double TClassic = 298.15;
    public final MathContext mathContext;
    public final ExpFunction e;
    public final double R;
    public final double T;
    private final double RT;

    public BoltzmannCalculator(MathContext mathContext) {
        this(mathContext, 0.0019891, 298.15);
    }

    public BoltzmannCalculator(MathContext mathContext, double R, double T) {
        this.mathContext = mathContext;
        this.e = new ExpFunction(mathContext);
        this.R = R;
        this.T = T;
        this.RT = R * T;
    }

    public BoltzmannCalculator(MathContext mathContext, Conditions conditions) {
        this(mathContext, conditions.R, conditions.T);
    }

    public BigDecimal calc(double energy) {
        return this.e.exp(-energy / this.RT);
    }

    public double freeEnergy(BigDecimal z) {
        return -this.RT * this.e.log(z).doubleValue();
    }

    public BigDecimal calcPrecise(double e) {
        return this.exp(-e / this.RT);
    }

    public BigDecimal exp(double e) {
        long num;
        if (Double.isNaN(e)) {
            return MathTools.BigNaN;
        }
        if (e == Double.NEGATIVE_INFINITY) {
            return BigDecimal.ZERO;
        }
        if (e == Double.POSITIVE_INFINITY) {
            return MathTools.BigPositiveInfinity;
        }
        BigDecimal d = new BigDecimal(e);
        BigDecimal i = BigDecimalMath.integralPart((BigDecimal)d);
        if (i.signum() != 0 && (long)((int)(num = i.longValueExact())) != num) {
            if (e > 0.0) {
                return MathTools.BigPositiveInfinity;
            }
            return BigDecimal.ZERO;
        }
        return BigDecimalMath.exp((BigDecimal)d, (MathContext)this.mathContext);
    }

    public double freeEnergyPrecise(BigDecimal z) {
        return -this.RT * this.ln(z);
    }

    public double freeEnergyPrecise(BigExp z) {
        return -this.RT * z.ln();
    }

    public MathTools.DoubleBounds freeEnergyPrecise(MathTools.BigDecimalBounds z) {
        return new MathTools.DoubleBounds(this.freeEnergyPrecise(z.upper), this.freeEnergyPrecise(z.lower));
    }

    public MathTools.DoubleBounds freeEnergyPrecise(BigExp.Bounds z) {
        return new MathTools.DoubleBounds(this.freeEnergyPrecise(z.upper), this.freeEnergyPrecise(z.lower));
    }

    public double ln(BigDecimal z) {
        if (MathTools.isNaN(z) || MathTools.isNegative(z)) {
            return Double.NaN;
        }
        if (MathTools.isZero(z)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (z == MathTools.BigPositiveInfinity) {
            return Double.POSITIVE_INFINITY;
        }
        if (z.scale() > 10000) {
            Log.log("WARN: assuming ln of tiny value (%.2e) is just -inf", z);
            return Double.NEGATIVE_INFINITY;
        }
        if (z.scale() < -10000) {
            Log.log("WARN: assuming ln of huge value (%.2e) is just +inf", z);
            return Double.POSITIVE_INFINITY;
        }
        return BigDecimalMath.log((BigDecimal)z, (MathContext)this.mathContext).doubleValue();
    }

    public double ln(BigExp z) {
        return this.ln(z.toBigDecimal(this.mathContext));
    }

    public double ln1p(BigDecimal z) {
        double d = MathTools.isInf(z) || MathTools.isNaN(z) || MathTools.isZero(z) ? z.doubleValue() : (MathTools.isPositive(z) ? this.ln(z.add(BigDecimal.ONE, this.mathContext)) : -this.ln(MathTools.bigNegate(z).add(BigDecimal.ONE, this.mathContext)));
        return d;
    }

    public double ln1p(BigExp z) {
        return this.ln1p(z.toBigDecimal(this.mathContext));
    }

    public static class Conditions {
        public final double R;
        public final double T;
        public static final Conditions Classic = new Conditions(0.0019891, 298.15);
        public static final Conditions AlmostFrozen = new Conditions(275.0);
        public static final Conditions Room = new Conditions(298.15);
        public static final Conditions Body = new Conditions(310.0);

        public Conditions(double R, double T) {
            this.R = R;
            this.T = T;
        }

        public Conditions(double T) {
            this(0.00198720425864083, T);
        }
    }
}

