/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.LowerBoundCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.kstar.pfunc.UpperBoundCalculator;
import edu.duke.cs.osprey.parallelism.ThreadPoolTaskExecutor;
import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Stopwatch;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SimplePartitionFunction
implements PartitionFunction {
    public final ConfEnergyCalculator ecalc;
    public int scoreConfsBatchSize = 1000;
    private double targetEpsilon = Double.NaN;
    private BigDecimal stabilityThreshold = BigDecimal.ZERO;
    private PartitionFunction.Status status = null;
    private PartitionFunction.Values values = null;
    private LowerBoundCalculator lowerBound;
    private UpperBoundCalculator upperBound;
    private PartitionFunction.ConfListener confListener = null;
    private boolean isReportingProgress = false;
    private Stopwatch stopwatch = new Stopwatch().start();

    public SimplePartitionFunction(ConfEnergyCalculator ecalc, ConfSearch confSearch, BigInteger numConfsBeforePruning) {
        this.ecalc = ecalc;
        ConfSearch.MultiSplitter confsSplitter = new ConfSearch.MultiSplitter(confSearch);
        this.lowerBound = new LowerBoundCalculator(confsSplitter.makeStream(), ecalc);
        this.upperBound = new UpperBoundCalculator(confsSplitter.makeStream(), numConfsBeforePruning);
    }

    @Override
    public void setReportProgress(boolean val) {
        this.isReportingProgress = val;
    }

    @Override
    public void setConfListener(PartitionFunction.ConfListener val) {
        this.confListener = val;
    }

    @Override
    public PartitionFunction.Status getStatus() {
        return this.status;
    }

    @Override
    public PartitionFunction.Values getValues() {
        return this.values;
    }

    @Override
    public int getNumConfsEvaluated() {
        return this.lowerBound.numConfsEnergied;
    }

    @Override
    public int getParallelism() {
        return this.ecalc.tasks.getParallelism();
    }

    @Override
    public void init(double targetEpsilon) {
        this.targetEpsilon = targetEpsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = PartitionFunction.Values.makeFullRange();
        this.values.pstar = BigDecimal.ZERO;
    }

    @Override
    public void setStabilityThreshold(BigDecimal val) {
        this.stabilityThreshold = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compute(int maxNumConfs) {
        block19: {
            if (this.status == null) {
                throw new IllegalStateException("pfunc was not initialized. Call init() before compute()");
            }
            double upperBoundEpsilon = 1.0E-5;
            this.upperBound.scoreNextConf();
            this.values.qprime = this.upperBound.totalBound.subtract(this.lowerBound.weightedScoreSum);
            int initialNumConfsScored = this.lowerBound.numConfsScored;
            block7: while (true) {
                int oldNum;
                SimplePartitionFunction simplePartitionFunction = this;
                synchronized (simplePartitionFunction) {
                    if (this.lowerBound.numConfsEnergied > 0 && this.stabilityThreshold != null && MathTools.isLessThan(this.values.calcUpperBound(), this.stabilityThreshold)) {
                        this.status = PartitionFunction.Status.Unstable;
                        break block19;
                    }
                    if (this.values.getEffectiveEpsilon() <= this.targetEpsilon) {
                        this.status = PartitionFunction.Status.Estimated;
                        break block19;
                    }
                    if (!this.status.canContinue() || this.lowerBound.numConfsScored - initialNumConfsScored >= maxNumConfs) {
                        break block19;
                    }
                }
                if (this.ecalc.tasks instanceof ThreadPoolTaskExecutor) {
                    while (this.upperBound.delta > 1.0E-5 && this.ecalc.tasks.isBusy()) {
                        this.upperBound.run(this.scoreConfsBatchSize, 1.0E-5);
                    }
                } else {
                    this.upperBound.run(this.scoreConfsBatchSize, 1.0E-5);
                }
                LowerBoundCalculator.Status lbStatus = this.lowerBound.energyNextConfAsync(econf -> {
                    SimplePartitionFunction simplePartitionFunction = this;
                    synchronized (simplePartitionFunction) {
                        this.values.qstar = this.lowerBound.weightedEnergySum;
                        this.values.qprime = this.upperBound.totalBound.subtract(this.lowerBound.weightedScoreSum);
                    }
                    if (this.isReportingProgress) {
                        System.out.println(String.format("conf:%4d, score:%12.6f, energy:%12.6f, q*:%12e, q':%12e, epsilon:%.6f, time:%10s, heapMem:%s", this.lowerBound.numConfsEnergied, econf.getScore(), econf.getEnergy(), this.values.qstar, this.values.qprime, this.values.getEffectiveEpsilon(), this.stopwatch.getTime(2), JvmMem.getOldPool()));
                    }
                    if (this.confListener != null) {
                        this.confListener.onConf((ConfSearch.ScoredConf)econf);
                    }
                });
                switch (lbStatus) {
                    case OutOfConfs: {
                        this.status = PartitionFunction.Status.OutOfConformations;
                        this.lowerBound.waitForFinish();
                        break;
                    }
                    case OutOfLowEnergies: {
                        this.status = PartitionFunction.Status.OutOfLowEnergies;
                        this.lowerBound.waitForFinish();
                    }
                }
                do {
                    if (this.lowerBound.numConfsScored <= this.upperBound.numScoredConfs) continue block7;
                    oldNum = this.upperBound.numScoredConfs;
                    this.upperBound.scoreNextConf();
                } while (this.upperBound.numScoredConfs > oldNum);
                break;
            }
            throw new Error(String.format("The lower bound calculator apparently scored more conformations (%d) than is possible for the upper bound calculator (%s). This is definitely a bug", this.lowerBound.numConfsScored, this.upperBound.tree.getNumConformations().toString()));
        }
        if (this.ecalc.tasks instanceof ThreadPoolTaskExecutor) {
            while (this.upperBound.delta > 1.0E-5 && this.ecalc.tasks.isWorking()) {
                this.upperBound.run(this.scoreConfsBatchSize, 1.0E-5);
            }
        }
        this.ecalc.tasks.waitForFinish();
        if (this.status != PartitionFunction.Status.Unstable && this.stabilityThreshold != null && MathTools.isLessThan(this.values.calcUpperBound(), this.stabilityThreshold)) {
            this.status = PartitionFunction.Status.Unstable;
        }
    }
}

