/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.BigInteger;

public class UpperBoundCalculator {
    public final ConfSearch tree;
    public BigInteger numUnscoredConfs;
    public int numScoredConfs = 0;
    public BigDecimal weightedScoreSum = BigDecimal.ZERO;
    public BigDecimal unscoredBound = BigDecimal.ZERO;
    public BigDecimal totalBound = BigDecimal.ZERO;
    public double delta = 1.0;
    private BoltzmannCalculator boltzmann = new BoltzmannCalculator(PartitionFunction.decimalPrecision);

    public UpperBoundCalculator(ConfSearch tree, BigInteger numConfsBeforePruning) {
        this.tree = tree;
        this.numUnscoredConfs = numConfsBeforePruning;
    }

    public UpperBoundCalculator run(int numConfs) {
        boolean canContinue = true;
        while (canContinue && numConfs > 0) {
            canContinue = this.scoreNextConf();
            --numConfs;
        }
        return this;
    }

    public UpperBoundCalculator run(int numConfs, double epsilon) {
        boolean canContinue;
        boolean bl = canContinue = this.delta > epsilon;
        while (canContinue && numConfs > 0) {
            canContinue = this.scoreNextConf() && this.delta > epsilon;
            --numConfs;
        }
        return this;
    }

    public boolean scoreNextConf() {
        ConfSearch.ScoredConf conf = this.tree.nextConf();
        if (conf == null) {
            return false;
        }
        ++this.numScoredConfs;
        BigDecimal weightedScore = this.boltzmann.calc(conf.getScore());
        this.weightedScoreSum = this.weightedScoreSum.add(weightedScore);
        this.numUnscoredConfs = this.numUnscoredConfs.subtract(BigInteger.ONE);
        this.unscoredBound = weightedScore.multiply(new BigDecimal(this.numUnscoredConfs));
        this.totalBound = this.weightedScoreSum.add(this.unscoredBound);
        this.delta = MathTools.bigDivide(this.unscoredBound, this.totalBound, PartitionFunction.decimalPrecision).doubleValue();
        return MathTools.isGreaterThan(weightedScore, BigDecimal.ZERO);
    }

    public String toString() {
        return String.format("UpperBoundCalculator  scored: %8d  sum: %e   unscored: %e  %e   bound: %e   delta: %f", this.numScoredConfs, this.weightedScoreSum.doubleValue(), this.numUnscoredConfs.doubleValue(), this.unscoredBound.doubleValue(), this.totalBound.doubleValue(), this.delta);
    }
}

