/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pfunc.impl;

import cern.colt.Arrays;
import edu.duke.cs.osprey.energy.MultiTermEnergyFunction;
import edu.duke.cs.osprey.kstar.KSAbstract;
import edu.duke.cs.osprey.kstar.KSConf;
import edu.duke.cs.osprey.kstar.KSConfQ;
import edu.duke.cs.osprey.kstar.KSConfigFileParser;
import edu.duke.cs.osprey.kstar.KSPStarCalculator;
import edu.duke.cs.osprey.kstar.KSQPrimeCalculator;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.RCEnergyContribs;
import edu.duke.cs.osprey.kstar.pfunc.PFAbstract;
import edu.duke.cs.osprey.kstar.pfunc.impl.PFTraditional;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;

public class PFParallel1
extends PFTraditional
implements Serializable {
    protected KSConfQ confsQ = null;
    protected KSQPrimeCalculator qPrimeCalculator = null;
    protected KSPStarCalculator pStarCalculator = null;
    protected long initSleepTime = 3000L;

    public PFParallel1() {
    }

    public PFParallel1(int strand, ArrayList<String> sequence, ArrayList<Integer> absolutePos, String checkPointPath, String reducedSPName, KSConfigFileParser cfp, KSSearchProblem panSP) {
        super(strand, sequence, absolutePos, checkPointPath, reducedSPName, cfp, panSP);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        this.confsQ = null;
        this.qPrimeCalculator = null;
        this.pStarCalculator = null;
    }

    @Override
    public void start() {
        try {
            this.setRunState(PFAbstract.RunState.STARTED);
            if (this.canUseHotByManualSelection()) {
                this.createHotsFromCFG();
            }
            this.pStarCalculator = null;
            if (this.prunedConfs.compareTo(BigInteger.ZERO) == 0) {
                this.pStar = BigDecimal.ZERO;
            } else {
                System.out.println("using p* calculator");
                this.pStarCalculator = new KSPStarCalculator(this);
                this.pStarCalculator.setPriority(10);
            }
            this.confsQ = new KSConfQ(this, 1, this.partialQLB);
            this.qPrimeCalculator = new KSQPrimeCalculator(this);
            this.qPrimeCalculator.setPriority(10);
            if (this.pStarCalculator != null) {
                this.pStarCalculator.start();
            }
            this.qPrimeCalculator.start();
            this.confsQ.start();
            if (!this.isContinuous() && this.isFullyDefined()) {
                Thread.sleep(this.initSleepTime);
            }
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function", ex);
        }
        this.startTime = System.currentTimeMillis();
    }

    protected int canSatisfy(int request) throws InterruptedException {
        int granted = 0;
        while (!this.confsQ.canSatisfy(request)) {
            if (!this.confsQ.isExhausted()) {
                if (this.confsQ.getState() == Thread.State.WAITING || this.confsQ.getState() == Thread.State.BLOCKED) {
                    if (this.confsQ.getQCapacity() < request) {
                        this.confsQ.setQCapacity(request);
                    }
                    this.confsQ.lock.notify();
                }
                this.confsQ.lock.wait();
                continue;
            }
            granted = this.confsQ.size();
            if (granted > 0) {
                return granted;
            }
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
            this.confsQ.cleanUp(true);
            this.qPrimeCalculator.cleanUp(true);
            if (this.pStarCalculator != null) {
                this.pStarCalculator.cleanUp(true);
            }
            return granted;
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void iterate() {
        try {
            KSConf conf = null;
            String string = this.confsQ.lock;
            synchronized (string) {
                if (this.canSatisfy(1) == 0) {
                    return;
                }
                conf = this.confsQ.deQueue();
                this.processingConfs = this.processingConfs.add(BigInteger.ONE);
                if (this.confsQ.getState() == Thread.State.WAITING) {
                    this.confsQ.lock.notify();
                }
            }
            this.accumulate(conf);
            if (this.eAppx != PFAbstract.EApproxReached.FALSE) {
                this.confsQ.cleanUp(true);
                this.qPrimeCalculator.cleanUp(true);
                if (this.pStarCalculator != null) {
                    this.pStarCalculator.cleanUp(true);
                }
            }
            this.exitIfTimeOut();
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void computeSlice() {
        try {
            if (KSAbstract.doCheckPoint) {
                if (this.confsQ != null && !this.confsQ.isExhausted() && this.confsQ.getState() == Thread.State.NEW) {
                    this.confsQ.start();
                    String string = this.confsQ.lock;
                    synchronized (string) {
                        this.confsQ.lock.notify();
                    }
                }
                if (this.qPrimeCalculator != null && !this.qPrimeCalculator.isExhausted() && this.qPrimeCalculator.getState() == Thread.State.NEW) {
                    this.qPrimeCalculator.start();
                }
                if (this.pStarCalculator != null && !this.pStarCalculator.isExhausted() && this.pStarCalculator.getState() == Thread.State.NEW) {
                    this.pStarCalculator.start();
                }
            }
            this.iterate();
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function slice", ex);
        }
    }

    @Override
    protected void compute() {
        try {
            while (this.eAppx == PFAbstract.EApproxReached.FALSE) {
                this.iterate();
            }
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function", ex);
        }
    }

    @Override
    protected void combineResidues(KSConf conf, double pbe, double tpbe, int[] tpce) {
        this.abort(true);
        System.out.print("% bound error: " + pbe + ". ");
        System.out.print("% bound error from top " + PFParallel1.getHotNumRes() + " RCs: " + tpbe + ". positions: " + Arrays.toString((int[])tpce));
        System.out.print(". Combining residues: ");
        for (int i : tpce) {
            System.out.print(this.getSequence().get(i) + " ");
        }
        System.out.print("... ");
        long start = System.currentTimeMillis();
        this.reducedSP.mergeResiduePositions(tpce);
        this.memoizePosInHot(tpce);
        long duration = (System.currentTimeMillis() - start) / 1000L;
        System.out.println("done in " + duration + "s");
        this.partialQLB = this.reComputePartialQLB(null);
        this.confsQ = new KSConfQ(this, 1, this.partialQLB);
        this.qPrimeCalculator = new KSQPrimeCalculator(this);
        this.qPrimeCalculator.setPriority(10);
        this.qPrimeCalculator.start();
        this.confsQ.start();
        conf.setEnergyBound(this.getConfBound(null, conf.getConfArray()));
    }

    @Override
    protected void tryHotForConf(KSConf conf, MultiTermEnergyFunction mef) {
        double pbe = 0.0;
        double tpbe = 0.0;
        int[] tpce = null;
        RCEnergyContribs rce = new RCEnergyContribs(this, mef, conf.getConfArray());
        pbe = rce.getPercentBoundError();
        if (pbe >= PFParallel1.getHotBoundPct() && (tpbe = rce.getPercentErrorForTopPos(PFParallel1.getHotNumRes())) >= PFParallel1.getHotTopRotsPct()) {
            tpce = rce.getTopPosCausingError(PFParallel1.getHotNumRes());
            this.combineResidues(conf, pbe, tpbe, tpce);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void accumulate(KSConf conf) {
        double d;
        double energy = 0.0;
        double boundError = 0.0;
        MultiTermEnergyFunction mef = null;
        if (this.isContinuous() && this.isFullyDefined()) {
            mef = this.reducedSP.decompMinimizedEnergy(conf.getConfArray());
            energy = mef.getPreCompE();
        } else {
            energy = conf.getEnergyBound();
        }
        conf.setEnergy(energy);
        boundError = conf.getEnergyBound() - conf.getEnergy();
        this.processingConfs = this.processingConfs.subtract(BigInteger.ONE);
        this.updateQStar(conf);
        this.updateQPrime();
        this.updatePStar();
        this.effectiveEpsilon = this.computeEffectiveEpsilon();
        if (d < 0.0) {
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
            return;
        }
        long currentTime = System.currentTimeMillis();
        String string = this.confsQ.lock;
        synchronized (string) {
            if (!PFAbstract.suppressOutput) {
                if (!this.printedHeader) {
                    this.printHeader();
                }
                System.out.println(this.numberFormat.format(boundError) + "\t" + this.numberFormat.format(energy) + "\t" + this.numberFormat.format(this.effectiveEpsilon) + "\t" + String.valueOf(this.getNumProcessed()) + "\t" + String.valueOf(this.getNumUnEnumerated()) + "\t" + this.confsQ.size() + "\t" + (currentTime - this.startTime) / 1000L);
            }
        }
        this.eAppx = this.effectiveEpsilon <= targetEpsilon || this.maxKSConfsReached() ? PFAbstract.EApproxReached.TRUE : PFAbstract.EApproxReached.FALSE;
        double peb = (conf.getEnergyBound() - conf.getEnergy()) / conf.getEnergy();
        if (this.canUseHotByConfError(peb)) {
            this.tryHotForConf(conf, mef);
        }
        if (!this.isFullyDefined() && this.eAppx == PFAbstract.EApproxReached.TRUE) {
            this.adjustQStar();
        }
    }

    @Override
    protected void printHeader() {
        System.out.println("error\tenergy\tepsilon\t#processed\t#un-enum\t#buf\ttime(sec)");
        this.printedHeader = true;
    }

    @Override
    protected BigInteger getNumUnEnumerated() {
        BigInteger numProcessing = this.getNumProcessed().add(BigInteger.valueOf(this.confsQ.size())).add(this.processingConfs);
        BigInteger ans = this.unPrunedConfs.subtract(numProcessing);
        if (ans.compareTo(BigInteger.ZERO) < 0) {
            throw new RuntimeException("ERROR: the number of un-enumerated conformations must be >= 0");
        }
        return ans;
    }

    @Override
    protected void updateQPrime() {
        try {
            if (this.qPrimeCalculator == null) {
                return;
            }
            while (this.partialQLB.compareTo(this.qPrimeCalculator.getTotalPF()) > 0) {
                Thread.sleep(1000L);
            }
            this.qPrime = this.qPrimeCalculator.getQPrime(this.partialQLB);
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function q'", ex);
        }
    }

    protected void updatePStar() {
        try {
            if (this.pStarCalculator == null) {
                return;
            }
            this.pStar = this.pStarCalculator.getPStar();
        }
        catch (Exception ex) {
            throw new Error("can't compute partition function p*", ex);
        }
    }

    @Override
    public void abort(boolean nullify) {
        try {
            if (this.getRunState() == PFAbstract.RunState.NOTSTARTED) {
                return;
            }
            if (this.eAppx != PFAbstract.EApproxReached.FALSE) {
                return;
            }
            this.eAppx = PFAbstract.EApproxReached.NOT_POSSIBLE;
            if (this.confsQ != null) {
                this.confsQ.cleanUp(nullify);
            }
            if (this.qPrimeCalculator != null) {
                this.qPrimeCalculator.cleanUp(nullify);
            }
            if (this.pStarCalculator != null) {
                this.pStarCalculator.cleanUp(nullify);
            }
            this.eAppx = PFAbstract.EApproxReached.FALSE;
        }
        catch (Exception ex) {
            throw new Error("can't abort partition function computation", ex);
        }
    }

    @Override
    public String getImpl() {
        return "Parallel1";
    }
}

