/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.kstar.pruning;

import edu.duke.cs.osprey.astar.comets.UpdatedPruningMatrix;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.kstar.KSSearchProblem;
import edu.duke.cs.osprey.kstar.pruning.ReducedPruningMatrix;

public class InvertedPruningMatrix
extends ReducedPruningMatrix {
    public InvertedPruningMatrix(KSSearchProblem sp, UpdatedPruningMatrix upm) {
        super(sp, upm);
    }

    @Override
    public Boolean getOneBody(int res, int index) {
        Integer pos = this.sp.posNums.get(res);
        String rcAAType = this.sp.confSpace.posFlex.get((int)pos.intValue()).RCs.get((int)index).AAType;
        if (this.sp.reducedAllowedAAs.get(res).contains(rcAAType)) {
            int numPrunedForAAType = 0;
            for (int index2 : this.upm.prunedRCsAtPos(pos)) {
                String rcAAType2 = this.sp.confSpace.posFlex.get((int)pos.intValue()).RCs.get((int)index2).AAType;
                if (!rcAAType2.equalsIgnoreCase(rcAAType)) continue;
                ++numPrunedForAAType;
                break;
            }
            if (numPrunedForAAType == 0) {
                return this.upm.getOneBody(pos, index);
            }
            return this.upm.getOneBody(pos, index) == false;
        }
        return true;
    }

    @Override
    public Boolean getPairwise(int res1, int index1, int res2, int index2) {
        Integer pos1 = this.sp.posNums.get(res1);
        Integer pos2 = this.sp.posNums.get(res2);
        String rcAAType1 = this.sp.confSpace.posFlex.get((int)pos1.intValue()).RCs.get((int)index1).AAType;
        String rcAAType2 = this.sp.confSpace.posFlex.get((int)pos2.intValue()).RCs.get((int)index2).AAType;
        if (this.sp.reducedAllowedAAs.get(res1).contains(rcAAType1) && this.sp.reducedAllowedAAs.get(res2).contains(rcAAType2)) {
            return this.upm.getPairwise(pos1, index1, pos2, index2) == false;
        }
        return true;
    }

    @Override
    public HigherTupleFinder<Boolean> getHigherOrderTerms(int res1, int index1, int res2, int index2) {
        return null;
    }
}

