/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TuplesIndex;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;

public abstract class ConfSampler {
    public final SimpleConfSpace confSpace;
    public final PruningMatrix pmat;
    public final int randomSeed;
    protected final Random rand;

    public ConfSampler(SimpleConfSpace confSpace, PruningMatrix pmat, int randomSeed) {
        this.confSpace = confSpace;
        this.pmat = pmat;
        this.randomSeed = randomSeed;
        this.rand = new Random(randomSeed);
    }

    public abstract void sampleConfsForTuples(Samples var1, int var2);

    public static class NoMoreSamplesException
    extends RuntimeException {
        private static final long serialVersionUID = 3248938824507606370L;

        NoMoreSamplesException() {
            super("Can't fit LUTE model. No more conformations to sample. Try less pruning?");
        }
    }

    public static class Samples {
        public final TuplesIndex tuples;
        private final Set<int[]> confs = new Conf.Set();
        private final List<Set<int[]>> confsByTuple = new ArrayList<Set<int[]>>();
        private final List<Integer> numConfsByTuple = new ArrayList<Integer>();

        public Samples(TuplesIndex tuples) {
            this.tuples = tuples;
        }

        public RCTuple getLeastSampledTuple(Set<RCTuple> except) {
            int bestt = -1;
            int bestSize = -1;
            for (int t = 0; t < this.tuples.size(); ++t) {
                int size = this.numConfsByTuple.get(t);
                if (bestt != -1 && size >= bestSize || except.contains(this.tuples.get(t))) continue;
                bestt = t;
                bestSize = size;
            }
            if (bestt == -1) {
                return null;
            }
            return this.tuples.get(bestt);
        }

        public int size() {
            return this.confs.size();
        }

        public int countTuplesWithLessThan(int numConfs) {
            int count = 0;
            for (int tupleConfs : this.numConfsByTuple) {
                if (tupleConfs >= numConfs) continue;
                ++count;
            }
            return count;
        }

        public int countTuplesWithAtLeast(int numConfs) {
            int count = 0;
            for (int tupleConfs : this.numConfsByTuple) {
                if (tupleConfs < numConfs) continue;
                ++count;
            }
            return count;
        }

        public Set<int[]> getAllConfs() {
            return Collections.unmodifiableSet(this.confs);
        }

        public Set<int[]> getConfs(RCTuple tuple) {
            return Collections.unmodifiableSet(this.confsByTuple.get(this.tuples.getIndex(tuple)));
        }

        public void addConf(int[] conf) {
            boolean throwIfMissingSingle = conf.length == 1;
            boolean throwIfMissingPair = conf.length > 1;
            this.tuples.forEachIn(conf, throwIfMissingSingle, throwIfMissingPair, index -> {
                Set<int[]> confsForTuple = this.confsByTuple.get((int)index);
                confsForTuple.add(conf);
                this.numConfsByTuple.set((int)index, confsForTuple.size());
            });
            this.confs.add(conf);
        }

        public void addTuple(RCTuple tuple) {
            Integer tupleIndex = this.tuples.getIndex(tuple);
            if (tupleIndex == null) {
                throw new IllegalArgumentException("tuple must be indexed");
            }
            if (tupleIndex != this.tuples.size() - 1) {
                throw new IllegalArgumentException("must be most recently added tuple to the index");
            }
            if (tupleIndex < this.confsByTuple.size()) {
                throw new IllegalArgumentException("can't add the same tuple more than once: " + String.valueOf(tuple));
            }
            Function<int[], Boolean> matches = conf -> {
                for (int i = 0; i < tuple.size(); ++i) {
                    int rc;
                    int pos = tuple.pos.get(i);
                    if (conf[pos] == (rc = tuple.RCs.get(i).intValue())) continue;
                    return false;
                }
                return true;
            };
            Conf.Set tuplesConfs = new Conf.Set();
            this.confsByTuple.add(tuplesConfs);
            for (int[] conf2 : this.confs) {
                if (!matches.apply(conf2).booleanValue()) continue;
                tuplesConfs.add(conf2);
            }
            this.numConfsByTuple.add(tuplesConfs.size());
        }
    }
}

