/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.FragmentEnergies;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TuplesIndex;
import edu.duke.cs.osprey.energy.ConfEnergyCalculator;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.energy.ResidueInteractions;
import edu.duke.cs.osprey.lute.LUTEState;
import edu.duke.cs.osprey.minimization.MoleculeObjectiveFunction;
import edu.duke.cs.osprey.parallelism.TaskExecutor;

public class LUTEConfEnergyCalculator
extends ConfEnergyCalculator
implements FragmentEnergies {
    public final LUTEState state;
    public final TuplesIndex tuples;

    public LUTEConfEnergyCalculator(SimpleConfSpace confSpace, LUTEState state) {
        super(confSpace, new TaskExecutor());
        this.state = state;
        this.tuples = new TuplesIndex(confSpace, state.tuples);
    }

    @Override
    public ResidueInteractions makeSingleInters(int pos, int rc) {
        throw new NotSupportedByLUTEException();
    }

    @Override
    public ResidueInteractions makePairInters(int pos1, int rc1, int pos2, int rc2) {
        throw new NotSupportedByLUTEException();
    }

    @Override
    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf) {
        return new ConfSearch.EnergiedConf(conf, this.calcEnergy(conf.getAssignments()));
    }

    @Override
    public ConfSearch.EnergiedConf calcEnergy(ConfSearch.ScoredConf conf, ResidueInteractions inters) {
        throw new UnsupportedOperationException("Not implemented yet... don't think anyone uses this anyway");
    }

    @Override
    public EnergyCalculator.EnergiedParametricMolecule calcEnergy(RCTuple frag, ResidueInteractions inters) {
        throw new NotSupportedByLUTEException();
    }

    @Override
    public MoleculeObjectiveFunction makeIntraShellObjFcn(int pos, int rc) {
        throw new NotSupportedByLUTEException();
    }

    @Override
    public MoleculeObjectiveFunction makePairwiseObjFcn(int pos1, int rc1, int pos2, int rc2) {
        throw new NotSupportedByLUTEException();
    }

    public double calcEnergy(int[] conf) {
        this.numCalculations.incrementAndGet();
        boolean throwIfMissingSingle = false;
        boolean throwIfMissingPair = true;
        double[] energy = new double[]{0.0};
        this.tuples.forEachIn(conf, false, true, t -> {
            energy[0] = energy[0] + this.state.tupleEnergies[t];
        });
        return energy[0] + this.state.tupleEnergyOffset;
    }

    public boolean hasTuple(int pos, int rc) {
        return this.tuples.getIndex(pos, rc) != null;
    }

    public boolean hasTuple(int pos1, int rc1, int pos2, int rc2) {
        return this.tuples.getIndex(pos1, rc1, pos2, rc2) != null;
    }

    public boolean hasTuple(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.tuples.getIndex(pos1, rc1, pos2, rc2, pos3, rc3) != null;
    }

    @Override
    public double getEnergy(int pos, int rc) {
        return this.getEnergy(this.tuples.getIndex(pos, rc));
    }

    @Override
    public double getEnergy(int pos1, int rc1, int pos2, int rc2) {
        return this.getEnergy(this.tuples.getIndex(pos1, rc1, pos2, rc2));
    }

    public double getEnergy(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.getEnergy(this.tuples.getIndex(pos1, rc1, pos2, rc2, pos3, rc3));
    }

    private double getEnergy(Integer index) {
        if (index == null) {
            return 0.0;
        }
        return this.state.tupleEnergies[index];
    }

    private static class NotSupportedByLUTEException
    extends RuntimeException {
        public NotSupportedByLUTEException() {
            super("LUTE can only be used to compute full-conformation energies");
        }
    }
}

