/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.lute.LUTEConfEnergyCalculator;
import edu.duke.cs.osprey.lute.LUTEGScorer;
import edu.duke.cs.osprey.lute.LUTEHScorer;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.JvmMem;
import edu.duke.cs.osprey.tools.MathTools;
import edu.duke.cs.osprey.tools.Stopwatch;
import edu.duke.cs.osprey.tools.TimeTools;
import java.math.BigDecimal;
import java.math.BigInteger;

public class LUTEPfunc
implements PartitionFunction.WithConfDB {
    public final LUTEConfEnergyCalculator ecalc;
    private final BoltzmannCalculator bcalc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private boolean reportProgress = false;
    private PartitionFunction.ConfListener confListener = null;
    private ConfAStarTree astar = null;
    private BigInteger numConfsBeforePruning = null;
    private double epsilon;
    private BigDecimal stabilityThreshold = null;
    private PartitionFunction.Status status;
    private PartitionFunction.Values values;
    private int numConfsEvaluated;
    private Stopwatch stopwatch = new Stopwatch();
    private ConfDB confDB;
    private ConfDB.Key confDBKey;

    public LUTEPfunc(LUTEConfEnergyCalculator ecalc, ConfAStarTree astar, BigInteger numConfsBeforePruning) {
        this.ecalc = ecalc;
        this.astar = astar;
        this.numConfsBeforePruning = numConfsBeforePruning;
        if (!(astar.gscorer instanceof LUTEGScorer) || !(astar.hscorer instanceof LUTEHScorer)) {
            throw new IllegalArgumentException("needs LUTE-capable A* search");
        }
    }

    @Override
    public void setReportProgress(boolean val) {
        this.reportProgress = val;
    }

    @Override
    public void setConfListener(PartitionFunction.ConfListener val) {
        this.confListener = val;
    }

    @Override
    public void setConfDB(ConfDB confDB, ConfDB.Key key) {
        this.confDB = confDB;
        this.confDBKey = key;
    }

    @Override
    public void init(double epsilon) {
        this.epsilon = epsilon;
        this.status = PartitionFunction.Status.Estimating;
        this.values = PartitionFunction.Values.makeFullRange();
        this.numConfsEvaluated = 0;
        this.stopwatch.start();
    }

    @Override
    public void setStabilityThreshold(BigDecimal val) {
        this.stabilityThreshold = val;
    }

    @Override
    public PartitionFunction.Status getStatus() {
        return this.status;
    }

    @Override
    public PartitionFunction.Values getValues() {
        return this.values;
    }

    @Override
    public int getParallelism() {
        return this.ecalc.tasks.getParallelism();
    }

    @Override
    public int getNumConfsEvaluated() {
        return this.numConfsEvaluated;
    }

    @Override
    public void compute(int maxNumConfs) {
        if (this.astar == null) {
            throw new IllegalStateException("pfunc was not initialized. Call init() before compute()");
        }
        for (int i = 0; i < maxNumConfs; ++i) {
            ConfSearch.ScoredConf conf = this.astar.nextConf();
            if (conf == null) {
                this.status = PartitionFunction.Status.OutOfConformations;
                break;
            }
            if (this.confDB != null && this.confDBKey != null) {
                ConfDB.ConfTable table = this.confDB.get(this.confDBKey);
                table.setUpperBound(conf.getAssignments(), conf.getScore(), TimeTools.getTimestampNs());
            }
            if (conf.getScore() == Double.POSITIVE_INFINITY) {
                this.status = PartitionFunction.Status.OutOfLowEnergies;
                break;
            }
            ++this.numConfsEvaluated;
            BigInteger numConfsLeft = this.numConfsBeforePruning.subtract(BigInteger.valueOf(this.numConfsEvaluated));
            if (this.confListener != null) {
                this.confListener.onConf(conf);
            }
            if (this.reportProgress) {
                System.out.println(String.format("conf:%4d, score:%12.6f, bounds:[%12e,%12e], delta:%.6f, time:%10s, heapMem:%s", this.numConfsEvaluated, conf.getScore(), this.values.calcLowerBound().doubleValue(), this.values.calcUpperBound().doubleValue(), this.values.getEffectiveEpsilon(), this.stopwatch.getTime(2), JvmMem.getOldPool()));
            }
            BigDecimal weight = this.bcalc.calc(conf.getScore());
            this.values.qstar = this.values.qstar.add(weight);
            this.values.qprime = new BigMath(PartitionFunction.decimalPrecision).set(weight).mult(numConfsLeft).get();
            if (this.values.getEffectiveEpsilon() <= this.epsilon) {
                this.status = PartitionFunction.Status.Estimated;
                break;
            }
            if (this.stabilityThreshold == null || !MathTools.isLessThan(this.values.calcUpperBound(), this.stabilityThreshold)) continue;
            this.status = PartitionFunction.Status.Unstable;
            break;
        }
    }
}

