/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.lute;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.Conf;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.lute.ConfSampler;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import edu.duke.cs.osprey.tools.Log;
import edu.duke.cs.osprey.tools.MathTools;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class LowEnergyConfSampler
extends ConfSampler {
    public final Function<RCs, ConfSearch> astarFactory;

    public LowEnergyConfSampler(SimpleConfSpace confSpace, PruningMatrix pmat, int randomSeed, Function<RCs, ConfSearch> astarFactory) {
        super(confSpace, pmat, randomSeed);
        this.astarFactory = astarFactory;
    }

    @Override
    public void sampleConfsForTuples(ConfSampler.Samples samples, int minSamplesPerTuple) {
        RCTuple tuple;
        Set<int[]> alreadySampled;
        int numSamplesNeeded;
        HashSet<RCTuple> unsampleableTuples = new HashSet<RCTuple>();
        while ((numSamplesNeeded = minSamplesPerTuple - (alreadySampled = samples.getConfs(tuple = samples.getLeastSampledTuple(unsampleableTuples))).size()) > 0) {
            ConfSearch.ScoredConf conf;
            int[] sampleConf = Conf.make(this.confSpace, tuple);
            RCs rcs = new RCs(this.pmat);
            if (MathTools.isZero((rcs = new RCs(rcs, (pos, rc) -> {
                if (sampleConf[pos] == -1) {
                    return true;
                }
                return rc == sampleConf[pos];
            })).getNumConformations())) {
                throw new Error("tuple " + String.valueOf(tuple) + " has no compatible conformations");
            }
            int maxPoolSize = numSamplesNeeded * 10;
            ConfSearch astar = this.astarFactory.apply(rcs);
            ArrayList<int[]> confPool = new ArrayList<int[]>();
            for (int i = 0; i < maxPoolSize && (conf = astar.nextConf()) != null; ++i) {
                confPool.add(conf.getAssignments());
            }
            int numAttempts = numSamplesNeeded * 10;
            for (int i = 0; i < numAttempts; ++i) {
                int[] conf2 = (int[])confPool.get(this.rand.nextInt(confPool.size()));
                samples.addConf(conf2);
                if (alreadySampled.size() >= numSamplesNeeded) break;
            }
            if (alreadySampled.size() >= numSamplesNeeded) continue;
            Log.log("tuple %s ran out of samples, have %d, need %d, pool size %d", tuple, alreadySampled.size(), minSamplesPerTuple, confPool.size());
            unsampleableTuples.add(tuple);
        }
    }
}

