/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.markstar.framework;

import edu.duke.cs.osprey.astar.conf.ConfAStarNode;
import edu.duke.cs.osprey.astar.conf.ConfIndex;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.astar.conf.scoring.AStarScorer;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.kstar.pfunc.BoltzmannCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.tools.ExpFunction;
import edu.duke.cs.osprey.tools.MathTools;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class MARKStarNode
implements Comparable<MARKStarNode> {
    static boolean debug = false;
    private boolean updated = true;
    private BigDecimal errorBound = BigDecimal.ONE;
    private double nodeEpsilon = 1.0;
    private MARKStarNode parent;
    private List<MARKStarNode> children;
    private Node confSearchNode;
    public final int level;
    private static ExpFunction ef = new ExpFunction();
    private static BoltzmannCalculator bc = new BoltzmannCalculator(PartitionFunction.decimalPrecision);
    private RCs RCs;
    private boolean partOfLastBound = false;

    private MARKStarNode(Node confNode, MARKStarNode markStarNode) {
        this.confSearchNode = confNode;
        this.level = this.confSearchNode.getLevel();
        this.parent = markStarNode;
        this.computeEpsilonErrorBounds();
        this.errorBound = this.getErrorBound();
    }

    public BigInteger getNumConfs() {
        return this.confSearchNode.numConfs;
    }

    public void markUpdated() {
        this.updated = true;
        if (this.level > 0) {
            this.parent.markUpdated();
        }
    }

    public RCTuple toTuple() {
        return new RCTuple(this.confSearchNode.assignments);
    }

    private void printBoundBreakDown() {
        this.printBoundBreakDown("");
    }

    private void printBoundBreakDown(String prefix) {
        if (this.level == 0) {
            System.out.println("=====================BEGIN TREE INFO==================================");
            System.out.println((String)prefix + String.valueOf(this.confSearchNode) + ": [" + String.valueOf(MARKStarNode.setSigFigs(this.confSearchNode.subtreeLowerBound)) + "," + String.valueOf(MARKStarNode.setSigFigs(this.confSearchNode.subtreeUpperBound)) + "], errorBound =" + String.format("%3.3e", this.errorBound));
        }
        if (this.children != null && this.children.size() > 0) {
            BigDecimal upper = BigDecimal.ZERO;
            BigDecimal lower = BigDecimal.ZERO;
            Collections.sort(this.children);
            prefix = (String)prefix + "+~~";
            for (MARKStarNode child : this.children) {
                System.out.print((String)prefix + String.valueOf(child.confSearchNode) + ": [" + String.valueOf(MARKStarNode.setSigFigs(child.confSearchNode.subtreeLowerBound)) + "," + String.valueOf(MARKStarNode.setSigFigs(child.confSearchNode.subtreeUpperBound)) + "], epsilon=" + String.format("%3.3e", this.errorBound));
                System.out.print("Upper: " + String.valueOf(MARKStarNode.setSigFigs(upper)) + " + " + String.valueOf(MARKStarNode.setSigFigs(child.confSearchNode.subtreeUpperBound)) + " = " + String.valueOf(MARKStarNode.setSigFigs(upper.add(child.confSearchNode.subtreeUpperBound))));
                System.out.println("Lower: " + String.valueOf(MARKStarNode.setSigFigs(lower)) + " + " + String.valueOf(MARKStarNode.setSigFigs(child.confSearchNode.subtreeLowerBound)) + " = " + String.valueOf(MARKStarNode.setSigFigs(lower.add(child.confSearchNode.subtreeLowerBound))));
                upper = upper.add(child.confSearchNode.subtreeUpperBound);
                lower = lower.add(child.confSearchNode.subtreeLowerBound);
                child.printBoundBreakDown((String)prefix);
            }
        }
        if (this.level == 0) {
            System.out.println("=====================END TREE INFO==================================");
        }
    }

    public void updateSubtreeBounds() {
        if (!this.updated) {
            return;
        }
        this.updated = false;
        if (this.children != null && this.children.size() > 0) {
            BigDecimal errorUpperBound = BigDecimal.ZERO;
            BigDecimal errorLowerBound = BigDecimal.ZERO;
            for (MARKStarNode child : this.children) {
                child.updateSubtreeBounds();
                errorUpperBound = errorUpperBound.add(child.confSearchNode.subtreeUpperBound);
                errorLowerBound = errorLowerBound.add(child.confSearchNode.subtreeLowerBound);
            }
            this.confSearchNode.subtreeUpperBound = errorUpperBound;
            this.confSearchNode.subtreeLowerBound = errorLowerBound;
        }
    }

    public double recomputeEpsilon() {
        this.nodeEpsilon = this.confSearchNode.subtreeUpperBound.subtract(this.confSearchNode.subtreeLowerBound).divide(this.confSearchNode.subtreeUpperBound, RoundingMode.HALF_UP).doubleValue();
        return this.nodeEpsilon;
    }

    public int countNodesToProcess() {
        if (!this.updated) {
            return 0;
        }
        if (this.updated && (this.children == null || this.children.size() < 1)) {
            return 1;
        }
        int sum = 0;
        for (MARKStarNode child : this.children) {
            sum += child.countNodesToProcess();
        }
        return sum;
    }

    public double computeEpsilonErrorBounds() {
        if (this.children == null || this.children.size() < 1) {
            return this.nodeEpsilon;
        }
        if (!this.updated) {
            return this.nodeEpsilon;
        }
        double epsilonBound = 0.0;
        BigDecimal lastUpper = this.confSearchNode.subtreeUpperBound;
        BigDecimal lastLower = this.confSearchNode.subtreeLowerBound;
        this.updateSubtreeBounds();
        if (this.confSearchNode.subtreeUpperBound.subtract(this.confSearchNode.subtreeLowerBound).compareTo(BigDecimal.ONE) < 1) {
            return 0.0;
        }
        if (this.level == 0) {
            epsilonBound = this.confSearchNode.subtreeUpperBound.subtract(this.confSearchNode.subtreeLowerBound).divide(this.confSearchNode.subtreeUpperBound, RoundingMode.HALF_UP).doubleValue();
            this.debugChecks(lastUpper, lastLower, epsilonBound);
            this.nodeEpsilon = epsilonBound;
            if (debug) {
                this.printBoundBreakDown();
            }
        }
        return this.nodeEpsilon;
    }

    public void updateConfBounds(ConfIndex index, RCs rcs, AStarScorer gscorer, AStarScorer hScorer) {
        if (this.children == null || this.children.size() < 1) {
            this.confSearchNode.index(index);
            double gscore = gscorer.calc(index, rcs);
            double hscore = hScorer.calc(index, rcs);
            if (gscore + hscore > this.confSearchNode.getConfLowerBound()) {
                this.confSearchNode.setBoundsFromConfLowerAndUpper(gscore + hscore, this.confSearchNode.confUpperBound);
            }
        }
        if (this.children != null && this.children.size() > 0) {
            for (MARKStarNode child : this.children) {
                child.updateConfBounds(index, rcs, gscorer, hScorer);
            }
        }
    }

    public double updateAndReportConfBoundChange(ConfIndex index, RCs rcs, AStarScorer gscorer, AStarScorer hScorer) {
        if (this.children == null || this.children.size() < 1) {
            this.confSearchNode.index(index);
            double gscore = gscorer.calc(index, rcs);
            double hscore = hScorer.calc(index, rcs);
            if (gscore + hscore - this.confSearchNode.getConfLowerBound() > 1.0E-5) {
                double previousLower = this.confSearchNode.getConfLowerBound();
                this.confSearchNode.setBoundsFromConfLowerAndUpper(gscore + hscore, this.confSearchNode.confUpperBound);
                if (gscore + hscore < -10.0) {
                    System.out.println("Correcting " + this.toTuple().stringListing() + " down to " + (gscore + hscore) + " from " + previousLower + ", reducing it by " + (gscore + hscore - previousLower));
                }
                return gscore + hscore - previousLower;
            }
        }
        double sum = 0.0;
        if (this.children != null && this.children.size() > 0) {
            for (MARKStarNode child : this.children) {
                sum += child.updateAndReportConfBoundChange(index, rcs, gscorer, hScorer);
            }
        }
        if (sum > 0.0 && this.level == 0) {
            System.out.println("Children corrected " + sum);
        }
        return sum;
    }

    private void debugChecks(BigDecimal lastUpper, BigDecimal lastLower, double epsilonBound) {
        if (!debug) {
            return;
        }
        BigDecimal tolerance = new BigDecimal(1.0E-5);
        if (lastUpper != null && this.confSearchNode.subtreeUpperBound.subtract(lastUpper).compareTo(BigDecimal.ZERO) > 0 && this.confSearchNode.subtreeUpperBound.subtract(lastUpper).compareTo(tolerance) > 0) {
            System.err.println("Upper bound got bigger!?");
            System.err.println("Previous: " + String.valueOf(MARKStarNode.setSigFigs(lastUpper)) + ", now " + String.valueOf(MARKStarNode.setSigFigs(this.confSearchNode.subtreeUpperBound)));
            System.err.println("Increased by " + String.valueOf(lastUpper.subtract(this.confSearchNode.subtreeUpperBound)));
        }
        if (lastLower != null && this.confSearchNode.subtreeLowerBound.subtract(lastLower).compareTo(BigDecimal.ZERO) < 0 && lastLower.subtract(this.confSearchNode.subtreeLowerBound).compareTo(tolerance) > 0) {
            System.err.println("Lower bound got smaller!?");
            System.err.println("Decreased by " + String.valueOf(lastLower.subtract(this.confSearchNode.subtreeLowerBound)));
        }
        if (this.nodeEpsilon < epsilonBound && epsilonBound - this.nodeEpsilon > 1.0E-4) {
            System.err.println("Epsilon got bigger. Error.");
            System.err.println("UpperBound change: " + String.valueOf(this.confSearchNode.subtreeUpperBound.subtract(lastUpper)));
            System.err.println("LowerBound change: " + String.valueOf(this.confSearchNode.subtreeLowerBound.subtract(lastLower)));
        }
    }

    public BigDecimal getUpperBound() {
        return this.confSearchNode.subtreeUpperBound;
    }

    public BigDecimal getLowerBound() {
        return this.confSearchNode.subtreeLowerBound;
    }

    public static BigDecimal setSigFigs(BigDecimal decimal, int numSigFigs) {
        return decimal.setScale(4 - decimal.precision() + decimal.scale(), RoundingMode.HALF_UP);
    }

    public static BigDecimal setSigFigs(BigDecimal decimal) {
        return MARKStarNode.setSigFigs(decimal, 4);
    }

    public void printTree(String prefix, FileWriter writer, SimpleConfSpace confSpace) {
        Object confString = this.confSearchNode.confToString();
        if (confSpace != null) {
            confString = (String)confString + "->(" + confSpace.formatConfRotamersWithResidueNumbers(this.confSearchNode.assignments) + ")";
        }
        String out = prefix + (String)confString + ":[" + this.confSearchNode.confLowerBound + "," + this.confSearchNode.confUpperBound + "]->[" + String.valueOf(MARKStarNode.setSigFigs(this.confSearchNode.subtreeLowerBound)) + "," + String.valueOf(MARKStarNode.setSigFigs(this.confSearchNode.subtreeUpperBound)) + "]\n";
        if (MathTools.isLessThan(this.confSearchNode.getSubtreeUpperBound(), BigDecimal.ONE)) {
            return;
        }
        if (writer != null) {
            try {
                writer.write(out);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            System.out.print(out);
        }
        if (this.children != null && !this.children.isEmpty()) {
            Collections.sort(this.children, (a, b) -> -a.confSearchNode.subtreeUpperBound.compareTo(b.confSearchNode.subtreeUpperBound));
            for (MARKStarNode child : this.children) {
                child.printTree(prefix + "~+", writer, confSpace);
            }
        }
    }

    public void printTree(String name) {
        this.printTree(name, null);
    }

    public void printTree(String name, SimpleConfSpace confspace) {
        try {
            FileWriter writer = new FileWriter(new File(name + "ConfTreeBounds.txt"));
            this.printTree("", writer, confspace);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void printTree() {
        this.printTree("", null, null);
    }

    public void index(ConfIndex confIndex) {
        this.confSearchNode.index(confIndex);
    }

    public Node getConfSearchNode() {
        return this.confSearchNode;
    }

    public MARKStarNode makeChild(Node child) {
        MARKStarNode newChild = new MARKStarNode(child, this);
        if (this.children == null) {
            this.children = new CopyOnWriteArrayList<MARKStarNode>();
        }
        this.children.add(newChild);
        return newChild;
    }

    public void setBoundsFromConfLowerAndUpper(double lowerBound, double upperBound) {
        this.confSearchNode.updateConfLowerBound(lowerBound);
        this.confSearchNode.updateConfUpperBound(upperBound);
        this.confSearchNode.setBoundsFromConfLowerAndUpper(lowerBound, upperBound);
    }

    public List<? extends MARKStarNode> getChildren() {
        return this.children;
    }

    public Type type(RCs rcs) {
        if (this.level < rcs.getNumPos()) {
            return Type.internal;
        }
        if (!this.confSearchNode.isMinimized()) {
            return Type.boundedLeaf;
        }
        return Type.minimizedLeaf;
    }

    public static MARKStarNode makeRoot(SimpleConfSpace confSpace, EnergyMatrix rigidEnergyMatrix, EnergyMatrix minimizingEnergyMatrix, RCs rcs, AStarScorer gScorer, AStarScorer hScorer, AStarScorer rigidgScorer, AStarScorer negatedHScorer, boolean reportProgress) {
        Node node;
        ConfIndex confIndex = new ConfIndex(confSpace.positions.size());
        Node rootNode = node = new Node(confSpace.positions.size());
        rootNode.index(confIndex);
        rootNode.gscore = gScorer.calc(confIndex, rcs);
        rootNode.rigidScore = rigidgScorer.calc(confIndex, rcs);
        double confUpperBound = rigidgScorer.calc(confIndex, rcs) - negatedHScorer.calc(confIndex, rcs);
        double confLowerBound = rootNode.gscore + hScorer.calc(confIndex, rcs);
        rootNode.computeNumConformations(rcs);
        rootNode.setBoundsFromConfLowerAndUpper(confLowerBound, confUpperBound);
        return new MARKStarNode(rootNode, null);
    }

    @Override
    public int compareTo(MARKStarNode other) {
        return -this.getErrorBound().compareTo(other.getErrorBound());
    }

    public BigDecimal getErrorBound() {
        if (this.confSearchNode.isMinimized()) {
            return BigDecimal.ZERO;
        }
        if (this.children == null || this.children.size() < 1) {
            BigDecimal diff = this.confSearchNode.subtreeUpperBound.subtract(this.confSearchNode.subtreeLowerBound);
            return diff.multiply(new BigDecimal(this.confSearchNode.minimizationRatio));
        }
        BigDecimal errorSum = BigDecimal.ZERO;
        for (MARKStarNode childNode : this.children) {
            errorSum = errorSum.add(childNode.getErrorBound());
        }
        this.errorBound = errorSum;
        return this.errorBound;
    }

    public static class Node
    implements ConfAStarNode {
        private static int Unassigned = -1;
        public double gscore = Double.NaN;
        public double rigidScore = Double.NaN;
        private BigDecimal subtreeLowerBound = BigDecimal.ZERO;
        private BigDecimal subtreeUpperBound = null;
        private double confLowerBound = -1.7976931348623157E308;
        private double confUpperBound = Double.MAX_VALUE;
        public int[] assignments;
        public int pos = Unassigned;
        public int rc = Unassigned;
        public final int level;
        public BigInteger numConfs = BigInteger.ZERO;
        private double minimizationRatio = 1.0;

        public Node(int size) {
            this(size, 0);
        }

        public Node(int size, int level) {
            this.assignments = new int[size];
            Arrays.fill(this.assignments, Unassigned);
            this.level = level;
        }

        public void setMinimizationRatio(double v) {
            this.minimizationRatio = v;
        }

        public void setBoundsFromConfLowerAndUpper(double lowerBound, double upperBound) {
            if (lowerBound - upperBound > 1.0E-5) {
                if (debug) {
                    System.out.println("Incorrect conf bounds set.");
                }
                double temp = lowerBound;
                lowerBound = upperBound;
                upperBound = temp;
                lowerBound = Math.min(0.0, lowerBound);
                upperBound = Math.max(lowerBound, upperBound);
            }
            this.updateConfLowerBound(lowerBound);
            this.updateConfUpperBound(upperBound);
        }

        private void updateConfLowerBound(double tighterLower) {
            if (tighterLower < 10.0 && tighterLower - this.confLowerBound < -1.0E-5) {
                System.err.println("Updating conf lower bound of  " + this.confLowerBound + " with " + tighterLower + ", which is lower!?");
            }
            if (tighterLower > this.confLowerBound) {
                this.confLowerBound = tighterLower;
                this.updateSubtreeUpperBound(this.computeBoundsFromEnergy(this.confLowerBound));
            }
        }

        private void updateConfUpperBound(double tighterUpper) {
            if (tighterUpper < 10.0 && tighterUpper - this.confUpperBound > 1.0E-5) {
                System.err.println("Updating conf upper bound of  " + this.confUpperBound + " with " + tighterUpper + ", which is greater!?");
            }
            if (tighterUpper == Double.POSITIVE_INFINITY) {
                this.updateSubtreeLowerBound(BigDecimal.ZERO);
            }
            if (tighterUpper < this.confUpperBound) {
                this.confUpperBound = tighterUpper;
                this.updateSubtreeLowerBound(this.computeBoundsFromEnergy(this.confUpperBound));
            }
        }

        private BigDecimal computeBoundsFromEnergy(double energy) {
            return bc.calc(energy).multiply(new BigDecimal(this.getNumConformations()));
        }

        private void updateSubtreeLowerBound(BigDecimal tighterLower) {
            if (this.subtreeLowerBound != null && this.subtreeLowerBound.compareTo(tighterLower) > 0) {
                System.err.println("Updating subtree lower bound " + String.valueOf(MARKStarNode.setSigFigs(this.subtreeLowerBound)) + " with " + String.valueOf(tighterLower) + ", which is lower!?");
            }
            this.subtreeLowerBound = tighterLower;
        }

        private void updateSubtreeUpperBound(BigDecimal tighterUpper) {
            if (this.subtreeUpperBound != null && this.subtreeUpperBound.compareTo(tighterUpper) < 0) {
                System.err.println("Updating subtree upper bound " + String.valueOf(MARKStarNode.setSigFigs(this.subtreeUpperBound)) + " with " + String.valueOf(MARKStarNode.setSigFigs(tighterUpper)) + ", which is greater!?");
            }
            this.subtreeUpperBound = tighterUpper;
        }

        public boolean isMinimized() {
            return this.confLowerBound == this.confUpperBound;
        }

        public boolean isLeaf() {
            return this.level == this.assignments.length;
        }

        @Override
        public Node assign(int pos, int rc) {
            Node node = new Node(this.assignments.length, this.level + 1);
            node.pos = pos;
            node.rc = rc;
            System.arraycopy(this.assignments, 0, node.assignments, 0, this.assignments.length);
            node.assignments[pos] = rc;
            return node;
        }

        @Override
        public double getGScore() {
            return this.gscore;
        }

        @Override
        public void setGScore(double val) {
            this.gscore = val;
        }

        public double getMaxScore() {
            return -this.confLowerBound;
        }

        public double getMinScore() {
            return -this.confUpperBound;
        }

        @Override
        public double getHScore() {
            return -this.subtreeUpperBound.subtract(this.subtreeLowerBound).doubleValue();
        }

        @Override
        public void setHScore(double val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLevel() {
            return this.level;
        }

        @Override
        public void getConf(int[] conf) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void index(ConfIndex confIndex) {
            confIndex.numDefined = 0;
            confIndex.numUndefined = 0;
            for (int pos = 0; pos < this.assignments.length; ++pos) {
                int rc = this.assignments[pos];
                if (rc == -1) {
                    confIndex.undefinedPos[confIndex.numUndefined] = pos;
                    ++confIndex.numUndefined;
                    continue;
                }
                confIndex.definedPos[confIndex.numDefined] = pos;
                confIndex.definedRCs[confIndex.numDefined] = this.assignments[pos];
                ++confIndex.numDefined;
            }
            confIndex.node = this;
        }

        public String confToString() {
            Object out = "(";
            for (int i = 0; i < this.assignments.length; ++i) {
                out = (String)out + this.assignments[i] + ", ";
            }
            out = (String)out + ")";
            return out;
        }

        public String toString() {
            Object out = this.confToString();
            out = (String)out + "Energy:" + String.format("%4.2f", this.gscore) + "*" + String.valueOf(this.numConfs);
            out = !this.isMinimized() ? (String)out + " in [" + String.format("%4.4e,%4.4e", this.confLowerBound, this.confUpperBound) + "]->[" + String.valueOf(MARKStarNode.setSigFigs(this.subtreeLowerBound)) + "," + String.valueOf(MARKStarNode.setSigFigs(this.subtreeUpperBound)) + "]" : (String)out + " (minimized) -> " + String.valueOf(MARKStarNode.setSigFigs(this.subtreeLowerBound));
            return out;
        }

        public BigInteger getNumConformations() {
            return this.numConfs;
        }

        public void computeNumConformations(RCs rcs) {
            BigInteger numConfs;
            this.numConfs = numConfs = BigInteger.ONE;
            if (rcs.getNumPos() == this.assignments.length) {
                boolean fullyAssigned = true;
                for (int pos = 0; pos < this.assignments.length; ++pos) {
                    if (this.assignments[pos] != Unassigned) continue;
                    fullyAssigned = false;
                }
                if (fullyAssigned) {
                    return;
                }
            }
            for (int pos = 0; pos < this.assignments.length; ++pos) {
                if (this.assignments[pos] != Unassigned) continue;
                numConfs = numConfs.multiply(BigInteger.valueOf(rcs.getNum(pos)));
            }
            this.numConfs = numConfs;
            assert (this.numConfs.compareTo(BigInteger.ZERO) > 0);
        }

        public double getConfLowerBound() {
            return this.confLowerBound;
        }

        public double getConfUpperBound() {
            return this.confUpperBound;
        }

        public BigDecimal getSubtreeLowerBound() {
            return this.subtreeLowerBound;
        }

        public BigDecimal getSubtreeUpperBound() {
            return this.subtreeUpperBound;
        }
    }

    public static enum Type {
        internal,
        boundedLeaf,
        minimizedLeaf;

    }

    public static interface ScorerFactory {
        public AStarScorer make(EnergyMatrix var1);
    }
}

