/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleMatrix1D;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.energy.EnergyFunction;
import edu.duke.cs.osprey.minimization.MoleculeModifierAndScorer;
import edu.duke.cs.osprey.voxq.BoltzmannIntegrator1D;

public class IdealSeparableReference
extends MoleculeModifierAndScorer {
    double centerE;
    double[] baseValForDOF;
    DoubleMatrix1D fullCurDOFVals;

    public IdealSeparableReference(EnergyFunction ef, ConfSpace cSpace, RCTuple RCTup, DoubleMatrix1D center) {
        super(ef, cSpace, RCTup);
        super.setDOFs(center);
        this.centerE = this.efunc.getEnergy();
        this.fullCurDOFVals = center.copy();
        this.baseValForDOF = new double[this.getNumDOFs()];
        for (int dof = 0; dof < this.getNumDOFs(); ++dof) {
            this.baseValForDOF[dof] = this.partialEFuncs != null ? ((EnergyFunction)this.partialEFuncs.get(dof)).getEnergy() : this.efunc.getEnergy();
        }
    }

    @Override
    public void setDOFs(DoubleMatrix1D x) {
        this.fullCurDOFVals.assign(x);
    }

    @Override
    public void setDOF(int dof, double val) {
        this.fullCurDOFVals.set(dof, val);
    }

    @Override
    public double getValForDOF(int dof, double val) {
        double baseDOFVal = this.curDOFVals.get(dof);
        super.setDOF(dof, val);
        double ans = this.partialEFuncs != null ? ((EnergyFunction)this.partialEFuncs.get(dof)).getEnergy() : this.efunc.getEnergy();
        super.setDOF(dof, baseDOFVal);
        this.fullCurDOFVals.set(dof, val);
        return ans -= this.baseValForDOF[dof];
    }

    @Override
    public double getValue(DoubleMatrix1D x) {
        double ans = this.centerE;
        for (int dof = 0; dof < this.getNumDOFs(); ++dof) {
            ans += this.getValForDOF(dof, x.get(dof));
        }
        this.fullCurDOFVals.assign(x);
        return ans;
    }

    @Override
    public double getCurValueOfDOF(int dof) {
        return this.fullCurDOFVals.get(dof);
    }

    public double calcG() {
        double ans = this.centerE;
        for (int dof = 0; dof < this.getNumDOFs(); ++dof) {
            ans -= 0.593050165 * Math.log(this.axisIntegrator(dof).doIntegral());
        }
        return ans;
    }

    private BoltzmannIntegrator1D axisIntegrator(final int dof) {
        double lo = this.getConstraints()[0].get(dof);
        double hi = this.getConstraints()[1].get(dof);
        return new BoltzmannIntegrator1D(lo, hi){

            @Override
            public double f(double x) {
                return IdealSeparableReference.this.getValForDOF(dof, x);
            }
        };
    }
}

