/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.minimization;

import cern.colt.matrix.DoubleFactory1D;
import cern.colt.matrix.DoubleMatrix1D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public interface ObjectiveFunction
extends Serializable {
    public int getNumDOFs();

    public DoubleMatrix1D[] getConstraints();

    default public DoubleMatrix1D getDOFsCenter() {
        int n = this.getNumDOFs();
        DoubleMatrix1D x = DoubleFactory1D.dense.make(n);
        for (int d = 0; d < n; ++d) {
            double xdmin = this.getConstraints()[0].get(d);
            double xdmax = this.getConstraints()[1].get(d);
            x.set(d, (xdmin + xdmax) / 2.0);
        }
        return x;
    }

    public void setDOFs(DoubleMatrix1D var1);

    public void setDOF(int var1, double var2);

    public double getValue(DoubleMatrix1D var1);

    public double getValForDOF(int var1, double var2);

    public double getInitStepSize(int var1);

    default public boolean isDOFAngle(int dof) {
        throw new UnsupportedOperationException();
    }

    default public ArrayList<Integer> getInitFixableDOFs() {
        throw new UnsupportedOperationException();
    }

    public static class DofBounds
    implements Serializable {
        private DoubleMatrix1D[] bounds;

        public static DofBounds concatenate(DofBounds ... bounds) {
            return DofBounds.concatenate(Arrays.asList(bounds));
        }

        public static DofBounds concatenate(List<DofBounds> subBoundsList) {
            int size = 0;
            for (DofBounds subBounds : subBoundsList) {
                if (subBounds == null) continue;
                size += subBounds.size();
            }
            DofBounds bounds = new DofBounds(size);
            int i = 0;
            for (DofBounds subBounds : subBoundsList) {
                if (subBounds == null) continue;
                for (int j = 0; j < subBounds.size(); ++j) {
                    bounds.set(i++, subBounds.getMin(j), subBounds.getMax(j));
                }
            }
            return bounds;
        }

        public DofBounds(int numDofs) {
            this.bounds = new DoubleMatrix1D[]{DoubleFactory1D.dense.make(numDofs), DoubleFactory1D.dense.make(numDofs)};
        }

        public DofBounds(DofBounds other) {
            this.bounds = new DoubleMatrix1D[]{other.bounds[0].copy(), other.bounds[1].copy()};
        }

        public DofBounds(DoubleMatrix1D[] bounds) {
            this.bounds = bounds;
        }

        public DoubleMatrix1D[] getBounds() {
            return this.bounds;
        }

        public DoubleMatrix1D getMins() {
            return this.bounds[0];
        }

        public DoubleMatrix1D getMaxs() {
            return this.bounds[1];
        }

        public int size() {
            return this.getMins().size();
        }

        public double getMin(int d) {
            return this.getMins().get(d);
        }

        public double getMax(int d) {
            return this.getMaxs().get(d);
        }

        public double getCenter(int d) {
            return (this.getMin(d) + this.getMax(d)) / 2.0;
        }

        public void getCenter(DoubleMatrix1D out) {
            for (int d = 0; d < this.size(); ++d) {
                out.set(d, this.getCenter(d));
            }
        }

        public double getWidth(int d) {
            return this.getMax(d) - this.getMin(d);
        }

        public void set(int d, double min, double max) {
            this.bounds[0].set(d, min);
            this.bounds[1].set(d, max);
        }

        public double clamp(int d, double xd) {
            double min = this.getMin(d);
            double max = this.getMax(d);
            if (xd < min) {
                xd = min;
            } else if (xd > max) {
                xd = max;
            }
            return xd;
        }

        public void clamp(DoubleMatrix1D x) {
            for (int d = 0; d < this.size(); ++d) {
                x.set(d, this.clamp(d, x.get(d)));
            }
        }

        public double clampDelta(int d, double xd, double delta) {
            double min = this.getMin(d);
            double max = this.getMax(d);
            if (xd - delta < min) {
                delta = min - xd;
            } else if (xd + delta > max) {
                delta = max - xd;
            }
            return delta;
        }

        public void clampDelta(DoubleMatrix1D x, DoubleMatrix1D delta) {
            for (int d = 0; d < this.size(); ++d) {
                delta.set(d, this.clampDelta(d, x.get(d), delta.get(d)));
            }
        }

        public boolean isInBounds(int d, double xd) {
            return xd >= this.getMin(d) && xd <= this.getMax(d);
        }

        public boolean isInBounds(DoubleMatrix1D x) {
            for (int d = 0; d < this.size(); ++d) {
                if (this.isInBounds(d, x.get(d))) continue;
                return false;
            }
            return true;
        }

        public String toString() {
            return this.toString(9, 4);
        }

        public String toString(int size, int precision) {
            String format = "%" + size + "." + precision + "f";
            format = "[" + format + "," + format + "]";
            StringBuilder buf = new StringBuilder();
            for (int d = 0; d < this.size(); ++d) {
                if (d > 0) {
                    buf.append(", ");
                }
                buf.append(String.format(format, this.getMin(d), this.getMax(d)));
            }
            return buf.toString();
        }
    }

    public static class OneDof
    implements Serializable {
        private ObjectiveFunction f;
        private int d;
        private double xdmin;
        private double xdmax;

        public OneDof(ObjectiveFunction f, int d) {
            this.f = f;
            this.d = d;
            this.xdmin = f.getConstraints()[0].get(d);
            this.xdmax = f.getConstraints()[1].get(d);
        }

        public ObjectiveFunction getParent() {
            return this.f;
        }

        public int getDimension() {
            return this.d;
        }

        public double getXMin() {
            return this.xdmin;
        }

        public double getXMax() {
            return this.xdmax;
        }

        public void setX(double xd) {
            this.f.setDOF(this.d, xd);
        }

        public double getValue(double xd) {
            return this.f.getValForDOF(this.d, xd);
        }

        public double getInitialStepSize() {
            return this.f.getInitStepSize(this.d);
        }
    }
}

