/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.molscope.molecule;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.Element;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\b\u0018\u0000 &2\u00020\u0001:\u0001&B/\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\nB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\fH\u00c6\u0003J\u001c\u0010\u0017\u001a\u00020\u00002\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0019J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u000b\u001a\u00020\fH\u00c6\u0001J\u0013\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020#J\b\u0010$\u001a\u00020\u0005H\u0016J\u001c\u0010%\u001a\u00020 2\u0014\b\u0002\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\f0\u0019R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006'"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Atom;", "", "element", "Ledu/duke/cs/osprey/molscope/molecule/Element;", "name", "", "x", "", "y", "z", "(Ledu/duke/cs/osprey/molscope/molecule/Element;Ljava/lang/String;DDD)V", "pos", "Lorg/joml/Vector3d;", "(Ledu/duke/cs/osprey/molscope/molecule/Element;Ljava/lang/String;Lorg/joml/Vector3d;)V", "getElement", "()Ledu/duke/cs/osprey/molscope/molecule/Element;", "getName", "()Ljava/lang/String;", "getPos", "()Lorg/joml/Vector3d;", "component1", "component2", "component3", "copy", "transform", "Lkotlin/Function1;", "equals", "", "other", "hashCode", "", "invertInPlace", "", "label", "mol", "Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "toString", "transformInPlace", "Companion", "osprey3"})
@SourceDebugExtension(value={"SMAP\nMolecule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Molecule.kt\nedu/duke/cs/osprey/molscope/molecule/Atom\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,706:1\n1#2:707\n*E\n"})
public final class Atom {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Element element;
    @NotNull
    private final String name;
    @NotNull
    private final Vector3d pos;

    public Atom(@NotNull Element element, @NotNull String name, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.element = element;
        this.name = name;
        this.pos = pos;
    }

    @NotNull
    public final Element getElement() {
        return this.element;
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    @NotNull
    public final Vector3d getPos() {
        return this.pos;
    }

    public Atom(@NotNull Element element, @NotNull String name, double x, double y, double z) {
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this(element, name, new Vector3d(x, y, z));
    }

    @NotNull
    public String toString() {
        return this.name;
    }

    @NotNull
    public final Atom copy(@NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        return this.copy(this.element, this.name, (Vector3d)transform.invoke((Object)this.pos));
    }

    public static /* synthetic */ Atom copy$default(Atom atom, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = copy.1.INSTANCE;
        }
        return atom.copy((Function1<? super Vector3d, ? extends Vector3d>)function1);
    }

    public final void transformInPlace(@NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Vector3d newPos = (Vector3d)transform.invoke((Object)this.pos);
        MoleculeKt.assignCoords(this.pos, newPos);
    }

    public static /* synthetic */ void transformInPlace$default(Atom atom, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = transformInPlace.1.INSTANCE;
        }
        atom.transformInPlace((Function1<? super Vector3d, ? extends Vector3d>)function1);
    }

    public final void invertInPlace() {
        this.transformInPlace((Function1<? super Vector3d, ? extends Vector3d>)((Function1)invertInPlace.1.INSTANCE));
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String label(@NotNull Molecule mol) {
        String string;
        Pair<Polymer.Chain, Polymer.Residue> pair;
        Polymer polymer;
        Intrinsics.checkNotNullParameter((Object)mol, (String)"mol");
        Polymer polymer2 = polymer = mol instanceof Polymer ? (Polymer)mol : null;
        if (polymer != null && (pair = polymer.findChainAndResidue(this)) != null) {
            Pair<Polymer.Chain, Polymer.Residue> pair2 = pair;
            boolean bl = false;
            Polymer.Chain chain = (Polymer.Chain)pair2.component1();
            Polymer.Residue res = (Polymer.Residue)pair2.component2();
            String string2 = mol.getName() + " " + chain.getId() + " " + res.getId() + " " + this.name;
            if (string2 != null) {
                string = string2;
                return string;
            }
        }
        string = mol.getName() + " " + this.name;
        return string;
    }

    @NotNull
    public final Element component1() {
        return this.element;
    }

    @NotNull
    public final String component2() {
        return this.name;
    }

    @NotNull
    public final Vector3d component3() {
        return this.pos;
    }

    @NotNull
    public final Atom copy(@NotNull Element element, @NotNull String name, @NotNull Vector3d pos) {
        Intrinsics.checkNotNullParameter((Object)((Object)element), (String)"element");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        return new Atom(element, name, pos);
    }

    public static /* synthetic */ Atom copy$default(Atom atom, Element element, String string, Vector3d vector3d, int n, Object object) {
        if ((n & 1) != 0) {
            element = atom.element;
        }
        if ((n & 2) != 0) {
            string = atom.name;
        }
        if ((n & 4) != 0) {
            vector3d = atom.pos;
        }
        return atom.copy(element, string, vector3d);
    }

    public int hashCode() {
        int result = this.element.hashCode();
        result = result * 31 + this.name.hashCode();
        result = result * 31 + this.pos.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Atom)) {
            return false;
        }
        Atom atom = (Atom)other;
        if (this.element != atom.element) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)atom.name)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.pos, (Object)atom.pos);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002H\u00060\u0004\"\u0004\b\u0000\u0010\u0006J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0012\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00050\u000b\"\u00020\u0005\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Atom$Companion;", "", "()V", "identityMap", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "T", "identitySet", "", "identitySetOf", "atoms", "", "([Ledu/duke/cs/osprey/molscope/molecule/Atom;)Ljava/util/Set;", "osprey3"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> Map<Atom, T> identityMap() {
            return new IdentityHashMap();
        }

        @NotNull
        public final Set<Atom> identitySet() {
            Set<Atom> set = Collections.newSetFromMap(this.identityMap());
            Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(identityMap<Boolean>())");
            return set;
        }

        @NotNull
        public final Set<Atom> identitySetOf(Atom ... atoms) {
            Set<Atom> set;
            Intrinsics.checkNotNullParameter((Object)atoms, (String)"atoms");
            Set<Atom> $this$identitySetOf_u24lambda_u240 = set = this.identitySet();
            boolean bl = false;
            CollectionsKt.addAll((Collection)$this$identitySetOf_u24lambda_u240, (Object[])atoms);
            return set;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

