/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.molscope.molecule;

import edu.duke.cs.osprey.molscope.molecule.Atom;
import edu.duke.cs.osprey.molscope.molecule.AtomMap;
import edu.duke.cs.osprey.molscope.molecule.AtomPair;
import edu.duke.cs.osprey.molscope.molecule.Molecule;
import edu.duke.cs.osprey.molscope.molecule.MoleculeKt;
import edu.duke.cs.osprey.molscope.molecule.MoleculeMap;
import edu.duke.cs.osprey.molscope.molecule.MoleculeMaps;
import edu.duke.cs.osprey.molscope.molecule.Polymer;
import edu.duke.cs.osprey.molscope.tools.LangKt;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000}\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b*\u0001;\b\u0016\u0018\u0000 D2\u00020\u0001:\u0006BCDEFGB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007Jm\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2M\b\u0002\u0010\"\u001aG\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b('\u0012\u0004\u0012\u00020!0#J\b\u0010(\u001a\u00020\u0000H\u0016J$\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020\u00002\u0014\b\u0002\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0-J\u0014\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020*00H\u0016Jm\u00101\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2M\b\u0002\u0010\"\u001aG\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b('\u0012\u0004\u0012\u00020!0#J\u0013\u00102\u001a\u00020!2\b\u00103\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u00104\u001a\u00020\u0006H\u0016J\b\u00105\u001a\u00020\u0000H\u0016J\b\u00106\u001a\u00020\u0000H\u0016J\u000e\u00107\u001a\u0002082\u0006\u00103\u001a\u00020\u0000J\u000e\u00109\u001a\u0002082\u0006\u00103\u001a\u00020\u0000Jv\u0010:\u001a\u00020;2\u0006\u0010\u001e\u001a\u00020\u001f2\b\b\u0002\u0010 \u001a\u00020!2M\b\u0002\u0010\"\u001aG\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b(%\u0012\u0013\u0012\u00110\u001f\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b(&\u0012\u0013\u0012\u00110\u0006\u00a2\u0006\f\b$\u0012\b\b\u0002\u0012\u0004\b\b('\u0012\u0004\u0012\u00020!0#2\u0006\u0010<\u001a\u00020=H\u0002\u00a2\u0006\u0002\u0010>J\b\u0010?\u001a\u00020\u0003H\u0016J*\u0010@\u001a\u000e\u0012\u0004\u0012\u00020\u0000\u0012\u0004\u0012\u00020*002\u0014\b\u0002\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0-H\u0016J\u001e\u0010A\u001a\u00020\u00002\u0014\b\u0002\u0010,\u001a\u000e\u0012\u0004\u0012\u00020.\u0012\u0004\u0012\u00020.0-H\u0016R\u0015\u0010\b\u001a\u00060\tR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0015\u0010\f\u001a\u00060\rR\u00020\u0000\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001e\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0018\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0011\"\u0004\b\u001a\u0010\u0013\u00a8\u0006H"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule;", "", "name", "", "type", "netCharge", "", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;)V", "atoms", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$Atoms;", "getAtoms", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule$Atoms;", "bonds", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$Bonds;", "getBonds", "()Ledu/duke/cs/osprey/molscope/molecule/Molecule$Bonds;", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "getNetCharge", "()Ljava/lang/Integer;", "setNetCharge", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getType", "setType", "bfs", "", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$Searched;", "source", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "visitSource", "", "shouldVisit", "Lkotlin/Function3;", "Lkotlin/ParameterName;", "fromAtom", "toAtom", "dist", "copy", "copyTo", "Ledu/duke/cs/osprey/molscope/molecule/MoleculeMaps;", "dst", "transform", "Lkotlin/Function1;", "Lorg/joml/Vector3d;", "copyWithMaps", "Lkotlin/Pair;", "dfs", "equals", "other", "hashCode", "invertedCopy", "invertedInPlace", "mapAtomsByNameTo", "Ledu/duke/cs/osprey/molscope/molecule/AtomMap;", "mapAtomsByValueTo", "search", "edu/duke/cs/osprey/molscope/molecule/Molecule$search$2", "searchType", "Ledu/duke/cs/osprey/molscope/molecule/Molecule$SearchType;", "(Ledu/duke/cs/osprey/molscope/molecule/Atom;ZLkotlin/jvm/functions/Function3;Ledu/duke/cs/osprey/molscope/molecule/Molecule$SearchType;)Ledu/duke/cs/osprey/molscope/molecule/Molecule$search$2;", "toString", "transformCopy", "transformInPlace", "Atoms", "Bonds", "Companion", "DuplicateAtomNameException", "SearchType", "Searched", "osprey3"})
@SourceDebugExtension(value={"SMAP\nMolecule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Molecule.kt\nedu/duke/cs/osprey/molscope/molecule/Molecule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,706:1\n1271#2,2:707\n1285#2,4:709\n1271#2,2:713\n1285#2,4:715\n*S KotlinDebug\n*F\n+ 1 Molecule.kt\nedu/duke/cs/osprey/molscope/molecule/Molecule\n*L\n357#1:707,2\n357#1:709,4\n423#1:713,2\n423#1:715,4\n*E\n"})
public class Molecule {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private String name;
    @Nullable
    private String type;
    @Nullable
    private Integer netCharge;
    @NotNull
    private final Atoms atoms;
    @NotNull
    private final Bonds bonds;

    public Molecule(@NotNull String name, @Nullable String type, @Nullable Integer netCharge) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.type = type;
        this.netCharge = netCharge;
        this.atoms = new Atoms(this, null, 1, null);
        this.bonds = new Bonds();
    }

    public /* synthetic */ Molecule(String string, String string2, Integer n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            string2 = null;
        }
        if ((n2 & 4) != 0) {
            n = null;
        }
        this(string, string2, n);
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.name = string;
    }

    @Nullable
    public final String getType() {
        return this.type;
    }

    public final void setType(@Nullable String string) {
        this.type = string;
    }

    @Nullable
    public final Integer getNetCharge() {
        return this.netCharge;
    }

    public final void setNetCharge(@Nullable Integer n) {
        this.netCharge = n;
    }

    @NotNull
    public String toString() {
        return this.type == null || Intrinsics.areEqual((Object)this.type, (Object)this.name) ? this.name : this.name + " (" + this.type + ")";
    }

    @NotNull
    public Molecule copy() {
        return (Molecule)this.copyWithMaps().getFirst();
    }

    @NotNull
    public Pair<Molecule, MoleculeMaps> copyWithMaps() {
        Molecule src = this;
        Molecule dst = new Molecule(this.name, this.type, null, 4, null);
        MoleculeMaps maps = Molecule.copyTo$default(src, dst, null, 2, null);
        return TuplesKt.to((Object)dst, (Object)maps);
    }

    @NotNull
    public final MoleculeMaps copyTo(@NotNull Molecule dst, @NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter((Object)dst, (String)"dst");
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Molecule src = this;
        dst.netCharge = src.netCharge;
        MoleculeMap molMap = new MoleculeMap();
        molMap.add(src, dst);
        AtomMap atomMap2 = new AtomMap();
        for (Atom entry : src.atoms) {
            Atom dstAtom = entry.copy(transform);
            atomMap2.add(entry, dstAtom);
            dst.atoms.add(dstAtom);
        }
        for (Map.Entry entry : ((Map)src.bonds.getAdjacency$osprey3()).entrySet()) {
            Atom otherAtom = (Atom)entry.getKey();
            Set otherBondedAtoms = (Set)entry.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)otherAtom, (String)"otherAtom");
            Atom atom = atomMap2.getBOrThrow(otherAtom);
            for (Atom otherBondedAtom : otherBondedAtoms) {
                Atom bondedAtom = atomMap2.getBOrThrow(otherBondedAtom);
                dst.bonds.add(atom, bondedAtom);
            }
        }
        return new MoleculeMaps(molMap, atomMap2);
    }

    public static /* synthetic */ MoleculeMaps copyTo$default(Molecule molecule, Molecule molecule2, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: copyTo");
        }
        if ((n & 2) != 0) {
            function1 = copyTo.1.INSTANCE;
        }
        return molecule.copyTo(molecule2, (Function1<? super Vector3d, ? extends Vector3d>)function1);
    }

    @NotNull
    public Pair<Molecule, MoleculeMaps> transformCopy(@NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        Molecule src = this;
        Molecule dst = new Molecule(this.name, this.type, null, 4, null);
        MoleculeMaps maps = src.copyTo(dst, transform);
        return TuplesKt.to((Object)dst, (Object)maps);
    }

    public static /* synthetic */ Pair transformCopy$default(Molecule molecule, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformCopy");
        }
        if ((n & 1) != 0) {
            function1 = transformCopy.1.INSTANCE;
        }
        return molecule.transformCopy((Function1<? super Vector3d, ? extends Vector3d>)function1);
    }

    @NotNull
    public Molecule invertedCopy() {
        return (Molecule)this.transformCopy((Function1<? super Vector3d, ? extends Vector3d>)((Function1)invertedCopy.1.INSTANCE)).getFirst();
    }

    @NotNull
    public Molecule invertedInPlace() {
        for (Atom atom : this.atoms) {
            atom.invertInPlace();
        }
        return this;
    }

    @NotNull
    public Molecule transformInPlace(@NotNull Function1<? super Vector3d, ? extends Vector3d> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        for (Atom atom : this.atoms) {
            atom.transformInPlace(transform);
        }
        return this;
    }

    public static /* synthetic */ Molecule transformInPlace$default(Molecule molecule, Function1 function1, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformInPlace");
        }
        if ((n & 1) != 0) {
            function1 = transformInPlace.1.INSTANCE;
        }
        return molecule.transformInPlace((Function1<? super Vector3d, ? extends Vector3d>)function1);
    }

    @NotNull
    public final Atoms getAtoms() {
        return this.atoms;
    }

    @NotNull
    public final Bonds getBonds() {
        return this.bonds;
    }

    @NotNull
    public final Iterable<Searched> dfs(@NotNull Atom source, boolean visitSource, @NotNull Function3<? super Atom, ? super Atom, ? super Integer, Boolean> shouldVisit) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(shouldVisit, (String)"shouldVisit");
        return this.search(source, visitSource, shouldVisit, SearchType.DFS);
    }

    public static /* synthetic */ Iterable dfs$default(Molecule molecule, Atom atom, boolean bl, Function3 function3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: dfs");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function3 = dfs.1.INSTANCE;
        }
        return molecule.dfs(atom, bl, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)function3);
    }

    @NotNull
    public final Iterable<Searched> bfs(@NotNull Atom source, boolean visitSource, @NotNull Function3<? super Atom, ? super Atom, ? super Integer, Boolean> shouldVisit) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter(shouldVisit, (String)"shouldVisit");
        return this.search(source, visitSource, shouldVisit, SearchType.BFS);
    }

    public static /* synthetic */ Iterable bfs$default(Molecule molecule, Atom atom, boolean bl, Function3 function3, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bfs");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function3 = bfs.1.INSTANCE;
        }
        return molecule.bfs(atom, bl, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)function3);
    }

    private final search.2 search(Atom source, boolean visitSource, Function3<? super Atom, ? super Atom, ? super Integer, Boolean> shouldVisit, SearchType searchType) {
        return new Iterable<Searched>(source, visitSource, searchType, this, shouldVisit){
            final /* synthetic */ Atom $source;
            final /* synthetic */ boolean $visitSource;
            final /* synthetic */ SearchType $searchType;
            final /* synthetic */ Molecule this$0;
            final /* synthetic */ Function3<Atom, Atom, Integer, Boolean> $shouldVisit;
            {
                this.$source = $source;
                this.$visitSource = $visitSource;
                this.$searchType = $searchType;
                this.this$0 = $receiver;
                this.$shouldVisit = $shouldVisit;
            }

            @NotNull
            public search.iterator.1 iterator() {
                return new Iterator<Searched>(this.$source, this.$visitSource, this.$searchType, this.this$0, this.$shouldVisit){
                    @NotNull
                    private final ArrayDeque<Searched> toVisit;
                    @NotNull
                    private final Set<Atom> visitScheduled;
                    final /* synthetic */ SearchType $searchType;
                    final /* synthetic */ Molecule this$0;
                    final /* synthetic */ Function3<Atom, Atom, Integer, Boolean> $shouldVisit;
                    {
                        this.$searchType = $searchType;
                        this.this$0 = $receiver;
                        this.$shouldVisit = $shouldVisit;
                        this.toVisit = new ArrayDeque<E>();
                        this.visitScheduled = Atom.Companion.identitySet();
                        this.scheduleVisit($source, 0);
                        if (!$visitSource) {
                            this.next();
                        }
                    }

                    @NotNull
                    public final ArrayDeque<Searched> getToVisit() {
                        return this.toVisit;
                    }

                    @NotNull
                    public final Set<Atom> getVisitScheduled() {
                        return this.visitScheduled;
                    }

                    public final void scheduleVisit(@NotNull Atom atom, int dist) {
                        Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
                        this.toVisit.add(new Searched(atom, dist));
                        this.visitScheduled.add(atom);
                    }

                    public boolean hasNext() {
                        return !((Collection)this.toVisit).isEmpty();
                    }

                    @NotNull
                    public Searched next() {
                        Searched searched = switch (search.iterator.WhenMappings.$EnumSwitchMapping$0[this.$searchType.ordinal()]) {
                            case 1 -> this.toVisit.pollLast();
                            case 2 -> this.toVisit.pollFirst();
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        if (searched == null) {
                            throw new NoSuchElementException("no more atoms to visit");
                        }
                        Searched step = searched;
                        int nextDist = step.getDist() + 1;
                        List bondedAtoms = switch (search.iterator.WhenMappings.$EnumSwitchMapping$0[this.$searchType.ordinal()]) {
                            case 1 -> CollectionsKt.reversed((Iterable)this.this$0.getBonds().bondedAtomsSorted(step.getAtom()));
                            case 2 -> this.this$0.getBonds().bondedAtomsSorted(step.getAtom());
                            default -> throw new NoWhenBranchMatchedException();
                        };
                        for (Atom bondedAtom : bondedAtoms) {
                            if (this.visitScheduled.contains(bondedAtom) || !((Boolean)this.$shouldVisit.invoke((Object)step.getAtom(), (Object)bondedAtom, (Object)nextDist)).booleanValue()) continue;
                            this.scheduleVisit(bondedAtom, nextDist);
                        }
                        return step;
                    }

                    public void remove() {
                        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
                    }
                };
            }
        };
    }

    static /* synthetic */ search.2 search$default(Molecule molecule, Atom atom, boolean bl, Function3 function3, SearchType searchType, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: search");
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            function3 = search.1.INSTANCE;
        }
        return molecule.search(atom, bl, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)function3, searchType);
    }

    public int hashCode() {
        int hash = 0;
        hash ^= this.name.hashCode();
        String string = this.type;
        hash ^= string != null ? string.hashCode() : 0;
        Integer n = this.netCharge;
        hash ^= n != null ? ((Object)n).hashCode() : 0;
        for (Atom atom : this.atoms) {
            hash ^= atom.hashCode();
            for (Atom bondedAtom : this.bonds.bondedAtoms(atom)) {
                hash ^= bondedAtom.hashCode();
            }
        }
        return hash;
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Molecule)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.name, (Object)((Molecule)other).name)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.type, (Object)((Molecule)other).type)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.netCharge, (Object)((Molecule)other).netCharge)) {
            return false;
        }
        if (this.atoms.size() != ((Molecule)other).atoms.size()) {
            return false;
        }
        Iterable $this$associateWith$iv = ((Molecule)other).atoms;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Atom atom = (Atom)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            void var14_14 = it;
            map.put(t, var14_14);
        }
        Map otherAtoms = result$iv;
        for (Atom thisAtom : this.atoms) {
            Atom otherAtom;
            if ((Atom)otherAtoms.get(thisAtom) == null) {
                return false;
            }
            Set<Atom> set = this.bonds.getAdjacency$osprey3().get(thisAtom);
            Set<Atom> set2 = ((Molecule)other).bonds.getAdjacency$osprey3().get(otherAtom);
            if (Intrinsics.areEqual((Object)(set != null ? CollectionsKt.toSet((Iterable)set) : null), (Object)(set2 != null ? CollectionsKt.toSet((Iterable)set2) : null))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final AtomMap mapAtomsByNameTo(@NotNull Molecule other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        HashMap lookup = new HashMap();
        for (Atom otherAtom : other.atoms) {
            String id = Molecule.mapAtomsByNameTo$id(otherAtom, other);
            if (((Map)lookup).containsKey(id)) {
                throw new DuplicateAtomNameException(id);
            }
            ((Map)lookup).put(id, otherAtom);
        }
        AtomMap map = new AtomMap();
        for (Atom thisAtom : this.atoms) {
            Atom otherAtom;
            if ((Atom)lookup.get(Molecule.mapAtomsByNameTo$id(thisAtom, this)) == null) continue;
            map.add(thisAtom, otherAtom);
        }
        return map;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final AtomMap mapAtomsByValueTo(@NotNull Molecule other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        AtomMap map = new AtomMap();
        Iterable $this$associateWith$iv = other.atoms;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void it;
            Atom atom = (Atom)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            void var15_15 = it;
            map2.put(t, var15_15);
        }
        Map lookup = result$iv;
        for (Atom thisAtom : this.atoms) {
            Atom otherAtom = (Atom)lookup.get(thisAtom);
            if (otherAtom == null) continue;
            map.add(thisAtom, otherAtom);
        }
        return map;
    }

    private static final String mapAtomsByNameTo$id(Atom $this$mapAtomsByNameTo_u24id, Molecule mol) {
        Polymer polymer = mol instanceof Polymer ? (Polymer)mol : null;
        Polymer.Residue res = polymer != null ? polymer.findResidue($this$mapAtomsByNameTo_u24id) : null;
        return res != null ? $this$mapAtomsByNameTo_u24id.getName() + "@" + res.getId() : $this$mapAtomsByNameTo_u24id.getName();
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0005\b\u0086\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0000\u0012\u000e\b\u0002\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\f\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u0002J\u0014\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011J\u0011\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010\u0015\u001a\u00020\u00132\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0096\u0001J\u000e\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u0019J\u0011\u0010\u001a\u001a\u00020\u00022\u0006\u0010\u001b\u001a\u00020\tH\u0096\u0003J\u0011\u0010\u001c\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0001J\t\u0010\u001d\u001a\u00020\u0013H\u0096\u0001J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u001fH\u0096\u0003J\u0011\u0010 \u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0002H\u0096\u0001J\u000f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"H\u0096\u0001J\u0017\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00020\"2\u0006\u0010\u001b\u001a\u00020\tH\u0096\u0001J\u000e\u0010#\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\u0002J\u001f\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010%\u001a\u00020\t2\u0006\u0010&\u001a\u00020\tH\u0096\u0001R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0012\u0010\b\u001a\u00020\tX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006'"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule$Atoms;", "", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "list", "", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;Ljava/util/List;)V", "getList$osprey3", "()Ljava/util/List;", "size", "", "getSize", "()I", "add", "atom", "addAll", "", "atoms", "", "contains", "", "element", "containsAll", "elements", "findOrThrow", "name", "", "get", "index", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "remove", "subList", "fromIndex", "toIndex", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nMolecule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Molecule.kt\nedu/duke/cs/osprey/molscope/molecule/Molecule$Atoms\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,706:1\n1#2:707\n*E\n"})
    public final class Atoms
    implements List<Atom>,
    KMappedMarker {
        @NotNull
        private final List<Atom> list;
        final /* synthetic */ Molecule this$0;

        public Atoms(@NotNull Molecule this$0, List<Atom> list) {
            Intrinsics.checkNotNullParameter(list, (String)"list");
            this.this$0 = this$0;
            this.list = list;
        }

        public /* synthetic */ Atoms(Molecule molecule, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                list = new ArrayList();
            }
            this(molecule, list);
        }

        @NotNull
        public final List<Atom> getList$osprey3() {
            return this.list;
        }

        public int getSize() {
            return this.list.size();
        }

        public boolean contains(@NotNull Atom element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.list.contains(element);
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            return this.list.containsAll(elements);
        }

        @Override
        @NotNull
        public Atom get(int index) {
            return this.list.get(index);
        }

        public int indexOf(@NotNull Atom element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.list.indexOf(element);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }

        @Override
        @NotNull
        public Iterator<Atom> iterator() {
            return this.list.iterator();
        }

        public int lastIndexOf(@NotNull Atom element) {
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            return this.list.lastIndexOf(element);
        }

        @Override
        @NotNull
        public ListIterator<Atom> listIterator() {
            return this.list.listIterator();
        }

        @Override
        @NotNull
        public ListIterator<Atom> listIterator(int index) {
            return this.list.listIterator(index);
        }

        @Override
        @NotNull
        public List<Atom> subList(int fromIndex, int toIndex) {
            return this.list.subList(fromIndex, toIndex);
        }

        @NotNull
        public final Atom add(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.list.add(atom);
            return atom;
        }

        public final void addAll(@NotNull Collection<Atom> atoms) {
            Intrinsics.checkNotNullParameter(atoms, (String)"atoms");
            for (Atom atom : atoms) {
                this.add(atom);
            }
        }

        public final void remove(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.list.remove(atom);
            this.this$0.getBonds().getAdjacency$osprey3().remove(atom);
            for (Set<Atom> bondedAtoms : this.this$0.getBonds().getAdjacency$osprey3().values()) {
                bondedAtoms.remove(atom);
            }
        }

        @NotNull
        public final Atom findOrThrow(@NotNull String name) {
            Object v0;
            block2: {
                Intrinsics.checkNotNullParameter((Object)name, (String)"name");
                Iterable iterable = this.list;
                for (Object t : iterable) {
                    Atom it = (Atom)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)name)) continue;
                    v0 = t;
                    break block2;
                }
                v0 = null;
            }
            Atom atom = v0;
            if (atom == null) {
                throw new NoSuchElementException("no atom with name " + name);
            }
            return atom;
        }

        @Override
        public boolean add(Atom element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void add(int index, Atom element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(int index, Collection<? extends Atom> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean addAll(Collection<? extends Atom> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean remove(Object element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean removeAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public Atom remove(int index) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void replaceAll(UnaryOperator<Atom> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public boolean retainAll(Collection<? extends Object> elements) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public Atom set(int index, Atom element) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public void sort(Comparator<? super Atom> p0) {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u00062\u0006\u0010\u0010\u001a\u00020\u0005J\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u0010\u001a\u00020\u0005J\u0006\u0010\u0013\u001a\u00020\u0014J\"\u0010\u0015\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00160\u00122\u000e\b\u0002\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0018J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0016\u0010\u001b\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u001c\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005J\u000e\u0010\u001c\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eJ\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0016R&\u0010\u0003\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u001e"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule$Bonds;", "", "(Ledu/duke/cs/osprey/molscope/molecule/Molecule;)V", "adjacency", "Ljava/util/IdentityHashMap;", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "", "getAdjacency$osprey3", "()Ljava/util/IdentityHashMap;", "add", "", "a1", "a2", "pair", "Ledu/duke/cs/osprey/molscope/molecule/AtomPair;", "bondedAtoms", "atom", "bondedAtomsSorted", "", "clear", "", "connectedComponents", "", "amongAtoms", "", "count", "", "isBonded", "remove", "toSet", "osprey3"})
    @SourceDebugExtension(value={"SMAP\nMolecule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Molecule.kt\nedu/duke/cs/osprey/molscope/molecule/Molecule$Bonds\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,706:1\n361#2,7:707\n1045#3:714\n1855#3,2:716\n1549#3:718\n1620#3,3:719\n1#4:715\n*S KotlinDebug\n*F\n+ 1 Molecule.kt\nedu/duke/cs/osprey/molscope/molecule/Molecule$Bonds\n*L\n142#1:707,7\n145#1:714\n180#1:716,2\n211#1:718\n211#1:719,3\n*E\n"})
    public final class Bonds {
        @NotNull
        private final IdentityHashMap<Atom, Set<Atom>> adjacency = new IdentityHashMap();

        @NotNull
        public final IdentityHashMap<Atom, Set<Atom>> getAdjacency$osprey3() {
            return this.adjacency;
        }

        @NotNull
        public final Set<Atom> bondedAtoms(@NotNull Atom atom) {
            Object object;
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            Map $this$getOrPut$iv = this.adjacency;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(atom);
            if (value$iv == null) {
                boolean bl = false;
                Set<Atom> answer$iv = Atom.Companion.identitySet();
                $this$getOrPut$iv.put(atom, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            Intrinsics.checkNotNullExpressionValue(object, (String)"adjacency.getOrPut(atom) { Atom.identitySet() }");
            return (Set)object;
        }

        @NotNull
        public final List<Atom> bondedAtomsSorted(@NotNull Atom atom) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            Iterable $this$sortedBy$iv = this.bondedAtoms(atom);
            boolean $i$f$sortedBy = false;
            return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    Atom it = (Atom)a;
                    boolean bl = false;
                    Comparable comparable = (Comparable)((Object)it.getName());
                    it = (Atom)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.getName())));
                }
            });
        }

        public final boolean add(@NotNull Atom a1, @NotNull Atom a2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
            Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
            if (a1 == a2) {
                throw new IllegalArgumentException("no self bonds allowed");
            }
            LangKt.assert$default(null, (Function0)new Function0<Boolean>(Molecule.this, a1){
                final /* synthetic */ Molecule this$0;
                final /* synthetic */ Atom $a1;
                {
                    this.this$0 = $receiver;
                    this.$a1 = $a1;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke() {
                    boolean bl;
                    block3: {
                        void $this$any$iv;
                        Iterable iterable = this.this$0.getAtoms();
                        Atom atom = this.$a1;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Atom it = (Atom)element$iv;
                                boolean bl2 = false;
                                if (!(it == atom)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, 1, null);
            LangKt.assert$default(null, (Function0)new Function0<Boolean>(Molecule.this, a2){
                final /* synthetic */ Molecule this$0;
                final /* synthetic */ Atom $a2;
                {
                    this.this$0 = $receiver;
                    this.$a2 = $a2;
                    super(0);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke() {
                    boolean bl;
                    block3: {
                        void $this$any$iv;
                        Iterable iterable = this.this$0.getAtoms();
                        Atom atom = this.$a2;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl = false;
                        } else {
                            for (T element$iv : $this$any$iv) {
                                Atom it = (Atom)element$iv;
                                boolean bl2 = false;
                                if (!(it == atom)) continue;
                                bl = true;
                                break block3;
                            }
                            bl = false;
                        }
                    }
                    return bl;
                }
            }, 1, null);
            boolean wasAdded1 = this.bondedAtoms(a1).add(a2);
            boolean wasAdded2 = this.bondedAtoms(a2).add(a1);
            boolean bl2 = bl = wasAdded1 == wasAdded2;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "bond adjacency table mismatch";
                throw new AssertionError((Object)string);
            }
            return wasAdded1;
        }

        public final boolean add(@NotNull AtomPair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
            return this.add(pair.getA(), pair.getB());
        }

        public final boolean remove(@NotNull Atom a1, @NotNull Atom a2) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
            Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
            boolean wasRemoved1 = this.bondedAtoms(a1).remove(a2);
            boolean wasRemoved2 = this.bondedAtoms(a2).remove(a1);
            boolean bl2 = bl = wasRemoved1 == wasRemoved2;
            if (_Assertions.ENABLED && !bl) {
                boolean bl3 = false;
                String string = "bond adjacency table mismatch";
                throw new AssertionError((Object)string);
            }
            return wasRemoved1;
        }

        public final boolean remove(@NotNull AtomPair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
            return this.remove(pair.getA(), pair.getB());
        }

        public final boolean isBonded(@NotNull Atom a1, @NotNull Atom a2) {
            Object v0;
            block1: {
                Intrinsics.checkNotNullParameter((Object)a1, (String)"a1");
                Intrinsics.checkNotNullParameter((Object)a2, (String)"a2");
                Iterable iterable = this.bondedAtoms(a1);
                for (Object t : iterable) {
                    Atom it = (Atom)t;
                    boolean bl = false;
                    if (!(it == a2)) continue;
                    v0 = t;
                    break block1;
                }
                v0 = null;
            }
            return v0 != null;
        }

        public final boolean isBonded(@NotNull AtomPair pair) {
            Intrinsics.checkNotNullParameter((Object)pair, (String)"pair");
            return this.isBonded(pair.getA(), pair.getB());
        }

        public final void clear() {
            Collection<Set<Atom>> collection = this.adjacency.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"adjacency.values");
            Iterable $this$forEach$iv = collection;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Set it = (Set)element$iv;
                boolean bl = false;
                it.clear();
            }
        }

        /*
         * WARNING - void declaration
         */
        public final int count() {
            Collection<Set<Atom>> collection = this.adjacency.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"adjacency.values");
            Iterable iterable = collection;
            int n = 0;
            for (Object t : iterable) {
                void it;
                Set set = (Set)t;
                int n2 = n;
                boolean bl = false;
                int n3 = it.size();
                n = n2 + n3;
            }
            return n / 2;
        }

        @NotNull
        public final Set<AtomPair> toSet() {
            LinkedHashSet<AtomPair> linkedHashSet = new LinkedHashSet<AtomPair>();
            Molecule molecule = Molecule.this;
            LinkedHashSet<AtomPair> $this$toSet_u24lambda_u247 = linkedHashSet;
            boolean bl = false;
            for (Atom a1 : molecule.getAtoms()) {
                for (Atom a2 : this.bondedAtomsSorted(a1)) {
                    $this$toSet_u24lambda_u247.add(new AtomPair(a1, a2));
                }
            }
            return linkedHashSet;
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<Set<Atom>> connectedComponents(@NotNull Collection<Atom> amongAtoms) {
            Intrinsics.checkNotNullParameter(amongAtoms, (String)"amongAtoms");
            ArrayList<Set<Atom>> out = new ArrayList<Set<Atom>>();
            Set<Atom> atomQueue = MoleculeKt.toIdentitySet(amongAtoms);
            while (!((Collection)atomQueue).isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Atom atom = (Atom)CollectionsKt.first((Iterable)atomQueue);
                Iterable<Searched> iterable = Molecule.this.dfs(atom, true, (Function3<? super Atom, ? super Atom, ? super Integer, Boolean>)((Function3)new Function3<Atom, Atom, Integer, Boolean>(atomQueue){
                    final /* synthetic */ Set<Atom> $atomQueue;
                    {
                        this.$atomQueue = $atomQueue;
                        super(3);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull Atom atom, @NotNull Atom to, int n) {
                        Intrinsics.checkNotNullParameter((Object)atom, (String)"<anonymous parameter 0>");
                        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
                        return this.$atomQueue.contains(to);
                    }
                }));
                boolean $i$f$map = false;
                void var8_8 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Searched searched = (Searched)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add(it.getAtom());
                }
                Set<Atom> component2 = MoleculeKt.toIdentitySet((List)destination$iv$iv);
                atomQueue.removeAll((Collection)component2);
                out.add(component2);
            }
            return out;
        }

        public static /* synthetic */ List connectedComponents$default(Bonds bonds2, Collection collection, int n, Object object) {
            if ((n & 1) != 0) {
                collection = bonds2.Molecule.this.getAtoms();
            }
            return bonds2.connectedComponents(collection);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule$Companion;", "", "()V", "osprey3"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00060\u0001j\u0002`\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule$DuplicateAtomNameException;", "Ljava/lang/IllegalArgumentException;", "Lkotlin/IllegalArgumentException;", "id", "", "(Ljava/lang/String;)V", "getId", "()Ljava/lang/String;", "osprey3"})
    public static final class DuplicateAtomNameException
    extends IllegalArgumentException {
        @NotNull
        private final String id;

        public DuplicateAtomNameException(@NotNull String id) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            super("Atoms have duplicate names: " + id);
            this.id = id;
        }

        @NotNull
        public final String getId() {
            return this.id;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule$SearchType;", "", "(Ljava/lang/String;I)V", "DFS", "BFS", "osprey3"})
    private static final class SearchType
    extends Enum<SearchType> {
        public static final /* enum */ SearchType DFS = new SearchType();
        public static final /* enum */ SearchType BFS = new SearchType();
        private static final /* synthetic */ SearchType[] $VALUES;

        public static SearchType[] values() {
            return (SearchType[])$VALUES.clone();
        }

        public static SearchType valueOf(String value2) {
            return Enum.valueOf(SearchType.class, value2);
        }

        static {
            $VALUES = searchTypeArray = new SearchType[]{SearchType.DFS, SearchType.BFS};
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Ledu/duke/cs/osprey/molscope/molecule/Molecule$Searched;", "", "atom", "Ledu/duke/cs/osprey/molscope/molecule/Atom;", "dist", "", "(Ledu/duke/cs/osprey/molscope/molecule/Atom;I)V", "getAtom", "()Ledu/duke/cs/osprey/molscope/molecule/Atom;", "getDist", "()I", "component1", "component2", "copy", "equals", "", "other", "hashCode", "toString", "", "osprey3"})
    public static final class Searched {
        @NotNull
        private final Atom atom;
        private final int dist;

        public Searched(@NotNull Atom atom, int dist) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            this.atom = atom;
            this.dist = dist;
        }

        @NotNull
        public final Atom getAtom() {
            return this.atom;
        }

        public final int getDist() {
            return this.dist;
        }

        @NotNull
        public final Atom component1() {
            return this.atom;
        }

        public final int component2() {
            return this.dist;
        }

        @NotNull
        public final Searched copy(@NotNull Atom atom, int dist) {
            Intrinsics.checkNotNullParameter((Object)atom, (String)"atom");
            return new Searched(atom, dist);
        }

        public static /* synthetic */ Searched copy$default(Searched searched, Atom atom, int n, int n2, Object object) {
            if ((n2 & 1) != 0) {
                atom = searched.atom;
            }
            if ((n2 & 2) != 0) {
                n = searched.dist;
            }
            return searched.copy(atom, n);
        }

        @NotNull
        public String toString() {
            return "Searched(atom=" + this.atom + ", dist=" + this.dist + ")";
        }

        public int hashCode() {
            int result = this.atom.hashCode();
            result = result * 31 + Integer.hashCode(this.dist);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Searched)) {
                return false;
            }
            Searched searched = (Searched)other;
            if (!Intrinsics.areEqual((Object)this.atom, (Object)searched.atom)) {
                return false;
            }
            return this.dist == searched.dist;
        }
    }
}

