/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.control.ParamSet;
import edu.duke.cs.osprey.multistatekstar.KStarScore;
import edu.duke.cs.osprey.multistatekstar.LMB;
import edu.duke.cs.osprey.multistatekstar.MSSearchProblem;
import edu.duke.cs.osprey.multistatekstar.ResidueOrder;
import edu.duke.cs.osprey.multistatekstar.ResidueOrderFactory;
import java.math.BigDecimal;
import java.util.ArrayList;

public class MSKStarNode {
    public static LMB OBJ_FUNC;
    public static ArrayList<String[]> WT_SEQS;
    public static int NUM_MAX_MUT;
    private KStarScore[] ksLB;
    private KStarScore[] ksUB;
    private KStarScore[] ksObjFunc;
    private BigDecimal[] kss;
    private BigDecimal score;

    public MSKStarNode(KStarScore[] ksLB, KStarScore[] ksUB) {
        this.ksLB = ksLB;
        this.ksUB = ksUB;
        this.ksObjFunc = new KStarScore[ksLB.length];
        this.kss = new BigDecimal[ksLB.length];
        this.score = null;
    }

    public boolean isFullyAssigned() {
        return this.ksLB[0].isFullyAssigned();
    }

    public ArrayList<MSKStarNode> split(ParamSet msParams) {
        this.ksObjFunc = this.getStateKStarObjects(OBJ_FUNC);
        MSSearchProblem[][] objFcnSearch = new MSSearchProblem[this.ksObjFunc.length][];
        for (int state = 0; state < objFcnSearch.length; ++state) {
            objFcnSearch[state] = this.ksObjFunc[state].getSettings().search;
        }
        ResidueOrder order = ResidueOrderFactory.getResidueOrder(msParams, objFcnSearch);
        order.getNextAssignments(objFcnSearch, NUM_MAX_MUT - this.getNumMutations(0));
        return null;
    }

    private int getNumMutations(int state) {
        KStarScore score = this.ksLB[state];
        int boundState = score.getSettings().search.length - 1;
        ArrayList<ArrayList<String>> AATypeOptions = score.getSettings().search[boundState].settings.AATypeOptions;
        int ans = 0;
        for (int pos : score.getSettings().search[boundState].getPosNums(true)) {
            if (AATypeOptions.get(pos).size() > 0) {
                ++ans;
                continue;
            }
            if (AATypeOptions.get(pos).get(0).equalsIgnoreCase(WT_SEQS.get(state)[pos])) continue;
            ++ans;
        }
        return ans;
    }

    public BigDecimal getScore() {
        return this.score;
    }

    public void setScore(LMB lmb) {
        this.score = lmb.eval(this.getStateKStarScores(lmb));
    }

    public BigDecimal[] getStateKStarScores(LMB lmb) {
        BigDecimal[] coeffs = lmb.getCoeffs();
        for (int i = 0; i < coeffs.length; ++i) {
            if (coeffs[i].compareTo(BigDecimal.ZERO) < 0) {
                this.kss[i] = this.ksUB[i].getUpperBoundScore();
                continue;
            }
            if (coeffs[i].compareTo(BigDecimal.ZERO) > 0) {
                this.kss[i] = this.ksLB[i].getLowerBoundScore();
                continue;
            }
            if (lmb.equals(OBJ_FUNC)) {
                throw new RuntimeException("ERROR: objective function coefficient cannot be 0");
            }
            this.kss[i] = BigDecimal.ZERO;
        }
        return this.kss;
    }

    public KStarScore[] getStateKStarObjects(LMB lmb) {
        BigDecimal[] coeffs = lmb.getCoeffs();
        for (int i = 0; i < coeffs.length; ++i) {
            if (coeffs[i].compareTo(BigDecimal.ZERO) < 0) {
                this.ksObjFunc[i] = this.ksUB[i];
                continue;
            }
            if (coeffs[i].compareTo(BigDecimal.ZERO) > 0) {
                this.ksObjFunc[i] = this.ksLB[i];
                continue;
            }
            if (lmb.equals(OBJ_FUNC)) {
                throw new RuntimeException("ERROR: objective function coefficient cannot be 0");
            }
            this.ksObjFunc = null;
        }
        return this.ksObjFunc;
    }

    public boolean isLeafNode() {
        for (int i = 0; i < this.ksLB.length; ++i) {
            if (this.ksLB[i].isFullyProcessed()) continue;
            return false;
        }
        return true;
    }

    public boolean constrSatisfied() {
        for (KStarScore score : this.getStateKStarObjects(OBJ_FUNC)) {
            if (score == null || score.constrSatisfied()) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "";
    }
}

