/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.astar.comets.UpdatedPruningMatrix;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.multistatekstar.MSSearchSettings;
import edu.duke.cs.osprey.pruning.Pruner;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;

public class MSSearchProblem
extends SearchProblem {
    public MSSearchSettings settings;
    private int numAssignedPos;

    public MSSearchProblem(SearchProblem other, MSSearchSettings settings) {
        super(other);
        if (settings == null) {
            throw new RuntimeException("ERROR: search settings cannot be null");
        }
        this.settings = settings;
        this.numAssignedPos = other.confSpace.numPos - Collections.frequency(settings.mutRes, "-1");
    }

    public ArrayList<Integer> getPosNums(boolean assigned) {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (int i = 0; i < this.settings.mutRes.size(); ++i) {
            if (!assigned && this.settings.mutRes.get(i).equals("-1")) {
                ans.add(i);
                continue;
            }
            if (!assigned || this.settings.mutRes.get(i).equals("-1")) continue;
            ans.add(i);
        }
        ans.trimToSize();
        return ans;
    }

    public ArrayList<String> getAssignedAAs() {
        ArrayList<String> ans = new ArrayList<String>();
        for (int i : this.getPosNums(true)) {
            ans.add(this.settings.AATypeOptions.get(i).get(0));
        }
        ans.trimToSize();
        return ans;
    }

    public int getNumUnAssignedPos() {
        return this.confSpace.numPos - this.numAssignedPos;
    }

    public int getNumAssignedPos() {
        return this.numAssignedPos;
    }

    public boolean isFullyAssigned() {
        return this.numAssignedPos == this.confSpace.numPos;
    }

    public ArrayList<Integer> unprunedAtPos(PruningMatrix pruneMat, int pos, String AAType) {
        ArrayList<Integer> ans = new ArrayList<Integer>();
        for (int rc : pruneMat.unprunedRCsAtPos(pos)) {
            String type = this.confSpace.posFlex.get((int)pos).RCs.get((int)rc).AAType;
            if (!AAType.equalsIgnoreCase(type)) continue;
            ans.add(rc);
        }
        return ans;
    }

    public void setPruningMatrix() {
        this.pruneMat = this.updatePruningMatrix(this.getPosNums(true), this.settings.AATypeOptions);
    }

    public void setPruningMatrix(PruningMatrix pmat) {
        this.pruneMat = pmat;
    }

    private BigInteger getNumConfs(PruningMatrix pmat) {
        BigInteger ans = BigInteger.ONE;
        for (int pos = 0; pos < pmat.getNumPos(); ++pos) {
            if ((ans = ans.multiply(BigInteger.valueOf(pmat.unprunedRCsAtPos(pos).size()))).compareTo(BigInteger.ZERO) != 0) continue;
            return ans;
        }
        return ans;
    }

    public PruningMatrix updatePruningMatrix(ArrayList<Integer> splitPosNums, ArrayList<ArrayList<String>> splitAAs) {
        UpdatedPruningMatrix ans = new UpdatedPruningMatrix(this.pruneMat);
        for (int pos : splitPosNums) {
            for (int rc : this.pruneMat.unprunedRCsAtPos(pos)) {
                String rcAAType = this.confSpace.posFlex.get((int)pos).RCs.get((int)rc).AAType;
                if (splitAAs.get(pos).contains(rcAAType)) continue;
                ans.markAsPruned(new RCTuple(pos, rc));
            }
        }
        return ans;
    }

    public PruningMatrix updatePruningMatrix(int splitPos, String splitAA) {
        UpdatedPruningMatrix ans = new UpdatedPruningMatrix(this.pruneMat);
        for (int rc : this.pruneMat.unprunedRCsAtPos(splitPos)) {
            String rcAAType = this.confSpace.posFlex.get((int)splitPos).RCs.get((int)rc).AAType;
            if (splitAA.equals(rcAAType)) continue;
            ans.markAsPruned(new RCTuple(splitPos, rc));
        }
        return ans;
    }

    private void prunePmat(SearchProblem search2) {
        int oldNumUpdates;
        UpdatedPruningMatrix upmat = (UpdatedPruningMatrix)this.pruneMat;
        BigInteger minConfs = BigInteger.valueOf(65536L);
        int numUpdates = upmat.countUpdates();
        Pruner dee = new Pruner(search2, upmat, true, this.settings.stericThreshold, this.settings.pruningWindow, search2.useEPIC, search2.useTupExpForSearch);
        dee.setVerbose(false);
        do {
            oldNumUpdates = numUpdates;
            dee.prune("GOLDSTEIN");
            dee.prune("GOLDSTEIN PAIRS FULL");
        } while ((numUpdates = upmat.countUpdates()) > oldNumUpdates && this.getNumConfs(upmat).compareTo(minConfs) > 0);
    }

    public void prunePmat() {
        this.prunePmat(this);
    }
}

