/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.multistatekstar;

import edu.duke.cs.osprey.ematrix.EnergyMatrix;
import edu.duke.cs.osprey.gmec.ConfSearchFactory;
import edu.duke.cs.osprey.gmec.GMECConfEnergyCalculator;
import edu.duke.cs.osprey.kstar.pfunc.PartitionFunction;
import edu.duke.cs.osprey.multistatekstar.PartitionFunctionDiscrete;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class PartitionFunctionDiscreteUppperBound
extends PartitionFunctionDiscrete {
    public PartitionFunctionDiscreteUppperBound(EnergyMatrix emat, PruningMatrix pmat, PruningMatrix invmat, ConfSearchFactory confSearchFactory, GMECConfEnergyCalculator.Async ecalc) {
        super(emat, pmat, invmat, confSearchFactory, ecalc);
    }

    @Override
    public void compute(int maxNumConfs) {
        super.compute(maxNumConfs);
        if (this.status == PartitionFunction.Status.Estimated) {
            this.values.qstar = this.values.qstar.multiply(new BigDecimal(1.0 + this.getEffectiveEpsilon()));
        }
    }

    @Override
    public void compute(BigDecimal targetScoreWeights) {
        super.compute(targetScoreWeights);
        this.values.qstar = this.values.qstar.multiply(new BigDecimal(1.0 + this.getEffectiveEpsilon()));
    }

    @Override
    protected double getEffectiveEpsilon() {
        BigDecimal s = this.values.qprime.add(this.values.pstar);
        BigDecimal q = s.add(this.values.qstar);
        if (q.compareTo(BigDecimal.ZERO) == 0) {
            return Double.NaN;
        }
        return s.divide(this.values.qstar, RoundingMode.HALF_UP).doubleValue();
    }
}

