/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.parallelism.Signal;
import edu.duke.cs.osprey.parallelism.TaskExecutor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ConcurrentTaskExecutor
extends TaskExecutor {
    private final AtomicLong numTasksStarted = new AtomicLong(0L);
    private final AtomicLong numTasksFinished = new AtomicLong(0L);
    private Signal taskSignal = new Signal();
    private AtomicReference<TaskExecutor.TaskException> exception = new AtomicReference<Object>(null);

    @Override
    public abstract int getParallelism();

    @Override
    public abstract <T> void submit(TaskExecutor.Task<T> var1, TaskExecutor.TaskListener<T> var2);

    @Override
    public boolean isBusy() {
        return this.getNumRunningTasks() >= (long)this.getParallelism();
    }

    @Override
    public boolean isWorking() {
        return this.getNumRunningTasks() > 0L;
    }

    @Override
    public void waitForFinish() {
        long numTasks = this.numTasksStarted.get();
        while (this.numTasksFinished.get() < numTasks) {
            this.taskSignal.waitForSignal(100L);
        }
        TaskExecutor.TaskException t = this.exception.get();
        if (t != null) {
            throw t;
        }
    }

    public long getNumRunningTasks() {
        return this.numTasksStarted.get() - this.numTasksFinished.get();
    }

    protected <T> void taskSuccess(TaskExecutor.Task<T> task, TaskExecutor.TaskListener<T> listener, T result) {
        try {
            listener.onFinished(result);
        }
        catch (Throwable t) {
            this.recordException(task, listener, t);
        }
        this.finishedTask();
    }

    protected void taskSuccessCoerceTypes(TaskExecutor.Task<?> task, TaskExecutor.TaskListener<?> listener, Object result) {
        try {
            TaskExecutor.TaskListener<?> listenerObj = listener;
            listenerObj.onFinished(result);
        }
        catch (Throwable t) {
            this.recordException(task, listener, t);
        }
        this.finishedTask();
    }

    protected void taskFailure(TaskExecutor.Task<?> task, TaskExecutor.TaskListener<?> listener, Throwable t) {
        this.recordException(task, listener, t);
        this.finishedTask();
    }

    protected void checkException() {
        if (this.exception.get() != null) {
            this.waitForFinish();
        }
    }

    protected void recordException(TaskExecutor.Task<?> task, TaskExecutor.TaskListener<?> listener, Throwable t) {
        this.exception.compareAndSet(null, new TaskExecutor.TaskException(task, listener, t));
    }

    protected void startedTask() {
        this.numTasksStarted.incrementAndGet();
    }

    protected void finishedTask() {
        this.numTasksFinished.incrementAndGet();
        this.taskSignal.sendSignal();
    }
}

