/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;

public class PulseSignal {
    private final Sync sync = new Sync();

    public void signal() {
        this.sync.release(1);
    }

    public Result waitForSignal(long timeout, TimeUnit timeUnit) {
        try {
            if (this.sync.tryAcquireNanos(1, timeUnit.toNanos(timeout))) {
                return Result.Signaled;
            }
            return Result.TimedOut;
        }
        catch (InterruptedException ex) {
            throw new Error(ex);
        }
    }

    private static class Sync
    extends AbstractQueuedSynchronizer {
        Sync() {
            this.setState(0);
        }

        @Override
        protected boolean tryAcquire(int acquires) {
            int state;
            do {
                if ((state = this.getState()) > 0) continue;
                return false;
            } while (!this.compareAndSetState(state, state - 1));
            return true;
        }

        @Override
        protected boolean tryRelease(int releases) {
            int state;
            while (!this.compareAndSetState(state = this.getState(), state + 1)) {
            }
            return true;
        }
    }

    public static enum Result {
        Signaled,
        TimedOut;

    }
}

