/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.tools.AutoCleanable;
import edu.duke.cs.osprey.tools.HashCalculator;
import java.util.HashMap;
import java.util.Map;

public class TaskExecutor
implements AutoCleanable {
    private ContextGroup contextGroup = null;

    public int getParallelism() {
        return 1;
    }

    public ContextGroup contextGroup() {
        if (this.contextGroup != null) {
            throw new IllegalStateException("only one context group can be active at a time");
        }
        return new ContextGroup();
    }

    public boolean isBusy() {
        return false;
    }

    public boolean isWorking() {
        return false;
    }

    public <T> void submit(Task<T> task, TaskListener<T> listener) {
        listener.onFinished(this.runTask(task));
    }

    protected <T> T runTask(Task<T> task) {
        if (task instanceof Task.WithContext) {
            Task.WithContext taskWithContext = (Task.WithContext)task;
            if (this.contextGroup == null) {
                throw new IllegalStateException("task with context was submitted, but no context group was active");
            }
            Object ctx = this.contextGroup.getContext(taskWithContext);
            return taskWithContext.run(ctx);
        }
        return task.run();
    }

    public void waitForFinish() {
    }

    @Override
    public void clean() {
    }

    public class ContextGroup
    implements AutoCloseable {
        private Map<ContextId, Object> contexts = new HashMap<ContextId, Object>();

        protected ContextGroup() {
            TaskExecutor.this.contextGroup = this;
        }

        public void putContext(ContextId ctxid, Object ctx) {
            this.contexts.put(ctxid, ctx);
        }

        public void putContext(int instanceId, Class<?> taskClass, Object ctx) {
            this.putContext(new ContextId(instanceId, taskClass), ctx);
        }

        public Object getContext(ContextId ctxid) {
            return this.contexts.get(ctxid);
        }

        public Object getContext(int instanceId, Class<?> taskClass) {
            return this.getContext(new ContextId(instanceId, taskClass));
        }

        public <T, C> C getContext(Task.WithContext<T, C> task) {
            Object ctx = this.getContext(task.contextId());
            return (C)ctx;
        }

        @Override
        public void close() {
            TaskExecutor.this.contextGroup = null;
        }
    }

    public static interface Task<T> {
        public T run();

        public static interface WithContext<T, C>
        extends Task<T> {
            public int instanceId();

            public T run(C var1);

            default public ContextId contextId() {
                return new ContextId(this.instanceId(), this.getClass());
            }

            @Override
            default public T run() {
                return this.run(null);
            }
        }
    }

    public static interface TaskListener<T> {
        public void onFinished(T var1);
    }

    public static class TaskException
    extends RuntimeException {
        private static final long serialVersionUID = 8523925290195831558L;
        public final Task<?> task;
        public final TaskListener<?> listener;

        public TaskException(Task<?> task, TaskListener<?> listener, Throwable cause) {
            super("A task failed, no new tasks can be submitted", cause);
            this.task = task;
            this.listener = listener;
        }
    }

    public static class ContextId {
        public final int instanceId;
        public final Class<?> taskClass;

        public ContextId(int instanceId, Class<?> taskClass) {
            this.instanceId = instanceId;
            this.taskClass = taskClass;
        }

        public int hashCode() {
            return HashCalculator.combineHashes(this.instanceId, this.taskClass.hashCode());
        }

        public boolean equals(Object other) {
            return other instanceof ContextId && this.equals((ContextId)other);
        }

        public boolean equals(ContextId other) {
            return this.instanceId == other.instanceId && this.taskClass.equals(other.taskClass);
        }
    }
}

