/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.parallelism;

import edu.duke.cs.osprey.parallelism.WorkCrew;
import edu.duke.cs.osprey.parallelism.WorkThread;

public abstract class Worker
extends WorkThread {
    private WorkCrew<Worker> crew;
    protected boolean hasWork;

    public Worker(WorkCrew<? extends Worker> crew) {
        super(crew.getName() + "-" + crew.workers.size());
        this.crew = crew;
        this.crew.workers.add(this);
        this.hasWork = false;
    }

    @Override
    public void doWork() throws InterruptedException {
        if (this.hasWork) {
            this.workIt();
            this.hasWork = false;
            this.crew.finishedWork();
        }
        this.crew.waitForWork(this, 1000);
    }

    protected abstract void workIt();
}

