/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.partcr;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RCSplits {
    private List<PosInfo> infoByPos = new ArrayList<PosInfo>();
    private Map<RC, RCInfo> infoByRC = new HashMap<RC, RCInfo>();

    public RCSplits(ConfSpace confSpace) {
        for (int pos = 0; pos < confSpace.numPos; ++pos) {
            PosInfo posInfo = new PosInfo(confSpace.posFlex.get(pos));
            this.infoByPos.add(posInfo);
            for (RCInfo rcInfo : posInfo.infoByRC) {
                this.infoByRC.put(rcInfo.parent, rcInfo);
            }
        }
    }

    public RCInfo getRCInfo(int pos, int parentRC) {
        return this.infoByPos.get((int)pos).infoByRC.get(parentRC);
    }

    public RCInfo getRCInfo(RC rcObj) {
        return this.infoByRC.get(rcObj);
    }

    public void split(RC rcObj, List<RC> splitRCs) {
        RCInfo info2 = this.infoByRC.get(rcObj);
        info2.children.remove(rcObj);
        info2.children.addAll(splitRCs);
        this.infoByRC.remove(rcObj);
        for (RC splitRCObj : splitRCs) {
            this.infoByRC.put(splitRCObj, info2);
        }
    }

    public RCs makeRCs(int[] conf) {
        int numPos = this.infoByPos.size();
        ArrayList<List<Integer>> rcsByPos = new ArrayList<List<Integer>>(numPos);
        for (int pos = 0; pos < numPos; ++pos) {
            rcsByPos.add(this.getRCInfo(pos, conf[pos]).getRCs());
        }
        return new RCs(rcsByPos);
    }

    public static class PosInfo {
        private List<RCInfo> infoByRC = new ArrayList<RCInfo>();

        public PosInfo(PositionConfSpace posConfSpace) {
            for (RC rcObj : posConfSpace.RCs) {
                this.infoByRC.add(new RCInfo(rcObj));
            }
        }
    }

    public static class RCInfo {
        private RC parent;
        private List<RC> children;

        public RCInfo(RC rcObj) {
            this.parent = rcObj;
            this.children = new ArrayList<RC>();
        }

        public RC getParent() {
            return this.parent;
        }

        public boolean isSplit() {
            return !this.children.isEmpty();
        }

        public int getNumVoxels() {
            if (this.isSplit()) {
                return this.children.size();
            }
            return 1;
        }

        public List<Integer> getRCs() {
            ArrayList<Integer> rcs = new ArrayList<Integer>();
            if (this.isSplit()) {
                for (RC child : this.children) {
                    rcs.add(child.RCIndex);
                }
            } else {
                rcs.add(this.parent.RCIndex);
            }
            return rcs;
        }
    }
}

