/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.partcr;

import edu.duke.cs.osprey.astar.conf.ConfAStarTree;
import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.PositionConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCIndexMap;
import edu.duke.cs.osprey.confspace.SearchProblem;
import edu.duke.cs.osprey.ematrix.LazyEnergyMatrix;
import edu.duke.cs.osprey.ematrix.SimpleEnergyCalculator;
import edu.duke.cs.osprey.energy.forcefield.ForcefieldParams;
import edu.duke.cs.osprey.partcr.RCSplits;
import edu.duke.cs.osprey.pruning.PruningMatrix;
import java.util.ArrayList;
import java.util.List;

public class SplitWorld {
    private SearchProblem search;
    private RCSplits splits;
    private List<RCIndexMap> rcMaps;
    private SimpleEnergyCalculator ecalc;

    public SplitWorld(SearchProblem search2, ForcefieldParams ffparams) {
        int pos;
        this.search = new SearchProblem(search2);
        this.search.confSpace = new ConfSpace(search2.confSpace);
        for (pos = 0; pos < this.search.confSpace.numPos; ++pos) {
            this.search.confSpace.posFlex.set(pos, new PositionConfSpace(search2.confSpace.posFlex.get(pos)));
        }
        this.splits = new RCSplits(this.search.confSpace);
        this.rcMaps = new ArrayList<RCIndexMap>();
        for (pos = 0; pos < this.search.confSpace.numPos; ++pos) {
            this.rcMaps.add(null);
        }
        this.ecalc = new SimpleEnergyCalculator.Cpu(ffparams, this.search.confSpace, this.search.shellResidues);
        this.search.fullConfE = this.ecalc.getEnergyFunctionGenerator().fullConfEnergy(this.search.confSpace, this.search.shellResidues);
        this.search.emat = new LazyEnergyMatrix(this.search.emat, this.ecalc);
        this.search.pruneMat = new PruningMatrix(this.search.pruneMat);
    }

    public SearchProblem getSearchProblem() {
        return this.search;
    }

    public RCSplits getSplits() {
        return this.splits;
    }

    public RC getRC(int pos, int rc) {
        return this.search.confSpace.posFlex.get((int)pos).RCs.get(rc);
    }

    public void replaceRc(int pos, RC rc, List<RC> splitRCs) {
        this.splits.split(rc, splitRCs);
        RCIndexMap map = this.search.confSpace.posFlex.get(pos).replaceRC(rc, splitRCs);
        this.rcMaps.set(pos, map);
    }

    public RCIndexMap getRcMap(int pos) {
        return this.rcMaps.get(pos);
    }

    public void resizeMatrices() {
        int pos1;
        int numPos = this.search.confSpace.numPos;
        assert (this.search.emat != null);
        LazyEnergyMatrix oldEmat = (LazyEnergyMatrix)this.search.emat;
        LazyEnergyMatrix newEmat = new LazyEnergyMatrix(this.search.confSpace, oldEmat.getPruningInterval(), this.ecalc);
        for (pos1 = 0; pos1 < numPos; ++pos1) {
            RCIndexMap rcMap1 = this.rcMaps.get(pos1);
            for (int rc1 = 0; rc1 < newEmat.getNumConfAtPos(pos1); ++rc1) {
                Integer oldRc1 = rc1;
                if (rcMap1 != null) {
                    oldRc1 = rcMap1.newToOld(rc1);
                }
                if (oldRc1 != null) {
                    if (oldEmat.hasOneBody(pos1, oldRc1)) {
                        newEmat.setOneBody(pos1, rc1, oldEmat.getOneBody(pos1, oldRc1));
                    }
                } else {
                    newEmat.setOneBody(pos1, rc1, this.ecalc.calcSingle((int)pos1, (int)rc1).energy);
                }
                for (int pos2 = 0; pos2 < pos1; ++pos2) {
                    RCIndexMap rcMap2 = this.rcMaps.get(pos2);
                    for (int rc2 = 0; rc2 < newEmat.getNumConfAtPos(pos2); ++rc2) {
                        Integer oldRc2 = rc2;
                        if (rcMap2 != null) {
                            oldRc2 = rcMap2.newToOld(rc2);
                        }
                        if (oldRc1 == null || oldRc2 == null || !oldEmat.hasPairwise(pos1, oldRc1, pos2, oldRc2)) continue;
                        newEmat.setPairwise(pos1, rc1, pos2, rc2, oldEmat.getPairwise(pos1, oldRc1, pos2, oldRc2));
                    }
                }
            }
        }
        this.search.emat = newEmat;
        for (pos1 = 0; pos1 < numPos; ++pos1) {
            this.rcMaps.set(pos1, null);
        }
    }

    public ConfSearch.ScoredConf translateConf(ConfSearch.ScoredConf conf) {
        RCs subRcs = this.splits.makeRCs(conf.getAssignments());
        ConfAStarTree tree = new ConfAStarTree.Builder(this.search.emat, subRcs).setMPLP(new ConfAStarTree.MPLPBuilder().setNumIterations(1)).build();
        return tree.nextConf();
    }
}

