/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.partcr.splitters;

import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.partcr.splitters.RCSplitter;
import java.util.ArrayList;
import java.util.List;

public class SmartRCSplitter
extends RCSplitter {
    private double[] dofBoundValues;
    private int baseDofIndex;

    public SmartRCSplitter(double[] dofBoundValues, int baseDofIndex) {
        this.dofBoundValues = dofBoundValues;
        this.baseDofIndex = baseDofIndex;
    }

    @Override
    public List<RC> split(int pos, RC rc) {
        ArrayList<RC> rcs = null;
        int widestDofIndex = this.getWidestDofIndex(rc);
        if (widestDofIndex >= 0) {
            double min = rc.DOFmin.get(widestDofIndex);
            double max = rc.DOFmax.get(widestDofIndex);
            double boundVal = this.getBoundVal(widestDofIndex);
            double currentVal = this.getCurrentVal(rc, widestDofIndex);
            double mid = (boundVal + currentVal) / 2.0;
            assert (boundVal >= min && boundVal <= max);
            assert (currentVal >= min && currentVal <= max);
            rcs = new ArrayList<RC>();
            rcs.add(this.makeRC(rc, widestDofIndex, min, mid));
            rcs.add(this.makeRC(rc, widestDofIndex, mid, max));
        }
        return rcs;
    }

    private int getWidestDofIndex(RC rc) {
        double bestDist = 0.0;
        int bestIndex = -1;
        for (int i = 0; i < rc.DOFs.size(); ++i) {
            double dist = Math.abs(this.getBoundVal(i) - this.getCurrentVal(rc, i));
            if (!(dist > bestDist)) continue;
            bestDist = dist;
            bestIndex = i;
        }
        return bestIndex;
    }

    private double getBoundVal(int dofIndex) {
        return this.dofBoundValues[this.baseDofIndex + dofIndex];
    }

    private double getCurrentVal(RC rc, int dofIndex) {
        return rc.DOFs.get(dofIndex).getCurVal();
    }
}

