/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.paste;

import edu.duke.cs.osprey.astar.conf.RCs;
import edu.duke.cs.osprey.confspace.ConfDB;
import edu.duke.cs.osprey.confspace.ConfSearch;
import edu.duke.cs.osprey.energy.EnergyCalculator;
import edu.duke.cs.osprey.kstar.KStarScore;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.MathTools;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.function.Function;

public interface PastePartitionFunction {
    public static final MathContext decimalPrecision = new MathContext(64, RoundingMode.HALF_UP);

    public void setReportProgress(boolean var1);

    public void setConfListener(ConfListener var1);

    public void init(ConfSearch var1, ConfSearch var2, BigInteger var3, double var4, double var6, Result var8, boolean var9);

    default public void setStabilityThreshold(BigDecimal stabilityThreshold) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not yet support stability thresholds");
    }

    public Status getStatus();

    public ArrayList<EnergyCalculator.EnergiedParametricMolecule> getEpMols();

    public HashMap<Double, ConfSearch.ScoredConf> getSConfs();

    public Values getValues();

    public int getParallelism();

    public int getNumConfsEvaluated();

    public void compute(int var1, int var2);

    default public void compute() {
        this.compute(Integer.MAX_VALUE, 10);
    }

    default public Result makeResult() {
        return new Result(this.getStatus(), this.getEpMols(), this.getSConfs(), this.getValues(), this.getNumConfsEvaluated());
    }

    public static class Result {
        public final Status status;
        public final Values values;
        public final int numConfs;
        public final ArrayList<EnergyCalculator.EnergiedParametricMolecule> epMols;
        public final HashMap<Double, ConfSearch.ScoredConf> sConfs;

        public Result(Status status, ArrayList<EnergyCalculator.EnergiedParametricMolecule> epMols, HashMap<Double, ConfSearch.ScoredConf> sConfs, Values values2, int numConfs) {
            this.epMols = epMols;
            this.sConfs = sConfs;
            this.status = status;
            this.values = values2;
            this.numConfs = numConfs;
        }

        public void clearSomeResults() {
            this.epMols.clear();
            this.sConfs.clear();
        }

        public String toString() {
            Function<String, String> trim = s -> {
                if (s.length() > 9) {
                    return s.substring(0, 9);
                }
                return s;
            };
            StringBuilder buf = new StringBuilder();
            buf.append(String.format("[%-9s,%9s]", trim.apply(KStarScore.scoreToLog10String(this.values.calcLowerBound())), trim.apply(KStarScore.scoreToLog10String(this.values.calcUpperBound()))));
            if (this.status == Status.EpsilonReached) {
                buf.append(" (log10)");
            } else {
                buf.append(String.format(" %-26s", "(log10," + this.status.name() + ")"));
            }
            return buf.toString();
        }

        public static Result makeAborted() {
            return new Result(Status.Aborted, null, null, Values.makeFullRange(), 0);
        }
    }

    public static enum Status {
        Estimating(true),
        EpsilonReached(false),
        NoWindowOverlap(false),
        EnergyReached(false),
        ConfLimitReached(false),
        OutOfConformations(false),
        OutOfLowEnergies(false),
        Unstable(false),
        Aborted(false);

        private boolean canContinue;

        private Status(boolean canContinue) {
            this.canContinue = canContinue;
        }

        public boolean canContinue() {
            return this.canContinue;
        }
    }

    public static class Values {
        public BigDecimal qstar = BigDecimal.ZERO;
        public BigDecimal qprime = BigDecimal.ZERO;
        public BigDecimal pstar = BigDecimal.ZERO;

        public static Values makeFullRange() {
            Values values2 = new Values();
            values2.qprime = MathTools.BigPositiveInfinity;
            return values2;
        }

        public double getEffectiveEpsilon() {
            BigDecimal s = MathTools.bigAdd(this.qprime, this.pstar, decimalPrecision);
            BigDecimal qu = MathTools.bigAdd(s, this.qstar, decimalPrecision);
            return MathTools.bigDivide(s, qu, decimalPrecision).doubleValue();
        }

        public BigDecimal calcLowerBound() {
            return this.qstar;
        }

        public BigDecimal calcUpperBound() {
            return new BigMath(decimalPrecision).set(this.qstar).add(this.qprime).add(this.pstar).get();
        }
    }

    public static interface WithExternalMemory
    extends PastePartitionFunction {
        public void setUseExternalMemory(boolean var1, RCs var2);

        public static void setOrThrow(PastePartitionFunction pfunc, boolean val, RCs rcs) {
            if (!(pfunc instanceof WithExternalMemory)) {
                throw new UnsupportedException(pfunc);
            }
            ((WithExternalMemory)pfunc).setUseExternalMemory(val, rcs);
        }

        public static class UnsupportedException
        extends RuntimeException {
            public UnsupportedException(PastePartitionFunction pfunc) {
                super("This partition function implementation (" + pfunc.getClass().getSimpleName() + ") doesn't support external memory");
            }
        }
    }

    public static interface WithConfTable
    extends PastePartitionFunction {
        public void setConfTable(ConfDB.ConfTable var1);

        public static void setOrThrow(PastePartitionFunction pfunc, ConfDB.ConfTable table) {
            if (!(pfunc instanceof WithConfTable)) {
                throw new UnsupportedException(pfunc);
            }
            ((WithConfTable)pfunc).setConfTable(table);
        }

        public static class UnsupportedException
        extends RuntimeException {
            public UnsupportedException(PastePartitionFunction pfunc) {
                super("This partition function implementation (" + pfunc.getClass().getSimpleName() + ") doesn't support conformation database tables");
            }
        }
    }

    public static interface ConfListener {
        public void onConf(ConfSearch.ScoredConf var1);
    }
}

