/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.paste;

import edu.duke.cs.osprey.paste.PastePartitionFunction;
import edu.duke.cs.osprey.tools.BigMath;
import edu.duke.cs.osprey.tools.MathTools;
import java.util.function.Function;

public class PasteScore {
    public static double constRT = -0.593050165;
    public final PastePartitionFunction.Result protein;
    public final PastePartitionFunction.Result wt;
    public final Double score;
    public final Double lowerBound;
    public final Double upperBound;
    public String stability;

    public PasteScore(Double score, Double lowerBound, Double upperBound) {
        this.protein = null;
        this.wt = null;
        this.score = score;
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public PasteScore(PastePartitionFunction.Result protein, PastePartitionFunction.Result wt) {
        this.protein = protein;
        this.wt = wt;
        this.score = protein.status == PastePartitionFunction.Status.EnergyReached || protein.status == PastePartitionFunction.Status.ConfLimitReached || protein.status == PastePartitionFunction.Status.EpsilonReached || protein.status == PastePartitionFunction.Status.NoWindowOverlap ? (MathTools.isNaN(protein.values.qstar) ? null : Double.valueOf(constRT * Math.log(new BigMath(PastePartitionFunction.decimalPrecision).set(protein.values.calcLowerBound()).div(wt.values.calcLowerBound()).get().doubleValue()))) : null;
        this.lowerBound = constRT * Math.log(new BigMath(PastePartitionFunction.decimalPrecision).set(protein.values.calcUpperBound()).div(wt.values.calcLowerBound()).get().doubleValue());
        this.upperBound = constRT * Math.log(new BigMath(PastePartitionFunction.decimalPrecision).set(protein.values.calcLowerBound()).div(wt.values.calcUpperBound()).get().doubleValue());
        this.stability = this.upperBound < 0.0 && this.lowerBound < 0.0 ? "Mutation Increases Stability" : (this.upperBound > 0.0 && this.lowerBound > 0.0 ? "Mutation Decreases Stability" : "Affect on Stability Unclear");
    }

    public String toString() {
        Function<String, String> trim = s -> {
            if (s.length() > 9) {
                return s.substring(0, 9);
            }
            return s;
        };
        return String.format("%-9s in [%-9s,%9s]       %35s", trim.apply(PasteScore.scoreToString(this.score)), trim.apply(PasteScore.scoreToString(this.lowerBound)), trim.apply(PasteScore.scoreToString(this.upperBound)), this.stability);
    }

    public boolean equals(Object other) {
        return other instanceof PasteScore && this.equals((PasteScore)other);
    }

    public boolean equals(PasteScore other) {
        return this.score.equals(other.score) && this.lowerBound.equals(other.lowerBound) && this.upperBound.equals(other.upperBound);
    }

    public String lowerBoundLog10String() {
        return PasteScore.scoreToLog10String(this.protein.values.calcLowerBound().doubleValue());
    }

    public String upperBoundLog10String() {
        return PasteScore.scoreToLog10String(this.protein.values.calcUpperBound().doubleValue());
    }

    public static Double scoreToLog10(Double score) {
        if (score != null) {
            return Math.log10(score);
        }
        return null;
    }

    public static String scoreToString(Double score) {
        if (score != null) {
            return String.format("%f", score);
        }
        return "none";
    }

    public static String scoreToLog10String(Double score) {
        if (score != null) {
            return String.format("%f", PasteScore.scoreToLog10(score));
        }
        return "none";
    }
}

