/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.RC;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.dof.ResidueTypeDOF;
import edu.duke.cs.osprey.plug.ISAtomsIterable;
import edu.duke.cs.osprey.plug.RCTuplePolytope;
import edu.duke.cs.osprey.plug.Res2AtomsIterable;
import edu.duke.cs.osprey.plug.VoxelVDWDistExplorer;
import edu.duke.cs.osprey.plug.VoxelVDWListChecker;
import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.Residue;
import edu.duke.cs.osprey.tools.VectorAlgebra;
import java.util.ArrayList;
import java.util.HashSet;
import org.apache.commons.math3.optim.linear.LinearConstraint;

public class RCPairVDWChecker {
    Residue res1;
    Residue res2 = null;
    ArrayList<Residue> shellResidues = null;
    ArrayList<VoxelVDWListChecker.DOFInterval> dofIntervals = new ArrayList();
    ArrayList<LinearConstraint> voxLinConstr = new ArrayList();
    ResidueTypeDOF res1MutDOF = null;
    ResidueTypeDOF res2MutDOF = null;
    ArrayList<Atom[]> interactingAtoms;
    ArrayList<LinearConstraint> feasiblePolytope;

    public RCPairVDWChecker(Residue res1, RC rc1, Residue res2, RC rc2, ArrayList<Residue> shellResidues) {
        this.res1 = res1;
        this.res2 = res2;
        this.shellResidues = shellResidues;
        this.initDOFIntervals(rc1, rc2);
    }

    public RCPairVDWChecker(ConfSpace cSpace, RCTuple tup, ArrayList<Residue> shellResidues) {
        int pos1 = tup.pos.get(0);
        this.res1 = cSpace.posFlex.get((int)pos1).res;
        RC rc1 = cSpace.posFlex.get((int)pos1).RCs.get(tup.RCs.get(0));
        this.res1MutDOF = cSpace.mutDOFs.get(pos1);
        this.shellResidues = shellResidues;
        switch (tup.pos.size()) {
            case 1: {
                this.initDOFIntervals(rc1, null);
                break;
            }
            case 2: {
                int pos2 = tup.pos.get(1);
                this.res2 = cSpace.posFlex.get((int)pos2).res;
                RC rc2 = cSpace.posFlex.get((int)pos2).RCs.get(tup.RCs.get(1));
                this.res2MutDOF = cSpace.mutDOFs.get(pos2);
                this.initDOFIntervals(rc1, rc2);
                break;
            }
            default: {
                throw new RuntimeException("ERROR: Bad tuple size for RCPairVDWChecker");
            }
        }
    }

    private void initDOFIntervals(RC rc1, RC rc2) {
        double lb;
        DegreeOfFreedom curDOF;
        int dof;
        HashSet<DegreeOfFreedom> res1DOFs = new HashSet<DegreeOfFreedom>();
        for (dof = 0; dof < rc1.DOFs.size(); ++dof) {
            curDOF = rc1.DOFs.get(dof);
            lb = rc1.DOFmin.get(dof);
            this.dofIntervals.add(new VoxelVDWListChecker.DOFInterval(curDOF, lb, rc1.DOFmax.get(dof) - lb));
            res1DOFs.add(curDOF);
        }
        if (!rc1.AAType.equalsIgnoreCase(this.res1.template.name)) {
            this.res1MutDOF.mutateTo(rc1.AAType);
        }
        if (rc2 != null) {
            for (dof = 0; dof < rc2.DOFs.size(); ++dof) {
                curDOF = rc2.DOFs.get(dof);
                if (res1DOFs.contains(curDOF)) continue;
                lb = rc2.DOFmin.get(dof);
                this.dofIntervals.add(new VoxelVDWListChecker.DOFInterval(curDOF, lb, rc2.DOFmax.get(dof) - lb));
            }
            if (!rc2.AAType.equalsIgnoreCase(this.res2.template.name)) {
                this.res2MutDOF.mutateTo(rc2.AAType);
            }
        }
    }

    public boolean checkVDW() {
        return this.calcPolytopeConstr() != null;
    }

    public ArrayList<LinearConstraint> calcPolytopeConstr() {
        return this.calcPolytopeConstr(null);
    }

    public ArrayList<LinearConstraint> calcPolytopeConstr(ArrayList<String> atomPairNames) {
        this.interactingAtoms = new ArrayList();
        for (VoxelVDWListChecker.DOFInterval di : this.dofIntervals) {
            di.dof.apply(di.lb + di.range / 2.0);
        }
        double maxMotion = 3.0;
        VoxelVDWListChecker distChecker = new VoxelVDWListChecker(this.dofIntervals, new ArrayList<Atom[]>(), new ArrayList<Residue>(), new ArrayList<Residue>(), this.voxLinConstr);
        for (Atom at1 : this.res1.atoms) {
            double vdwRad1 = VoxelVDWDistExplorer.getVDWRadius(at1);
            Iterable<Atom> atoms2 = this.res2 == null ? new ISAtomsIterable(at1, this.res1, this.shellResidues) : new Res2AtomsIterable(at1, this.res1, this.res2);
            for (Atom at2 : atoms2) {
                double vdwRad2 = VoxelVDWDistExplorer.getVDWRadius(at2);
                double outerDist = vdwRad1 + vdwRad2 + 0.25;
                double centerDist = VectorAlgebra.distance(at1.getCoords(), at2.getCoords());
                if (!(centerDist <= outerDist + maxMotion) || centerDist > outerDist && distChecker.DOFsAtAtomPairDist(new Atom[]{at1, at2}, outerDist) == null) continue;
                this.interactingAtoms.add(new Atom[]{at1, at2});
            }
        }
        ArrayList<Residue> knownConfRes = new ArrayList<Residue>();
        knownConfRes.add(this.res1);
        if (this.res2 == null) {
            knownConfRes.addAll(this.shellResidues);
        } else {
            knownConfRes.add(this.res2);
        }
        VoxelVDWListChecker vvlc = new VoxelVDWListChecker(this.dofIntervals, this.interactingAtoms, knownConfRes, this.shellResidues, this.voxLinConstr);
        return vvlc.calcFeasiblePolytope(atomPairNames);
    }

    public RCTuplePolytope buildPolytope() {
        ArrayList<String> atomPairNames = new ArrayList<String>();
        ArrayList<LinearConstraint> constr = this.calcPolytopeConstr(atomPairNames);
        ArrayList<DegreeOfFreedom> DOFs = new ArrayList<DegreeOfFreedom>();
        for (VoxelVDWListChecker.DOFInterval di : this.dofIntervals) {
            DOFs.add(di.dof);
        }
        if (constr == null) {
            return null;
        }
        RCTuplePolytope ans = new RCTuplePolytope(DOFs, constr);
        ans.atomPairNames = atomPairNames;
        return ans;
    }
}

