/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import edu.duke.cs.osprey.dof.DegreeOfFreedom;
import edu.duke.cs.osprey.plug.LPChecks;
import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.math3.optim.linear.LinearConstraint;

public class RCTuplePolytope
implements Serializable {
    ArrayList<DegreeOfFreedom> DOFs;
    ArrayList<LinearConstraint> constr;
    ArrayList<String> atomPairNames;

    public RCTuplePolytope(ArrayList<DegreeOfFreedom> DOFs, ArrayList<LinearConstraint> constr) {
        this.DOFs = DOFs;
        this.constr = constr;
    }

    ArrayList<LinearConstraint> expandConstraints(ArrayList<DegreeOfFreedom> allDOFs) {
        return RCTuplePolytope.transferConstraints(this.DOFs, allDOFs, this.constr);
    }

    public static ArrayList<LinearConstraint> transferConstraints(ArrayList<DegreeOfFreedom> oldDOFs, ArrayList<? extends DegreeOfFreedom> newDOFs, ArrayList<LinearConstraint> oldConstr) {
        ArrayList<LinearConstraint> ans = new ArrayList<LinearConstraint>();
        for (LinearConstraint c : oldConstr) {
            double[] bigGrad = new double[newDOFs.size()];
            block1: for (int dof = 0; dof < oldDOFs.size(); ++dof) {
                for (int index = 0; index < newDOFs.size(); ++index) {
                    if (!oldDOFs.get(dof).getName().equalsIgnoreCase(newDOFs.get(index).getName())) continue;
                    bigGrad[index] = c.getCoefficients().getEntry(dof);
                    continue block1;
                }
            }
            ans.add(new LinearConstraint(bigGrad, c.getRelationship(), c.getValue()));
        }
        return ans;
    }

    public void checkDOFList(ArrayList<DegreeOfFreedom> checkDOFs) {
        if (checkDOFs.size() != this.DOFs.size()) {
            throw new RuntimeException("ERROR: Wrong number of DOFs for RCTuplePolytope");
        }
        for (int dof = 0; dof < this.DOFs.size(); ++dof) {
            if (this.DOFs.get(dof) == checkDOFs.get(dof)) continue;
            throw new RuntimeException("ERROR: DOFs don't match");
        }
    }

    public boolean containsPoint(double[] pt) {
        return LPChecks.isPointInPolytope(this.constr, pt);
    }

    public void listClashes(double[] pt) {
        for (int c = 0; c < this.constr.size(); ++c) {
            if (!(LPChecks.constrAsFunction(this.constr.get(c)).value(pt) > 1.0E-10)) continue;
            System.out.println("INEQUALITY VIOLATED: " + this.atomPairNames.get(c));
        }
    }

    public ArrayList<LinearConstraint> getConstr() {
        return this.constr;
    }

    public boolean hasNonBoxConstr() {
        return this.constr.size() > 2 * this.DOFs.size();
    }

    public ArrayList<String> getAtomPairNames() {
        return this.atomPairNames;
    }

    public ArrayList<DegreeOfFreedom> getDOFs() {
        return this.DOFs;
    }
}

