/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.plug;

import edu.duke.cs.osprey.structure.Atom;
import edu.duke.cs.osprey.structure.AtomNeighbors;
import edu.duke.cs.osprey.structure.ProbeAtomNeighbors;
import edu.duke.cs.osprey.structure.Residue;
import java.util.Iterator;

public class Res2AtomsIterable
implements Iterable<Atom> {
    ProbeAtomNeighbors neighbors;
    Residue res1;
    Residue res2;

    public Res2AtomsIterable(Atom at1, Residue res1, Residue res2) {
        this.neighbors = new ProbeAtomNeighbors(at1);
        this.res1 = res1;
        this.res2 = res2;
    }

    @Override
    public Iterator<Atom> iterator() {
        return new Res2AtomsIterator();
    }

    private class Res2AtomsIterator
    implements Iterator<Atom> {
        int atomCounter = -1;
        boolean done = false;

        private Res2AtomsIterator() {
            this.updateCounter();
        }

        @Override
        public boolean hasNext() {
            return !this.done;
        }

        @Override
        public Atom next() {
            Atom nextAtom = Res2AtomsIterable.this.res2.atoms.get(this.atomCounter);
            this.updateCounter();
            return nextAtom;
        }

        private void updateCounter() {
            Atom candAtom;
            do {
                ++this.atomCounter;
                if (this.atomCounter != Res2AtomsIterable.this.res2.atoms.size()) continue;
                this.done = true;
                break;
            } while (Res2AtomsIterable.this.neighbors.classifyAtom(candAtom = Res2AtomsIterable.this.res2.atoms.get(this.atomCounter)) != AtomNeighbors.Type.NONBONDED);
        }
    }
}

