/*
 * Decompiled with CFR 0.152.
 */
package edu.duke.cs.osprey.pruning;

import edu.duke.cs.osprey.confspace.ConfSpace;
import edu.duke.cs.osprey.confspace.HigherTupleFinder;
import edu.duke.cs.osprey.confspace.RCTuple;
import edu.duke.cs.osprey.confspace.SimpleConfSpace;
import edu.duke.cs.osprey.confspace.TupleMatrixBoolean;
import edu.duke.cs.osprey.confspace.TupleTree;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

public class PruningMatrix
extends TupleMatrixBoolean {
    private static final long serialVersionUID = 1212622649775905467L;

    protected PruningMatrix() {
    }

    public PruningMatrix(PruningMatrix other) {
        super(other);
    }

    public PruningMatrix(ConfSpace cSpace, double pruningInterval) {
        super(cSpace, pruningInterval, false);
        this.fill(false);
    }

    public PruningMatrix(SimpleConfSpace confSpace) {
        super(confSpace, 0.0, false);
        this.fill(false);
    }

    public PruningMatrix(int numPos, int[] numAllowedAtPos, double pruningInterval) {
        super(numPos, numAllowedAtPos, pruningInterval, false);
    }

    @Override
    public Boolean getTuple(RCTuple tuple) {
        Boolean val = (Boolean)super.getTuple(tuple);
        if (val != null) {
            return val;
        }
        return false;
    }

    public void unprunedRCsAtPos(ArrayList<Integer> out, int pos) {
        out.clear();
        int numRCs = this.getNumConfAtPos(pos);
        for (int index = 0; index < numRCs; ++index) {
            if (this.getOneBody(pos, index).booleanValue()) continue;
            out.add(index);
        }
    }

    public ArrayList<Integer> unprunedRCsAtPos(int pos) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        this.unprunedRCsAtPos(out, pos);
        return out;
    }

    public void prunedRCsAtPos(ArrayList<Integer> out, int pos) {
        out.clear();
        int numRCs = this.getNumConfAtPos(pos);
        for (int index = 0; index < numRCs; ++index) {
            if (!this.getOneBody(pos, index).booleanValue()) continue;
            out.add(index);
        }
    }

    public ArrayList<Integer> prunedRCsAtPos(int pos) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        this.prunedRCsAtPos(out, pos);
        return out;
    }

    public ArrayList<RCTuple> unprunedRCTuplesAtPos(ArrayList<Integer> pos) {
        int numPos = pos.size();
        ArrayList<RCTuple> unpruned = new ArrayList<RCTuple>();
        if (numPos == 1) {
            int posNum = pos.get(0);
            for (int rc = 0; rc < this.getNumConfAtPos(posNum); ++rc) {
                if (this.getOneBody(posNum, rc).booleanValue()) continue;
                unpruned.add(new RCTuple(posNum, rc));
            }
        } else {
            ArrayList posReduced = (ArrayList)pos.clone();
            posReduced.remove(numPos - 1);
            ArrayList<RCTuple> tupsReduced = this.unprunedRCTuplesAtPos(posReduced);
            int lastPos = pos.get(numPos - 1);
            for (int rc = 0; rc < this.getNumConfAtPos(lastPos); ++rc) {
                if (this.getOneBody(lastPos, rc).booleanValue()) continue;
                for (RCTuple reducedTup : tupsReduced) {
                    ArrayList fullRCList = (ArrayList)reducedTup.RCs.clone();
                    fullRCList.add(rc);
                    RCTuple fullTup = new RCTuple(pos, fullRCList);
                    if (this.isPruned(fullTup)) continue;
                    unpruned.add(fullTup);
                }
            }
        }
        return unpruned;
    }

    public boolean isPruned(RCTuple tup) {
        int rc1;
        int pos1;
        int i1;
        ArrayList<Integer> tuppos = tup.pos;
        ArrayList<Integer> tupRCs = tup.RCs;
        boolean hasHigherOrderTerms = this.hasHigherOrderTerms();
        int numTupPos = tuppos.size();
        for (i1 = 0; i1 < numTupPos; ++i1) {
            pos1 = tuppos.get(i1);
            if (!this.getOneBody(pos1, rc1 = tupRCs.get(i1).intValue()).booleanValue()) continue;
            return true;
        }
        for (i1 = 0; i1 < numTupPos; ++i1) {
            pos1 = tuppos.get(i1);
            rc1 = tupRCs.get(i1);
            for (int i2 = 0; i2 < i1; ++i2) {
                HigherTupleFinder<Boolean> htf;
                int rc2;
                int pos2 = tuppos.get(i2);
                if (this.getPairwise(pos1, rc1, pos2, rc2 = tupRCs.get(i2).intValue()).booleanValue()) {
                    return true;
                }
                if (!hasHigherOrderTerms || (htf = this.getHigherOrderTerms(pos1, rc1, pos2, rc2)) == null || !this.isPrunedHigherOrder(tup, i2, htf)) continue;
                return true;
            }
        }
        if (this.hasHigherOrderTuples()) {
            RCTuple tuple = new RCTuple(0, 0, 0, 0, 0, 0);
            for (int i12 = 2; i12 < numTupPos; ++i12) {
                int pos12 = tuppos.get(i12);
                int rc12 = tupRCs.get(i12);
                tuple.pos.set(2, pos12);
                tuple.RCs.set(2, rc12);
                for (int i2 = 1; i2 < i12; ++i2) {
                    int pos2 = tuppos.get(i2);
                    int rc2 = tupRCs.get(i2);
                    tuple.pos.set(1, pos2);
                    tuple.RCs.set(1, rc2);
                    for (int i3 = 0; i3 < i2; ++i3) {
                        int pos3 = tuppos.get(i3);
                        int rc3 = tupRCs.get(i3);
                        tuple.pos.set(0, pos3);
                        tuple.RCs.set(0, rc3);
                        if (!this.getTuple(tuple).booleanValue()) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isPrunedHigherOrder(RCTuple tup, int curIndex, HigherTupleFinder<Boolean> htf) {
        ArrayList<Integer> interactingPos = htf.getInteractingPos();
        for (int ipos : interactingPos) {
            int iposIndex = -1;
            for (int ind = 0; ind < curIndex; ++ind) {
                if (tup.pos.get(ind) != ipos) continue;
                iposIndex = ind;
                break;
            }
            if (iposIndex <= -1) continue;
            int iposRC = tup.RCs.get(iposIndex);
            if (htf.getInteraction(ipos, iposRC).booleanValue()) {
                return true;
            }
            HigherTupleFinder<Boolean> htf2 = htf.getHigherInteractions(ipos, iposRC);
            if (htf2 == null || !this.isPrunedHigherOrder(tup, iposIndex, htf2)) continue;
            return true;
        }
        return false;
    }

    public void pruneSingle(int pos1, int rc1) {
        this.setOneBody(pos1, rc1, true);
        this.prunePairsFromSingle(pos1, rc1);
    }

    public void prunePair(int pos1, int rc1, int pos2, int rc2) {
        this.setPairwise(pos1, rc1, pos2, rc2, true);
    }

    public void pruneTriple(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        this.setTuple(new RCTuple(pos1, rc1, pos2, rc2, pos3, rc3).sorted(), true);
    }

    public void prunePairsFromSingles() {
        int n = this.getNumPos();
        for (int pos1 = 0; pos1 < n; ++pos1) {
            int n1 = this.getNumConfAtPos(pos1);
            for (int rc1 = 0; rc1 < n1; ++rc1) {
                if (!this.getOneBody(pos1, rc1).booleanValue()) continue;
                this.prunePairsFromSingle(pos1, rc1);
            }
        }
    }

    public void prunePairsFromSingle(int pos1, int rc1) {
        int n = this.getNumPos();
        for (int pos2 = 0; pos2 < n; ++pos2) {
            if (pos1 == pos2) continue;
            int n2 = this.getNumConfAtPos(pos2);
            for (int rc2 = 0; rc2 < n2; ++rc2) {
                this.setPairwise(pos1, rc1, pos2, rc2, true);
            }
        }
    }

    public boolean isSinglePruned(int pos, int rc) {
        return this.getOneBody(pos, rc);
    }

    public boolean isPairPruned(int pos1, int rc1, int pos2, int rc2) {
        return this.getPairwise(pos1, rc1, pos2, rc2) != false || this.isSinglePruned(pos1, rc1) || this.isSinglePruned(pos2, rc2);
    }

    public boolean isTriplePruned(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3) {
        return this.isSinglePruned(pos1, rc1) || this.isSinglePruned(pos2, rc2) || this.isSinglePruned(pos3, rc3) || this.getPairwise(pos1, rc1, pos2, rc2) != false || this.getPairwise(pos1, rc1, pos3, rc3) != false || this.getPairwise(pos2, rc2, pos3, rc3) != false || this.getTuple(new RCTuple(pos1, rc1, pos2, rc2, pos3, rc3).sorted()) != false;
    }

    public boolean isQuadruplePruned(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4) {
        RCTuple tuple = new RCTuple(0, 0, 0, 0, 0, 0);
        return this.isSinglePruned(pos1, rc1) || this.isSinglePruned(pos2, rc2) || this.isSinglePruned(pos3, rc3) || this.isSinglePruned(pos4, rc4) || this.getPairwise(pos1, rc1, pos2, rc2) != false || this.getPairwise(pos1, rc1, pos3, rc3) != false || this.getPairwise(pos1, rc1, pos4, rc4) != false || this.getPairwise(pos2, rc2, pos3, rc3) != false || this.getPairwise(pos2, rc2, pos4, rc4) != false || this.getPairwise(pos3, rc3, pos4, rc4) != false || this.getTuple(tuple.set(pos1, rc1, pos2, rc2, pos3, rc3).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos2, rc2, pos4, rc4).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos3, rc3, pos4, rc4).sorted()) != false || this.getTuple(tuple.set(pos2, rc2, pos3, rc3, pos4, rc4).sorted()) != false;
    }

    public boolean isQuintuplePruned(int pos1, int rc1, int pos2, int rc2, int pos3, int rc3, int pos4, int rc4, int pos5, int rc5) {
        RCTuple tuple = new RCTuple(0, 0, 0, 0, 0, 0);
        return this.isSinglePruned(pos1, rc1) || this.isSinglePruned(pos2, rc2) || this.isSinglePruned(pos3, rc3) || this.isSinglePruned(pos4, rc4) || this.isSinglePruned(pos5, rc5) || this.getPairwise(pos1, rc1, pos2, rc2) != false || this.getPairwise(pos1, rc1, pos3, rc3) != false || this.getPairwise(pos1, rc1, pos4, rc4) != false || this.getPairwise(pos1, rc1, pos5, rc5) != false || this.getPairwise(pos2, rc2, pos3, rc3) != false || this.getPairwise(pos2, rc2, pos4, rc4) != false || this.getPairwise(pos2, rc2, pos5, rc5) != false || this.getPairwise(pos3, rc3, pos4, rc4) != false || this.getPairwise(pos3, rc3, pos5, rc5) != false || this.getPairwise(pos4, rc4, pos5, rc5) != false || this.getTuple(tuple.set(pos1, rc1, pos2, rc2, pos3, rc3).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos2, rc2, pos4, rc4).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos2, rc2, pos5, rc5).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos3, rc3, pos4, rc4).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos3, rc3, pos5, rc5).sorted()) != false || this.getTuple(tuple.set(pos1, rc1, pos4, rc4, pos5, rc5).sorted()) != false || this.getTuple(tuple.set(pos2, rc2, pos3, rc3, pos4, rc4).sorted()) != false || this.getTuple(tuple.set(pos2, rc2, pos3, rc3, pos5, rc5).sorted()) != false || this.getTuple(tuple.set(pos2, rc2, pos4, rc4, pos5, rc5).sorted()) != false || this.getTuple(tuple.set(pos3, rc3, pos4, rc4, pos5, rc5).sorted()) != false;
    }

    public void markAsPruned(RCTuple tup) {
        this.setTupleValue(tup, true);
    }

    public int countPrunedRCs() {
        int count = 0;
        int numPos = this.getNumPos();
        for (int res1 = 0; res1 < numPos; ++res1) {
            int m1 = this.getNumConfAtPos(res1);
            for (int i1 = 0; i1 < m1; ++i1) {
                if (!this.getOneBody(res1, i1).booleanValue()) continue;
                ++count;
            }
        }
        return count;
    }

    public int countPrunedPairs() {
        int count = 0;
        int numPos = this.getNumPos();
        for (int res1 = 0; res1 < numPos; ++res1) {
            int m1 = this.getNumConfAtPos(res1);
            for (int i1 = 0; i1 < m1; ++i1) {
                for (int res2 = 0; res2 < res1; ++res2) {
                    int m2 = this.getNumConfAtPos(res2);
                    for (int i2 = 0; i2 < m2; ++i2) {
                        if (!this.getPairwise(res1, i1, res2, i2).booleanValue()) continue;
                        ++count;
                    }
                }
            }
        }
        return count;
    }

    public int countPrunedTriples() {
        int numPos = this.getNumPos();
        int count = 0;
        RCTuple tuple = new RCTuple(0, 0, 0, 0, 0, 0);
        for (int pos1 = 0; pos1 < this.getNumPos(); ++pos1) {
            tuple.pos.set(0, pos1);
            for (int rc1 = 0; rc1 < this.getNumConfAtPos(pos1); ++rc1) {
                tuple.RCs.set(0, rc1);
                for (int pos2 = pos1 + 1; pos2 < numPos; ++pos2) {
                    tuple.pos.set(1, pos2);
                    for (int rc2 = 0; rc2 < this.getNumConfAtPos(pos2); ++rc2) {
                        tuple.RCs.set(1, rc2);
                        TupleTree tree = this.getHigherOrderTuples(pos1, rc1, pos2, rc2);
                        if (tree == null) continue;
                        for (int pos3 = pos2 + 1; pos3 < numPos; ++pos3) {
                            tuple.pos.set(2, pos3);
                            for (int rc3 = 0; rc3 < this.getNumConfAtPos(pos3); ++rc3) {
                                tuple.RCs.set(2, rc3);
                                Boolean val = (Boolean)tree.get(tuple);
                                if (val == null || !val.booleanValue()) continue;
                                ++count;
                            }
                        }
                    }
                }
            }
        }
        return count;
    }

    public int countUnprunedSingles(int pos) {
        int count = 0;
        for (int rc = 0; rc < this.getNumConfAtPos(pos); ++rc) {
            if (this.isSinglePruned(pos, rc)) continue;
            ++count;
        }
        return count;
    }

    public BigInteger calcUnprunedConfsUpperBound() {
        int n = this.getNumPos();
        ArrayList<Integer> posPermutation = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            posPermutation.add(i);
        }
        posPermutation.sort(Comparator.comparing(pos -> this.getNumConfAtPos((int)pos)));
        return PruningMatrix.countConfsAfterOnlyDiagonalPairsPruning(this, posPermutation);
    }

    private static BigInteger countConfsAfterOnlyDiagonalPairsPruning(PruningMatrix pmat, List<Integer> posPermutation) {
        int pos;
        int i;
        int n = pmat.getNumPos();
        BigInteger[][] counts = new BigInteger[n][];
        for (i = 0; i < n; ++i) {
            pos = posPermutation.get(i);
            counts[i] = new BigInteger[pmat.getNumConfAtPos(pos)];
        }
        for (i = 0; i < n; ++i) {
            pos = posPermutation.get(i);
            for (int rc = 0; rc < pmat.getNumConfAtPos(pos); ++rc) {
                counts[i][rc] = i < n - 1 ? BigInteger.ZERO : BigInteger.ONE;
            }
        }
        for (int i1 = n - 2; i1 >= 0; --i1) {
            int i2 = i1 + 1;
            int pos1 = posPermutation.get(i1);
            int pos2 = posPermutation.get(i2);
            for (int rc1 = 0; rc1 < pmat.getNumConfAtPos(pos1); ++rc1) {
                if (pmat.isSinglePruned(pos1, rc1)) continue;
                for (int rc2 = 0; rc2 < pmat.getNumConfAtPos(pos2); ++rc2) {
                    if (pmat.isSinglePruned(pos2, rc2) || pmat.isPairPruned(pos1, rc1, pos2, rc2)) continue;
                    counts[i1][rc1] = counts[i1][rc1].add(counts[i2][rc2]);
                }
            }
        }
        BigInteger sum = BigInteger.ZERO;
        for (int rc = 0; rc < pmat.getNumConfAtPos(posPermutation.get(0)); ++rc) {
            sum = sum.add(counts[0][rc]);
        }
        return sum;
    }

    public BigInteger calcUnprunedConfsLowerBound() {
        PruningMatrix expandedPmat = new PruningMatrix(this);
        int n = this.getNumPos();
        for (int pos1 = 2; pos1 < n; ++pos1) {
            for (int pos2 = 0; pos2 < pos1 - 1; ++pos2) {
                for (int rc1 = 0; rc1 < this.getNumConfAtPos(pos1); ++rc1) {
                    for (int rc2 = 0; rc2 < this.getNumConfAtPos(pos2); ++rc2) {
                        if (!this.getPairwise(pos1, rc1, pos2, rc2).booleanValue() || expandedPmat.isSinglePruned(pos1, rc1) || expandedPmat.isSinglePruned(pos2, rc2)) continue;
                        if (expandedPmat.countUnprunedSingles(pos1) < expandedPmat.countUnprunedSingles(pos2)) {
                            expandedPmat.pruneSingle(pos1, rc1);
                            continue;
                        }
                        expandedPmat.pruneSingle(pos2, rc2);
                    }
                }
            }
        }
        ArrayList<Integer> posPermutation = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            posPermutation.add(i);
        }
        return PruningMatrix.countConfsAfterOnlyDiagonalPairsPruning(expandedPmat, posPermutation);
    }

    public IteratorCommand forEachUnprunedSingle(SingleConsumer consumer) {
        int n = this.getNumPos();
        for (int pos1 = 0; pos1 < n; ++pos1) {
            switch (this.forEachUnprunedSingleAt(pos1, consumer)) {
                case Break: {
                    return IteratorCommand.Break;
                }
            }
        }
        return IteratorCommand.Continue;
    }

    public IteratorCommand forEachUnprunedSingleAt(int pos1, SingleConsumer consumer) {
        for (int rc1 = 0; rc1 < this.getNumConfAtPos(pos1); ++rc1) {
            if (this.isSinglePruned(pos1, rc1)) continue;
            switch (consumer.apply(pos1, rc1)) {
                case Break: {
                    return IteratorCommand.Break;
                }
            }
        }
        return IteratorCommand.Continue;
    }

    public IteratorCommand forEachUnprunedPair(PairConsumer consumer) {
        for (int pos1 = 1; pos1 < this.getNumPos(); ++pos1) {
            for (int pos2 = 0; pos2 < pos1; ++pos2) {
                switch (this.forEachUnprunedPairAt(pos1, pos2, consumer)) {
                    case Break: {
                        return IteratorCommand.Break;
                    }
                }
            }
        }
        return IteratorCommand.Continue;
    }

    public IteratorCommand forEachUnprunedPairAt(int pos1, int pos2, PairConsumer consumer) {
        for (int rc1 = 0; rc1 < this.getNumConfAtPos(pos1); ++rc1) {
            if (this.getOneBody(pos1, rc1).booleanValue()) continue;
            for (int rc2 = 0; rc2 < this.getNumConfAtPos(pos2); ++rc2) {
                if (this.getOneBody(pos2, rc2).booleanValue() || this.getPairwise(pos1, rc1, pos2, rc2).booleanValue()) continue;
                switch (consumer.apply(pos1, rc1, pos2, rc2)) {
                    case Break: {
                        return IteratorCommand.Break;
                    }
                }
            }
        }
        return IteratorCommand.Continue;
    }

    public IteratorCommand forEachUnprunedTriple(TripleConsumer consumer) {
        for (int pos1 = 2; pos1 < this.getNumPos(); ++pos1) {
            for (int pos2 = 1; pos2 < pos1; ++pos2) {
                for (int pos3 = 0; pos3 < pos2; ++pos3) {
                    switch (this.forEachUnprunedTripleAt(pos1, pos2, pos3, consumer)) {
                        case Break: {
                            return IteratorCommand.Break;
                        }
                    }
                }
            }
        }
        return IteratorCommand.Continue;
    }

    public IteratorCommand forEachUnprunedTripleAt(int pos1, int pos2, int pos3, TripleConsumer consumer) {
        RCTuple tuple = new RCTuple(0, 0, 0, 0, 0, 0);
        for (int rc1 = 0; rc1 < this.getNumConfAtPos(pos1); ++rc1) {
            if (this.getOneBody(pos1, rc1).booleanValue()) continue;
            tuple.pos.set(2, pos1);
            tuple.RCs.set(2, rc1);
            for (int rc2 = 0; rc2 < this.getNumConfAtPos(pos2); ++rc2) {
                if (this.getOneBody(pos2, rc2).booleanValue() || this.getPairwise(pos1, rc1, pos2, rc2).booleanValue()) continue;
                tuple.pos.set(1, pos2);
                tuple.RCs.set(1, rc2);
                for (int rc3 = 0; rc3 < this.getNumConfAtPos(pos3); ++rc3) {
                    tuple.pos.set(0, pos3);
                    tuple.RCs.set(0, rc3);
                    if (this.getOneBody(pos3, rc3).booleanValue() || this.getPairwise(pos1, rc1, pos3, rc3).booleanValue() || this.getPairwise(pos2, rc2, pos3, rc3).booleanValue() || this.getTuple(tuple).booleanValue()) continue;
                    switch (consumer.apply(pos1, rc1, pos2, rc2, pos3, rc3)) {
                        case Break: {
                            return IteratorCommand.Break;
                        }
                    }
                }
            }
        }
        return IteratorCommand.Continue;
    }

    public static interface SingleConsumer {
        public IteratorCommand apply(int var1, int var2);
    }

    public static enum IteratorCommand {
        Break,
        Continue;

    }

    public static interface PairConsumer {
        public IteratorCommand apply(int var1, int var2, int var3, int var4);
    }

    public static interface TripleConsumer {
        public IteratorCommand apply(int var1, int var2, int var3, int var4, int var5, int var6);
    }
}

